/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal;

import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.longs.Long2LongOpenHashMap;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.kyori.adventure.util.TriState;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.particles.ParticleParam;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.game.PacketDebug;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.PoiTypeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.MathHelper;
import net.minecraft.util.TimeRange;
import net.minecraft.util.VisibleForDebug;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.IEntityAngerable;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.control.ControllerLook;
import net.minecraft.world.entity.ai.control.ControllerMoveFlying;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.goal.PathfinderGoalBreed;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFollowParent;
import net.minecraft.world.entity.ai.goal.PathfinderGoalMeleeAttack;
import net.minecraft.world.entity.ai.goal.PathfinderGoalSelector;
import net.minecraft.world.entity.ai.goal.PathfinderGoalTempt;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalHurtByTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalUniversalAngerReset;
import net.minecraft.world.entity.ai.navigation.NavigationAbstract;
import net.minecraft.world.entity.ai.navigation.NavigationFlying;
import net.minecraft.world.entity.ai.util.AirAndWaterRandomPos;
import net.minecraft.world.entity.ai.util.AirRandomPos;
import net.minecraft.world.entity.ai.util.HoverRandomPos;
import net.minecraft.world.entity.ai.village.poi.VillagePlace;
import net.minecraft.world.entity.ai.village.poi.VillagePlaceRecord;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.animal.EntityBird;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemBlock;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.level.IMaterial;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockCrops;
import net.minecraft.world.level.block.BlockFlowers;
import net.minecraft.world.level.block.BlockStem;
import net.minecraft.world.level.block.BlockSweetBerryBush;
import net.minecraft.world.level.block.BlockTallPlant;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.IBlockFragilePlantElement;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityBeehive;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockPropertyDoubleBlockHalf;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.level.pathfinder.PathEntity;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_21_R4.event.CraftEventFactory;
import org.bukkit.event.entity.EntityPotionEffectEvent;
import org.bukkit.event.entity.EntityTargetEvent;

public class EntityBee
extends EntityAnimal
implements IEntityAngerable,
EntityBird {
    public static final float bI = 120.32113f;
    public static final int bJ = MathHelper.f(1.4959966f);
    private static final DataWatcherObject<Byte> bT = DataWatcher.a(EntityBee.class, DataWatcherRegistry.a);
    private static final DataWatcherObject<Integer> bU = DataWatcher.a(EntityBee.class, DataWatcherRegistry.b);
    private static final int bV = 2;
    private static final int bW = 4;
    private static final int bX = 8;
    private static final int bY = 1200;
    private static final int bZ = 600;
    private static final int ca = 3600;
    private static final int cb = 4;
    private static final int cc = 10;
    private static final int cd = 10;
    private static final int ce = 18;
    private static final int cf = 48;
    private static final int cg = 2;
    private static final int ch = 24;
    private static final int ci = 16;
    private static final int cj = 16;
    private static final int ck = 20;
    public static final String bK = "CropsGrownSincePollination";
    public static final String bM = "CannotEnterHiveTicks";
    public static final String bN = "TicksSincePollination";
    public static final String bO = "HasStung";
    public static final String bP = "HasNectar";
    public static final String bQ = "flower_pos";
    public static final String bR = "hive_pos";
    public static final boolean bS = false;
    private static final boolean cl = false;
    private static final int cm = 0;
    private static final int cn = 0;
    private static final int cq = 0;
    private static final UniformInt cr = TimeRange.a(20, 39);
    @Nullable
    private UUID cs;
    private float ct;
    private float cu;
    private int cv;
    public int cw = 0;
    public int cx = 0;
    public int cy = 0;
    private static final int cz = 200;
    int cA;
    private static final int cB = 200;
    private static final int cC = 20;
    private static final int cD = 60;
    int cE = MathHelper.a(this.ae, 20, 60);
    @Nullable
    BlockPosition cF;
    @Nullable
    public BlockPosition cG;
    k cH;
    e cI;
    private f cJ;
    private int cK;
    public TriState rollingOverride = TriState.NOT_SET;

    public EntityBee(EntityTypes<? extends EntityBee> entityType, World level) {
        super((EntityTypes<? extends EntityAnimal>)entityType, level);
        class BeeFlyingMoveControl
        extends ControllerMoveFlying {
            public BeeFlyingMoveControl(EntityInsentient entity, int maxPitchChange, boolean noGravity) {
                super(entity, maxPitchChange, noGravity);
            }

            @Override
            public void a() {
                if (this.d.dC() <= (double)EntityBee.this.dV().K_()) {
                    this.d.f(false);
                }
                super.a();
            }
        }
        this.bC = new BeeFlyingMoveControl(this, 20, true);
        this.bB = new j(this);
        this.a(PathType.n, -1.0f);
        this.a(PathType.j, -1.0f);
        this.a(PathType.k, 16.0f);
        this.a(PathType.x, -1.0f);
        this.a(PathType.h, -1.0f);
    }

    @Override
    protected void a(DataWatcher.a builder) {
        super.a(builder);
        builder.a(bT, (byte)0);
        builder.a(bU, 0);
    }

    @Override
    public float a(BlockPosition pos, IWorldReader level) {
        return level.a_(pos).l() ? 10.0f : 0.0f;
    }

    @Override
    protected void C() {
        this.bF.a(0, new b(this, 1.4f, true));
        this.bF.a(1, new d());
        this.bF.a(2, new PathfinderGoalBreed(this, 1.0));
        this.bF.a(3, new PathfinderGoalTempt(this, 1.25, stack -> stack.a(TagsItem.ao), false));
        this.bF.a(3, new n());
        this.bF.a(3, new m());
        this.cH = new k();
        this.bF.a(4, this.cH);
        this.bF.a(5, new PathfinderGoalFollowParent(this, 1.25));
        this.bF.a(5, new i());
        this.cI = new e();
        this.bF.a(5, this.cI);
        this.cJ = new f();
        this.bF.a(6, this.cJ);
        this.bF.a(7, new g());
        this.bF.a(8, new l());
        this.bF.a(9, new PathfinderGoalFloat(this));
        this.bG.a(1, new h(this).a(new Class[0]));
        this.bG.a(2, new c(this));
        this.bG.a(3, new PathfinderGoalUniversalAngerReset<EntityBee>(this, true));
    }

    @Override
    public void b(NBTTagCompound compound) {
        this.addAdditionalSaveData(compound, true);
    }

    @Override
    public void addAdditionalSaveData(NBTTagCompound compound, boolean saveAll) {
        super.b(compound);
        if (saveAll) {
            compound.b(bR, BlockPosition.a, this.cG);
            compound.b(bQ, BlockPosition.a, this.cF);
        }
        compound.a(bP, this.gG());
        compound.a(bO, this.gH());
        compound.a(bN, this.cw);
        compound.a(bM, this.cx);
        compound.a(bK, this.cy);
        this.a_(compound);
    }

    @Override
    public void a(NBTTagCompound compound) {
        super.a(compound);
        this.w(compound.b(bP, false));
        this.x(compound.b(bO, false));
        this.cw = compound.b(bN, 0);
        this.cx = compound.b(bM, 0);
        this.cy = compound.b(bK, 0);
        this.cG = compound.a(bR, BlockPosition.a).orElse(null);
        this.cF = compound.a(bQ, BlockPosition.a).orElse(null);
        this.a(this.dV(), compound);
    }

    @Override
    public boolean c(WorldServer level, Entity source) {
        DamageSource damageSource = this.dW().a(this);
        boolean flag = source.a(level, damageSource, (float)((int)this.h(GenericAttributes.c)));
        if (flag) {
            EnchantmentManager.a(level, source, damageSource);
            if (source instanceof EntityLiving) {
                EntityLiving livingEntity = (EntityLiving)source;
                livingEntity.p(livingEntity.eX() + 1);
                int i2 = 0;
                if (this.dV().an() == EnumDifficulty.c) {
                    i2 = 10;
                } else if (this.dV().an() == EnumDifficulty.d) {
                    i2 = 18;
                }
                if (i2 > 0) {
                    livingEntity.addEffect(new MobEffect(MobEffects.s, i2 * 20, 0), this, EntityPotionEffectEvent.Cause.ATTACK);
                }
            }
            this.x(true);
            this.i();
            this.a(SoundEffects.bS, 1.0f, 1.0f);
        }
        return flag;
    }

    @Override
    public void g() {
        super.g();
        if (this.gG() && this.gR() < 10 && this.ae.i() < 0.05f) {
            for (int i2 = 0; i2 < this.ae.a(2) + 1; ++i2) {
                this.a(this.dV(), this.dA() - (double)0.3f, this.dA() + (double)0.3f, this.dG() - (double)0.3f, this.dG() + (double)0.3f, this.e(0.5), Particles.aB);
            }
        }
        this.gP();
    }

    private void a(World level, double startX, double endX, double startZ, double endZ, double posY, ParticleParam particleOption) {
        level.a(particleOption, MathHelper.d(level.A.j(), startX, endX), posY, MathHelper.d(level.A.j(), startZ, endZ), 0.0, 0.0, 0.0);
    }

    void j(BlockPosition pos) {
        Vec3D posTowards;
        Vec3D vec3 = Vec3D.c(pos);
        int i2 = 0;
        BlockPosition blockPos = this.dv();
        int i1 = (int)vec3.e - blockPos.v();
        if (i1 > 2) {
            i2 = 4;
        } else if (i1 < -2) {
            i2 = -4;
        }
        int i22 = 6;
        int i3 = 8;
        int i4 = blockPos.k(pos);
        if (i4 < 15) {
            i22 = i4 / 2;
            i3 = i4 / 2;
        }
        if ((posTowards = AirRandomPos.a(this, i22, i3, i2, vec3, 0.3141592741012573)) != null) {
            this.bE.b(0.5f);
            this.bE.a(posTowards.d, posTowards.e, posTowards.f, 1.0);
        }
    }

    @Nullable
    public BlockPosition m() {
        return this.cF;
    }

    public boolean p() {
        return this.cF != null;
    }

    public void h(BlockPosition savedFlowerPos) {
        this.cF = savedFlowerPos;
    }

    @VisibleForDebug
    public int u() {
        return Math.max(this.cI.d, this.cJ.d);
    }

    @VisibleForDebug
    public List<BlockPosition> gu() {
        return this.cI.f;
    }

    private boolean gL() {
        return this.cw > 3600;
    }

    void gM() {
        this.cG = null;
        this.cA = 200;
    }

    void gN() {
        this.cF = null;
        this.cE = MathHelper.a(this.ae, 20, 60);
    }

    boolean gO() {
        if (this.cx <= 0 && !this.cH.l() && !this.gH() && this.e() == null) {
            boolean flag = this.gL() || EntityBee.c(this.dV()) || this.gG();
            return flag && !this.gQ();
        }
        return false;
    }

    public static boolean c(World level) {
        return level.F_().g() && (level.W() || level.ah());
    }

    public void s(int stayOutOfHiveCountdown) {
        this.cx = stayOutOfHiveCountdown;
    }

    public float J(float partialTick) {
        return MathHelper.h(partialTick, this.cu, this.ct);
    }

    private void gP() {
        this.cu = this.ct;
        this.ct = this.gW() ? Math.min(1.0f, this.ct + 0.2f) : Math.max(0.0f, this.ct - 0.24f);
    }

    @Override
    protected void a(WorldServer level) {
        boolean hasStung = this.gH();
        this.cK = this.bi() ? ++this.cK : 0;
        if (this.cK > 20) {
            this.a(level, this.dW().i(), 1.0f);
        }
        if (hasStung) {
            ++this.cv;
            if (this.cv % 5 == 0 && this.ae.a(MathHelper.a(1200 - this.cv, 1, 1200)) == 0) {
                this.a(level, this.dW().p(), this.eG());
            }
        }
        if (!this.gG()) {
            ++this.cw;
        }
        this.a(level, false);
    }

    public void gv() {
        this.cw = 0;
    }

    private boolean gQ() {
        TileEntityBeehive beehiveBlockEntity = this.gU();
        return beehiveBlockEntity != null && beehiveBlockEntity.a();
    }

    @Override
    public int a() {
        return this.al.a(bU);
    }

    @Override
    public void a(int time) {
        this.al.a(bU, time);
    }

    @Override
    @Nullable
    public UUID b() {
        return this.cs;
    }

    @Override
    public void a(@Nullable UUID target) {
        this.cs = target;
    }

    @Override
    public void c() {
        this.a(cr.a(this.ae));
    }

    private boolean k(BlockPosition hivePos) {
        TileEntity blockEntity = this.dV().c_(hivePos);
        return blockEntity instanceof TileEntityBeehive && !((TileEntityBeehive)blockEntity).d();
    }

    @VisibleForDebug
    public boolean gw() {
        return this.cG != null;
    }

    @Nullable
    @VisibleForDebug
    public BlockPosition gx() {
        return this.cG;
    }

    @VisibleForDebug
    public PathfinderGoalSelector gy() {
        return this.bF;
    }

    @Override
    protected void ab() {
        super.ab();
        PacketDebug.a(this);
    }

    int gR() {
        return this.cy;
    }

    private void gS() {
        this.cy = 0;
    }

    void gT() {
        ++this.cy;
    }

    @Override
    public void d_() {
        super.d_();
        if (!this.dV().C) {
            if (this.cx > 0) {
                --this.cx;
            }
            if (this.cA > 0) {
                --this.cA;
            }
            if (this.cE > 0) {
                --this.cE;
            }
            boolean flag = this.ac_() && !this.gH() && this.e() != null && this.e().g(this) < 4.0;
            this.y(flag);
            if (this.af % 20 == 0 && !this.gV()) {
                this.cG = null;
            }
        }
    }

    @Nullable
    TileEntityBeehive gU() {
        if (this.cG == null) {
            return null;
        }
        return this.l(this.cG) || this.dV().getChunkIfLoadedImmediately(this.cG.u() >> 4, this.cG.w() >> 4) == null ? null : (TileEntityBeehive)this.dV().a(this.cG, TileEntityTypes.I).orElse(null);
    }

    boolean gV() {
        return this.gU() != null;
    }

    public boolean gG() {
        return this.t(8);
    }

    public void w(boolean hasNectar) {
        if (hasNectar) {
            this.gv();
        }
        this.d(8, hasNectar);
    }

    public boolean gH() {
        return this.t(4);
    }

    public void x(boolean hasStung) {
        this.d(4, hasStung);
    }

    public boolean gW() {
        return this.t(2);
    }

    public void y(boolean isRolling) {
        isRolling = this.rollingOverride.toBooleanOrElse(isRolling);
        this.d(2, isRolling);
    }

    boolean l(BlockPosition pos) {
        return !this.b(pos, 48);
    }

    private void d(int flagId, boolean value) {
        if (value) {
            this.al.a(bT, (byte)(this.al.a(bT) | flagId));
        } else {
            this.al.a(bT, (byte)(this.al.a(bT) & ~flagId));
        }
    }

    private boolean t(int flagId) {
        return (this.al.a(bT) & flagId) != 0;
    }

    public static AttributeProvider.Builder gI() {
        return EntityAnimal.gz().a(GenericAttributes.s, 10.0).a(GenericAttributes.l, 0.6f).a(GenericAttributes.v, 0.3f).a(GenericAttributes.c, 2.0);
    }

    @Override
    protected NavigationAbstract b(World level) {
        NavigationFlying flyingPathNavigation = new NavigationFlying(this, level){

            @Override
            public boolean a(BlockPosition pos) {
                return !this.b.a_(pos.e()).l();
            }

            @Override
            public void c() {
                if (!EntityBee.this.cH.l()) {
                    super.c();
                }
            }
        };
        flyingPathNavigation.b(false);
        flyingPathNavigation.a(false);
        flyingPathNavigation.a(48.0f);
        return flyingPathNavigation;
    }

    @Override
    public EnumInteractionResult b(EntityHuman player, EnumHand hand) {
        BlockFlowers flowerBlock;
        MobEffect beeInteractionEffect;
        ItemBlock blockItem;
        IMaterial iMaterial;
        ItemStack itemInHand = player.b(hand);
        if (this.i(itemInHand) && (iMaterial = itemInHand.h()) instanceof ItemBlock && (iMaterial = (blockItem = (ItemBlock)iMaterial).c()) instanceof BlockFlowers && (beeInteractionEffect = (flowerBlock = (BlockFlowers)iMaterial).b()) != null) {
            this.a(player, hand, itemInHand);
            if (!this.dV().C) {
                this.addEffect(beeInteractionEffect, EntityPotionEffectEvent.Cause.FOOD);
            }
            return EnumInteractionResult.a;
        }
        return super.b(player, hand);
    }

    @Override
    public boolean i(ItemStack stack) {
        return stack.a(TagsItem.ao);
    }

    @Override
    protected void b(BlockPosition pos, IBlockData block) {
    }

    @Override
    public SoundEffect s() {
        return null;
    }

    @Override
    public SoundEffect e(DamageSource damageSource) {
        return SoundEffects.bP;
    }

    @Override
    public SoundEffect j_() {
        return SoundEffects.bO;
    }

    @Override
    public float fe() {
        return 0.4f;
    }

    @Nullable
    public EntityBee b(WorldServer level, EntityAgeable otherParent) {
        return EntityTypes.m.a(level, EntitySpawnReason.e);
    }

    @Override
    protected void a(double y2, boolean onGround, IBlockData state, BlockPosition pos) {
    }

    @Override
    public boolean aZ() {
        return this.gJ() && this.af % bJ == 0;
    }

    @Override
    public boolean gJ() {
        return !this.aH();
    }

    public void gK() {
        this.w(false);
        this.gS();
    }

    @Override
    public boolean a(WorldServer level, DamageSource damageSource, float amount) {
        if (this.a(level, damageSource)) {
            return false;
        }
        if (!super.a(level, damageSource, amount)) {
            return false;
        }
        this.cH.m();
        return true;
    }

    @Override
    protected void c(TagKey<FluidType> fluidTag) {
        this.i(this.dy().b(0.0, 0.01, 0.0));
    }

    @Override
    public Vec3D cT() {
        return new Vec3D(0.0, 0.5f * this.cS(), this.dq() * 0.2f);
    }

    boolean b(BlockPosition pos, int distance) {
        return pos.a(this.dv(), (double)distance);
    }

    public void i(BlockPosition hivePos) {
        this.cG = hivePos;
    }

    public static boolean c(IBlockData state) {
        return state.a(TagsBlock.W) && state.a(BlockProperties.I, false) == false && (!state.a(Blocks.jf) || state.c(BlockTallPlant.b) == BlockPropertyDoubleBlockHalf.a);
    }

    class j
    extends ControllerLook {
        j(EntityInsentient mob) {
            super(mob);
        }

        @Override
        public void a() {
            if (!EntityBee.this.ac_()) {
                super.a();
            }
        }

        @Override
        protected boolean c() {
            return !EntityBee.this.cH.l();
        }
    }

    class b
    extends PathfinderGoalMeleeAttack {
        b(EntityCreature mob, double speedModifier, boolean followingTargetEvenIfNotSeen) {
            super(mob, speedModifier, followingTargetEvenIfNotSeen);
        }

        @Override
        public boolean b() {
            return super.b() && EntityBee.this.ac_() && !EntityBee.this.gH();
        }

        @Override
        public boolean c() {
            return super.c() && EntityBee.this.ac_() && !EntityBee.this.gH();
        }
    }

    class d
    extends a {
        d() {
        }

        @Override
        public boolean h() {
            TileEntityBeehive beehiveBlockEntity;
            if (EntityBee.this.cG != null && EntityBee.this.gO() && EntityBee.this.cG.a(EntityBee.this.dt(), 2.0) && (beehiveBlockEntity = EntityBee.this.gU()) != null) {
                if (!beehiveBlockEntity.d()) {
                    return true;
                }
                EntityBee.this.cG = null;
            }
            return false;
        }

        @Override
        public boolean i() {
            return false;
        }

        @Override
        public void d() {
            TileEntityBeehive beehiveBlockEntity = EntityBee.this.gU();
            if (beehiveBlockEntity != null) {
                beehiveBlockEntity.a(EntityBee.this);
            }
        }
    }

    class n
    extends a {
        private final int c;
        private long d;

        n() {
            this.c = MathHelper.a(EntityBee.this.ae, 20, 40);
            this.d = -1L;
        }

        @Override
        public void d() {
            if (EntityBee.this.cG != null && EntityBee.this.dV().p(EntityBee.this.cG) && !EntityBee.this.gV()) {
                EntityBee.this.gM();
            }
            this.d = EntityBee.this.dV().ae();
        }

        @Override
        public boolean h() {
            return EntityBee.this.dV().ae() > this.d + (long)this.c;
        }

        @Override
        public boolean i() {
            return false;
        }
    }

    class m
    extends a {
        private final int c;
        private long d;

        m() {
            this.c = MathHelper.a(EntityBee.this.ae, 20, 40);
            this.d = -1L;
        }

        @Override
        public void d() {
            if (EntityBee.this.cF != null && EntityBee.this.dV().p(EntityBee.this.cF) && !this.a(EntityBee.this.cF)) {
                EntityBee.this.gN();
            }
            this.d = EntityBee.this.dV().ae();
        }

        @Override
        public boolean h() {
            return EntityBee.this.dV().ae() > this.d + (long)this.c;
        }

        @Override
        public boolean i() {
            return false;
        }

        private boolean a(BlockPosition pos) {
            return EntityBee.c(EntityBee.this.dV().a_(pos));
        }
    }

    class k
    extends a {
        private static final int c = 400;
        private static final double d = 0.1;
        private static final int e = 25;
        private static final float f = 0.35f;
        private static final float g = 0.6f;
        private static final float h = 0.33333334f;
        private static final int i = 5;
        private int j;
        private int k;
        private boolean l;
        @Nullable
        private Vec3D m;
        private int n;
        private static final int o = 600;
        private Long2LongOpenHashMap p;

        k() {
            this.p = new Long2LongOpenHashMap();
            this.a(EnumSet.of(PathfinderGoal.Type.a));
        }

        @Override
        public boolean h() {
            if (EntityBee.this.cE > 0) {
                return false;
            }
            if (EntityBee.this.gG()) {
                return false;
            }
            if (EntityBee.this.dV().ah()) {
                return false;
            }
            Optional<BlockPosition> optional = this.p();
            if (optional.isPresent()) {
                EntityBee.this.cF = optional.get();
                EntityBee.this.bE.a((double)EntityBee.this.cF.u() + 0.5, (double)EntityBee.this.cF.v() + 0.5, (double)EntityBee.this.cF.w() + 0.5, 1.2f);
                return true;
            }
            EntityBee.this.cE = MathHelper.a(EntityBee.this.ae, 20, 60);
            return false;
        }

        @Override
        public boolean i() {
            return this.l && EntityBee.this.p() && !EntityBee.this.dV().ah() && (!this.k() || EntityBee.this.ae.i() < 0.2f);
        }

        private boolean k() {
            return this.j > 400;
        }

        boolean l() {
            return this.l;
        }

        void m() {
            this.l = false;
        }

        @Override
        public void d() {
            this.j = 0;
            this.n = 0;
            this.k = 0;
            this.l = true;
            EntityBee.this.gv();
        }

        @Override
        public void e() {
            if (this.k()) {
                EntityBee.this.w(true);
            }
            this.l = false;
            EntityBee.this.bE.m();
            EntityBee.this.cE = 200;
        }

        @Override
        public boolean W_() {
            return true;
        }

        @Override
        public void a() {
            if (EntityBee.this.p()) {
                ++this.n;
                if (this.n > 600) {
                    EntityBee.this.gN();
                    this.l = false;
                    EntityBee.this.cE = 200;
                } else if (EntityBee.this.cF != null) {
                    Vec3D vec3 = Vec3D.c(EntityBee.this.cF).b(0.0, 0.6f, 0.0);
                    if (vec3.f(EntityBee.this.dt()) > 1.0) {
                        this.m = vec3;
                        this.n();
                    } else {
                        if (this.m == null) {
                            this.m = vec3;
                        }
                        boolean flag = EntityBee.this.dt().f(this.m) <= 0.1;
                        boolean flag1 = true;
                        if (!flag && this.n > 600) {
                            EntityBee.this.gN();
                        } else {
                            if (flag) {
                                boolean flag2;
                                boolean bl = flag2 = EntityBee.this.ae.a(25) == 0;
                                if (flag2) {
                                    this.m = new Vec3D(vec3.a() + (double)this.o(), vec3.b(), vec3.c() + (double)this.o());
                                    EntityBee.this.bE.m();
                                } else {
                                    flag1 = false;
                                }
                                EntityBee.this.I().a(vec3.a(), vec3.b(), vec3.c());
                            }
                            if (flag1) {
                                this.n();
                            }
                            ++this.j;
                            if (EntityBee.this.ae.i() < 0.05f && this.j > this.k + 60) {
                                this.k = this.j;
                                EntityBee.this.a(SoundEffects.bT, 1.0f, 1.0f);
                            }
                        }
                    }
                }
            }
        }

        private void n() {
            EntityBee.this.K().a(this.m.a(), this.m.b(), this.m.c(), 0.35f);
        }

        private float o() {
            return (EntityBee.this.ae.i() * 2.0f - 1.0f) * 0.33333334f;
        }

        private Optional<BlockPosition> p() {
            Iterable<BlockPosition> iterable = BlockPosition.a(EntityBee.this.dv(), 5, 5, 5);
            Long2LongOpenHashMap map = new Long2LongOpenHashMap();
            for (BlockPosition blockPos : iterable) {
                long orDefault = this.p.getOrDefault(blockPos.a(), Long.MIN_VALUE);
                if (EntityBee.this.dV().ae() < orDefault) {
                    map.put(blockPos.a(), orDefault);
                    continue;
                }
                if (!EntityBee.c(EntityBee.this.dV().a_(blockPos))) continue;
                PathEntity path = EntityBee.this.bE.a(blockPos, 1);
                if (path != null && path.j()) {
                    return Optional.of(blockPos);
                }
                map.put(blockPos.a(), EntityBee.this.dV().ae() + 600L);
            }
            this.p = map;
            return Optional.empty();
        }
    }

    class i
    extends a {
        i() {
        }

        @Override
        public boolean h() {
            return EntityBee.this.cA == 0 && !EntityBee.this.gw() && EntityBee.this.gO();
        }

        @Override
        public boolean i() {
            return false;
        }

        @Override
        public void d() {
            EntityBee.this.cA = 200;
            List<BlockPosition> list = this.k();
            if (!list.isEmpty()) {
                for (BlockPosition blockPos : list) {
                    if (EntityBee.this.cI.b(blockPos)) continue;
                    EntityBee.this.cG = blockPos;
                    return;
                }
                EntityBee.this.cI.k();
                EntityBee.this.cG = list.get(0);
            }
        }

        private List<BlockPosition> k() {
            BlockPosition blockPos = EntityBee.this.dv();
            VillagePlace poiManager = ((WorldServer)EntityBee.this.dV()).A();
            Stream<VillagePlaceRecord> inRange = poiManager.c(poiRecord -> poiRecord.a(PoiTypeTags.c), blockPos, 20, VillagePlace.Occupancy.c);
            return inRange.map(VillagePlaceRecord::g).filter(EntityBee.this::k).sorted(Comparator.comparingDouble(pos -> pos.j(blockPos))).collect(Collectors.toList());
        }
    }

    @VisibleForDebug
    public class e
    extends a {
        public static final int b = 2400;
        int d;
        private static final int e = 3;
        final List<BlockPosition> f;
        @Nullable
        private PathEntity g;
        private static final int h = 60;
        private int i;

        e() {
            this.d = EntityBee.this.ae.a(10);
            this.f = Lists.newArrayList();
            this.a(EnumSet.of(PathfinderGoal.Type.a));
        }

        @Override
        public boolean h() {
            return EntityBee.this.cG != null && !EntityBee.this.l(EntityBee.this.cG) && !EntityBee.this.gi() && EntityBee.this.gO() && !this.d(EntityBee.this.cG) && EntityBee.this.dV().a_(EntityBee.this.cG).a(TagsBlock.aJ);
        }

        @Override
        public boolean i() {
            return this.h();
        }

        @Override
        public void d() {
            this.d = 0;
            this.i = 0;
            super.d();
        }

        @Override
        public void e() {
            this.d = 0;
            this.i = 0;
            EntityBee.this.bE.m();
            EntityBee.this.bE.f();
        }

        @Override
        public void a() {
            if (EntityBee.this.cG != null) {
                ++this.d;
                if (this.d > this.a(2400)) {
                    this.l();
                } else if (!EntityBee.this.bE.l()) {
                    if (!EntityBee.this.b(EntityBee.this.cG, 16)) {
                        if (EntityBee.this.l(EntityBee.this.cG)) {
                            EntityBee.this.gM();
                        } else {
                            EntityBee.this.j(EntityBee.this.cG);
                        }
                    } else {
                        boolean flag = this.a(EntityBee.this.cG);
                        if (!flag) {
                            this.l();
                        } else if (this.g != null && EntityBee.this.bE.i().a(this.g)) {
                            ++this.i;
                            if (this.i > 60) {
                                EntityBee.this.gM();
                                this.i = 0;
                            }
                        } else {
                            this.g = EntityBee.this.bE.i();
                        }
                    }
                }
            }
        }

        private boolean a(BlockPosition pos) {
            int i2 = EntityBee.this.b(pos, 3) ? 1 : 2;
            EntityBee.this.bE.b(10.0f);
            EntityBee.this.bE.a(pos.u(), (double)pos.v(), pos.w(), i2, 1.0);
            return EntityBee.this.bE.i() != null && EntityBee.this.bE.i().j();
        }

        boolean b(BlockPosition pos) {
            return this.f.contains(pos);
        }

        private void c(BlockPosition pos) {
            this.f.add(pos);
            while (this.f.size() > 3) {
                this.f.remove(0);
            }
        }

        void k() {
            this.f.clear();
        }

        private void l() {
            if (EntityBee.this.cG != null) {
                this.c(EntityBee.this.cG);
            }
            EntityBee.this.gM();
        }

        private boolean d(BlockPosition pos) {
            if (EntityBee.this.b(pos, 2)) {
                return true;
            }
            PathEntity path = EntityBee.this.bE.i();
            return path != null && path.l().equals(pos) && path.j() && path.c();
        }
    }

    public class f
    extends a {
        private static final int c = 2400;
        int d;

        f() {
            this.d = EntityBee.this.ae.a(10);
            this.a(EnumSet.of(PathfinderGoal.Type.a));
        }

        @Override
        public boolean h() {
            return EntityBee.this.cF != null && !EntityBee.this.gi() && this.k() && !EntityBee.this.b(EntityBee.this.cF, 2);
        }

        @Override
        public boolean i() {
            return this.h();
        }

        @Override
        public void d() {
            this.d = 0;
            super.d();
        }

        @Override
        public void e() {
            this.d = 0;
            EntityBee.this.bE.m();
            EntityBee.this.bE.f();
        }

        @Override
        public void a() {
            if (EntityBee.this.cF != null) {
                ++this.d;
                if (this.d > this.a(2400)) {
                    EntityBee.this.gN();
                } else if (!EntityBee.this.bE.l()) {
                    if (EntityBee.this.l(EntityBee.this.cF)) {
                        EntityBee.this.gN();
                    } else {
                        EntityBee.this.j(EntityBee.this.cF);
                    }
                }
            }
        }

        private boolean k() {
            return EntityBee.this.cw > 600;
        }
    }

    class g
    extends a {
        static final int b = 30;

        g() {
        }

        @Override
        public boolean h() {
            return EntityBee.this.gR() < 10 && !(EntityBee.this.ae.i() < 0.3f) && EntityBee.this.gG() && EntityBee.this.gV();
        }

        @Override
        public boolean i() {
            return this.h();
        }

        @Override
        public void a() {
            if (EntityBee.this.ae.a(this.a(30)) == 0) {
                for (int i2 = 1; i2 <= 2; ++i2) {
                    IBlockFragilePlantElement bonemealableBlock;
                    BlockPosition blockPos = EntityBee.this.dv().c(i2);
                    IBlockData blockState = EntityBee.this.dV().a_(blockPos);
                    Block block = blockState.b();
                    IBlockData blockState1 = null;
                    if (!blockState.a(TagsBlock.aL)) continue;
                    if (block instanceof BlockCrops) {
                        BlockCrops cropBlock = (BlockCrops)block;
                        if (!cropBlock.i(blockState)) {
                            blockState1 = cropBlock.b(cropBlock.h(blockState) + 1);
                        }
                    } else if (block instanceof BlockStem) {
                        int ageValue = blockState.c(BlockStem.c);
                        if (ageValue < 7) {
                            blockState1 = (IBlockData)blockState.b(BlockStem.c, ageValue + 1);
                        }
                    } else if (blockState.a(Blocks.oO)) {
                        int ageValue = blockState.c(BlockSweetBerryBush.c);
                        if (ageValue < 3) {
                            blockState1 = (IBlockData)blockState.b(BlockSweetBerryBush.c, ageValue + 1);
                        }
                    } else if ((blockState.a(Blocks.td) || blockState.a(Blocks.te)) && (bonemealableBlock = (IBlockFragilePlantElement)((Object)blockState.b())).a(EntityBee.this.dV(), blockPos, blockState)) {
                        bonemealableBlock.a((WorldServer)EntityBee.this.dV(), EntityBee.this.ae, blockPos, blockState);
                        blockState1 = EntityBee.this.dV().a_(blockPos);
                    }
                    if (blockState1 == null || !CraftEventFactory.callEntityChangeBlockEvent(EntityBee.this, blockPos, blockState1)) continue;
                    EntityBee.this.dV().c(2011, blockPos, 15);
                    EntityBee.this.dV().b(blockPos, blockState1);
                    EntityBee.this.gT();
                }
            }
        }
    }

    class l
    extends PathfinderGoal {
        l() {
            this.a(EnumSet.of(PathfinderGoal.Type.a));
        }

        @Override
        public boolean b() {
            return EntityBee.this.bE.k() && EntityBee.this.ae.a(10) == 0;
        }

        @Override
        public boolean c() {
            return EntityBee.this.bE.l();
        }

        @Override
        public void d() {
            Vec3D vec3 = this.h();
            if (vec3 != null) {
                EntityBee.this.bE.a(EntityBee.this.bE.a(BlockPosition.a(vec3), 1), 1.0);
            }
        }

        @Nullable
        private Vec3D h() {
            Vec3D vec31;
            if (EntityBee.this.gV() && !EntityBee.this.b(EntityBee.this.cG, this.i())) {
                Vec3D vec3 = Vec3D.b(EntityBee.this.cG);
                vec31 = vec3.d(EntityBee.this.dt()).d();
            } else {
                vec31 = EntityBee.this.h(0.0f);
            }
            int i2 = 8;
            Vec3D pos = HoverRandomPos.a(EntityBee.this, 8, 7, vec31.d, vec31.f, 1.5707964f, 3, 1);
            return pos != null ? pos : AirAndWaterRandomPos.a(EntityBee.this, 8, 4, -2, vec31.d, vec31.f, 1.5707963705062866);
        }

        private int i() {
            int i2 = !EntityBee.this.gw() && !EntityBee.this.p() ? 16 : 24;
            return 48 - i2;
        }
    }

    class h
    extends PathfinderGoalHurtByTarget {
        h(EntityBee mob) {
            super(mob, new Class[0]);
        }

        @Override
        public boolean c() {
            return EntityBee.this.ac_() && super.c();
        }

        @Override
        protected void a(EntityInsentient mob, EntityLiving target) {
            if (mob instanceof EntityBee && this.e.E(target)) {
                mob.setTarget(target, EntityTargetEvent.TargetReason.TARGET_ATTACKED_ENTITY);
            }
        }
    }

    static class c
    extends PathfinderGoalNearestAttackableTarget<EntityHuman> {
        c(EntityBee mob) {
            super(mob, EntityHuman.class, 10, true, false, mob::a);
        }

        @Override
        public boolean b() {
            return this.i() && super.b();
        }

        @Override
        public boolean c() {
            boolean flag = this.i();
            if (flag && this.e.e() != null) {
                return super.c();
            }
            this.g = null;
            return false;
        }

        private boolean i() {
            EntityBee bee = (EntityBee)this.e;
            return bee.ac_() && !bee.gH();
        }
    }

    abstract class a
    extends PathfinderGoal {
        a() {
        }

        public abstract boolean h();

        public abstract boolean i();

        @Override
        public boolean b() {
            return this.h() && !EntityBee.this.ac_();
        }

        @Override
        public boolean c() {
            return this.i() && !EntityBee.this.ac_();
        }
    }
}

