/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal;

import io.papermc.paper.event.entity.EntityDyeEvent;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTameableAnimal;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.goal.PathfinderGoalAvoidTarget;
import net.minecraft.world.entity.ai.goal.PathfinderGoalBreed;
import net.minecraft.world.entity.ai.goal.PathfinderGoalCatSitOnBed;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFollowOwner;
import net.minecraft.world.entity.ai.goal.PathfinderGoalJumpOnBlock;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLeapAtTarget;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalOcelotAttack;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStrollLand;
import net.minecraft.world.entity.ai.goal.PathfinderGoalSit;
import net.minecraft.world.entity.ai.goal.PathfinderGoalTempt;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalRandomTargetNonTamed;
import net.minecraft.world.entity.animal.CatVariant;
import net.minecraft.world.entity.animal.CatVariants;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.animal.EntityRabbit;
import net.minecraft.world.entity.animal.EntityTurtle;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.variant.SpawnContext;
import net.minecraft.world.entity.variant.VariantUtils;
import net.minecraft.world.food.FoodInfo;
import net.minecraft.world.item.EnumColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDye;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.BlockFacingHorizontal;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.storage.loot.LootTables;
import net.minecraft.world.phys.AxisAlignedBB;
import org.bukkit.DyeColor;
import org.bukkit.craftbukkit.v1_21_R4.event.CraftEventFactory;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.EntityDropItemEvent;
import org.bukkit.event.entity.EntityRegainHealthEvent;

public class EntityCat
extends EntityTameableAnimal {
    public static final double bM = 0.6;
    public static final double bN = 0.8;
    public static final double bO = 1.33;
    private static final DataWatcherObject<Holder<CatVariant>> bP = DataWatcher.a(EntityCat.class, DataWatcherRegistry.x);
    private static final DataWatcherObject<Boolean> bQ = DataWatcher.a(EntityCat.class, DataWatcherRegistry.k);
    private static final DataWatcherObject<Boolean> bR = DataWatcher.a(EntityCat.class, DataWatcherRegistry.k);
    private static final DataWatcherObject<Integer> bS = DataWatcher.a(EntityCat.class, DataWatcherRegistry.b);
    private static final ResourceKey<CatVariant> bT = CatVariants.b;
    private static final EnumColor bU = EnumColor.o;
    @Nullable
    private a<EntityHuman> bV;
    @Nullable
    private PathfinderGoalTempt bW;
    private float bX;
    private float bY;
    private float bZ;
    private float ca;
    private boolean cb;
    private float cc;
    private float cd;

    public EntityCat(EntityTypes<? extends EntityCat> entityType, World level) {
        super((EntityTypes<? extends EntityTameableAnimal>)entityType, level);
        this.gM();
    }

    @Override
    protected void C() {
        this.bW = new PathfinderGoalTemptChance(this, 0.6, stack -> stack.a(TagsItem.aj), true);
        this.bF.a(1, new PathfinderGoalFloat(this));
        this.bF.a(1, new EntityTameableAnimal.a(1.5));
        this.bF.a(2, new PathfinderGoalSit(this));
        this.bF.a(3, new b(this));
        this.bF.a(4, this.bW);
        this.bF.a(5, new PathfinderGoalCatSitOnBed(this, 1.1, 8));
        this.bF.a(6, new PathfinderGoalFollowOwner(this, 1.0, 10.0f, 5.0f));
        this.bF.a(7, new PathfinderGoalJumpOnBlock(this, 0.8));
        this.bF.a(8, new PathfinderGoalLeapAtTarget(this, 0.3f));
        this.bF.a(9, new PathfinderGoalOcelotAttack(this));
        this.bF.a(10, new PathfinderGoalBreed(this, 0.8));
        this.bF.a(11, new PathfinderGoalRandomStrollLand((EntityCreature)this, 0.8, 1.0000001E-5f));
        this.bF.a(12, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 10.0f));
        this.bG.a(1, new PathfinderGoalRandomTargetNonTamed<EntityRabbit>(this, EntityRabbit.class, false, null));
        this.bG.a(1, new PathfinderGoalRandomTargetNonTamed<EntityTurtle>(this, EntityTurtle.class, false, EntityTurtle.bI));
    }

    public Holder<CatVariant> gG() {
        return this.al.a(bP);
    }

    public void j(Holder<CatVariant> variant) {
        this.al.a(bP, variant);
    }

    @Override
    @Nullable
    public <T> T a(DataComponentType<? extends T> component) {
        if (component == DataComponents.aP) {
            return EntityCat.c(component, this.gG());
        }
        return component == DataComponents.aQ ? EntityCat.c(component, this.gI()) : super.a(component);
    }

    @Override
    protected void a(DataComponentGetter componentGetter) {
        this.a(componentGetter, DataComponents.aP);
        this.a(componentGetter, DataComponents.aQ);
        super.a(componentGetter);
    }

    @Override
    protected <T> boolean b(DataComponentType<T> component, T value) {
        if (component == DataComponents.aP) {
            this.j(EntityCat.c(DataComponents.aP, value));
            return true;
        }
        if (component == DataComponents.aQ) {
            this.a(EntityCat.c(DataComponents.aQ, value));
            return true;
        }
        return super.b(component, value);
    }

    public void z(boolean lying) {
        this.al.a(bQ, lying);
    }

    public boolean gH() {
        return this.al.a(bQ);
    }

    public void A(boolean relaxStateOne) {
        this.al.a(bR, relaxStateOne);
    }

    public boolean gN() {
        return this.al.a(bR);
    }

    public EnumColor gI() {
        return EnumColor.a(this.al.a(bS));
    }

    public void a(EnumColor color) {
        this.al.a(bS, color.a());
    }

    @Override
    protected void a(DataWatcher.a builder) {
        super.a(builder);
        builder.a(bP, VariantUtils.a(this.dX(), bT));
        builder.a(bQ, false);
        builder.a(bR, false);
        builder.a(bS, bU.a());
    }

    @Override
    public void b(NBTTagCompound compound) {
        super.b(compound);
        VariantUtils.a(compound, this.gG());
        compound.a("CollarColor", EnumColor.s, this.gI());
    }

    @Override
    public void a(NBTTagCompound compound) {
        super.a(compound);
        VariantUtils.a(compound, this.dX(), Registries.aH).ifPresent(this::j);
        this.a(compound.a("CollarColor", EnumColor.s).orElse(bU));
    }

    @Override
    public void a(WorldServer level) {
        if (this.K().b()) {
            double speedModifier = this.K().c();
            if (speedModifier == 0.6) {
                this.b(EntityPose.f);
                this.h(false);
            } else if (speedModifier == 1.33) {
                this.b(EntityPose.a);
                this.h(true);
            } else {
                this.b(EntityPose.a);
                this.h(false);
            }
        } else {
            this.b(EntityPose.a);
            this.h(false);
        }
    }

    @Override
    @Nullable
    public SoundEffect s() {
        if (this.m()) {
            if (this.gE()) {
                return SoundEffects.eb;
            }
            return this.ae.a(4) == 0 ? SoundEffects.ec : SoundEffects.dU;
        }
        return SoundEffects.dV;
    }

    @Override
    public int R() {
        return 120;
    }

    public void gJ() {
        this.b(SoundEffects.dY);
    }

    @Override
    public SoundEffect e(DamageSource damageSource) {
        return SoundEffects.ea;
    }

    @Override
    public SoundEffect j_() {
        return SoundEffects.dW;
    }

    public static AttributeProvider.Builder gK() {
        return EntityAnimal.gz().a(GenericAttributes.s, 10.0).a(GenericAttributes.v, 0.3f).a(GenericAttributes.c, 3.0);
    }

    @Override
    protected void gA() {
        this.a(SoundEffects.dX, 1.0f, 1.0f);
    }

    @Override
    public void g() {
        super.g();
        if (this.bW != null && this.bW.i() && !this.m() && this.af % 100 == 0) {
            this.a(SoundEffects.dZ, 1.0f, 1.0f);
        }
        this.gO();
    }

    private void gO() {
        if ((this.gH() || this.gN()) && this.af % 5 == 0) {
            this.a(SoundEffects.eb, 0.6f + 0.4f * (this.ae.i() - this.ae.i()), 1.0f);
        }
        this.gP();
        this.gQ();
        this.cb = false;
        if (this.gH()) {
            BlockPosition blockPos = this.dv();
            for (EntityHuman player : this.dV().a(EntityHuman.class, new AxisAlignedBB(blockPos).c(2.0, 2.0, 2.0))) {
                if (!player.fR()) continue;
                this.cb = true;
                break;
            }
        }
    }

    public boolean gL() {
        return this.cb;
    }

    private void gP() {
        this.bY = this.bX;
        this.ca = this.bZ;
        if (this.gH()) {
            this.bX = Math.min(1.0f, this.bX + 0.15f);
            this.bZ = Math.min(1.0f, this.bZ + 0.08f);
        } else {
            this.bX = Math.max(0.0f, this.bX - 0.22f);
            this.bZ = Math.max(0.0f, this.bZ - 0.13f);
        }
    }

    private void gQ() {
        this.cd = this.cc;
        this.cc = this.gN() ? Math.min(1.0f, this.cc + 0.1f) : Math.max(0.0f, this.cc - 0.13f);
    }

    public float J(float partialTicks) {
        return MathHelper.h(partialTicks, this.bY, this.bX);
    }

    public float K(float partialTicks) {
        return MathHelper.h(partialTicks, this.ca, this.bZ);
    }

    public float L(float partialTicks) {
        return MathHelper.h(partialTicks, this.cd, this.cc);
    }

    @Nullable
    public EntityCat b(WorldServer level, EntityAgeable otherParent) {
        EntityCat cat = EntityTypes.v.a(level, EntitySpawnReason.e);
        if (cat != null && otherParent instanceof EntityCat) {
            EntityCat cat1 = (EntityCat)otherParent;
            if (this.ae.h()) {
                cat.j(this.gG());
            } else {
                cat.j(cat1.gG());
            }
            if (this.m()) {
                ((EntityTameableAnimal)cat).a(this.d());
                cat.a(true, true);
                EnumColor collarColor = this.gI();
                EnumColor collarColor1 = cat1.gI();
                cat.a(EnumColor.a(level, collarColor, collarColor1));
            }
        }
        return cat;
    }

    @Override
    public boolean a(EntityAnimal otherAnimal) {
        EntityCat cat;
        return this.m() && otherAnimal instanceof EntityCat && (cat = (EntityCat)otherAnimal).m() && super.a(otherAnimal);
    }

    @Override
    @Nullable
    public GroupDataEntity a(WorldAccess level, DifficultyDamageScaler difficulty, EntitySpawnReason spawnReason, @Nullable GroupDataEntity spawnGroupData) {
        spawnGroupData = super.a(level, difficulty, spawnReason, spawnGroupData);
        CatVariants.a(this.ae, this.dX(), SpawnContext.a(level, this.dv())).ifPresent(this::j);
        return spawnGroupData;
    }

    @Override
    public EnumInteractionResult b(EntityHuman player, EnumHand hand) {
        EnumInteractionResult interactionResult;
        ItemStack itemInHand = player.b(hand);
        Item item = itemInHand.h();
        if (this.m()) {
            if (this.j(player)) {
                EnumInteractionResult interactionResult2;
                if (item instanceof ItemDye) {
                    ItemDye dyeItem = (ItemDye)item;
                    EnumColor dyeColor = dyeItem.a();
                    if (dyeColor != this.gI()) {
                        EntityDyeEvent event = new EntityDyeEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), DyeColor.getByWoolData((byte)((byte)dyeColor.a())), (Player)((EntityPlayer)player).getBukkitEntity());
                        if (!event.callEvent()) {
                            return EnumInteractionResult.d;
                        }
                        dyeColor = EnumColor.a(event.getColor().getWoolData());
                        if (!this.dV().A_()) {
                            this.a(dyeColor);
                            itemInHand.a(1, (EntityLiving)player);
                            this.gc();
                        }
                        return EnumInteractionResult.a;
                    }
                } else if (this.i(itemInHand) && this.eG() < this.eU()) {
                    if (!this.dV().A_()) {
                        this.a(player, hand, itemInHand);
                        FoodInfo foodProperties = itemInHand.a(DataComponents.v);
                        this.heal(foodProperties != null ? (float)foodProperties.a() : 1.0f, EntityRegainHealthEvent.RegainReason.EATING);
                        this.gA();
                    }
                    return EnumInteractionResult.a;
                }
                if (!(interactionResult2 = super.b(player, hand)).a()) {
                    this.y(!this.gu());
                    return EnumInteractionResult.a;
                }
                return interactionResult2;
            }
        } else if (this.i(itemInHand)) {
            if (!this.dV().A_()) {
                this.a(player, hand, itemInHand);
                this.f(player);
                this.gc();
                this.gA();
            }
            return EnumInteractionResult.a;
        }
        if ((interactionResult = super.b(player, hand)).a()) {
            this.gc();
        }
        return interactionResult;
    }

    @Override
    public boolean i(ItemStack stack) {
        return stack.a(TagsItem.aj);
    }

    @Override
    public boolean h(double distanceToClosestPlayer) {
        return !this.m() && this.af > 2400;
    }

    @Override
    public void a(boolean tame, boolean applyTamingSideEffects) {
        super.a(tame, applyTamingSideEffects);
        this.gM();
    }

    protected void gM() {
        if (this.bV == null) {
            this.bV = new a<EntityHuman>(this, EntityHuman.class, 16.0f, 0.8, 1.33);
        }
        this.bF.a(this.bV);
        if (!this.m()) {
            this.bF.a(4, this.bV);
        }
    }

    private void f(EntityHuman player) {
        if (this.ae.a(3) == 0 && !CraftEventFactory.callEntityTameEvent(this, player).isCancelled()) {
            this.a(player);
            this.y(true);
            this.dV().a((Entity)this, (byte)7);
        } else {
            this.dV().a((Entity)this, (byte)6);
        }
    }

    @Override
    public boolean cd() {
        return this.ch() || super.cd();
    }

    static class PathfinderGoalTemptChance
    extends PathfinderGoalTempt {
        @Nullable
        private EntityLiving selectedPlayer;
        private final EntityCat d;

        public PathfinderGoalTemptChance(EntityCat cat, double speedModifier, Predicate<ItemStack> items, boolean canScare) {
            super(cat, speedModifier, items, canScare);
            this.d = cat;
        }

        @Override
        public void a() {
            super.a();
            if (this.selectedPlayer == null && this.a.dY().a(this.a(600)) == 0) {
                this.selectedPlayer = this.player;
            } else if (this.a.dY().a(this.a(500)) == 0) {
                this.selectedPlayer = null;
            }
        }

        @Override
        protected boolean h() {
            return (this.selectedPlayer == null || !this.selectedPlayer.equals(this.player)) && super.h();
        }

        @Override
        public boolean b() {
            return super.b() && !this.d.m();
        }
    }

    static class b
    extends PathfinderGoal {
        private final EntityCat a;
        @Nullable
        private EntityHuman b;
        @Nullable
        private BlockPosition c;
        private int d;

        public b(EntityCat cat) {
            this.a = cat;
        }

        @Override
        public boolean b() {
            if (!this.a.m()) {
                return false;
            }
            if (this.a.gu()) {
                return false;
            }
            EntityLiving owner = this.a.T_();
            if (owner instanceof EntityHuman) {
                EntityHuman player;
                this.b = player = (EntityHuman)owner;
                if (!owner.fR()) {
                    return false;
                }
                if (this.a.g((Entity)this.b) > 100.0) {
                    return false;
                }
                BlockPosition blockPos = this.b.dv();
                IBlockData blockState = this.a.dV().a_(blockPos);
                if (blockState.a(TagsBlock.T)) {
                    this.c = blockState.d(BlockFacingHorizontal.e).map(pos -> blockPos.a(pos.g())).orElseGet(() -> new BlockPosition(blockPos));
                    return !this.h();
                }
            }
            return false;
        }

        private boolean h() {
            for (EntityCat cat : this.a.dV().a(EntityCat.class, new AxisAlignedBB(this.c).g(2.0))) {
                if (cat == this.a || !cat.gH() && !cat.gN()) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean c() {
            return this.a.m() && !this.a.gu() && this.b != null && this.b.fR() && this.c != null && !this.h();
        }

        @Override
        public void d() {
            if (this.c != null) {
                this.a.x(false);
                this.a.N().a((double)this.c.u(), (double)this.c.v(), (double)this.c.w(), 1.1f);
            }
        }

        @Override
        public void e() {
            this.a.z(false);
            float timeOfDay = this.a.dV().f(1.0f);
            if (this.b.gp() >= 100 && (double)timeOfDay > 0.77 && (double)timeOfDay < 0.8 && (double)this.a.dV().G_().i() < 0.7) {
                this.i();
            }
            this.d = 0;
            this.a.A(false);
            this.a.N().m();
        }

        private void i() {
            RandomSource random = this.a.dY();
            BlockPosition.MutableBlockPosition mutableBlockPos = new BlockPosition.MutableBlockPosition();
            mutableBlockPos.g(this.a.Q_() ? this.a.B().dv() : this.a.dv());
            this.a.b(mutableBlockPos.u() + random.a(11) - 5, mutableBlockPos.v() + random.a(5) - 2, mutableBlockPos.w() + random.a(11) - 5, false);
            mutableBlockPos.g(this.a.dv());
            this.a.a(net.minecraft.world.entity.animal.EntityCat$b.a(this.a), LootTables.aq, (WorldServer level, ItemStack stack) -> {
                EntityItem item = new EntityItem((World)level, (double)mutableBlockPos.u() - (double)MathHelper.a(this.a.aV * ((float)Math.PI / 180)), mutableBlockPos.v(), (double)mutableBlockPos.w() + (double)MathHelper.b(this.a.aV * ((float)Math.PI / 180)), (ItemStack)stack);
                EntityDropItemEvent event = new EntityDropItemEvent((org.bukkit.entity.Entity)this.a.getBukkitEntity(), (org.bukkit.entity.Item)item.getBukkitEntity());
                if (!event.callEvent()) {
                    return;
                }
                level.b(item);
            });
        }

        @Override
        public void a() {
            if (this.b != null && this.c != null) {
                this.a.x(false);
                this.a.N().a((double)this.c.u(), (double)this.c.v(), (double)this.c.w(), 1.1f);
                if (this.a.g((Entity)this.b) < 2.5) {
                    ++this.d;
                    if (this.d > this.a(16)) {
                        this.a.z(true);
                        this.a.A(false);
                    } else {
                        this.a.a((Entity)this.b, 45.0f, 45.0f);
                        this.a.A(true);
                    }
                } else {
                    this.a.z(false);
                }
            }
        }
    }

    static class a<T extends EntityLiving>
    extends PathfinderGoalAvoidTarget<T> {
        private final EntityCat i;

        public a(EntityCat cat, Class<T> entityClassToAvoid, float maxDist, double walkSpeedModifier, double sprintSpeedModifier) {
            super(cat, entityClassToAvoid, maxDist, walkSpeedModifier, sprintSpeedModifier, IEntitySelector.e::test);
            this.i = cat;
        }

        @Override
        public boolean b() {
            return !this.i.m() && super.b();
        }

        @Override
        public boolean c() {
            return !this.i.m() && super.c();
        }
    }
}

