/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal;

import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.MathHelper;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.PathfinderGoalBreed;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFollowParent;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalPanic;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomLookaround;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStrollLand;
import net.minecraft.world.entity.ai.goal.PathfinderGoalTempt;
import net.minecraft.world.entity.animal.ChickenVariant;
import net.minecraft.world.entity.animal.ChickenVariants;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.variant.SpawnContext;
import net.minecraft.world.entity.variant.VariantUtils;
import net.minecraft.world.item.EitherHolder;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.storage.loot.LootTables;
import net.minecraft.world.phys.Vec3D;

public class EntityChicken
extends EntityAnimal {
    private static final EntitySize bQ = EntityTypes.A.n().a(0.5f).b(0.2975f);
    private static final DataWatcherObject<Holder<ChickenVariant>> bR = DataWatcher.a(EntityChicken.class, DataWatcherRegistry.y);
    private static final boolean bS = false;
    public float bI;
    public float bJ;
    public float bK;
    public float bM;
    public float bN = 1.0f;
    private float bT = 1.0f;
    public int bO = this.ae.a(6000) + 6000;
    public boolean bP = false;

    public EntityChicken(EntityTypes<? extends EntityChicken> entityType, World level) {
        super((EntityTypes<? extends EntityAnimal>)entityType, level);
        this.a(PathType.j, 0.0f);
    }

    @Override
    protected void C() {
        this.bF.a(0, new PathfinderGoalFloat(this));
        this.bF.a(1, new PathfinderGoalPanic(this, 1.4));
        this.bF.a(2, new PathfinderGoalBreed(this, 1.0));
        this.bF.a(3, new PathfinderGoalTempt(this, 1.0, itemStack -> itemStack.a(TagsItem.ap), false));
        this.bF.a(4, new PathfinderGoalFollowParent(this, 1.1));
        this.bF.a(5, new PathfinderGoalRandomStrollLand(this, 1.0));
        this.bF.a(6, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 6.0f));
        this.bF.a(7, new PathfinderGoalRandomLookaround(this));
    }

    @Override
    public EntitySize e(EntityPose pose) {
        return this.e_() ? bQ : super.e(pose);
    }

    public static AttributeProvider.Builder m() {
        return EntityAnimal.gz().a(GenericAttributes.s, 4.0).a(GenericAttributes.v, 0.25);
    }

    @Override
    public void d_() {
        super.d_();
        this.bM = this.bI;
        this.bK = this.bJ;
        this.bJ += (this.aH() ? -1.0f : 4.0f) * 0.3f;
        this.bJ = MathHelper.a(this.bJ, 0.0f, 1.0f);
        if (!this.aH() && this.bN < 1.0f) {
            this.bN = 1.0f;
        }
        this.bN *= 0.9f;
        Vec3D deltaMovement = this.dy();
        if (!this.aH() && deltaMovement.e < 0.0) {
            this.i(deltaMovement.d(1.0, 0.6, 1.0));
        }
        this.bI += this.bN * 2.0f;
        World world = this.dV();
        if (world instanceof WorldServer) {
            WorldServer serverLevel = (WorldServer)world;
            if (this.bJ() && !this.e_() && !this.u() && --this.bO <= 0) {
                this.forceDrops = true;
                if (this.a(serverLevel, LootTables.aI, this::a)) {
                    this.a(SoundEffects.eX, 1.0f, (this.ae.i() - this.ae.i()) * 0.2f + 1.0f);
                    ((Entity)this).a(GameEvent.t);
                }
                this.forceDrops = false;
                this.bO = this.ae.a(6000) + 6000;
            }
        }
    }

    @Override
    protected boolean aZ() {
        return this.Y > this.bT;
    }

    @Override
    protected void aY() {
        this.bT = this.Y + this.bJ / 2.0f;
    }

    @Override
    public SoundEffect s() {
        return SoundEffects.eV;
    }

    @Override
    public SoundEffect e(DamageSource damageSource) {
        return SoundEffects.eY;
    }

    @Override
    public SoundEffect j_() {
        return SoundEffects.eW;
    }

    @Override
    protected void b(BlockPosition pos, IBlockData block) {
        this.a(SoundEffects.eZ, 0.15f, 1.0f);
    }

    @Nullable
    public EntityChicken b(WorldServer level, EntityAgeable otherParent) {
        EntityChicken chicken = EntityTypes.A.a(level, EntitySpawnReason.e);
        if (chicken != null && otherParent instanceof EntityChicken) {
            EntityChicken chicken1 = (EntityChicken)otherParent;
            chicken.j(this.ae.h() ? this.p() : chicken1.p());
        }
        return chicken;
    }

    @Override
    public GroupDataEntity a(WorldAccess level, DifficultyDamageScaler difficulty, EntitySpawnReason spawnReason, @Nullable GroupDataEntity spawnGroupData) {
        ChickenVariants.a(this.ae, this.dX(), SpawnContext.a(level, this.dv())).ifPresent(this::j);
        return super.a(level, difficulty, spawnReason, spawnGroupData);
    }

    @Override
    public boolean i(ItemStack stack) {
        return stack.a(TagsItem.ap);
    }

    @Override
    protected int e(WorldServer level) {
        return this.u() ? 10 : super.e(level);
    }

    @Override
    protected void a(DataWatcher.a builder) {
        super.a(builder);
        builder.a(bR, VariantUtils.a(this.dX(), ChickenVariants.a));
    }

    @Override
    public void a(NBTTagCompound compound) {
        super.a(compound);
        this.bP = compound.b("IsChickenJockey", false);
        compound.e("EggLayTime").ifPresent(integer -> {
            this.bO = integer;
        });
        VariantUtils.a(compound, this.dX(), Registries.aJ).ifPresent(this::j);
    }

    @Override
    public void b(NBTTagCompound compound) {
        super.b(compound);
        compound.a("IsChickenJockey", this.bP);
        compound.a("EggLayTime", this.bO);
        VariantUtils.a(compound, this.p());
    }

    public void j(Holder<ChickenVariant> variant) {
        this.al.a(bR, variant);
    }

    public Holder<ChickenVariant> p() {
        return this.al.a(bR);
    }

    @Override
    @Nullable
    public <T> T a(DataComponentType<? extends T> component) {
        return component == DataComponents.aJ ? EntityChicken.c(component, new EitherHolder<ChickenVariant>(this.p())) : super.a(component);
    }

    @Override
    protected void a(DataComponentGetter componentGetter) {
        this.a(componentGetter, DataComponents.aJ);
        super.a(componentGetter);
    }

    @Override
    protected <T> boolean b(DataComponentType<T> component, T value) {
        if (component == DataComponents.aJ) {
            Optional<Holder<ChickenVariant>> optional = EntityChicken.c(DataComponents.aJ, value).a(this.dX());
            if (optional.isPresent()) {
                this.j(optional.get());
                return true;
            }
            return false;
        }
        return super.b(component, value);
    }

    @Override
    public boolean h(double distanceToClosestPlayer) {
        return this.u();
    }

    @Override
    protected void a(Entity passenger, Entity.MoveFunction callback) {
        super.a(passenger, callback);
        if (passenger instanceof EntityLiving) {
            ((EntityLiving)passenger).aV = this.aV;
        }
    }

    public boolean u() {
        return this.bP;
    }

    public void w(boolean isChickenJockey) {
        this.bP = isChickenJockey;
    }
}

