/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal;

import com.mojang.serialization.Codec;
import io.netty.buffer.ByteBuf;
import io.papermc.paper.event.entity.EntityToggleSitEvent;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleParamItem;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.stats.StatisticList;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsFluid;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.INamable;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityExperienceOrb;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntityReference;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTameableAnimal;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.control.ControllerLook;
import net.minecraft.world.entity.ai.control.ControllerMove;
import net.minecraft.world.entity.ai.goal.ClimbOnTopOfPowderSnowGoal;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.goal.PathfinderGoalAvoidTarget;
import net.minecraft.world.entity.ai.goal.PathfinderGoalBreed;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFleeSun;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFollowParent;
import net.minecraft.world.entity.ai.goal.PathfinderGoalGotoTarget;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLeapAtTarget;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalMeleeAttack;
import net.minecraft.world.entity.ai.goal.PathfinderGoalNearestVillage;
import net.minecraft.world.entity.ai.goal.PathfinderGoalPanic;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStrollLand;
import net.minecraft.world.entity.ai.goal.PathfinderGoalWaterJumpAbstract;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.ai.targeting.PathfinderTargetCondition;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.animal.EntityChicken;
import net.minecraft.world.entity.animal.EntityFish;
import net.minecraft.world.entity.animal.EntityFishSchool;
import net.minecraft.world.entity.animal.EntityPolarBear;
import net.minecraft.world.entity.animal.EntityRabbit;
import net.minecraft.world.entity.animal.EntityTurtle;
import net.minecraft.world.entity.animal.wolf.EntityWolf;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.monster.EntityMonster;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockSweetBerryBush;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CaveVines;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_21_R4.event.CraftEventFactory;
import org.bukkit.entity.ExperienceOrb;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityBreedEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.entity.EntityTargetEvent;

public class EntityFox
extends EntityAnimal {
    private static final DataWatcherObject<Integer> bM = DataWatcher.a(EntityFox.class, DataWatcherRegistry.b);
    private static final DataWatcherObject<Byte> bN = DataWatcher.a(EntityFox.class, DataWatcherRegistry.a);
    private static final int bO = 1;
    public static final int bI = 4;
    public static final int bJ = 8;
    public static final int bK = 16;
    private static final int bP = 32;
    private static final int bQ = 64;
    private static final int bR = 128;
    public static final DataWatcherObject<Optional<EntityReference<EntityLiving>>> bS = DataWatcher.a(EntityFox.class, DataWatcherRegistry.r);
    public static final DataWatcherObject<Optional<EntityReference<EntityLiving>>> bT = DataWatcher.a(EntityFox.class, DataWatcherRegistry.r);
    static final Predicate<EntityItem> bU = item -> !item.n() && item.bJ();
    private static final Predicate<Entity> bV = entity -> {
        EntityLiving livingEntity;
        return entity instanceof EntityLiving && (livingEntity = (EntityLiving)entity).eu() != null && livingEntity.ev() < livingEntity.af + 600;
    };
    static final Predicate<Entity> bW = entity -> entity instanceof EntityChicken || entity instanceof EntityRabbit;
    private static final Predicate<Entity> bX = entity -> !entity.cf() && IEntitySelector.e.test((Entity)entity);
    private static final int bY = 600;
    private static final EntitySize bZ = EntityTypes.ab.n().a(0.5f).b(0.2975f);
    private static final Codec<List<EntityReference<EntityLiving>>> ca = EntityReference.a().listOf();
    private static final boolean cb = false;
    private static final boolean cc = false;
    private static final boolean cd = false;
    private PathfinderGoal ce;
    private PathfinderGoal cf;
    private PathfinderGoal cg;
    private float ch;
    private float ci;
    float cj;
    float ck;
    private int cl;

    public EntityFox(EntityTypes<? extends EntityFox> entityType, World level) {
        super((EntityTypes<? extends EntityAnimal>)entityType, level);
        this.bB = new k();
        this.bC = new m();
        this.a(PathType.p, 0.0f);
        this.a(PathType.q, 0.0f);
        this.a_(true);
        this.N().a(32.0f);
    }

    @Override
    protected void a(DataWatcher.a builder) {
        super.a(builder);
        builder.a(bS, Optional.empty());
        builder.a(bT, Optional.empty());
        builder.a(bM, Type.c.a());
        builder.a(bN, (byte)0);
    }

    @Override
    protected void C() {
        this.ce = new PathfinderGoalNearestAttackableTarget<EntityAnimal>(this, EntityAnimal.class, 10, false, false, (entity, level) -> entity instanceof EntityChicken || entity instanceof EntityRabbit);
        this.cf = new PathfinderGoalNearestAttackableTarget<EntityTurtle>(this, EntityTurtle.class, 10, false, false, EntityTurtle.bI);
        this.cg = new PathfinderGoalNearestAttackableTarget<EntityFish>(this, EntityFish.class, 20, false, false, (entity, level) -> entity instanceof EntityFishSchool);
        this.bF.a(0, new g());
        this.bF.a(0, new ClimbOnTopOfPowderSnowGoal(this, this.dV()));
        this.bF.a(1, new b());
        this.bF.a(2, new n(2.2));
        this.bF.a(3, new e(this, 1.0));
        this.bF.a(4, new PathfinderGoalAvoidTarget<EntityHuman>(this, EntityHuman.class, 16.0f, 1.6, 1.4, entity -> bX.test((Entity)entity) && !this.j((EntityLiving)entity) && !this.gJ()));
        this.bF.a(4, new PathfinderGoalAvoidTarget<EntityWolf>(this, EntityWolf.class, 8.0f, 1.6, 1.4, livingEntity -> !((EntityWolf)livingEntity).m() && !this.gJ()));
        this.bF.a(4, new PathfinderGoalAvoidTarget<EntityPolarBear>(this, EntityPolarBear.class, 8.0f, 1.6, 1.4, livingEntity -> !this.gJ()));
        this.bF.a(5, new u());
        this.bF.a(6, new o());
        this.bF.a(6, new s(1.25));
        this.bF.a(7, new l((double)1.2f, true));
        this.bF.a(7, new t());
        this.bF.a(8, new h(this, 1.25));
        this.bF.a(9, new q(32, 200));
        this.bF.a(10, new f((double)1.2f, 12, 1));
        this.bF.a(10, new PathfinderGoalLeapAtTarget(this, 0.4f));
        this.bF.a(11, new PathfinderGoalRandomStrollLand(this, 1.0));
        this.bF.a(11, new p());
        this.bF.a(12, new j(this, EntityHuman.class, 24.0f));
        this.bF.a(13, new r());
        this.bG.a(3, new a(EntityLiving.class, false, false, (entity, level) -> bV.test(entity) && !this.j(entity)));
    }

    @Override
    public void d_() {
        if (!this.dV().C && this.bJ() && this.dj()) {
            EntityLiving target;
            ++this.cl;
            ItemStack itemBySlot = this.a(EnumItemSlot.a);
            if (this.j(itemBySlot)) {
                if (this.cl > 600) {
                    ItemStack itemStack = itemBySlot.a(this.dV(), (EntityLiving)this);
                    if (!itemStack.f()) {
                        this.a(EnumItemSlot.a, itemStack);
                    }
                    this.cl = 0;
                } else if (this.cl > 560 && this.ae.i() < 0.1f) {
                    this.gA();
                    this.dV().a((Entity)this, (byte)45);
                }
            }
            if ((target = this.e()) == null || !target.bJ()) {
                this.y(false);
                this.z(false);
            }
        }
        if (this.fR() || this.fg()) {
            this.bf = false;
            this.bg = 0.0f;
            this.bi = 0.0f;
        }
        super.d_();
        if (this.gJ() && this.ae.i() < 0.05f) {
            this.a(SoundEffects.jJ, 1.0f, 1.0f);
        }
    }

    @Override
    protected boolean fg() {
        return this.eH();
    }

    private boolean j(ItemStack stack) {
        return stack.c(DataComponents.v) && this.e() == null && this.aH() && !this.fR();
    }

    @Override
    protected void a(RandomSource random, DifficultyDamageScaler difficulty) {
        if (random.i() < 0.2f) {
            float randomFloat = random.i();
            ItemStack itemStack = randomFloat < 0.05f ? new ItemStack(Items.po) : (randomFloat < 0.2f ? new ItemStack(Items.rH) : (randomFloat < 0.4f ? (random.h() ? new ItemStack(Items.vO) : new ItemStack(Items.vP)) : (randomFloat < 0.6f ? new ItemStack(Items.qk) : (randomFloat < 0.8f ? new ItemStack(Items.rt) : new ItemStack(Items.qh)))));
            this.a(EnumItemSlot.a, itemStack);
        }
    }

    @Override
    public void b(byte id) {
        if (id == 45) {
            ItemStack itemBySlot = this.a(EnumItemSlot.a);
            if (!itemBySlot.f()) {
                for (int i2 = 0; i2 < 8; ++i2) {
                    Vec3D vec3 = new Vec3D(((double)this.ae.i() - 0.5) * 0.1, Math.random() * 0.1 + 0.1, 0.0).a(-this.dN() * ((float)Math.PI / 180)).b(-this.dL() * ((float)Math.PI / 180));
                    this.dV().a(new ParticleParamItem(Particles.U, itemBySlot), this.dA() + this.bS().d / 2.0, this.dC(), this.dG() + this.bS().f / 2.0, vec3.d, vec3.e + 0.05, vec3.f);
                }
            }
        } else {
            super.b(id);
        }
    }

    public static AttributeProvider.Builder m() {
        return EntityAnimal.gz().a(GenericAttributes.v, 0.3f).a(GenericAttributes.s, 10.0).a(GenericAttributes.c, 2.0).a(GenericAttributes.x, 5.0).a(GenericAttributes.m, 32.0);
    }

    @Nullable
    public EntityFox b(WorldServer level, EntityAgeable otherParent) {
        EntityFox fox = EntityTypes.ab.a(level, EntitySpawnReason.e);
        if (fox != null) {
            fox.a(this.ae.h() ? this.p() : ((EntityFox)otherParent).p());
        }
        return fox;
    }

    public static boolean c(EntityTypes<EntityFox> entityType, GeneratorAccess level, EntitySpawnReason spawnReason, BlockPosition pos, RandomSource random) {
        return level.a_(pos.e()).a(TagsBlock.ci) && EntityFox.a(level, pos);
    }

    @Override
    @Nullable
    public GroupDataEntity a(WorldAccess level, DifficultyDamageScaler difficulty, EntitySpawnReason spawnReason, @Nullable GroupDataEntity spawnGroupData) {
        Holder<BiomeBase> biome = level.u(this.dv());
        Type variant = Type.a(biome);
        boolean flag = false;
        if (spawnGroupData instanceof i) {
            i foxGroupData = (i)spawnGroupData;
            variant = foxGroupData.a;
            if (foxGroupData.a() >= 2) {
                flag = true;
            }
        } else {
            spawnGroupData = new i(variant);
        }
        this.a(variant);
        if (flag) {
            this.c_(-24000);
        }
        if (level instanceof WorldServer) {
            this.gG();
        }
        this.a(level.G_(), difficulty);
        return super.a(level, difficulty, spawnReason, spawnGroupData);
    }

    private void gG() {
        if (this.p() == Type.a) {
            this.bG.a(4, this.ce);
            this.bG.a(4, this.cf);
            this.bG.a(6, this.cg);
        } else {
            this.bG.a(4, this.cg);
            this.bG.a(6, this.ce);
            this.bG.a(6, this.cf);
        }
    }

    @Override
    protected void gA() {
        this.a(SoundEffects.jN, 1.0f, 1.0f);
    }

    @Override
    public EntitySize e(EntityPose pose) {
        return this.e_() ? bZ : super.e(pose);
    }

    public Type p() {
        return Type.a(this.al.a(bM));
    }

    public void a(Type variant) {
        this.al.a(bM, variant.a());
    }

    @Override
    @Nullable
    public <T> T a(DataComponentType<? extends T> component) {
        return component == DataComponents.az ? EntityFox.c(component, this.p()) : super.a(component);
    }

    @Override
    protected void a(DataComponentGetter componentGetter) {
        this.a(componentGetter, DataComponents.az);
        super.a(componentGetter);
    }

    @Override
    protected <T> boolean b(DataComponentType<T> component, T value) {
        if (component == DataComponents.az) {
            this.a(EntityFox.c(DataComponents.az, value));
            return true;
        }
        return super.b(component, value);
    }

    Stream<EntityReference<EntityLiving>> gH() {
        return Stream.concat(this.al.a(bS).stream(), this.al.a(bT).stream());
    }

    void i(EntityLiving entity) {
        this.a(new EntityReference<EntityLiving>(entity));
    }

    private void a(EntityReference<EntityLiving> entityReference) {
        if (this.al.a(bS).isPresent()) {
            this.al.a(bT, Optional.of(entityReference));
        } else {
            this.al.a(bS, Optional.of(entityReference));
        }
    }

    @Override
    public void b(NBTTagCompound compound) {
        super.b(compound);
        compound.a("Trusted", ca, this.gH().toList());
        compound.a("Sleeping", this.fR());
        compound.a("Type", Type.d, this.p());
        compound.a("Sitting", this.u());
        compound.a("Crouching", this.ch());
    }

    @Override
    public void a(NBTTagCompound compound) {
        super.a(compound);
        this.gI();
        compound.a("Trusted", ca).orElse(List.of()).forEach(this::a);
        this.C(compound.b("Sleeping", false));
        this.a(compound.a("Type", Type.d).orElse(Type.c));
        this.setSitting(compound.b("Sitting", false), false);
        this.y(compound.b("Crouching", false));
        if (this.dV() instanceof WorldServer) {
            this.gG();
        }
    }

    private void gI() {
        this.al.a(bS, Optional.empty());
        this.al.a(bT, Optional.empty());
    }

    public boolean u() {
        return this.s(1);
    }

    public void w(boolean sitting) {
        this.setSitting(sitting, true);
    }

    public void setSitting(boolean sitting, boolean fireEvent) {
        if (fireEvent && !new EntityToggleSitEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), sitting).callEvent()) {
            return;
        }
        this.d(1, sitting);
    }

    public boolean gu() {
        return this.s(64);
    }

    public void A(boolean faceplanted) {
        this.d(64, faceplanted);
    }

    public boolean gJ() {
        return this.s(128);
    }

    public void B(boolean defending) {
        this.d(128, defending);
    }

    @Override
    public boolean fR() {
        return this.s(32);
    }

    public void C(boolean sleeping) {
        this.d(32, sleeping);
    }

    private void d(int flagId, boolean value) {
        if (value) {
            this.al.a(bN, (byte)(this.al.a(bN) | flagId));
        } else {
            this.al.a(bN, (byte)(this.al.a(bN) & ~flagId));
        }
    }

    private boolean s(int flagId) {
        return (this.al.a(bN) & flagId) != 0;
    }

    @Override
    protected boolean f(EnumItemSlot slot) {
        return slot == EnumItemSlot.a && this.fN();
    }

    @Override
    public boolean g(ItemStack stack) {
        ItemStack itemBySlot = this.a(EnumItemSlot.a);
        return itemBySlot.f() || this.cl > 0 && stack.c(DataComponents.v) && !itemBySlot.c(DataComponents.v);
    }

    private void k(ItemStack stack) {
        if (!stack.f() && !this.dV().C) {
            EntityItem itemEntity = new EntityItem(this.dV(), this.dA() + this.bS().d, this.dC() + 1.0, this.dG() + this.bS().f, stack);
            itemEntity.b(40);
            itemEntity.b((Entity)this);
            this.a(SoundEffects.jS, 1.0f, 1.0f);
            this.spawnAtLocation((WorldServer)this.dV(), itemEntity);
        }
    }

    private void l(ItemStack stack) {
        EntityItem itemEntity = new EntityItem(this.dV(), this.dA(), this.dC(), this.dG(), stack);
        this.spawnAtLocation((WorldServer)this.dV(), itemEntity);
    }

    @Override
    protected void a(WorldServer level, EntityItem entity) {
        ItemStack item = entity.e();
        if (!CraftEventFactory.callEntityPickupItemEvent(this, entity, item.M() - 1, !this.g(item)).isCancelled()) {
            item = entity.e();
            int count = item.M();
            if (count > 1) {
                this.l(item.a(count - 1));
            }
            this.k(this.a(EnumItemSlot.a));
            this.a(entity);
            this.a(EnumItemSlot.a, item.a(1));
            this.g(EnumItemSlot.a);
            this.a((Entity)entity, item.M());
            entity.discard(EntityRemoveEvent.Cause.PICKUP);
            this.cl = 0;
        }
    }

    @Override
    public void g() {
        super.g();
        if (this.dj()) {
            boolean isInWater = this.bi();
            if (isInWater || this.e() != null || this.dV().ag()) {
                this.gK();
            }
            if (isInWater || this.fR()) {
                this.w(false);
            }
            if (this.gu() && this.dV().A.i() < 0.2f) {
                BlockPosition blockPos = this.dv();
                IBlockData blockState = this.dV().a_(blockPos);
                this.dV().c(2001, blockPos, Block.j(blockState));
            }
        }
        this.ci = this.ch;
        this.ch = this.gy() ? (this.ch += (1.0f - this.ch) * 0.4f) : (this.ch += (0.0f - this.ch) * 0.4f);
        this.ck = this.cj;
        if (this.ch()) {
            this.cj += 0.2f;
            if (this.cj > 3.0f) {
                this.cj = 3.0f;
            }
        } else {
            this.cj = 0.0f;
        }
    }

    @Override
    public boolean i(ItemStack stack) {
        return stack.a(TagsItem.ae);
    }

    @Override
    protected void a(EntityHuman player, EntityInsentient child) {
        ((EntityFox)child).i(player);
    }

    public boolean gv() {
        return this.s(16);
    }

    public void x(boolean isPouncing) {
        this.d(16, isPouncing);
    }

    public boolean gw() {
        return this.bf;
    }

    public boolean gx() {
        return this.cj == 3.0f;
    }

    public void y(boolean isCrouching) {
        this.d(4, isCrouching);
    }

    @Override
    public boolean ch() {
        return this.s(4);
    }

    public void z(boolean isInterested) {
        this.d(8, isInterested);
    }

    public boolean gy() {
        return this.s(8);
    }

    public float J(float partialTick) {
        return MathHelper.h(partialTick, this.ci, this.ch) * 0.11f * (float)Math.PI;
    }

    public float K(float partialTick) {
        return MathHelper.h(partialTick, this.ck, this.cj);
    }

    @Override
    public boolean setTarget(@Nullable EntityLiving livingEntity, @Nullable EntityTargetEvent.TargetReason reason) {
        if (this.gJ() && livingEntity == null) {
            this.B(false);
        }
        return super.setTarget(livingEntity, reason);
    }

    void gK() {
        this.C(false);
    }

    void gL() {
        this.z(false);
        this.y(false);
        this.w(false);
        this.C(false);
        this.B(false);
        this.A(false);
    }

    boolean gM() {
        return !this.fR() && !this.u() && !this.gu();
    }

    @Override
    public void S() {
        SoundEffect ambientSound = this.s();
        if (ambientSound == SoundEffects.jP) {
            this.a(ambientSound, 2.0f, this.ff());
        } else {
            super.S();
        }
    }

    @Override
    @Nullable
    public SoundEffect s() {
        List<Entity> entitiesOfClass;
        if (this.fR()) {
            return SoundEffects.jQ;
        }
        if (!this.dV().V() && this.ae.i() < 0.1f && (entitiesOfClass = this.dV().a(EntityHuman.class, this.cR().c(16.0, 16.0, 16.0), IEntitySelector.f)).isEmpty()) {
            return SoundEffects.jP;
        }
        return SoundEffects.jK;
    }

    @Override
    @Nullable
    public SoundEffect e(DamageSource damageSource) {
        return SoundEffects.jO;
    }

    @Override
    @Nullable
    public SoundEffect j_() {
        return SoundEffects.jM;
    }

    boolean j(EntityLiving entity) {
        return this.gH().anyMatch(entityReference -> entityReference.a(entity));
    }

    @Override
    protected boolean shouldSkipLoot(EnumItemSlot slot) {
        return slot == EnumItemSlot.a;
    }

    @Override
    protected EntityDeathEvent dropAllDeathLoot(WorldServer level, DamageSource damageSource) {
        EntityDeathEvent deathEvent;
        ItemStack itemBySlot = this.a(EnumItemSlot.a);
        boolean releaseMouth = false;
        if (!itemBySlot.f() && level.O().c(GameRules.g)) {
            this.a(level, itemBySlot);
            releaseMouth = true;
        }
        if ((deathEvent = super.dropAllDeathLoot(level, damageSource)) == null || deathEvent.isCancelled()) {
            return deathEvent;
        }
        if (releaseMouth) {
            this.a(EnumItemSlot.a, ItemStack.l);
        }
        return deathEvent;
    }

    public static boolean a(EntityFox fox, EntityLiving livingEntity) {
        double d2 = livingEntity.dG() - fox.dG();
        double d1 = livingEntity.dA() - fox.dA();
        double d22 = d2 / d1;
        int i2 = 6;
        for (int i1 = 0; i1 < 6; ++i1) {
            double d3 = d22 == 0.0 ? 0.0 : d2 * (double)((float)i1 / 6.0f);
            double d4 = d22 == 0.0 ? d1 * (double)((float)i1 / 6.0f) : d3 / d22;
            for (int i22 = 1; i22 < 4; ++i22) {
                if (fox.dV().a_(BlockPosition.a(fox.dA() + d4, fox.dC() + (double)i22, fox.dG() + d3)).v()) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public Vec3D cT() {
        return new Vec3D(0.0, 0.55f * this.cS(), this.dq() * 0.4f);
    }

    public class k
    extends ControllerLook {
        public k() {
            super(EntityFox.this);
        }

        @Override
        public void a() {
            if (!EntityFox.this.fR()) {
                super.a();
            }
        }

        @Override
        protected boolean c() {
            return !EntityFox.this.gv() && !EntityFox.this.ch() && !EntityFox.this.gy() && !EntityFox.this.gu();
        }
    }

    class m
    extends ControllerMove {
        public m() {
            super(EntityFox.this);
        }

        @Override
        public void a() {
            if (EntityFox.this.gM()) {
                super.a();
            }
        }
    }

    public static final class Type
    extends Enum<Type>
    implements INamable {
        public static final /* enum */ Type a = new Type(0, "red");
        public static final /* enum */ Type b = new Type(1, "snow");
        public static final Type c;
        public static final INamable.a<Type> d;
        private static final IntFunction<Type> f;
        public static final StreamCodec<ByteBuf, Type> e;
        private final int g;
        private final String h;
        private static final /* synthetic */ Type[] i;

        public static Type[] values() {
            return (Type[])i.clone();
        }

        public static Type valueOf(String name) {
            return Enum.valueOf(Type.class, name);
        }

        private Type(int id, String name) {
            this.g = id;
            this.h = name;
        }

        @Override
        public String c() {
            return this.h;
        }

        public int a() {
            return this.g;
        }

        public static Type a(int id) {
            return f.apply(id);
        }

        public static Type a(Holder<BiomeBase> biome) {
            return biome.a(BiomeTags.at) ? b : a;
        }

        private static /* synthetic */ Type[] b() {
            return new Type[]{a, b};
        }

        static {
            i = Type.b();
            c = a;
            d = INamable.a(Type::values);
            f = ByIdMap.a(Type::a, Type.values(), ByIdMap.a.a);
            e = ByteBufCodecs.a(f, Type::a);
        }
    }

    class g
    extends PathfinderGoalFloat {
        public g() {
            super(EntityFox.this);
        }

        @Override
        public void d() {
            super.d();
            EntityFox.this.gL();
        }

        @Override
        public boolean b() {
            return EntityFox.this.bi() && EntityFox.this.b(TagsFluid.a) > 0.25 || EntityFox.this.bv();
        }
    }

    class b
    extends PathfinderGoal {
        int a;

        public b() {
            this.a(EnumSet.of(PathfinderGoal.Type.b, PathfinderGoal.Type.c, PathfinderGoal.Type.a));
        }

        @Override
        public boolean b() {
            return EntityFox.this.gu();
        }

        @Override
        public boolean c() {
            return this.b() && this.a > 0;
        }

        @Override
        public void d() {
            this.a = this.a(40);
        }

        @Override
        public void e() {
            EntityFox.this.A(false);
        }

        @Override
        public void a() {
            --this.a;
        }
    }

    class n
    extends PathfinderGoalPanic {
        public n(double speedModifier) {
            super(EntityFox.this, speedModifier);
        }

        @Override
        public boolean h() {
            return !EntityFox.this.gJ() && super.h();
        }
    }

    class e
    extends PathfinderGoalBreed {
        public e(EntityFox this$0, double speedModifier) {
            super(this$0, speedModifier);
        }

        @Override
        public void d() {
            ((EntityFox)this.a).gL();
            ((EntityFox)this.c).gL();
            super.d();
        }

        @Override
        protected void g() {
            WorldServer serverLevel = this.b;
            EntityFox fox = (EntityFox)this.a.a(serverLevel, (EntityAgeable)this.c);
            if (fox != null) {
                EntityPlayer loveCause = this.a.gD();
                EntityPlayer loveCause1 = this.c.gD();
                EntityPlayer serverPlayer = loveCause;
                if (loveCause != null) {
                    fox.i(loveCause);
                } else {
                    serverPlayer = loveCause1;
                }
                if (loveCause1 != null && loveCause != loveCause1) {
                    fox.i(loveCause1);
                }
                fox.c_(-24000);
                fox.b(this.a.dA(), this.a.dC(), this.a.dG(), 0.0f, 0.0f);
                int experience = this.a.dY().a(7) + 1;
                EntityBreedEvent entityBreedEvent = CraftEventFactory.callEntityBreedEvent(fox, this.a, this.c, loveCause, this.a.breedItem, experience);
                if (entityBreedEvent.isCancelled()) {
                    this.a.gF();
                    this.c.gF();
                    return;
                }
                experience = entityBreedEvent.getExperience();
                if (serverPlayer != null) {
                    serverPlayer.a(StatisticList.P);
                    CriterionTriggers.p.a(serverPlayer, this.a, this.c, fox);
                }
                this.a.c_(6000);
                this.c.c_(6000);
                this.a.gF();
                this.c.gF();
                serverLevel.addFreshEntityWithPassengers(fox, CreatureSpawnEvent.SpawnReason.BREEDING);
                this.b.a((Entity)this.a, (byte)18);
                if (experience > 0 && serverLevel.O().c(GameRules.g)) {
                    this.b.b(new EntityExperienceOrb(this.b, this.a.dA(), this.a.dC(), this.a.dG(), experience, ExperienceOrb.SpawnReason.BREED, loveCause, fox));
                }
            }
        }
    }

    class u
    extends PathfinderGoal {
        public u() {
            this.a(EnumSet.of(PathfinderGoal.Type.a, PathfinderGoal.Type.b));
        }

        @Override
        public boolean b() {
            if (EntityFox.this.fR()) {
                return false;
            }
            EntityLiving target = EntityFox.this.e();
            return target != null && target.bJ() && bW.test(target) && EntityFox.this.g((Entity)target) > 36.0 && !EntityFox.this.ch() && !EntityFox.this.gy() && !EntityFox.this.bf;
        }

        @Override
        public void d() {
            EntityFox.this.w(false);
            EntityFox.this.A(false);
        }

        @Override
        public void e() {
            EntityLiving target = EntityFox.this.e();
            if (target != null && EntityFox.a(EntityFox.this, target)) {
                EntityFox.this.z(true);
                EntityFox.this.y(true);
                EntityFox.this.N().m();
                EntityFox.this.I().a(target, (float)EntityFox.this.ae(), (float)EntityFox.this.ac());
            } else {
                EntityFox.this.z(false);
                EntityFox.this.y(false);
            }
        }

        @Override
        public void a() {
            EntityLiving target = EntityFox.this.e();
            if (target != null) {
                EntityFox.this.I().a(target, (float)EntityFox.this.ae(), (float)EntityFox.this.ac());
                if (EntityFox.this.g((Entity)target) <= 36.0) {
                    EntityFox.this.z(true);
                    EntityFox.this.y(true);
                    EntityFox.this.N().m();
                } else {
                    EntityFox.this.N().a((Entity)target, 1.5);
                }
            }
        }
    }

    public class o
    extends PathfinderGoalWaterJumpAbstract {
        @Override
        public boolean b() {
            if (!EntityFox.this.gx()) {
                return false;
            }
            EntityLiving target = EntityFox.this.e();
            if (target != null && target.bJ()) {
                if (target.cP() != target.cO()) {
                    return false;
                }
                boolean isPathClear = EntityFox.a(EntityFox.this, target);
                if (!isPathClear) {
                    EntityFox.this.N().a((Entity)target, 0);
                    EntityFox.this.y(false);
                    EntityFox.this.z(false);
                }
                return isPathClear;
            }
            return false;
        }

        @Override
        public boolean c() {
            EntityLiving target = EntityFox.this.e();
            if (target != null && target.bJ()) {
                double d2 = EntityFox.this.dy().e;
                return !(d2 * d2 < (double)0.05f && Math.abs(EntityFox.this.dN()) < 15.0f && EntityFox.this.aH() || EntityFox.this.gu());
            }
            return false;
        }

        @Override
        public boolean V_() {
            return false;
        }

        @Override
        public void d() {
            EntityFox.this.s(true);
            EntityFox.this.x(true);
            EntityFox.this.z(false);
            EntityLiving target = EntityFox.this.e();
            if (target != null) {
                EntityFox.this.I().a(target, 60.0f, 30.0f);
                Vec3D vec3 = new Vec3D(target.dA() - EntityFox.this.dA(), target.dC() - EntityFox.this.dC(), target.dG() - EntityFox.this.dG()).d();
                EntityFox.this.i(EntityFox.this.dy().b(vec3.d * 0.8, 0.9, vec3.f * 0.8));
            }
            EntityFox.this.N().m();
        }

        @Override
        public void e() {
            EntityFox.this.y(false);
            EntityFox.this.cj = 0.0f;
            EntityFox.this.ck = 0.0f;
            EntityFox.this.z(false);
            EntityFox.this.x(false);
        }

        @Override
        public void a() {
            EntityLiving target = EntityFox.this.e();
            if (target != null) {
                EntityFox.this.I().a(target, 60.0f, 30.0f);
            }
            if (!EntityFox.this.gu()) {
                Vec3D deltaMovement = EntityFox.this.dy();
                if (deltaMovement.e * deltaMovement.e < (double)0.03f && EntityFox.this.dN() != 0.0f) {
                    EntityFox.this.x(MathHelper.i(0.2f, EntityFox.this.dN(), 0.0f));
                } else {
                    double d2 = deltaMovement.i();
                    double d1 = Math.signum(-deltaMovement.e) * Math.acos(d2 / deltaMovement.g()) * 180.0 / 3.1415927410125732;
                    EntityFox.this.x((float)d1);
                }
            }
            if (target != null && EntityFox.this.f((Entity)target) <= 2.0f) {
                EntityFox.this.c(net.minecraft.world.entity.animal.EntityFox$o.a(EntityFox.this.dV()), (Entity)target);
            } else if (EntityFox.this.dN() > 0.0f && EntityFox.this.aH() && (float)EntityFox.this.dy().e != 0.0f && EntityFox.this.dV().a_(EntityFox.this.dv()).a(Blocks.ed)) {
                EntityFox.this.x(60.0f);
                EntityFox.this.g((EntityLiving)null);
                EntityFox.this.A(true);
            }
        }
    }

    class s
    extends PathfinderGoalFleeSun {
        private int c;

        public s(double speedModifier) {
            super(EntityFox.this, speedModifier);
            this.c = net.minecraft.world.entity.animal.EntityFox$s.b(100);
        }

        @Override
        public boolean b() {
            if (!EntityFox.this.fR() && this.a.e() == null) {
                if (EntityFox.this.dV().ag() && EntityFox.this.dV().h(this.a.dv())) {
                    return this.h();
                }
                if (this.c > 0) {
                    --this.c;
                    return false;
                }
                this.c = 100;
                BlockPosition blockPos = this.a.dv();
                return EntityFox.this.dV().V() && EntityFox.this.dV().h(blockPos) && !((WorldServer)EntityFox.this.dV()).c(blockPos) && this.h();
            }
            return false;
        }

        @Override
        public void d() {
            EntityFox.this.gL();
            super.d();
        }
    }

    class l
    extends PathfinderGoalMeleeAttack {
        public l(double speedModifier, boolean followingTargetEvenIfNotSeen) {
            super(EntityFox.this, speedModifier, followingTargetEvenIfNotSeen);
        }

        @Override
        protected void a(EntityLiving target) {
            if (this.b(target)) {
                this.h();
                this.a.c(net.minecraft.world.entity.animal.EntityFox$l.a(this.a), (Entity)target);
                EntityFox.this.a(SoundEffects.jL, 1.0f, 1.0f);
            }
        }

        @Override
        public void d() {
            EntityFox.this.z(false);
            super.d();
        }

        @Override
        public boolean b() {
            return !EntityFox.this.u() && !EntityFox.this.fR() && !EntityFox.this.ch() && !EntityFox.this.gu() && super.b();
        }
    }

    class t
    extends d {
        private static final int c = net.minecraft.world.entity.animal.EntityFox$t.b(140);
        private int d;

        public t() {
            this.d = EntityFox.this.ae.a(c);
            this.a(EnumSet.of(PathfinderGoal.Type.a, PathfinderGoal.Type.b, PathfinderGoal.Type.c));
        }

        @Override
        public boolean b() {
            return EntityFox.this.bg == 0.0f && EntityFox.this.bh == 0.0f && EntityFox.this.bi == 0.0f && (this.k() || EntityFox.this.fR());
        }

        @Override
        public boolean c() {
            return this.k();
        }

        private boolean k() {
            if (this.d > 0) {
                --this.d;
                return false;
            }
            return EntityFox.this.dV().V() && this.h() && !this.i() && !EntityFox.this.av;
        }

        @Override
        public void e() {
            this.d = EntityFox.this.ae.a(c);
            EntityFox.this.gL();
        }

        @Override
        public void d() {
            EntityFox.this.w(false);
            EntityFox.this.y(false);
            EntityFox.this.z(false);
            EntityFox.this.s(false);
            EntityFox.this.C(true);
            EntityFox.this.N().m();
            EntityFox.this.K().a(EntityFox.this.dA(), EntityFox.this.dC(), EntityFox.this.dG(), 0.0);
        }
    }

    static class h
    extends PathfinderGoalFollowParent {
        private final EntityFox d;

        public h(EntityFox fox, double speedModifier) {
            super(fox, speedModifier);
            this.d = fox;
        }

        @Override
        public boolean b() {
            return !this.d.gJ() && super.b();
        }

        @Override
        public boolean c() {
            return !this.d.gJ() && super.c();
        }

        @Override
        public void d() {
            this.d.gL();
            super.d();
        }
    }

    class q
    extends PathfinderGoalNearestVillage {
        public q(int unused32, int interval) {
            super(EntityFox.this, interval);
        }

        @Override
        public void d() {
            EntityFox.this.gL();
            super.d();
        }

        @Override
        public boolean b() {
            return super.b() && this.h();
        }

        @Override
        public boolean c() {
            return super.c() && this.h();
        }

        private boolean h() {
            return !EntityFox.this.fR() && !EntityFox.this.u() && !EntityFox.this.gJ() && EntityFox.this.e() == null;
        }
    }

    public class f
    extends PathfinderGoalGotoTarget {
        private static final int i = 40;
        protected int g;

        public f(double speedModifier, int searchRange, int verticalSearchRange) {
            super(EntityFox.this, speedModifier, searchRange, verticalSearchRange);
        }

        @Override
        public double i() {
            return 2.0;
        }

        @Override
        public boolean l() {
            return this.d % 100 == 0;
        }

        @Override
        protected boolean a(IWorldReader level, BlockPosition pos) {
            IBlockData blockState = level.a_(pos);
            return blockState.a(Blocks.oO) && blockState.c(BlockSweetBerryBush.c) >= 2 || CaveVines.j_(blockState);
        }

        @Override
        public void a() {
            if (this.m()) {
                if (this.g >= 40) {
                    this.o();
                } else {
                    ++this.g;
                }
            } else if (!this.m() && EntityFox.this.ae.i() < 0.05f) {
                EntityFox.this.a(SoundEffects.jR, 1.0f, 1.0f);
            }
            super.a();
        }

        protected void o() {
            if (net.minecraft.world.entity.animal.EntityFox$f.a(EntityFox.this.dV()).O().c(GameRules.d)) {
                IBlockData blockState = EntityFox.this.dV().a_(this.e);
                if (blockState.a(Blocks.oO)) {
                    this.b(blockState);
                } else if (CaveVines.j_(blockState)) {
                    this.a(blockState);
                }
            }
        }

        private void a(IBlockData state) {
            CaveVines.a(EntityFox.this, state, EntityFox.this.dV(), this.e);
        }

        private void b(IBlockData state) {
            int ageValue = state.c(BlockSweetBerryBush.c);
            state.b(BlockSweetBerryBush.c, 1);
            if (!CraftEventFactory.callEntityChangeBlockEvent(EntityFox.this, this.e, (IBlockData)state.b(BlockSweetBerryBush.c, 1))) {
                return;
            }
            int i2 = 1 + EntityFox.this.dV().A.a(2) + (ageValue == 3 ? 1 : 0);
            ItemStack itemBySlot = EntityFox.this.a(EnumItemSlot.a);
            if (itemBySlot.f()) {
                EntityFox.this.a(EnumItemSlot.a, new ItemStack(Items.xG));
                --i2;
            }
            if (i2 > 0) {
                Block.a(EntityFox.this.dV(), this.e, new ItemStack(Items.xG, i2));
            }
            EntityFox.this.a(SoundEffects.Aw, 1.0f, 1.0f);
            EntityFox.this.dV().a(this.e, (IBlockData)state.b(BlockSweetBerryBush.c, 1), 2);
            EntityFox.this.dV().a(GameEvent.c, this.e, GameEvent.a.a(EntityFox.this));
        }

        @Override
        public boolean b() {
            return !EntityFox.this.fR() && super.b();
        }

        @Override
        public void d() {
            this.g = 0;
            EntityFox.this.w(false);
            super.d();
        }
    }

    class p
    extends PathfinderGoal {
        public p() {
            this.a(EnumSet.of(PathfinderGoal.Type.a));
        }

        @Override
        public boolean b() {
            if (!EntityFox.this.a(EnumItemSlot.a).f()) {
                return false;
            }
            if (EntityFox.this.e() != null || EntityFox.this.er() != null) {
                return false;
            }
            if (!EntityFox.this.gM()) {
                return false;
            }
            if (EntityFox.this.dY().a(net.minecraft.world.entity.animal.EntityFox$p.b(10)) != 0) {
                return false;
            }
            List<EntityItem> entitiesOfClass = EntityFox.this.dV().a(EntityItem.class, EntityFox.this.cR().c(8.0, 8.0, 8.0), bU);
            return !entitiesOfClass.isEmpty() && EntityFox.this.a(EnumItemSlot.a).f();
        }

        @Override
        public void a() {
            List<EntityItem> entitiesOfClass = EntityFox.this.dV().a(EntityItem.class, EntityFox.this.cR().c(8.0, 8.0, 8.0), bU);
            ItemStack itemBySlot = EntityFox.this.a(EnumItemSlot.a);
            if (itemBySlot.f() && !entitiesOfClass.isEmpty()) {
                EntityFox.this.N().a((Entity)entitiesOfClass.get(0), (double)1.2f);
            }
        }

        @Override
        public void d() {
            List<EntityItem> entitiesOfClass = EntityFox.this.dV().a(EntityItem.class, EntityFox.this.cR().c(8.0, 8.0, 8.0), bU);
            if (!entitiesOfClass.isEmpty()) {
                EntityFox.this.N().a((Entity)entitiesOfClass.get(0), (double)1.2f);
            }
        }
    }

    class j
    extends PathfinderGoalLookAtPlayer {
        public j(EntityInsentient mob, Class<? extends EntityLiving> lookAtType, float lookDistance) {
            super(mob, lookAtType, lookDistance);
        }

        @Override
        public boolean b() {
            return super.b() && !EntityFox.this.gu() && !EntityFox.this.gy();
        }

        @Override
        public boolean c() {
            return super.c() && !EntityFox.this.gu() && !EntityFox.this.gy();
        }
    }

    class r
    extends d {
        private double c;
        private double d;
        private int e;
        private int f;

        public r() {
            this.a(EnumSet.of(PathfinderGoal.Type.a, PathfinderGoal.Type.b));
        }

        @Override
        public boolean b() {
            return EntityFox.this.er() == null && EntityFox.this.dY().i() < 0.02f && !EntityFox.this.fR() && EntityFox.this.e() == null && EntityFox.this.N().k() && !this.i() && !EntityFox.this.gv() && !EntityFox.this.ch();
        }

        @Override
        public boolean c() {
            return this.f > 0;
        }

        @Override
        public void d() {
            this.k();
            this.f = 2 + EntityFox.this.dY().a(3);
            EntityFox.this.w(true);
            EntityFox.this.N().m();
        }

        @Override
        public void e() {
            EntityFox.this.w(false);
        }

        @Override
        public void a() {
            --this.e;
            if (this.e <= 0) {
                --this.f;
                this.k();
            }
            EntityFox.this.I().a(EntityFox.this.dA() + this.c, EntityFox.this.dE(), EntityFox.this.dG() + this.d, EntityFox.this.ae(), EntityFox.this.ac());
        }

        private void k() {
            double d2 = Math.PI * 2 * EntityFox.this.dY().j();
            this.c = Math.cos(d2);
            this.d = Math.sin(d2);
            this.e = this.a(80 + EntityFox.this.dY().a(20));
        }
    }

    class a
    extends PathfinderGoalNearestAttackableTarget<EntityLiving> {
        @Nullable
        private EntityLiving j;
        @Nullable
        private EntityLiving k;
        private int l;

        public a(Class<EntityLiving> targetType, boolean mustSee, @Nullable boolean mustReach, PathfinderTargetCondition.a selector) {
            super(EntityFox.this, targetType, 10, mustSee, mustReach, selector);
        }

        @Override
        public boolean b() {
            if (this.b > 0 && this.e.dY().a(this.b) != 0) {
                return false;
            }
            WorldServer serverLevel = net.minecraft.world.entity.animal.EntityFox$a.a(EntityFox.this.dV());
            for (EntityReference<EntityLiving> entityReference : EntityFox.this.gH().toList()) {
                EntityLiving livingEntity = entityReference.a(serverLevel, EntityLiving.class);
                if (livingEntity == null) continue;
                this.k = livingEntity;
                this.j = livingEntity.er();
                int lastHurtByMobTimestamp = livingEntity.et();
                return lastHurtByMobTimestamp != this.l && this.a(this.j, this.d);
            }
            return false;
        }

        @Override
        public void d() {
            this.a(this.j);
            this.c = this.j;
            if (this.k != null) {
                this.l = this.k.et();
            }
            EntityFox.this.a(SoundEffects.jJ, 1.0f, 1.0f);
            EntityFox.this.B(true);
            EntityFox.this.gK();
            super.d();
        }
    }

    public static class i
    extends EntityAgeable.a {
        public final Type a;

        public i(Type variant) {
            super(false);
            this.a = variant;
        }
    }

    abstract class d
    extends PathfinderGoal {
        private final PathfinderTargetCondition b;

        d() {
            this.b = PathfinderTargetCondition.a().a(12.0).d().a(new c());
        }

        protected boolean h() {
            BlockPosition blockPos = BlockPosition.a(EntityFox.this.dA(), EntityFox.this.cR().e, EntityFox.this.dG());
            return !EntityFox.this.dV().h(blockPos) && EntityFox.this.c(blockPos) >= 0.0f;
        }

        protected boolean i() {
            return !net.minecraft.world.entity.animal.EntityFox$d.a(EntityFox.this.dV()).a(EntityLiving.class, this.b, EntityFox.this, EntityFox.this.cR().c(12.0, 6.0, 12.0)).isEmpty();
        }
    }

    public class c
    implements PathfinderTargetCondition.a {
        @Override
        public boolean test(EntityLiving entity, WorldServer level) {
            EntityHuman player;
            if (entity instanceof EntityFox) {
                return false;
            }
            if (entity instanceof EntityChicken || entity instanceof EntityRabbit || entity instanceof EntityMonster) {
                return true;
            }
            boolean bl = entity instanceof EntityTameableAnimal ? !((EntityTameableAnimal)entity).m() : (!(entity instanceof EntityHuman) || !(player = (EntityHuman)entity).ak() && !player.gz()) && !EntityFox.this.j(entity) && !entity.fR() && !entity.cf();
            return bl;
        }
    }
}

