/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal;

import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.TimeRange;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Crackiness;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.IEntityAngerable;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalMeleeAttack;
import net.minecraft.world.entity.ai.goal.PathfinderGoalMoveTowardsTarget;
import net.minecraft.world.entity.ai.goal.PathfinderGoalOfferFlower;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomLookaround;
import net.minecraft.world.entity.ai.goal.PathfinderGoalStrollVillage;
import net.minecraft.world.entity.ai.goal.PathfinderGoalStrollVillageGolem;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalDefendVillage;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalHurtByTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalUniversalAngerReset;
import net.minecraft.world.entity.animal.EntityGolem;
import net.minecraft.world.entity.monster.EntityCreeper;
import net.minecraft.world.entity.monster.IMonster;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.SpawnerCreature;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.material.FluidTypes;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.event.entity.EntityTargetEvent;

public class EntityIronGolem
extends EntityGolem
implements IEntityAngerable {
    protected static final DataWatcherObject<Byte> c = DataWatcher.a(EntityIronGolem.class, DataWatcherRegistry.a);
    private static final int d = 25;
    private static final boolean e = false;
    private int f;
    private int bI;
    private static final UniformInt bJ = TimeRange.a(20, 39);
    private int bK;
    @Nullable
    private UUID bL;

    public EntityIronGolem(EntityTypes<? extends EntityIronGolem> entityType, World level) {
        super((EntityTypes<? extends EntityGolem>)entityType, level);
    }

    @Override
    protected void C() {
        this.bF.a(1, new PathfinderGoalMeleeAttack(this, 1.0, true));
        this.bF.a(2, new PathfinderGoalMoveTowardsTarget(this, 0.9, 32.0f));
        this.bF.a(2, new PathfinderGoalStrollVillage((EntityCreature)this, 0.6, false));
        this.bF.a(4, new PathfinderGoalStrollVillageGolem(this, 0.6));
        this.bF.a(5, new PathfinderGoalOfferFlower(this));
        this.bF.a(7, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 6.0f));
        this.bF.a(8, new PathfinderGoalRandomLookaround(this));
        this.bG.a(1, new PathfinderGoalDefendVillage(this));
        this.bG.a(2, new PathfinderGoalHurtByTarget(this, new Class[0]));
        this.bG.a(3, new PathfinderGoalNearestAttackableTarget<EntityHuman>(this, EntityHuman.class, 10, true, false, this::a));
        this.bG.a(3, new PathfinderGoalNearestAttackableTarget<EntityInsentient>(this, EntityInsentient.class, 5, false, false, (entity, level) -> entity instanceof IMonster && !(entity instanceof EntityCreeper)));
        this.bG.a(4, new PathfinderGoalUniversalAngerReset<EntityIronGolem>(this, false));
    }

    @Override
    protected void a(DataWatcher.a builder) {
        super.a(builder);
        builder.a(c, (byte)0);
    }

    public static AttributeProvider.Builder m() {
        return EntityInsentient.D().a(GenericAttributes.s, 100.0).a(GenericAttributes.v, 0.25).a(GenericAttributes.p, 1.0).a(GenericAttributes.c, 15.0).a(GenericAttributes.B, 1.0);
    }

    @Override
    protected int l(int air) {
        return air;
    }

    @Override
    protected void D(Entity entity) {
        if (entity instanceof IMonster && !(entity instanceof EntityCreeper) && this.dY().a(20) == 0) {
            this.setTarget((EntityLiving)entity, EntityTargetEvent.TargetReason.COLLISION);
        }
        super.D(entity);
    }

    @Override
    public void d_() {
        super.d_();
        if (this.f > 0) {
            --this.f;
        }
        if (this.bI > 0) {
            --this.bI;
        }
        if (!this.dV().C) {
            this.a((WorldServer)this.dV(), true);
        }
    }

    @Override
    public boolean bt() {
        return this.dy().j() > 2.500000277905201E-7 && this.ae.a(5) == 0;
    }

    @Override
    public boolean a(EntityTypes<?> type) {
        return (!this.gv() || type != EntityTypes.bT) && type != EntityTypes.F && super.a(type);
    }

    @Override
    public void b(NBTTagCompound compound) {
        super.b(compound);
        compound.a("PlayerCreated", this.gv());
        this.a_(compound);
    }

    @Override
    public void a(NBTTagCompound compound) {
        super.a(compound);
        this.x(compound.b("PlayerCreated", false));
        this.a(this.dV(), compound);
    }

    @Override
    public void c() {
        this.a(bJ.a(this.ae));
    }

    @Override
    public void a(int time) {
        this.bK = time;
    }

    @Override
    public int a() {
        return this.bK;
    }

    @Override
    public void a(@Nullable UUID target) {
        this.bL = target;
    }

    @Override
    @Nullable
    public UUID b() {
        return this.bL;
    }

    private float gw() {
        return (float)this.h(GenericAttributes.c);
    }

    @Override
    public boolean c(WorldServer level, Entity source) {
        this.f = 10;
        level.a((Entity)this, (byte)4);
        float attackDamage = this.gw();
        float f2 = (int)attackDamage > 0 ? attackDamage / 2.0f + (float)this.ae.a((int)attackDamage) : attackDamage;
        DamageSource damageSource = this.dW().b(this);
        boolean flag = source.a(level, damageSource, f2);
        if (flag) {
            double d2;
            if (source instanceof EntityLiving) {
                EntityLiving livingEntity = (EntityLiving)source;
                d2 = livingEntity.h(GenericAttributes.p);
            } else {
                d2 = 0.0;
            }
            double d3 = d2;
            double max = Math.max(0.0, 1.0 - d3);
            source.i(source.dy().b(0.0, (double)0.4f * max, 0.0));
            EnchantmentManager.a(level, source, damageSource);
        }
        this.a(SoundEffects.nV, 1.0f, 1.0f);
        return flag;
    }

    @Override
    public boolean a(WorldServer level, DamageSource damageSource, float amount) {
        Crackiness.a crackiness = this.p();
        boolean flag = super.a(level, damageSource, amount);
        if (flag && this.p() != crackiness) {
            this.a(SoundEffects.nW, 1.0f, 1.0f);
        }
        return flag;
    }

    public Crackiness.a p() {
        return Crackiness.a.a(this.eG() / this.eU());
    }

    @Override
    public void b(byte id) {
        if (id == 4) {
            this.f = 10;
            this.a(SoundEffects.nV, 1.0f, 1.0f);
        } else if (id == 11) {
            this.bI = 400;
        } else if (id == 34) {
            this.bI = 0;
        } else {
            super.b(id);
        }
    }

    public int u() {
        return this.f;
    }

    public void w(boolean offeringFlower) {
        if (offeringFlower) {
            this.bI = 400;
            this.dV().a((Entity)this, (byte)11);
        } else {
            this.bI = 0;
            this.dV().a((Entity)this, (byte)34);
        }
    }

    @Override
    public SoundEffect e(DamageSource damageSource) {
        return SoundEffects.nY;
    }

    @Override
    public SoundEffect j_() {
        return SoundEffects.nX;
    }

    @Override
    protected EnumInteractionResult b(EntityHuman player, EnumHand hand) {
        ItemStack itemInHand = player.b(hand);
        if (!itemInHand.a(Items.pt)) {
            return EnumInteractionResult.e;
        }
        float health = this.eG();
        this.c(25.0f);
        if (this.eG() == health) {
            return EnumInteractionResult.e;
        }
        float f2 = 1.0f + (this.ae.i() - this.ae.i()) * 0.2f;
        this.a(SoundEffects.nZ, 1.0f, f2);
        itemInHand.a(1, (EntityLiving)player);
        return EnumInteractionResult.a;
    }

    @Override
    protected void b(BlockPosition pos, IBlockData block) {
        this.a(SoundEffects.oa, 1.0f, 1.0f);
    }

    public int gu() {
        return this.bI;
    }

    public boolean gv() {
        return (this.al.a(c) & 1) != 0;
    }

    public void x(boolean playerCreated) {
        byte b2 = this.al.a(c);
        if (playerCreated) {
            this.al.a(c, (byte)(b2 | 1));
        } else {
            this.al.a(c, (byte)(b2 & 0xFFFFFFFE));
        }
    }

    @Override
    public void a(DamageSource cause) {
        super.a(cause);
    }

    @Override
    public boolean a(IWorldReader level) {
        BlockPosition blockPos = this.dv();
        BlockPosition blockPos1 = blockPos.e();
        IBlockData blockState = level.a_(blockPos1);
        if (!blockState.b((IBlockAccess)level, blockPos1, this) && !this.dV().paperConfig().entities.spawning.ironGolemsCanSpawnInAir) {
            return false;
        }
        for (int i2 = 1; i2 < 3; ++i2) {
            IBlockData blockState1;
            BlockPosition blockPos2 = blockPos.b(i2);
            if (SpawnerCreature.a(level, blockPos2, blockState1 = level.a_(blockPos2), blockState1.y(), EntityTypes.aq)) continue;
            return false;
        }
        return SpawnerCreature.a(level, blockPos, level.a_(blockPos), FluidTypes.a.g(), EntityTypes.aq) && level.f(this);
    }

    @Override
    public Vec3D cT() {
        return new Vec3D(0.0, 0.875f * this.cS(), this.dq() * 0.4f);
    }
}

