/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal;

import com.destroystokyo.paper.event.entity.EntityJumpEvent;
import com.mojang.serialization.Codec;
import io.papermc.paper.event.entity.EntityToggleSitEvent;
import java.util.EnumSet;
import java.util.List;
import java.util.function.IntFunction;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.particles.ParticleParamItem;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.INamable;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityAttachment;
import net.minecraft.world.entity.EntityAttachments;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.control.ControllerMove;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.goal.PathfinderGoalAvoidTarget;
import net.minecraft.world.entity.ai.goal.PathfinderGoalBreed;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFollowParent;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalMeleeAttack;
import net.minecraft.world.entity.ai.goal.PathfinderGoalPanic;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomLookaround;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStrollLand;
import net.minecraft.world.entity.ai.goal.PathfinderGoalTempt;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalHurtByTarget;
import net.minecraft.world.entity.ai.targeting.PathfinderTargetCondition;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.monster.EntityMonster;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.loot.LootTables;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_21_R4.event.CraftEventFactory;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.entity.EntityTargetEvent;

public class EntityPanda
extends EntityAnimal {
    private static final DataWatcherObject<Integer> bK = DataWatcher.a(EntityPanda.class, DataWatcherRegistry.b);
    private static final DataWatcherObject<Integer> bM = DataWatcher.a(EntityPanda.class, DataWatcherRegistry.b);
    private static final DataWatcherObject<Integer> bN = DataWatcher.a(EntityPanda.class, DataWatcherRegistry.b);
    private static final DataWatcherObject<Byte> bO = DataWatcher.a(EntityPanda.class, DataWatcherRegistry.a);
    private static final DataWatcherObject<Byte> bP = DataWatcher.a(EntityPanda.class, DataWatcherRegistry.a);
    private static final DataWatcherObject<Byte> bQ = DataWatcher.a(EntityPanda.class, DataWatcherRegistry.a);
    static final PathfinderTargetCondition bR = PathfinderTargetCondition.b().a(8.0);
    private static final EntitySize bS = EntityTypes.aO.n().a(0.5f).a(EntityAttachments.a().a(EntityAttachment.a, 0.0f, 0.40625f, 0.0f));
    private static final int bT = 2;
    private static final int bU = 4;
    private static final int bV = 8;
    private static final int bW = 16;
    private static final int bX = 5;
    public static final int bI = 32;
    private static final int bY = 32;
    boolean bZ;
    boolean ca;
    public int bJ;
    private Vec3D cb;
    private float cc;
    private float cd;
    private float ce;
    private float cf;
    private float cg;
    private float ch;
    g ci;

    public EntityPanda(EntityTypes<? extends EntityPanda> entityType, World level) {
        super((EntityTypes<? extends EntityAnimal>)entityType, level);
        this.bC = new h(this);
        if (!this.e_()) {
            this.a_(true);
        }
    }

    @Override
    protected boolean f(EnumItemSlot slot) {
        return slot == EnumItemSlot.a && this.fN();
    }

    public int m() {
        return this.al.a(bK);
    }

    public void s(int unhappyCounter) {
        this.al.a(bK, unhappyCounter);
    }

    public boolean p() {
        return this.v(2);
    }

    public boolean u() {
        return this.v(8);
    }

    public void w(boolean sitting) {
        if (!new EntityToggleSitEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), sitting).callEvent()) {
            return;
        }
        this.d(8, sitting);
    }

    public boolean gu() {
        return this.v(16);
    }

    public void x(boolean onBack) {
        this.d(16, onBack);
    }

    public boolean gv() {
        return this.al.a(bN) > 0;
    }

    public void y(boolean eating) {
        this.al.a(bN, eating ? 1 : 0);
    }

    public int gR() {
        return this.al.a(bN);
    }

    public void u(int eatCounter) {
        this.al.a(bN, eatCounter);
    }

    public void z(boolean sneezing) {
        this.d(2, sneezing);
        if (!sneezing) {
            this.t(0);
        }
    }

    public int gw() {
        return this.al.a(bM);
    }

    public void t(int sneezeCounter) {
        this.al.a(bM, sneezeCounter);
    }

    public Gene gx() {
        return Gene.a(this.al.a(bO).byteValue());
    }

    public void a(Gene pandaType) {
        if (pandaType.a() > 6) {
            pandaType = Gene.a(this.ae);
        }
        this.al.a(bO, (byte)pandaType.a());
    }

    public Gene gy() {
        return Gene.a(this.al.a(bP).byteValue());
    }

    public void b(Gene pandaType) {
        if (pandaType.a() > 6) {
            pandaType = Gene.a(this.ae);
        }
        this.al.a(bP, (byte)pandaType.a());
    }

    public boolean gG() {
        return this.v(4);
    }

    public void A(boolean rolling) {
        this.d(4, rolling);
    }

    @Override
    protected void a(DataWatcher.a builder) {
        super.a(builder);
        builder.a(bK, 0);
        builder.a(bM, 0);
        builder.a(bO, (byte)0);
        builder.a(bP, (byte)0);
        builder.a(bQ, (byte)0);
        builder.a(bN, 0);
    }

    private boolean v(int flag) {
        return (this.al.a(bQ) & flag) != 0;
    }

    private void d(int flagId, boolean value) {
        byte b2 = this.al.a(bQ);
        if (value) {
            this.al.a(bQ, (byte)(b2 | flagId));
        } else {
            this.al.a(bQ, (byte)(b2 & ~flagId));
        }
    }

    @Override
    public void b(NBTTagCompound compound) {
        super.b(compound);
        compound.a("MainGene", Gene.h, this.gx());
        compound.a("HiddenGene", Gene.h, this.gy());
    }

    @Override
    public void a(NBTTagCompound compound) {
        super.a(compound);
        this.a(compound.a("MainGene", Gene.h).orElse(Gene.a));
        this.b(compound.a("HiddenGene", Gene.h).orElse(Gene.a));
    }

    @Override
    @Nullable
    public EntityAgeable a(WorldServer level, EntityAgeable otherParent) {
        EntityPanda panda = EntityTypes.aO.a(level, EntitySpawnReason.e);
        if (panda != null) {
            if (otherParent instanceof EntityPanda) {
                EntityPanda panda1 = (EntityPanda)otherParent;
                panda.a(this, panda1);
            }
            panda.gP();
        }
        return panda;
    }

    @Override
    protected void C() {
        this.bF.a(0, new PathfinderGoalFloat(this));
        this.bF.a(2, new i(this, 2.0));
        this.bF.a(2, new d(this, 1.0));
        this.bF.a(3, new b(this, (double)1.2f, true));
        this.bF.a(4, new PathfinderGoalTempt(this, 1.0, stack -> stack.a(TagsItem.av), false));
        this.bF.a(6, new c<EntityHuman>(this, EntityHuman.class, 8.0f, 2.0, 2.0));
        this.bF.a(6, new c<EntityMonster>(this, EntityMonster.class, 4.0f, 2.0, 2.0));
        this.bF.a(7, new k());
        this.bF.a(8, new f(this));
        this.bF.a(8, new l(this));
        this.ci = new g(this, EntityHuman.class, 6.0f);
        this.bF.a(9, this.ci);
        this.bF.a(10, new PathfinderGoalRandomLookaround(this));
        this.bF.a(12, new j(this));
        this.bF.a(13, new PathfinderGoalFollowParent(this, 1.25));
        this.bF.a(14, new PathfinderGoalRandomStrollLand(this, 1.0));
        this.bG.a(1, new e(this, new Class[0]).a(new Class[0]));
    }

    public static AttributeProvider.Builder gH() {
        return EntityAnimal.gz().a(GenericAttributes.v, 0.15f).a(GenericAttributes.c, 6.0);
    }

    public Gene gI() {
        return Gene.a(this.gx(), this.gy());
    }

    public boolean gJ() {
        return this.gI() == Gene.b;
    }

    public boolean gK() {
        return this.gI() == Gene.c;
    }

    public boolean gL() {
        return this.gI() == Gene.d;
    }

    public boolean gM() {
        return this.gI() == Gene.e;
    }

    public boolean gN() {
        return this.gI() == Gene.f;
    }

    @Override
    public boolean gl() {
        return this.gI() == Gene.g;
    }

    @Override
    public boolean w() {
        return false;
    }

    @Override
    public boolean c(WorldServer level, Entity source) {
        if (!this.gl()) {
            this.ca = true;
        }
        return super.c(level, source);
    }

    @Override
    public void gn() {
        this.a(SoundEffects.tr, 1.0f, 1.0f);
    }

    @Override
    public void g() {
        EntityLiving target;
        super.g();
        if (this.gK()) {
            if (this.dV().ag() && !this.bi()) {
                this.w(true);
                this.y(false);
            } else if (!this.gv()) {
                this.w(false);
            }
        }
        if ((target = this.e()) == null) {
            this.bZ = false;
            this.ca = false;
        }
        if (this.m() > 0) {
            if (target != null) {
                this.a((Entity)target, 90.0f, 90.0f);
            }
            if (this.m() == 29 || this.m() == 14) {
                this.a(SoundEffects.tn, 1.0f, 1.0f);
            }
            this.s(this.m() - 1);
        }
        if (this.p()) {
            this.t(this.gw() + 1);
            if (this.gw() > 20) {
                this.z(false);
                this.gY();
            } else if (this.gw() == 1) {
                this.a(SoundEffects.th, 1.0f, 1.0f);
            }
        }
        if (this.gG()) {
            this.gX();
        } else {
            this.bJ = 0;
        }
        if (this.u()) {
            this.x(0.0f);
        }
        this.gU();
        this.gS();
        this.gV();
        this.gW();
    }

    public boolean gO() {
        return this.gK() && this.dV().ag();
    }

    private void gS() {
        if (!this.gv() && this.u() && !this.gO() && !this.a(EnumItemSlot.a).f() && this.ae.a(80) == 1) {
            this.y(true);
        } else if (this.a(EnumItemSlot.a).f() || !this.u()) {
            this.y(false);
        }
        if (this.gv()) {
            this.gT();
            if (!this.dV().C && this.gR() > 80 && this.ae.a(20) == 1) {
                if (this.gR() > 100 && this.a(EnumItemSlot.a).a(TagsItem.aw)) {
                    if (!this.dV().C) {
                        this.a(EnumItemSlot.a, ItemStack.l);
                        ((Entity)this).a(GameEvent.m);
                    }
                    this.w(false);
                }
                this.y(false);
                return;
            }
            this.u(this.gR() + 1);
        }
    }

    private void gT() {
        if (this.gR() % 5 == 0) {
            this.a(SoundEffects.tl, 0.5f + 0.5f * (float)this.ae.a(2), (this.ae.i() - this.ae.i()) * 0.2f + 1.0f);
            for (int i2 = 0; i2 < 6; ++i2) {
                Vec3D vec3 = new Vec3D(((double)this.ae.i() - 0.5) * 0.1, Math.random() * 0.1 + 0.1, ((double)this.ae.i() - 0.5) * 0.1);
                vec3 = vec3.a(-this.dN() * ((float)Math.PI / 180));
                vec3 = vec3.b(-this.dL() * ((float)Math.PI / 180));
                double d2 = (double)(-this.ae.i()) * 0.6 - 0.3;
                Vec3D vec31 = new Vec3D(((double)this.ae.i() - 0.5) * 0.8, d2, 1.0 + ((double)this.ae.i() - 0.5) * 0.4);
                vec31 = vec31.b(-this.aV * ((float)Math.PI / 180));
                vec31 = vec31.b(this.dA(), this.dE() + 1.0, this.dG());
                this.dV().a(new ParticleParamItem(Particles.U, this.a(EnumItemSlot.a)), vec31.d, vec31.e, vec31.f, vec3.d, vec3.e + 0.05, vec3.f);
            }
        }
    }

    private void gU() {
        this.cd = this.cc;
        this.cc = this.u() ? Math.min(1.0f, this.cc + 0.15f) : Math.max(0.0f, this.cc - 0.19f);
    }

    private void gV() {
        this.cf = this.ce;
        this.ce = this.gu() ? Math.min(1.0f, this.ce + 0.15f) : Math.max(0.0f, this.ce - 0.19f);
    }

    private void gW() {
        this.ch = this.cg;
        this.cg = this.gG() ? Math.min(1.0f, this.cg + 0.15f) : Math.max(0.0f, this.cg - 0.19f);
    }

    public float J(float partialTick) {
        return MathHelper.h(partialTick, this.cd, this.cc);
    }

    public float K(float partialTick) {
        return MathHelper.h(partialTick, this.cf, this.ce);
    }

    public float L(float partialTick) {
        return MathHelper.h(partialTick, this.ch, this.cg);
    }

    private void gX() {
        ++this.bJ;
        if (this.bJ > 32) {
            this.A(false);
        } else if (!this.dV().C) {
            Vec3D deltaMovement = this.dy();
            if (this.bJ == 1) {
                float f2 = this.dL() * ((float)Math.PI / 180);
                float f1 = this.e_() ? 0.1f : 0.2f;
                this.cb = new Vec3D(deltaMovement.d + (double)(-MathHelper.a(f2) * f1), 0.0, deltaMovement.f + (double)(MathHelper.b(f2) * f1));
                this.i(this.cb.b(0.0, 0.27, 0.0));
            } else if ((float)this.bJ != 7.0f && (float)this.bJ != 15.0f && (float)this.bJ != 23.0f) {
                this.n(this.cb.d, deltaMovement.e, this.cb.f);
            } else {
                this.n(0.0, this.aH() ? 0.27 : deltaMovement.e, 0.0);
            }
        }
    }

    private void gY() {
        WorldServer serverLevel;
        Vec3D deltaMovement = this.dy();
        World level = this.dV();
        level.a(Particles.aj, this.dA() - (double)(this.dq() + 1.0f) * 0.5 * (double)MathHelper.a(this.aV * ((float)Math.PI / 180)), this.dE() - (double)0.1f, this.dG() + (double)(this.dq() + 1.0f) * 0.5 * (double)MathHelper.b(this.aV * ((float)Math.PI / 180)), deltaMovement.d, 0.0, deltaMovement.f);
        this.a(SoundEffects.ti, 1.0f, 1.0f);
        for (EntityPanda panda : level.a(EntityPanda.class, this.cR().g(10.0))) {
            if (panda.e_() || !panda.aH() || panda.bi() || !panda.gQ()) continue;
            if (new EntityJumpEvent((LivingEntity)this.getBukkitLivingEntity()).callEvent()) {
                panda.r();
                continue;
            }
            this.s(false);
        }
        World world = this.dV();
        if (world instanceof WorldServer && (serverLevel = (WorldServer)world).O().c(GameRules.g)) {
            this.forceDrops = true;
            this.a(serverLevel, LootTables.aH, this::a);
            this.forceDrops = false;
        }
    }

    @Override
    protected void a(WorldServer level, EntityItem entity) {
        if (!CraftEventFactory.callEntityPickupItemEvent(this, entity, 0, !this.a(EnumItemSlot.a).f() || !EntityPanda.b(entity)).isCancelled()) {
            this.a(entity);
            ItemStack item = entity.e();
            this.a(EnumItemSlot.a, item);
            this.g(EnumItemSlot.a);
            this.a((Entity)entity, item.M());
            entity.discard(EntityRemoveEvent.Cause.PICKUP);
        }
    }

    @Override
    public boolean a(WorldServer level, DamageSource damageSource, float amount) {
        this.w(false);
        return super.a(level, damageSource, amount);
    }

    @Override
    @Nullable
    public GroupDataEntity a(WorldAccess level, DifficultyDamageScaler difficulty, EntitySpawnReason spawnReason, @Nullable GroupDataEntity spawnGroupData) {
        RandomSource random = level.G_();
        this.a(Gene.a(random));
        this.b(Gene.a(random));
        this.gP();
        if (spawnGroupData == null) {
            spawnGroupData = new EntityAgeable.a(0.2f);
        }
        return super.a(level, difficulty, spawnReason, spawnGroupData);
    }

    public void a(EntityPanda father, @Nullable EntityPanda mother) {
        if (mother == null) {
            if (this.ae.h()) {
                this.a(father.gZ());
                this.b(Gene.a(this.ae));
            } else {
                this.a(Gene.a(this.ae));
                this.b(father.gZ());
            }
        } else if (this.ae.h()) {
            this.a(father.gZ());
            this.b(mother.gZ());
        } else {
            this.a(mother.gZ());
            this.b(father.gZ());
        }
        if (this.ae.a(32) == 0) {
            this.a(Gene.a(this.ae));
        }
        if (this.ae.a(32) == 0) {
            this.b(Gene.a(this.ae));
        }
    }

    private Gene gZ() {
        return this.ae.h() ? this.gx() : this.gy();
    }

    public void gP() {
        if (this.gN()) {
            this.g(GenericAttributes.s).a(10.0);
        }
        if (this.gJ()) {
            this.g(GenericAttributes.v).a(0.07f);
        }
    }

    void ha() {
        if (!this.bi()) {
            this.G(0.0f);
            this.N().m();
            this.w(true);
        }
    }

    @Override
    public EnumInteractionResult b(EntityHuman player, EnumHand hand) {
        block7: {
            block9: {
                WorldServer serverLevel;
                ItemStack itemInHand;
                block12: {
                    block11: {
                        block10: {
                            block8: {
                                itemInHand = player.b(hand);
                                if (this.gO()) {
                                    return EnumInteractionResult.e;
                                }
                                if (this.gu()) {
                                    this.x(false);
                                    return EnumInteractionResult.a;
                                }
                                if (!this.i(itemInHand)) break block7;
                                if (this.e() != null) {
                                    this.bZ = true;
                                }
                                if (!this.e_()) break block8;
                                this.a(player, hand, itemInHand);
                                this.a((int)((float)(-this.Y_() / 20) * 0.1f), true);
                                break block9;
                            }
                            if (this.dV().C || this.Y_() != 0 || !this.gB()) break block10;
                            ItemStack breedCopy = itemInHand.v();
                            this.a(player, hand, itemInHand);
                            this.setInLove(player, breedCopy);
                            break block9;
                        }
                        World world = this.dV();
                        if (!(world instanceof WorldServer)) break block11;
                        serverLevel = (WorldServer)world;
                        if (!this.u() && !this.bi()) break block12;
                    }
                    return EnumInteractionResult.e;
                }
                this.ha();
                this.y(true);
                ItemStack itemBySlot = this.a(EnumItemSlot.a);
                if (!itemBySlot.f() && !player.fV()) {
                    this.forceDrops = true;
                    this.a(serverLevel, itemBySlot);
                    this.forceDrops = false;
                }
                this.a(EnumItemSlot.a, new ItemStack(itemInHand.h(), 1));
                this.a(player, hand, itemInHand);
            }
            return EnumInteractionResult.b;
        }
        return EnumInteractionResult.e;
    }

    @Override
    @Nullable
    public SoundEffect s() {
        if (this.gl()) {
            return SoundEffects.to;
        }
        return this.gK() ? SoundEffects.tp : SoundEffects.tj;
    }

    @Override
    protected void b(BlockPosition pos, IBlockData block) {
        this.a(SoundEffects.tm, 0.15f, 1.0f);
    }

    @Override
    public boolean i(ItemStack stack) {
        return stack.a(TagsItem.av);
    }

    @Override
    @Nullable
    public SoundEffect j_() {
        return SoundEffects.tk;
    }

    @Override
    @Nullable
    public SoundEffect e(DamageSource damageSource) {
        return SoundEffects.tq;
    }

    public boolean gQ() {
        return !this.gu() && !this.gO() && !this.gv() && !this.gG() && !this.u();
    }

    @Override
    public EntitySize e(EntityPose pose) {
        return this.e_() ? bS : super.e(pose);
    }

    private static boolean b(EntityItem itemEntity) {
        return itemEntity.e().a(TagsItem.aw) && itemEntity.bJ() && !itemEntity.n();
    }

    static class h
    extends ControllerMove {
        private final EntityPanda l;

        public h(EntityPanda mob) {
            super(mob);
            this.l = mob;
        }

        @Override
        public void a() {
            if (this.l.gQ()) {
                super.a();
            }
        }
    }

    public static final class Gene
    extends Enum<Gene>
    implements INamable {
        public static final /* enum */ Gene a = new Gene(0, "normal", false);
        public static final /* enum */ Gene b = new Gene(1, "lazy", false);
        public static final /* enum */ Gene c = new Gene(2, "worried", false);
        public static final /* enum */ Gene d = new Gene(3, "playful", false);
        public static final /* enum */ Gene e = new Gene(4, "brown", true);
        public static final /* enum */ Gene f = new Gene(5, "weak", true);
        public static final /* enum */ Gene g = new Gene(6, "aggressive", false);
        public static final Codec<Gene> h;
        private static final IntFunction<Gene> i;
        private static final int j = 6;
        private final int k;
        private final String l;
        private final boolean m;
        private static final /* synthetic */ Gene[] n;

        public static Gene[] values() {
            return (Gene[])n.clone();
        }

        public static Gene valueOf(String name) {
            return Enum.valueOf(Gene.class, name);
        }

        private Gene(int id, String name, boolean isRecessive) {
            this.k = id;
            this.l = name;
            this.m = isRecessive;
        }

        public int a() {
            return this.k;
        }

        @Override
        public String c() {
            return this.l;
        }

        public boolean b() {
            return this.m;
        }

        static Gene a(Gene mainGene, Gene hiddenGene) {
            if (mainGene.b()) {
                return mainGene == hiddenGene ? mainGene : a;
            }
            return mainGene;
        }

        public static Gene a(int index) {
            return i.apply(index);
        }

        public static Gene a(RandomSource random) {
            int randomInt = random.a(16);
            if (randomInt == 0) {
                return b;
            }
            if (randomInt == 1) {
                return c;
            }
            if (randomInt == 2) {
                return d;
            }
            if (randomInt == 4) {
                return g;
            }
            if (randomInt < 9) {
                return f;
            }
            return randomInt < 11 ? e : a;
        }

        private static /* synthetic */ Gene[] d() {
            return new Gene[]{a, b, c, d, e, f, g};
        }

        static {
            n = Gene.d();
            h = INamable.a(Gene::values);
            i = ByIdMap.a(Gene::a, Gene.values(), ByIdMap.a.a);
        }
    }

    static class i
    extends PathfinderGoalPanic {
        private final EntityPanda a;

        public i(EntityPanda panda, double speedModifier) {
            super((EntityCreature)panda, speedModifier, DamageTypeTags.G);
            this.a = panda;
        }

        @Override
        public boolean c() {
            if (this.a.u()) {
                this.a.N().m();
                return false;
            }
            return super.c();
        }
    }

    static class d
    extends PathfinderGoalBreed {
        private final EntityPanda d;
        private int e;

        public d(EntityPanda panda, double speedModifier) {
            super(panda, speedModifier);
            this.d = panda;
        }

        @Override
        public boolean b() {
            if (!super.b() || this.d.m() != 0) {
                return false;
            }
            if (!this.h()) {
                if (this.e <= this.d.af) {
                    this.d.s(32);
                    this.e = this.d.af + 600;
                    if (this.d.dj()) {
                        EntityHuman nearestPlayer = this.b.a(bR, this.d);
                        this.d.ci.a(nearestPlayer);
                    }
                }
                return false;
            }
            return true;
        }

        private boolean h() {
            BlockPosition blockPos = this.d.dv();
            BlockPosition.MutableBlockPosition mutableBlockPos = new BlockPosition.MutableBlockPosition();
            for (int i2 = 0; i2 < 3; ++i2) {
                for (int i1 = 0; i1 < 8; ++i1) {
                    int i22 = 0;
                    while (i22 <= i1) {
                        int i3;
                        int n2 = i3 = i22 < i1 && i22 > -i1 ? i1 : 0;
                        while (i3 <= i1) {
                            mutableBlockPos.a(blockPos, i22, i2, i3);
                            if (this.b.a_(mutableBlockPos).a(Blocks.nF)) {
                                return true;
                            }
                            i3 = i3 > 0 ? -i3 : 1 - i3;
                        }
                        i22 = i22 > 0 ? -i22 : 1 - i22;
                    }
                }
            }
            return false;
        }
    }

    static class b
    extends PathfinderGoalMeleeAttack {
        private final EntityPanda b;

        public b(EntityPanda panda, double speedModifier, boolean followingTargetEvenIfNotSeen) {
            super(panda, speedModifier, followingTargetEvenIfNotSeen);
            this.b = panda;
        }

        @Override
        public boolean b() {
            return this.b.gQ() && super.b();
        }
    }

    static class c<T extends EntityLiving>
    extends PathfinderGoalAvoidTarget<T> {
        private final EntityPanda i;

        public c(EntityPanda panda, Class<T> entityClassToAvoid, float maxDist, double walkSpeedModifier, double sprintSpeedModifier) {
            super(panda, entityClassToAvoid, maxDist, walkSpeedModifier, sprintSpeedModifier, IEntitySelector.f::test);
            this.i = panda;
        }

        @Override
        public boolean b() {
            return this.i.gK() && this.i.gQ() && super.b();
        }
    }

    class k
    extends PathfinderGoal {
        private int b;

        public k() {
            this.a(EnumSet.of(PathfinderGoal.Type.a));
        }

        @Override
        public boolean b() {
            return this.b <= EntityPanda.this.af && !EntityPanda.this.e_() && !EntityPanda.this.bi() && EntityPanda.this.gQ() && EntityPanda.this.m() <= 0 && (!EntityPanda.this.a(EnumItemSlot.a).f() || !EntityPanda.this.dV().a(EntityItem.class, EntityPanda.this.cR().c(6.0, 6.0, 6.0), EntityPanda::b).isEmpty());
        }

        @Override
        public boolean c() {
            return !EntityPanda.this.bi() && (EntityPanda.this.gJ() || EntityPanda.this.ae.a(net.minecraft.world.entity.animal.EntityPanda$k.b(600)) != 1) && EntityPanda.this.ae.a(net.minecraft.world.entity.animal.EntityPanda$k.b(2000)) != 1;
        }

        @Override
        public void a() {
            if (!EntityPanda.this.u() && !EntityPanda.this.a(EnumItemSlot.a).f()) {
                EntityPanda.this.ha();
            }
        }

        @Override
        public void d() {
            if (EntityPanda.this.a(EnumItemSlot.a).f()) {
                List<EntityItem> entitiesOfClass = EntityPanda.this.dV().a(EntityItem.class, EntityPanda.this.cR().c(8.0, 8.0, 8.0), EntityPanda::b);
                if (!entitiesOfClass.isEmpty()) {
                    EntityPanda.this.N().a((Entity)entitiesOfClass.getFirst(), (double)1.2f);
                }
            } else {
                EntityPanda.this.ha();
            }
            this.b = 0;
        }

        @Override
        public void e() {
            ItemStack itemBySlot = EntityPanda.this.a(EnumItemSlot.a);
            if (!itemBySlot.f()) {
                EntityPanda.this.forceDrops = true;
                EntityPanda.this.a(net.minecraft.world.entity.animal.EntityPanda$k.a(EntityPanda.this.dV()), itemBySlot);
                EntityPanda.this.forceDrops = false;
                EntityPanda.this.a(EnumItemSlot.a, ItemStack.l);
                int i2 = EntityPanda.this.gJ() ? EntityPanda.this.ae.a(50) + 10 : EntityPanda.this.ae.a(150) + 10;
                this.b = EntityPanda.this.af + i2 * 20;
            }
            EntityPanda.this.w(false);
        }
    }

    static class f
    extends PathfinderGoal {
        private final EntityPanda a;
        private int b;

        public f(EntityPanda panda) {
            this.a = panda;
        }

        @Override
        public boolean b() {
            return this.b < this.a.af && this.a.gJ() && this.a.gQ() && this.a.ae.a(net.minecraft.world.entity.animal.EntityPanda$f.b(400)) == 1;
        }

        @Override
        public boolean c() {
            return !this.a.bi() && (this.a.gJ() || this.a.ae.a(net.minecraft.world.entity.animal.EntityPanda$f.b(600)) != 1) && this.a.ae.a(net.minecraft.world.entity.animal.EntityPanda$f.b(2000)) != 1;
        }

        @Override
        public void d() {
            this.a.x(true);
            this.b = 0;
        }

        @Override
        public void e() {
            this.a.x(false);
            this.b = this.a.af + 200;
        }
    }

    static class l
    extends PathfinderGoal {
        private final EntityPanda a;

        public l(EntityPanda panda) {
            this.a = panda;
        }

        @Override
        public boolean b() {
            return this.a.e_() && this.a.gQ() && (this.a.gN() && this.a.ae.a(net.minecraft.world.entity.animal.EntityPanda$l.b(500)) == 1 || this.a.ae.a(net.minecraft.world.entity.animal.EntityPanda$l.b(6000)) == 1);
        }

        @Override
        public boolean c() {
            return false;
        }

        @Override
        public void d() {
            this.a.z(true);
        }
    }

    static class g
    extends PathfinderGoalLookAtPlayer {
        private final EntityPanda h;

        public g(EntityPanda panda, Class<? extends EntityLiving> lookAtType, float lookDistance) {
            super(panda, lookAtType, lookDistance);
            this.h = panda;
        }

        public void a(EntityLiving lookAt) {
            this.c = lookAt;
        }

        @Override
        public boolean c() {
            return this.c != null && super.c();
        }

        @Override
        public boolean b() {
            if (this.b.dY().i() >= this.e) {
                return false;
            }
            if (this.c == null) {
                WorldServer serverLevel = g.a(this.b);
                this.c = this.f == EntityHuman.class ? serverLevel.a(this.g, this.b, this.b.dA(), this.b.dE(), this.b.dG()) : serverLevel.a(this.b.dV().a(this.f, this.b.cR().c(this.d, 3.0, this.d), entity -> true), this.g, this.b, this.b.dA(), this.b.dE(), this.b.dG());
            }
            return this.h.gQ() && this.c != null;
        }

        @Override
        public void a() {
            if (this.c != null) {
                super.a();
            }
        }
    }

    static class j
    extends PathfinderGoal {
        private final EntityPanda a;

        public j(EntityPanda panda) {
            this.a = panda;
            this.a(EnumSet.of(PathfinderGoal.Type.a, PathfinderGoal.Type.b, PathfinderGoal.Type.c));
        }

        @Override
        public boolean b() {
            if ((this.a.e_() || this.a.gL()) && this.a.aH()) {
                if (!this.a.gQ()) {
                    return false;
                }
                float f2 = this.a.dL() * ((float)Math.PI / 180);
                float f1 = -MathHelper.a(f2);
                float cos = MathHelper.b(f2);
                int i2 = (double)Math.abs(f1) > 0.5 ? MathHelper.j((double)f1) : 0;
                int i1 = (double)Math.abs(cos) > 0.5 ? MathHelper.j((double)cos) : 0;
                return this.a.dV().a_(this.a.dv().b(i2, -1, i1)).l() || this.a.gL() && this.a.ae.a(net.minecraft.world.entity.animal.EntityPanda$j.b(60)) == 1 || this.a.ae.a(net.minecraft.world.entity.animal.EntityPanda$j.b(500)) == 1;
            }
            return false;
        }

        @Override
        public boolean c() {
            return false;
        }

        @Override
        public void d() {
            this.a.A(true);
        }

        @Override
        public boolean V_() {
            return false;
        }
    }

    static class e
    extends PathfinderGoalHurtByTarget {
        private final EntityPanda a;

        public e(EntityPanda panda, Class<?> ... entityClassToIgnoreDamage) {
            super(panda, entityClassToIgnoreDamage);
            this.a = panda;
        }

        @Override
        public boolean c() {
            if (!this.a.bZ && !this.a.ca) {
                return super.c();
            }
            this.a.g((EntityLiving)null);
            return false;
        }

        @Override
        protected void a(EntityInsentient mob, EntityLiving target) {
            if (mob instanceof EntityPanda && mob.gl()) {
                mob.setTarget(target, EntityTargetEvent.TargetReason.TARGET_ATTACKED_ENTITY);
            }
        }
    }
}

