/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.serialization.Codec;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.INamable;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTameableAnimal;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.control.ControllerMoveFlying;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFollowEntity;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFollowOwner;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalPerch;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomFly;
import net.minecraft.world.entity.ai.goal.PathfinderGoalSit;
import net.minecraft.world.entity.ai.navigation.NavigationAbstract;
import net.minecraft.world.entity.ai.navigation.NavigationFlying;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.animal.EntityBird;
import net.minecraft.world.entity.animal.EntityPerchable;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.BlockLeaves;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_21_R4.event.CraftEventFactory;
import org.bukkit.event.entity.EntityPotionEffectEvent;

public class EntityParrot
extends EntityPerchable
implements EntityBird {
    private static final DataWatcherObject<Integer> bQ = DataWatcher.a(EntityParrot.class, DataWatcherRegistry.b);
    private static final Predicate<EntityInsentient> bR = new Predicate<EntityInsentient>(){

        public boolean a(@Nullable EntityInsentient mob) {
            return mob != null && bS.containsKey(mob.an());
        }
    };
    static final Map<EntityTypes<?>, SoundEffect> bS = SystemUtils.a(Maps.newHashMap(), (? super T map) -> {
        map.put(EntityTypes.p, SoundEffects.tx);
        map.put(EntityTypes.r, SoundEffects.ty);
        map.put(EntityTypes.s, SoundEffects.tz);
        map.put(EntityTypes.w, SoundEffects.tW);
        map.put(EntityTypes.E, SoundEffects.tA);
        map.put(EntityTypes.F, SoundEffects.tB);
        map.put(EntityTypes.L, SoundEffects.tC);
        map.put(EntityTypes.N, SoundEffects.tD);
        map.put(EntityTypes.Q, SoundEffects.tE);
        map.put(EntityTypes.P, SoundEffects.tF);
        map.put(EntityTypes.T, SoundEffects.tG);
        map.put(EntityTypes.ae, SoundEffects.tH);
        map.put(EntityTypes.aj, SoundEffects.tI);
        map.put(EntityTypes.ak, SoundEffects.tJ);
        map.put(EntityTypes.an, SoundEffects.tK);
        map.put(EntityTypes.ao, SoundEffects.tL);
        map.put(EntityTypes.aA, SoundEffects.tM);
        map.put(EntityTypes.aQ, SoundEffects.tN);
        map.put(EntityTypes.aS, SoundEffects.tO);
        map.put(EntityTypes.aT, SoundEffects.tP);
        map.put(EntityTypes.aU, SoundEffects.tQ);
        map.put(EntityTypes.ba, SoundEffects.tR);
        map.put(EntityTypes.bd, SoundEffects.tS);
        map.put(EntityTypes.bf, SoundEffects.tT);
        map.put(EntityTypes.bg, SoundEffects.tU);
        map.put(EntityTypes.bi, SoundEffects.tV);
        map.put(EntityTypes.bp, SoundEffects.tW);
        map.put(EntityTypes.bt, SoundEffects.tX);
        map.put(EntityTypes.bD, SoundEffects.tY);
        map.put(EntityTypes.bF, SoundEffects.tZ);
        map.put(EntityTypes.bH, SoundEffects.ua);
        map.put(EntityTypes.bJ, SoundEffects.ub);
        map.put(EntityTypes.bK, SoundEffects.uc);
        map.put(EntityTypes.bL, SoundEffects.ud);
        map.put(EntityTypes.bO, SoundEffects.ue);
        map.put(EntityTypes.bP, SoundEffects.uf);
        map.put(EntityTypes.bR, SoundEffects.ug);
    });
    public float bM;
    public float bN;
    public float bO;
    public float bP;
    private float bT = 1.0f;
    private float bU = 1.0f;
    private boolean bV;
    @Nullable
    private BlockPosition bW;

    public EntityParrot(EntityTypes<? extends EntityParrot> entityType, World level) {
        super((EntityTypes<? extends EntityPerchable>)entityType, level);
        this.bC = new ControllerMoveFlying(this, 10, false);
        this.a(PathType.n, -1.0f);
        this.a(PathType.o, -1.0f);
        this.a(PathType.x, -1.0f);
    }

    @Override
    @Nullable
    public GroupDataEntity a(WorldAccess level, DifficultyDamageScaler difficulty, EntitySpawnReason spawnReason, @Nullable GroupDataEntity spawnGroupData) {
        this.a(SystemUtils.a(Variant.values(), level.G_()));
        if (spawnGroupData == null) {
            spawnGroupData = new EntityAgeable.a(false);
        }
        return super.a(level, difficulty, spawnReason, spawnGroupData);
    }

    @Override
    public boolean e_() {
        return false;
    }

    @Override
    protected void C() {
        this.bF.a(0, new EntityTameableAnimal.a(1.25));
        this.bF.a(0, new PathfinderGoalFloat(this));
        this.bF.a(1, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 8.0f));
        this.bF.a(2, new PathfinderGoalSit(this));
        this.bF.a(2, new PathfinderGoalFollowOwner(this, 1.0, 5.0f, 1.0f));
        this.bF.a(2, new a(this, 1.0));
        this.bF.a(3, new PathfinderGoalPerch(this));
        this.bF.a(3, new PathfinderGoalFollowEntity(this, 1.0, 3.0f, 7.0f));
    }

    public static AttributeProvider.Builder gG() {
        return EntityAnimal.gz().a(GenericAttributes.s, 6.0).a(GenericAttributes.l, 0.4f).a(GenericAttributes.v, 0.2f).a(GenericAttributes.c, 3.0);
    }

    @Override
    protected NavigationAbstract b(World level) {
        NavigationFlying flyingPathNavigation = new NavigationFlying(this, level);
        flyingPathNavigation.b(false);
        flyingPathNavigation.a(true);
        return flyingPathNavigation;
    }

    @Override
    public void d_() {
        if (this.bW == null || !this.bW.a(this.dt(), 3.46) || !this.dV().a_(this.bW).a(Blocks.ek)) {
            this.bV = false;
            this.bW = null;
        }
        if (this.dV().A.a(400) == 0) {
            EntityParrot.a(this.dV(), this);
        }
        super.d_();
        this.gL();
    }

    @Override
    public void a(BlockPosition pos, boolean isPartying) {
        this.bW = pos;
        this.bV = isPartying;
    }

    public boolean gH() {
        return this.bV;
    }

    private void gL() {
        this.bP = this.bM;
        this.bO = this.bN;
        this.bN += (float)(!this.aH() && !this.bY() ? 4 : -1) * 0.3f;
        this.bN = MathHelper.a(this.bN, 0.0f, 1.0f);
        if (!this.aH() && this.bT < 1.0f) {
            this.bT = 1.0f;
        }
        this.bT *= 0.9f;
        Vec3D deltaMovement = this.dy();
        if (!this.aH() && deltaMovement.e < 0.0) {
            this.i(deltaMovement.d(1.0, 0.6, 1.0));
        }
        this.bM += this.bT * 2.0f;
    }

    public static boolean a(World level, Entity parrot) {
        if (parrot.bJ() && !parrot.ba() && level.A.a(2) == 0) {
            EntityInsentient mob;
            List<EntityInsentient> entitiesOfClass = level.a(EntityInsentient.class, parrot.cR().g(20.0), bR);
            if (!entitiesOfClass.isEmpty() && !(mob = entitiesOfClass.get(level.A.a(entitiesOfClass.size()))).ba()) {
                SoundEffect imitatedSound = EntityParrot.b(mob.an());
                level.a(null, parrot.dA(), parrot.dC(), parrot.dG(), imitatedSound, parrot.dm(), 0.7f, EntityParrot.a(level.A));
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    public EnumInteractionResult b(EntityHuman player, EnumHand hand) {
        ItemStack itemInHand = player.b(hand);
        if (!this.m() && itemInHand.a(TagsItem.aC)) {
            this.a(player, hand, itemInHand);
            if (!this.ba()) {
                this.dV().a(null, this.dA(), this.dC(), this.dG(), SoundEffects.tu, this.dm(), 1.0f, 1.0f + (this.ae.i() - this.ae.i()) * 0.2f);
            }
            if (!this.dV().C) {
                if (this.ae.a(10) == 0 && !CraftEventFactory.callEntityTameEvent(this, player).isCancelled()) {
                    this.a(player);
                    this.dV().a((Entity)this, (byte)7);
                } else {
                    this.dV().a((Entity)this, (byte)6);
                }
            }
            return EnumInteractionResult.a;
        }
        if (!itemInHand.a(TagsItem.aD)) {
            if (!this.gJ() && this.m() && this.j(player)) {
                if (!this.dV().C) {
                    this.y(!this.gu());
                }
                return EnumInteractionResult.a;
            }
            return super.b(player, hand);
        }
        this.a(player, hand, itemInHand);
        this.addEffect(new MobEffect(MobEffects.s, 900), EntityPotionEffectEvent.Cause.FOOD);
        if (player.gz() || !this.cC()) {
            this.a(this.dW().a(player), Float.MAX_VALUE);
        }
        return EnumInteractionResult.a;
    }

    @Override
    public boolean i(ItemStack stack) {
        return false;
    }

    public static boolean c(EntityTypes<EntityParrot> entityType, GeneratorAccess level, EntitySpawnReason spawnReason, BlockPosition pos, RandomSource random) {
        return level.a_(pos.e()).a(TagsBlock.cf) && EntityParrot.a(level, pos);
    }

    @Override
    protected void a(double y2, boolean onGround, IBlockData state, BlockPosition pos) {
    }

    @Override
    public boolean a(EntityAnimal otherAnimal) {
        return false;
    }

    @Override
    @Nullable
    public EntityAgeable a(WorldServer level, EntityAgeable otherParent) {
        return null;
    }

    @Override
    @Nullable
    public SoundEffect s() {
        return EntityParrot.a(this.dV(), this.dV().A);
    }

    public static SoundEffect a(World level, RandomSource random) {
        if (level.an() != EnumDifficulty.a && random.a(1000) == 0) {
            ArrayList list = Lists.newArrayList(bS.keySet());
            return EntityParrot.b((EntityTypes)list.get(random.a(list.size())));
        }
        return SoundEffects.ts;
    }

    private static SoundEffect b(EntityTypes<?> type) {
        return bS.getOrDefault(type, SoundEffects.ts);
    }

    @Override
    public SoundEffect e(DamageSource damageSource) {
        return SoundEffects.tw;
    }

    @Override
    public SoundEffect j_() {
        return SoundEffects.tt;
    }

    @Override
    protected void b(BlockPosition pos, IBlockData block) {
        this.a(SoundEffects.uh, 0.15f, 1.0f);
    }

    @Override
    protected boolean aZ() {
        return this.Y > this.bU;
    }

    @Override
    protected void aY() {
        this.a(SoundEffects.tv, 0.15f, 1.0f);
        this.bU = this.Y + this.bN / 2.0f;
    }

    @Override
    public float ff() {
        return EntityParrot.a(this.ae);
    }

    public static float a(RandomSource random) {
        return (random.i() - random.i()) * 0.2f + 1.0f;
    }

    @Override
    public SoundCategory dm() {
        return SoundCategory.g;
    }

    @Override
    public boolean isCollidable(boolean ignoreClimbing) {
        return super.isCollidable(ignoreClimbing);
    }

    @Override
    protected void D(Entity entity) {
        if (!(entity instanceof EntityHuman)) {
            super.D(entity);
        }
    }

    @Override
    public boolean a(WorldServer level, DamageSource damageSource, float amount) {
        if (this.a(level, damageSource)) {
            return false;
        }
        if (!super.a(level, damageSource, amount)) {
            return false;
        }
        this.y(false);
        return true;
    }

    public Variant gI() {
        return Variant.a(this.al.a(bQ));
    }

    public void a(Variant variant) {
        this.al.a(bQ, variant.k);
    }

    @Override
    @Nullable
    public <T> T a(DataComponentType<? extends T> component) {
        return component == DataComponents.aB ? EntityParrot.c(component, this.gI()) : super.a(component);
    }

    @Override
    protected void a(DataComponentGetter componentGetter) {
        this.a(componentGetter, DataComponents.aB);
        super.a(componentGetter);
    }

    @Override
    protected <T> boolean b(DataComponentType<T> component, T value) {
        if (component == DataComponents.aB) {
            this.a(EntityParrot.c(DataComponents.aB, value));
            return true;
        }
        return super.b(component, value);
    }

    @Override
    protected void a(DataWatcher.a builder) {
        super.a(builder);
        builder.a(bQ, Variant.f.k);
    }

    @Override
    public void b(NBTTagCompound compound) {
        super.b(compound);
        compound.a("Variant", Variant.h, this.gI());
    }

    @Override
    public void a(NBTTagCompound compound) {
        super.a(compound);
        this.a(compound.a("Variant", Variant.h).orElse(Variant.f));
    }

    @Override
    public boolean gJ() {
        return !this.aH();
    }

    @Override
    protected boolean gy() {
        return true;
    }

    @Override
    public Vec3D cT() {
        return new Vec3D(0.0, 0.5f * this.cS(), this.dq() * 0.4f);
    }

    public static final class Variant
    extends Enum<Variant>
    implements INamable {
        public static final /* enum */ Variant a = new Variant(0, "red_blue");
        public static final /* enum */ Variant b = new Variant(1, "blue");
        public static final /* enum */ Variant c = new Variant(2, "green");
        public static final /* enum */ Variant d = new Variant(3, "yellow_blue");
        public static final /* enum */ Variant e = new Variant(4, "gray");
        public static final Variant f;
        private static final IntFunction<Variant> j;
        public static final Codec<Variant> g;
        @Deprecated
        public static final Codec<Variant> h;
        public static final StreamCodec<ByteBuf, Variant> i;
        final int k;
        private final String l;
        private static final /* synthetic */ Variant[] m;

        public static Variant[] values() {
            return (Variant[])m.clone();
        }

        public static Variant valueOf(String name) {
            return Enum.valueOf(Variant.class, name);
        }

        private Variant(int id, String name) {
            this.k = id;
            this.l = name;
        }

        public int a() {
            return this.k;
        }

        public static Variant a(int id) {
            return j.apply(id);
        }

        @Override
        public String c() {
            return this.l;
        }

        private static /* synthetic */ Variant[] b() {
            return new Variant[]{a, b, c, d, e};
        }

        static {
            m = Variant.b();
            f = a;
            j = ByIdMap.a(Variant::a, Variant.values(), ByIdMap.a.c);
            g = INamable.a(Variant::values);
            h = Codec.INT.xmap(j::apply, Variant::a);
            i = ByteBufCodecs.a(j, Variant::a);
        }
    }

    static class a
    extends PathfinderGoalRandomFly {
        public a(EntityCreature mob, double speedModifier) {
            super(mob, speedModifier);
        }

        @Override
        @Nullable
        protected Vec3D h() {
            Vec3D vec3 = null;
            if (this.b.bi()) {
                vec3 = LandRandomPos.a(this.b, 15, 15);
            }
            if (this.b.dY().i() >= this.j) {
                vec3 = this.k();
            }
            return vec3 == null ? super.h() : vec3;
        }

        @Nullable
        private Vec3D k() {
            BlockPosition blockPos = this.b.dv();
            BlockPosition.MutableBlockPosition mutableBlockPos = new BlockPosition.MutableBlockPosition();
            BlockPosition.MutableBlockPosition mutableBlockPos1 = new BlockPosition.MutableBlockPosition();
            for (BlockPosition blockPos1 : BlockPosition.b(MathHelper.a(this.b.dA() - 3.0), MathHelper.a(this.b.dC() - 6.0), MathHelper.a(this.b.dG() - 3.0), MathHelper.a(this.b.dA() + 3.0), MathHelper.a(this.b.dC() + 6.0), MathHelper.a(this.b.dG() + 3.0))) {
                IBlockData blockState;
                boolean flag;
                if (blockPos.equals(blockPos1) || !(flag = (blockState = this.b.dV().a_(mutableBlockPos1.a((BaseBlockPosition)blockPos1, EnumDirection.a))).b() instanceof BlockLeaves || blockState.a(TagsBlock.u)) || !this.b.dV().v(blockPos1) || !this.b.dV().v(mutableBlockPos.a((BaseBlockPosition)blockPos1, EnumDirection.b))) continue;
                return Vec3D.c(blockPos1);
            }
            return null;
        }
    }
}

