/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsItem;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.ConversionParams;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityLightning;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.ISteerable;
import net.minecraft.world.entity.SaddleStorage;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.PathfinderGoalBreed;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFollowParent;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalPanic;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomLookaround;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStrollLand;
import net.minecraft.world.entity.ai.goal.PathfinderGoalTempt;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.animal.PigVariant;
import net.minecraft.world.entity.animal.PigVariants;
import net.minecraft.world.entity.monster.EntityPigZombie;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.variant.SpawnContext;
import net.minecraft.world.entity.variant.VariantUtils;
import net.minecraft.world.entity.vehicle.DismountUtil;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.equipment.Equippable;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_21_R4.event.CraftEventFactory;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityRemoveEvent;

public class EntityPig
extends EntityAnimal
implements ISteerable {
    private static final DataWatcherObject<Integer> bI = DataWatcher.a(EntityPig.class, DataWatcherRegistry.b);
    private static final DataWatcherObject<Holder<PigVariant>> bJ = DataWatcher.a(EntityPig.class, DataWatcherRegistry.D);
    public final SaddleStorage bK;

    public EntityPig(EntityTypes<? extends EntityPig> entityType, World level) {
        super((EntityTypes<? extends EntityAnimal>)entityType, level);
        this.bK = new SaddleStorage(this.al, bI);
    }

    @Override
    protected void C() {
        this.bF.a(0, new PathfinderGoalFloat(this));
        this.bF.a(1, new PathfinderGoalPanic(this, 1.25));
        this.bF.a(3, new PathfinderGoalBreed(this, 1.0));
        this.bF.a(4, new PathfinderGoalTempt(this, 1.2, itemStack -> itemStack.a(Items.oA), false));
        this.bF.a(4, new PathfinderGoalTempt(this, 1.2, itemStack -> itemStack.a(TagsItem.ax), false));
        this.bF.a(5, new PathfinderGoalFollowParent(this, 1.1));
        this.bF.a(6, new PathfinderGoalRandomStrollLand(this, 1.0));
        this.bF.a(7, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 6.0f));
        this.bF.a(8, new PathfinderGoalRandomLookaround(this));
    }

    public static AttributeProvider.Builder m() {
        return EntityAnimal.gz().a(GenericAttributes.s, 10.0).a(GenericAttributes.v, 0.25);
    }

    @Override
    @Nullable
    public EntityLiving cW() {
        EntityHuman player;
        Entity entity;
        return this.fZ() && (entity = this.cZ()) instanceof EntityHuman && (player = (EntityHuman)entity).b(Items.oA) ? player : super.cW();
    }

    @Override
    public void a(DataWatcherObject<?> key) {
        if (bI.equals(key) && this.dV().C) {
            this.bK.a();
        }
        super.a(key);
    }

    @Override
    protected void a(DataWatcher.a builder) {
        super.a(builder);
        builder.a(bI, 0);
        builder.a(bJ, VariantUtils.a(this.dX(), PigVariants.d));
    }

    @Override
    public void b(NBTTagCompound compound) {
        super.b(compound);
        VariantUtils.a(compound, this.p());
    }

    @Override
    public void a(NBTTagCompound compound) {
        super.a(compound);
        VariantUtils.a(compound, this.dX(), Registries.ba).ifPresent(this::j);
    }

    @Override
    public SoundEffect s() {
        return SoundEffects.uo;
    }

    @Override
    public SoundEffect e(DamageSource damageSource) {
        return SoundEffects.uq;
    }

    @Override
    public SoundEffect j_() {
        return SoundEffects.up;
    }

    @Override
    protected void b(BlockPosition pos, IBlockData block) {
        this.a(SoundEffects.us, 0.15f, 1.0f);
    }

    @Override
    public EnumInteractionResult b(EntityHuman player, EnumHand hand) {
        boolean isFood = this.i(player.b(hand));
        if (!isFood && this.fZ() && !this.bZ() && !player.fY()) {
            if (!this.dV().C) {
                player.n(this);
            }
            return EnumInteractionResult.a;
        }
        EnumInteractionResult interactionResult = super.b(player, hand);
        if (!interactionResult.a()) {
            ItemStack itemInHand = player.b(hand);
            return this.a(itemInHand, EnumItemSlot.h) ? itemInHand.a(player, (EntityLiving)this, hand) : EnumInteractionResult.e;
        }
        return interactionResult;
    }

    @Override
    public boolean e(EnumItemSlot slot) {
        return slot != EnumItemSlot.h ? super.e(slot) : this.bJ() && !this.e_();
    }

    @Override
    protected boolean f(EnumItemSlot slot) {
        return slot == EnumItemSlot.h || super.f(slot);
    }

    @Override
    protected Holder<SoundEffect> a(EnumItemSlot slot, ItemStack stack, Equippable equippable) {
        return slot == EnumItemSlot.h ? SoundEffects.ur : super.a(slot, stack, equippable);
    }

    @Override
    public Vec3D b(EntityLiving livingEntity) {
        EnumDirection motionDirection = this.cP();
        if (motionDirection.o() == EnumDirection.EnumAxis.b) {
            return super.b(livingEntity);
        }
        int[][] ints = DismountUtil.a(motionDirection);
        BlockPosition blockPos = this.dv();
        BlockPosition.MutableBlockPosition mutableBlockPos = new BlockPosition.MutableBlockPosition();
        for (EntityPose pose : livingEntity.fO()) {
            AxisAlignedBB localBoundsForPose = livingEntity.f(pose);
            for (int[] ints1 : ints) {
                mutableBlockPos.d(blockPos.u() + ints1[0], blockPos.v(), blockPos.w() + ints1[1]);
                double blockFloorHeight = this.dV().j(mutableBlockPos);
                if (!DismountUtil.a(blockFloorHeight)) continue;
                Vec3D vec3 = Vec3D.a(mutableBlockPos, blockFloorHeight);
                if (!DismountUtil.a(this.dV(), livingEntity, localBoundsForPose.c(vec3))) continue;
                livingEntity.b(pose);
                return vec3;
            }
        }
        return super.b(livingEntity);
    }

    @Override
    public void a(WorldServer level, EntityLightning lightning) {
        if (level.an() != EnumDifficulty.a) {
            EntityPigZombie zombifiedPiglin = this.convertTo(EntityTypes.bS, ConversionParams.a(this, false, true), (T mob) -> {
                if (this.fb().f()) {
                    mob.a(EnumItemSlot.a, new ItemStack(Items.pK));
                }
                mob.gc();
            }, null, null);
            if (CraftEventFactory.callPigZapEvent(this, lightning, zombifiedPiglin).isCancelled()) {
                return;
            }
            level.addFreshEntity(zombifiedPiglin, CreatureSpawnEvent.SpawnReason.LIGHTNING);
            this.discard(EntityRemoveEvent.Cause.TRANSFORMATION);
            if (zombifiedPiglin == null) {
                super.a(level, lightning);
            }
        } else {
            super.a(level, lightning);
        }
    }

    @Override
    protected void a(EntityHuman player, Vec3D travelVector) {
        super.a(player, travelVector);
        this.b(player.dL(), player.dN() * 0.5f);
        this.aV = this.aX = this.dL();
        this.N = this.aX;
        this.bK.b();
    }

    @Override
    protected Vec3D b(EntityHuman player, Vec3D travelVector) {
        return new Vec3D(0.0, 0.0, 1.0);
    }

    @Override
    protected float c(EntityHuman player) {
        return (float)(this.h(GenericAttributes.v) * 0.225 * (double)this.bK.c());
    }

    @Override
    public boolean a() {
        return this.bK.a(this.dY());
    }

    @Nullable
    public EntityPig b(WorldServer level, EntityAgeable otherParent) {
        EntityPig pig = EntityTypes.aR.a(level, EntitySpawnReason.e);
        if (pig != null && otherParent instanceof EntityPig) {
            EntityPig pig1 = (EntityPig)otherParent;
            pig.j(this.ae.h() ? this.p() : pig1.p());
        }
        return pig;
    }

    @Override
    public boolean i(ItemStack stack) {
        return stack.a(TagsItem.ax);
    }

    @Override
    public Vec3D cT() {
        return new Vec3D(0.0, 0.6f * this.cS(), this.dq() * 0.4f);
    }

    public void j(Holder<PigVariant> variant) {
        this.al.a(bJ, variant);
    }

    public Holder<PigVariant> p() {
        return this.al.a(bJ);
    }

    @Override
    @Nullable
    public <T> T a(DataComponentType<? extends T> component) {
        return component == DataComponents.aH ? EntityPig.c(component, this.p()) : super.a(component);
    }

    @Override
    protected void a(DataComponentGetter componentGetter) {
        this.a(componentGetter, DataComponents.aH);
        super.a(componentGetter);
    }

    @Override
    protected <T> boolean b(DataComponentType<T> component, T value) {
        if (component == DataComponents.aH) {
            this.j(EntityPig.c(DataComponents.aH, value));
            return true;
        }
        return super.b(component, value);
    }

    @Override
    public GroupDataEntity a(WorldAccess level, DifficultyDamageScaler difficulty, EntitySpawnReason spawnReason, @Nullable GroupDataEntity spawnGroupData) {
        PigVariants.a(this.ae, this.dX(), SpawnContext.a(level, this.dv())).ifPresent(this::j);
        return super.a(level, difficulty, spawnReason, spawnGroupData);
    }
}

