/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal;

import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.util.TimeRange;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.IEntityAngerable;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFollowParent;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalMeleeAttack;
import net.minecraft.world.entity.ai.goal.PathfinderGoalPanic;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomLookaround;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStroll;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalHurtByTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalUniversalAngerReset;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.animal.EntityFox;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.block.state.IBlockData;

public class EntityPolarBear
extends EntityAnimal
implements IEntityAngerable {
    private static final DataWatcherObject<Boolean> bI = DataWatcher.a(EntityPolarBear.class, DataWatcherRegistry.k);
    private static final float bJ = 6.0f;
    private float bK;
    private float bM;
    private int bN;
    private static final UniformInt bO = TimeRange.a(20, 39);
    private int bP;
    @Nullable
    private UUID bQ;

    public EntityPolarBear(EntityTypes<? extends EntityPolarBear> entityType, World level) {
        super((EntityTypes<? extends EntityAnimal>)entityType, level);
    }

    @Override
    @Nullable
    public EntityAgeable a(WorldServer level, EntityAgeable otherParent) {
        return EntityTypes.aV.a(level, EntitySpawnReason.e);
    }

    @Override
    public boolean i(ItemStack stack) {
        return false;
    }

    @Override
    protected void C() {
        super.C();
        this.bF.a(0, new PathfinderGoalFloat(this));
        this.bF.a(1, new c());
        this.bF.a(1, new PathfinderGoalPanic((EntityCreature)this, 2.0, mob -> mob.e_() ? DamageTypeTags.F : DamageTypeTags.G));
        this.bF.a(4, new PathfinderGoalFollowParent(this, 1.25));
        this.bF.a(5, new PathfinderGoalRandomStroll(this, 1.0));
        this.bF.a(6, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 6.0f));
        this.bF.a(7, new PathfinderGoalRandomLookaround(this));
        this.bG.a(1, new b());
        this.bG.a(2, new a());
        this.bG.a(3, new PathfinderGoalNearestAttackableTarget<EntityHuman>(this, EntityHuman.class, 10, true, false, this::a));
        this.bG.a(4, new PathfinderGoalNearestAttackableTarget<EntityFox>(this, EntityFox.class, 10, true, true, null));
        this.bG.a(5, new PathfinderGoalUniversalAngerReset<EntityPolarBear>(this, false));
    }

    public static AttributeProvider.Builder m() {
        return EntityAnimal.gz().a(GenericAttributes.s, 30.0).a(GenericAttributes.m, 20.0).a(GenericAttributes.v, 0.25).a(GenericAttributes.c, 6.0);
    }

    public static boolean c(EntityTypes<EntityPolarBear> entityType, GeneratorAccess level, EntitySpawnReason spawnReason, BlockPosition pos, RandomSource random) {
        Holder<BiomeBase> biome = level.u(pos);
        return !biome.a(BiomeTags.aq) ? EntityPolarBear.b(entityType, level, spawnReason, pos, random) : EntityPolarBear.a(level, pos) && level.a_(pos.e()).a(TagsBlock.cg);
    }

    @Override
    public void a(NBTTagCompound compound) {
        super.a(compound);
        this.a(this.dV(), compound);
    }

    @Override
    public void b(NBTTagCompound compound) {
        super.b(compound);
        this.a_(compound);
    }

    @Override
    public void c() {
        this.a(bO.a(this.ae));
    }

    @Override
    public void a(int time) {
        this.bP = time;
    }

    @Override
    public int a() {
        return this.bP;
    }

    @Override
    public void a(@Nullable UUID target) {
        this.bQ = target;
    }

    @Override
    @Nullable
    public UUID b() {
        return this.bQ;
    }

    @Override
    public SoundEffect s() {
        return this.e_() ? SoundEffects.vl : SoundEffects.vk;
    }

    @Override
    public SoundEffect e(DamageSource damageSource) {
        return SoundEffects.vn;
    }

    @Override
    public SoundEffect j_() {
        return SoundEffects.vm;
    }

    @Override
    protected void b(BlockPosition pos, IBlockData block) {
        this.a(SoundEffects.vo, 0.15f, 1.0f);
    }

    protected void p() {
        if (this.bN <= 0) {
            this.b(SoundEffects.vp);
            this.bN = 40;
        }
    }

    @Override
    protected void a(DataWatcher.a builder) {
        super.a(builder);
        builder.a(bI, false);
    }

    @Override
    public void g() {
        super.g();
        if (this.dV().C) {
            if (this.bM != this.bK) {
                this.h_();
            }
            this.bK = this.bM;
            this.bM = this.u() ? MathHelper.a(this.bM + 1.0f, 0.0f, 6.0f) : MathHelper.a(this.bM - 1.0f, 0.0f, 6.0f);
        }
        if (this.bN > 0) {
            --this.bN;
        }
        if (!this.dV().C) {
            this.a((WorldServer)this.dV(), true);
        }
    }

    @Override
    public EntitySize e(EntityPose pose) {
        if (this.bM > 0.0f) {
            float f2 = this.bM / 6.0f;
            float f1 = 1.0f + f2;
            return super.e(pose).a(1.0f, f1);
        }
        return super.e(pose);
    }

    public boolean u() {
        return this.al.a(bI);
    }

    public void w(boolean standing) {
        this.al.a(bI, standing);
    }

    public float J(float partialTick) {
        return MathHelper.h(partialTick, this.bK, this.bM) / 6.0f;
    }

    @Override
    protected float fk() {
        return 0.98f;
    }

    @Override
    public GroupDataEntity a(WorldAccess level, DifficultyDamageScaler difficulty, EntitySpawnReason spawnReason, @Nullable GroupDataEntity spawnGroupData) {
        if (spawnGroupData == null) {
            spawnGroupData = new EntityAgeable.a(1.0f);
        }
        return super.a(level, difficulty, spawnReason, spawnGroupData);
    }

    class c
    extends PathfinderGoalMeleeAttack {
        public c() {
            super(EntityPolarBear.this, 1.25, true);
        }

        @Override
        protected void a(EntityLiving target) {
            if (this.b(target)) {
                this.h();
                this.a.c(net.minecraft.world.entity.animal.EntityPolarBear$c.a(this.a), (Entity)target);
                EntityPolarBear.this.w(false);
            } else if (this.a.g((Entity)target) < (double)((target.dq() + 3.0f) * (target.dq() + 3.0f))) {
                if (this.i()) {
                    EntityPolarBear.this.w(false);
                    this.h();
                }
                if (this.k() <= 10) {
                    EntityPolarBear.this.w(true);
                    EntityPolarBear.this.p();
                }
            } else {
                this.h();
                EntityPolarBear.this.w(false);
            }
        }

        @Override
        public void e() {
            EntityPolarBear.this.w(false);
            super.e();
        }
    }

    class b
    extends PathfinderGoalHurtByTarget {
        public b() {
            super(EntityPolarBear.this, new Class[0]);
        }

        @Override
        public void d() {
            super.d();
            if (EntityPolarBear.this.e_()) {
                this.h();
                this.e();
            }
        }

        @Override
        protected void a(EntityInsentient mob, EntityLiving target) {
            if (mob instanceof EntityPolarBear && !mob.e_()) {
                super.a(mob, target);
            }
        }
    }

    class a
    extends PathfinderGoalNearestAttackableTarget<EntityHuman> {
        public a() {
            super(EntityPolarBear.this, EntityHuman.class, 20, true, true, null);
        }

        @Override
        public boolean b() {
            if (EntityPolarBear.this.e_()) {
                return false;
            }
            if (super.b()) {
                for (EntityPolarBear polarBear : EntityPolarBear.this.dV().a(EntityPolarBear.class, EntityPolarBear.this.cR().c(8.0, 4.0, 8.0))) {
                    if (!polarBear.e_()) continue;
                    return true;
                }
            }
            return false;
        }

        @Override
        protected double l() {
            return super.l() * 0.5;
        }
    }
}

