/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal;

import io.papermc.paper.event.entity.PufferFishStateChangeEvent;
import java.util.List;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.game.PacketPlayOutGameStateChange;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsEntity;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.targeting.PathfinderTargetCondition;
import net.minecraft.world.entity.animal.EntityFish;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.World;
import org.bukkit.entity.PufferFish;
import org.bukkit.event.entity.EntityPotionEffectEvent;

public class EntityPufferFish
extends EntityFish {
    private static final DataWatcherObject<Integer> e = DataWatcher.a(EntityPufferFish.class, DataWatcherRegistry.b);
    int f;
    int bI;
    private static final PathfinderTargetCondition.a bJ = (entity, level) -> {
        EntityHuman player;
        return (!(entity instanceof EntityHuman) || !(player = (EntityHuman)entity).gz()) && !entity.an().a(TagsEntity.A);
    };
    static final PathfinderTargetCondition bK = PathfinderTargetCondition.b().e().d().a(bJ);
    public static final int a = 0;
    public static final int b = 1;
    public static final int c = 2;
    private static final int bL = 0;

    public EntityPufferFish(EntityTypes<? extends EntityPufferFish> entityType, World level) {
        super((EntityTypes<? extends EntityFish>)entityType, level);
        this.h_();
    }

    @Override
    protected void a(DataWatcher.a builder) {
        super.a(builder);
        builder.a(e, 0);
    }

    public int gw() {
        return this.al.a(e);
    }

    public void b(int puffState) {
        this.al.a(e, puffState);
    }

    @Override
    public void a(DataWatcherObject<?> key) {
        if (e.equals(key)) {
            this.h_();
        }
        super.a(key);
    }

    @Override
    public void b(NBTTagCompound compound) {
        super.b(compound);
        compound.a("PuffState", this.gw());
    }

    @Override
    public void a(NBTTagCompound compound) {
        super.a(compound);
        this.b(Math.min(compound.b("PuffState", 0), 2));
    }

    @Override
    public ItemStack a() {
        return new ItemStack(Items.rv);
    }

    @Override
    protected void C() {
        super.C();
        this.bF.a(1, new a(this));
    }

    @Override
    public void g() {
        if (!this.dV().C && this.bJ() && this.dj()) {
            if (this.f > 0) {
                boolean increase = true;
                if (this.gw() == 0) {
                    if (new PufferFishStateChangeEvent((PufferFish)this.getBukkitEntity(), 1).callEvent()) {
                        this.b(SoundEffects.vF);
                        this.b(1);
                    } else {
                        increase = false;
                    }
                } else if (this.f > 40 && this.gw() == 1) {
                    if (new PufferFishStateChangeEvent((PufferFish)this.getBukkitEntity(), 2).callEvent()) {
                        this.b(SoundEffects.vF);
                        this.b(2);
                    } else {
                        increase = false;
                    }
                }
                if (increase) {
                    ++this.f;
                }
            } else if (this.gw() != 0) {
                boolean increase = true;
                if (this.bI > 60 && this.gw() == 2) {
                    if (new PufferFishStateChangeEvent((PufferFish)this.getBukkitEntity(), 1).callEvent()) {
                        this.b(SoundEffects.vE);
                        this.b(1);
                    } else {
                        increase = false;
                    }
                } else if (this.bI > 100 && this.gw() == 1) {
                    if (new PufferFishStateChangeEvent((PufferFish)this.getBukkitEntity(), 0).callEvent()) {
                        this.b(SoundEffects.vE);
                        this.b(0);
                    } else {
                        increase = false;
                    }
                }
                if (increase) {
                    ++this.bI;
                }
            }
        }
        super.g();
    }

    @Override
    public void d_() {
        super.d_();
        World world = this.dV();
        if (world instanceof WorldServer) {
            WorldServer serverLevel = (WorldServer)world;
            if (this.bJ() && this.gw() > 0) {
                for (EntityInsentient mob : this.dV().a(EntityInsentient.class, this.cR().g(0.3), (? super T mob1) -> bK.a(serverLevel, this, (EntityLiving)mob1))) {
                    if (!mob.bJ()) continue;
                    this.a(serverLevel, mob);
                }
            }
        }
    }

    private void a(WorldServer level, EntityInsentient mob) {
        int puffState = this.gw();
        if (mob.a(level, this.dW().b(this), (float)(1 + puffState))) {
            mob.addEffect(new MobEffect(MobEffects.s, 60 * puffState, 0), this, EntityPotionEffectEvent.Cause.ATTACK);
            this.a(SoundEffects.vJ, 1.0f, 1.0f);
        }
    }

    @Override
    public void a_(EntityHuman entity) {
        int puffState = this.gw();
        if (entity instanceof EntityPlayer) {
            EntityPlayer serverPlayer = (EntityPlayer)entity;
            if (puffState > 0 && entity.a(serverPlayer.x(), this.dW().b(this), (float)(1 + puffState))) {
                if (!this.ba()) {
                    serverPlayer.f.b(new PacketPlayOutGameStateChange(PacketPlayOutGameStateChange.k, 0.0f));
                }
                entity.addEffect(new MobEffect(MobEffects.s, 60 * puffState, 0), this, EntityPotionEffectEvent.Cause.ATTACK);
            }
        }
    }

    @Override
    public SoundEffect s() {
        return SoundEffects.vD;
    }

    @Override
    public SoundEffect j_() {
        return SoundEffects.vG;
    }

    @Override
    public SoundEffect e(DamageSource damageSource) {
        return SoundEffects.vI;
    }

    @Override
    protected SoundEffect gv() {
        return SoundEffects.vH;
    }

    @Override
    public EntitySize e(EntityPose pose) {
        return super.e(pose).a(EntityPufferFish.c(this.gw()));
    }

    private static float c(int puffState) {
        switch (puffState) {
            case 0: {
                return 0.5f;
            }
            case 1: {
                return 0.7f;
            }
        }
        return 1.0f;
    }

    static class a
    extends PathfinderGoal {
        private final EntityPufferFish a;

        public a(EntityPufferFish fish) {
            this.a = fish;
        }

        @Override
        public boolean b() {
            List<EntityLiving> entitiesOfClass = this.a.dV().a(EntityLiving.class, this.a.cR().g(2.0), entity -> bK.a(net.minecraft.world.entity.animal.EntityPufferFish$a.a(this.a), this.a, (EntityLiving)entity));
            return !entitiesOfClass.isEmpty();
        }

        @Override
        public void d() {
            this.a.f = 1;
            this.a.bI = 0;
        }

        @Override
        public void e() {
            this.a.f = 0;
        }
    }
}

