/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal;

import com.mojang.serialization.Codec;
import io.netty.buffer.ByteBuf;
import java.util.function.IntFunction;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.INamable;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.control.ControllerJump;
import net.minecraft.world.entity.ai.control.ControllerMove;
import net.minecraft.world.entity.ai.goal.ClimbOnTopOfPowderSnowGoal;
import net.minecraft.world.entity.ai.goal.PathfinderGoalAvoidTarget;
import net.minecraft.world.entity.ai.goal.PathfinderGoalBreed;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalGotoTarget;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalMeleeAttack;
import net.minecraft.world.entity.ai.goal.PathfinderGoalPanic;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStrollLand;
import net.minecraft.world.entity.ai.goal.PathfinderGoalTempt;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalHurtByTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.animal.wolf.EntityWolf;
import net.minecraft.world.entity.monster.EntityMonster;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockCarrots;
import net.minecraft.world.level.block.BlockCrops;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.PathEntity;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_21_R4.event.CraftEventFactory;

public class EntityRabbit
extends EntityAnimal {
    public static final double bI = 0.6;
    public static final double bJ = 0.8;
    public static final double bK = 1.0;
    public static final double bM = 2.2;
    public static final double bN = 1.4;
    private static final DataWatcherObject<Integer> bO = DataWatcher.a(EntityRabbit.class, DataWatcherRegistry.b);
    private static final int bP = 0;
    private static final MinecraftKey bQ = MinecraftKey.b("killer_bunny");
    private static final int bR = 3;
    private static final int bS = 5;
    private static final MinecraftKey bT = MinecraftKey.b("evil");
    private static final int bU = 8;
    private static final int bV = 40;
    private int bW;
    private int bX;
    private boolean bY;
    private int bZ;
    public int ca = 0;

    public EntityRabbit(EntityTypes<? extends EntityRabbit> entityType, World level) {
        super((EntityTypes<? extends EntityAnimal>)entityType, level);
        this.bD = new ControllerJumpRabbit(this);
        this.bC = new ControllerMoveRabbit(this);
    }

    @Override
    public void C() {
        this.bF.a(1, new PathfinderGoalFloat(this));
        this.bF.a(1, new ClimbOnTopOfPowderSnowGoal(this, this.dV()));
        this.bF.a(1, new PathfinderGoalRabbitPanic(this, 2.2));
        this.bF.a(2, new PathfinderGoalBreed(this, 0.8));
        this.bF.a(3, new PathfinderGoalTempt(this, 1.0, stack -> stack.a(TagsItem.ay), false));
        this.bF.a(4, new PathfinderGoalRabbitAvoidTarget<EntityHuman>(this, EntityHuman.class, 8.0f, 2.2, 2.2));
        this.bF.a(4, new PathfinderGoalRabbitAvoidTarget<EntityWolf>(this, EntityWolf.class, 10.0f, 2.2, 2.2));
        this.bF.a(4, new PathfinderGoalRabbitAvoidTarget<EntityMonster>(this, EntityMonster.class, 4.0f, 2.2, 2.2));
        this.bF.a(5, new PathfinderGoalEatCarrots(this));
        this.bF.a(6, new PathfinderGoalRandomStrollLand(this, 0.6));
        this.bF.a(11, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 10.0f));
    }

    @Override
    protected float fh() {
        PathEntity path;
        float f2 = 0.3f;
        if (this.bC.c() <= 0.6) {
            f2 = 0.2f;
        }
        if ((path = this.bE.i()) != null && !path.c()) {
            Vec3D nextEntityPos = path.a(this);
            if (nextEntityPos.e > this.dC() + 0.5) {
                f2 = 0.5f;
            }
        }
        if (this.P || this.bf && this.bC.e() > this.dC() + 0.5) {
            f2 = 0.5f;
        }
        return super.z(f2 / 0.42f);
    }

    @Override
    public void r() {
        double d2;
        super.r();
        double speedModifier = this.bC.c();
        if (speedModifier > 0.0 && (d2 = this.dy().j()) < 0.01) {
            this.a(0.1f, new Vec3D(0.0, 0.0, 1.0));
        }
        if (!this.dV().C) {
            this.dV().a((Entity)this, (byte)1);
        }
    }

    public float J(float partialTick) {
        return this.bX == 0 ? 0.0f : ((float)this.bW + partialTick) / (float)this.bX;
    }

    public void i(double speedModifier) {
        this.N().a(speedModifier);
        this.bC.a(this.bC.d(), this.bC.e(), this.bC.f(), speedModifier);
    }

    @Override
    public void s(boolean jumping) {
        super.s(jumping);
        if (jumping) {
            this.a(this.u(), this.fe(), ((this.ae.i() - this.ae.i()) * 0.2f + 1.0f) * 0.8f);
        }
    }

    public void m() {
        this.s(true);
        this.bX = 10;
        this.bW = 0;
    }

    @Override
    protected void a(DataWatcher.a builder) {
        super.a(builder);
        builder.a(bO, Variant.h.m);
    }

    @Override
    public void a(WorldServer level) {
        if (this.bZ > 0) {
            --this.bZ;
        }
        if (this.ca > 0) {
            this.ca -= this.ae.a(3);
            if (this.ca < 0) {
                this.ca = 0;
            }
        }
        if (this.aH()) {
            ControllerJumpRabbit rabbitJumpControl;
            EntityLiving target;
            if (!this.bY) {
                this.s(false);
                this.gy();
            }
            if (this.gu() == Variant.g && this.bZ == 0 && (target = this.e()) != null && this.g((Entity)target) < 16.0) {
                this.c(target.dA(), target.dG());
                this.bC.a(target.dA(), target.dC(), target.dG(), this.bC.c());
                this.m();
                this.bY = true;
            }
            if (!(rabbitJumpControl = (ControllerJumpRabbit)this.bD).c()) {
                if (this.bC.b() && this.bZ == 0) {
                    PathEntity path = this.bE.i();
                    Vec3D vec3 = new Vec3D(this.bC.d(), this.bC.e(), this.bC.f());
                    if (path != null && !path.c()) {
                        vec3 = path.a(this);
                    }
                    this.c(vec3.d, vec3.f);
                    this.m();
                }
            } else if (!rabbitJumpControl.d()) {
                this.gv();
            }
        }
        this.bY = this.aH();
    }

    @Override
    public boolean bt() {
        return false;
    }

    private void c(double x2, double z2) {
        this.w((float)(MathHelper.d(z2 - this.dG(), x2 - this.dA()) * 180.0 / 3.1415927410125732) - 90.0f);
    }

    private void gv() {
        ((ControllerJumpRabbit)this.bD).a(true);
    }

    private void gw() {
        ((ControllerJumpRabbit)this.bD).a(false);
    }

    private void gx() {
        this.bZ = this.bC.c() < 2.2 ? 10 : 1;
    }

    private void gy() {
        this.gx();
        this.gw();
    }

    @Override
    public void d_() {
        super.d_();
        if (this.bW != this.bX) {
            ++this.bW;
        } else if (this.bX != 0) {
            this.bW = 0;
            this.bX = 0;
            this.s(false);
        }
    }

    public static AttributeProvider.Builder p() {
        return EntityAnimal.gz().a(GenericAttributes.s, 3.0).a(GenericAttributes.v, 0.3f).a(GenericAttributes.c, 3.0);
    }

    @Override
    public void b(NBTTagCompound compound) {
        super.b(compound);
        compound.a("RabbitType", Variant.j, this.gu());
        compound.a("MoreCarrotTicks", this.ca);
    }

    @Override
    public void a(NBTTagCompound compound) {
        super.a(compound);
        this.a(compound.a("RabbitType", Variant.j).orElse(Variant.h));
        this.ca = compound.b("MoreCarrotTicks", 0);
    }

    protected SoundEffect u() {
        return SoundEffects.vP;
    }

    @Override
    public SoundEffect s() {
        return SoundEffects.vL;
    }

    @Override
    public SoundEffect e(DamageSource damageSource) {
        return SoundEffects.vO;
    }

    @Override
    public SoundEffect j_() {
        return SoundEffects.vN;
    }

    @Override
    public void gn() {
        if (this.gu() == Variant.g) {
            this.a(SoundEffects.vM, 1.0f, (this.ae.i() - this.ae.i()) * 0.2f + 1.0f);
        }
    }

    @Override
    public SoundCategory dm() {
        return this.gu() == Variant.g ? SoundCategory.f : SoundCategory.g;
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public EntityRabbit b(WorldServer level, EntityAgeable otherParent) {
        block2: {
            block3: {
                rabbit = EntityTypes.aZ.a(level, EntitySpawnReason.e);
                if (rabbit == null) break block2;
                randomRabbitVariant = EntityRabbit.a((GeneratorAccess)level, this.dv());
                if (this.ae.a(20) == 0) break block3;
                if (!(otherParent instanceof EntityRabbit)) ** GOTO lbl-1000
                rabbit1 = (EntityRabbit)otherParent;
                if (this.ae.h()) {
                    randomRabbitVariant = rabbit1.gu();
                } else lbl-1000:
                // 2 sources

                {
                    randomRabbitVariant = this.gu();
                }
            }
            rabbit.a(randomRabbitVariant);
        }
        return rabbit;
    }

    @Override
    public boolean i(ItemStack stack) {
        return stack.a(TagsItem.ay);
    }

    public Variant gu() {
        return Variant.a(this.al.a(bO));
    }

    public void a(Variant variant) {
        if (variant == Variant.g) {
            this.g(GenericAttributes.a).a(8.0);
            this.bF.a(4, new PathfinderGoalMeleeAttack(this, 1.4, true));
            this.bG.a(1, new PathfinderGoalHurtByTarget(this, new Class[0]).a(new Class[0]));
            this.bG.a(2, new PathfinderGoalNearestAttackableTarget<EntityHuman>((EntityInsentient)this, EntityHuman.class, true));
            this.bG.a(2, new PathfinderGoalNearestAttackableTarget<EntityWolf>((EntityInsentient)this, EntityWolf.class, true));
            this.g(GenericAttributes.c).a(new AttributeModifier(bT, 5.0, AttributeModifier.Operation.a));
            if (!this.g_()) {
                this.b(IChatBaseComponent.c(SystemUtils.a("entity", bQ)));
            }
        } else {
            this.g(GenericAttributes.c).c(bT);
        }
        this.al.a(bO, variant.m);
    }

    @Override
    @Nullable
    public <T> T a(DataComponentType<? extends T> component) {
        return component == DataComponents.aG ? EntityRabbit.c(component, this.gu()) : super.a(component);
    }

    @Override
    protected void a(DataComponentGetter componentGetter) {
        this.a(componentGetter, DataComponents.aG);
        super.a(componentGetter);
    }

    @Override
    protected <T> boolean b(DataComponentType<T> component, T value) {
        if (component == DataComponents.aG) {
            this.a(EntityRabbit.c(DataComponents.aG, value));
            return true;
        }
        return super.b(component, value);
    }

    @Override
    @Nullable
    public GroupDataEntity a(WorldAccess level, DifficultyDamageScaler difficulty, EntitySpawnReason spawnReason, @Nullable GroupDataEntity spawnGroupData) {
        Variant randomRabbitVariant = EntityRabbit.a(level, this.dv());
        if (spawnGroupData instanceof GroupDataRabbit) {
            randomRabbitVariant = ((GroupDataRabbit)spawnGroupData).a;
        } else {
            spawnGroupData = new GroupDataRabbit(randomRabbitVariant);
        }
        this.a(randomRabbitVariant);
        return super.a(level, difficulty, spawnReason, spawnGroupData);
    }

    private static Variant a(GeneratorAccess level, BlockPosition pos) {
        Holder<BiomeBase> biome = level.u(pos);
        int randomInt = level.G_().a(100);
        if (biome.a(BiomeTags.an)) {
            return randomInt < 80 ? Variant.b : Variant.d;
        }
        if (biome.a(BiomeTags.am)) {
            return Variant.e;
        }
        return randomInt < 50 ? Variant.a : (randomInt < 90 ? Variant.f : Variant.c);
    }

    public static boolean c(EntityTypes<EntityRabbit> entityType, GeneratorAccess level, EntitySpawnReason spawnReason, BlockPosition pos, RandomSource random) {
        return level.a_(pos.e()).a(TagsBlock.ch) && EntityRabbit.a(level, pos);
    }

    boolean gG() {
        return this.ca <= 0;
    }

    @Override
    public void b(byte id) {
        if (id == 1) {
            this.bu();
            this.bX = 10;
            this.bW = 0;
        } else {
            super.b(id);
        }
    }

    @Override
    public Vec3D cT() {
        return new Vec3D(0.0, 0.6f * this.cS(), this.dq() * 0.4f);
    }

    public static class ControllerJumpRabbit
    extends ControllerJump {
        private final EntityRabbit b;
        private boolean c;

        public ControllerJumpRabbit(EntityRabbit mob) {
            super(mob);
            this.b = mob;
        }

        public boolean c() {
            return this.a;
        }

        public boolean d() {
            return this.c;
        }

        public void a(boolean canJump) {
            this.c = canJump;
        }

        @Override
        public void b() {
            if (this.a) {
                this.b.m();
                this.a = false;
            }
        }
    }

    static class ControllerMoveRabbit
    extends ControllerMove {
        private final EntityRabbit l;
        private double m;

        public ControllerMoveRabbit(EntityRabbit mob) {
            super(mob);
            this.l = mob;
        }

        @Override
        public void a() {
            if (this.l.aH() && !this.l.bf && !((ControllerJumpRabbit)this.l.bD).c()) {
                this.l.i(0.0);
            } else if (this.b() || this.k == ControllerMove.Operation.d) {
                this.l.i(this.m);
            }
            super.a();
        }

        @Override
        public void a(double x2, double y2, double z2, double speed) {
            if (this.l.bi()) {
                speed = 1.5;
            }
            super.a(x2, y2, z2, speed);
            if (speed > 0.0) {
                this.m = speed;
            }
        }
    }

    static class PathfinderGoalRabbitPanic
    extends PathfinderGoalPanic {
        private final EntityRabbit a;

        public PathfinderGoalRabbitPanic(EntityRabbit rabbit, double speedModifier) {
            super(rabbit, speedModifier);
            this.a = rabbit;
        }

        @Override
        public void a() {
            super.a();
            this.a.i(this.d);
        }
    }

    static class PathfinderGoalRabbitAvoidTarget<T extends EntityLiving>
    extends PathfinderGoalAvoidTarget<T> {
        private final EntityRabbit i;

        public PathfinderGoalRabbitAvoidTarget(EntityRabbit rabbit, Class<T> entityClassToAvoid, float maxDist, double walkSpeedModifier, double sprintSpeedModifier) {
            super(rabbit, entityClassToAvoid, maxDist, walkSpeedModifier, sprintSpeedModifier);
            this.i = rabbit;
        }

        @Override
        public boolean b() {
            return this.i.gu() != Variant.g && super.b();
        }
    }

    static class PathfinderGoalEatCarrots
    extends PathfinderGoalGotoTarget {
        private final EntityRabbit g;
        private boolean h;
        private boolean i;

        public PathfinderGoalEatCarrots(EntityRabbit rabbit) {
            super(rabbit, 0.7f, 16);
            this.g = rabbit;
        }

        @Override
        public boolean b() {
            if (this.c <= 0) {
                if (!PathfinderGoalEatCarrots.a(this.g).O().c(GameRules.d)) {
                    return false;
                }
                this.i = false;
                this.h = this.g.gG();
            }
            return super.b();
        }

        @Override
        public boolean c() {
            return this.i && super.c();
        }

        @Override
        public void a() {
            super.a();
            this.g.I().a((double)this.e.u() + 0.5, this.e.v() + 1, (double)this.e.w() + 0.5, 10.0f, this.g.ac());
            if (this.m()) {
                World level = this.g.dV();
                BlockPosition blockPos = this.e.d();
                IBlockData blockState = level.a_(blockPos);
                Block block = blockState.b();
                if (this.i && block instanceof BlockCarrots) {
                    int ageValue = blockState.c(BlockCrops.f);
                    if (ageValue == 0) {
                        if (!CraftEventFactory.callEntityChangeBlockEvent(this.g, blockPos, blockState.y().g())) {
                            return;
                        }
                        level.a(blockPos, Blocks.a.m(), 2);
                        level.a(blockPos, true, this.g);
                    } else {
                        if (!CraftEventFactory.callEntityChangeBlockEvent(this.g, blockPos, (IBlockData)blockState.b(BlockCrops.f, ageValue - 1))) {
                            return;
                        }
                        level.a(blockPos, (IBlockData)blockState.b(BlockCrops.f, ageValue - 1), 2);
                        level.a(GameEvent.c, blockPos, GameEvent.a.a(this.g));
                        level.c(2001, blockPos, Block.j(blockState));
                    }
                    this.g.ca = 40;
                }
                this.i = false;
                this.c = 10;
            }
        }

        @Override
        protected boolean a(IWorldReader level, BlockPosition pos) {
            IBlockData blockState = level.a_(pos);
            if (blockState.a(Blocks.cN) && this.h && !this.i && (blockState = level.a_(pos.d())).b() instanceof BlockCarrots && ((BlockCarrots)blockState.b()).i(blockState)) {
                this.i = true;
                return true;
            }
            return false;
        }
    }

    public static final class Variant
    extends Enum<Variant>
    implements INamable {
        public static final /* enum */ Variant a = new Variant(0, "brown");
        public static final /* enum */ Variant b = new Variant(1, "white");
        public static final /* enum */ Variant c = new Variant(2, "black");
        public static final /* enum */ Variant d = new Variant(3, "white_splotched");
        public static final /* enum */ Variant e = new Variant(4, "gold");
        public static final /* enum */ Variant f = new Variant(5, "salt");
        public static final /* enum */ Variant g = new Variant(99, "evil");
        public static final Variant h;
        private static final IntFunction<Variant> l;
        public static final Codec<Variant> i;
        @Deprecated
        public static final Codec<Variant> j;
        public static final StreamCodec<ByteBuf, Variant> k;
        final int m;
        private final String n;
        private static final /* synthetic */ Variant[] o;

        public static Variant[] values() {
            return (Variant[])o.clone();
        }

        public static Variant valueOf(String name) {
            return Enum.valueOf(Variant.class, name);
        }

        private Variant(int id, String name) {
            this.m = id;
            this.n = name;
        }

        @Override
        public String c() {
            return this.n;
        }

        public int a() {
            return this.m;
        }

        public static Variant a(int id) {
            return l.apply(id);
        }

        private static /* synthetic */ Variant[] b() {
            return new Variant[]{a, b, c, d, e, f, g};
        }

        static {
            o = Variant.b();
            h = a;
            l = ByIdMap.a(Variant::a, Variant.values(), h);
            i = INamable.a(Variant::values);
            j = Codec.INT.xmap(l::apply, Variant::a);
            k = ByteBufCodecs.a(l, Variant::a);
        }
    }

    public static class GroupDataRabbit
    extends EntityAgeable.a {
        public final Variant a;

        public GroupDataRabbit(Variant variant) {
            super(1.0f);
            this.a = variant;
        }
    }
}

