/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.BiomeTags;
import net.minecraft.util.MathHelper;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.IShearable;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.PathfinderGoalArrowAttack;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomLookaround;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStrollLand;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.animal.EntityGolem;
import net.minecraft.world.entity.monster.IMonster;
import net.minecraft.world.entity.monster.IRangedEntity;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.EntitySnowball;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.loot.LootTables;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_21_R4.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_21_R4.inventory.CraftItemStack;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.player.PlayerShearEntityEvent;

public class EntitySnowman
extends EntityGolem
implements IShearable,
IRangedEntity {
    private static final DataWatcherObject<Byte> a = DataWatcher.a(EntitySnowman.class, DataWatcherRegistry.a);
    private static final byte b = 16;
    private static final boolean c = true;

    public EntitySnowman(EntityTypes<? extends EntitySnowman> entityType, World level) {
        super((EntityTypes<? extends EntityGolem>)entityType, level);
    }

    @Override
    protected void C() {
        this.bF.a(1, new PathfinderGoalArrowAttack(this, 1.25, 20, 10.0f));
        this.bF.a(2, new PathfinderGoalRandomStrollLand((EntityCreature)this, 1.0, 1.0000001E-5f));
        this.bF.a(3, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 6.0f));
        this.bF.a(4, new PathfinderGoalRandomLookaround(this));
        this.bG.a(1, new PathfinderGoalNearestAttackableTarget<EntityInsentient>(this, EntityInsentient.class, 10, true, false, (entity, level) -> entity instanceof IMonster));
    }

    public static AttributeProvider.Builder m() {
        return EntityInsentient.D().a(GenericAttributes.s, 4.0).a(GenericAttributes.v, 0.2f);
    }

    @Override
    protected void a(DataWatcher.a builder) {
        super.a(builder);
        builder.a(a, (byte)16);
    }

    @Override
    public void b(NBTTagCompound compound) {
        super.b(compound);
        compound.a("Pumpkin", this.p());
    }

    @Override
    public void a(NBTTagCompound compound) {
        super.a(compound);
        this.w(compound.b("Pumpkin", true));
    }

    @Override
    public boolean fr() {
        return true;
    }

    @Override
    public void d_() {
        super.d_();
        World world = this.dV();
        if (world instanceof WorldServer) {
            WorldServer serverLevel = (WorldServer)world;
            if (this.dV().u(this.dv()).a(BiomeTags.ae)) {
                this.a(serverLevel, this.dW().d().knownCause(EntityDamageEvent.DamageCause.MELTING), 1.0f);
            }
            if (!serverLevel.O().c(GameRules.d)) {
                return;
            }
            IBlockData blockState = Blocks.ed.m();
            for (int i2 = 0; i2 < 4; ++i2) {
                int floor = MathHelper.a(this.dA() + (double)((float)(i2 % 2 * 2 - 1) * 0.25f));
                int floor1 = MathHelper.a(this.dC());
                int floor2 = MathHelper.a(this.dG() + (double)((float)(i2 / 2 % 2 * 2 - 1) * 0.25f));
                BlockPosition blockPos = new BlockPosition(floor, floor1, floor2);
                if (!this.dV().a_(blockPos).l() || !blockState.a((IWorldReader)this.dV(), blockPos) || !CraftEventFactory.handleBlockFormEvent(this.dV(), blockPos, blockState, 3, this)) continue;
                this.dV().a(GameEvent.i, blockPos, GameEvent.a.a(this, blockState));
            }
        }
    }

    @Override
    public void a(EntityLiving target, float distanceFactor) {
        double d2 = target.dA() - this.dA();
        double d1 = target.dE() - (double)1.1f;
        double d22 = target.dG() - this.dG();
        double d3 = Math.sqrt(d2 * d2 + d22 * d22) * (double)0.2f;
        World world = this.dV();
        if (world instanceof WorldServer) {
            WorldServer serverLevel = (WorldServer)world;
            ItemStack itemStack = new ItemStack(Items.rs);
            IProjectile.a(new EntitySnowball(serverLevel, this, itemStack), serverLevel, itemStack, snowball -> snowball.c(d2, d1 + d3 - snowball.dC(), d22, 1.6f, 12.0f));
        }
        this.a(SoundEffects.zK, 1.0f, 0.4f / (this.dY().i() * 0.4f + 0.8f));
    }

    @Override
    protected EnumInteractionResult b(EntityHuman player, EnumHand hand) {
        ItemStack itemInHand = player.b(hand);
        if (itemInHand.a(Items.td) && this.a()) {
            World world = this.dV();
            if (world instanceof WorldServer) {
                WorldServer serverLevel = (WorldServer)world;
                List<ItemStack> drops = this.generateDefaultDrops(serverLevel, itemInHand);
                PlayerShearEntityEvent event = CraftEventFactory.handlePlayerShearEntityEvent(player, this, itemInHand, hand, drops);
                if (event != null) {
                    if (event.isCancelled()) {
                        return EnumInteractionResult.e;
                    }
                    drops = CraftItemStack.asNMSCopy(event.getDrops());
                }
                this.shear(serverLevel, SoundCategory.h, itemInHand, drops);
                this.a(GameEvent.M, (Entity)player);
                itemInHand.a(1, (EntityLiving)player, EntitySnowman.d(hand));
            }
            return EnumInteractionResult.a;
        }
        return EnumInteractionResult.e;
    }

    @Override
    public void a(WorldServer level, SoundCategory soundSource, ItemStack shears) {
        this.shear(level, soundSource, shears, this.generateDefaultDrops(level, shears));
    }

    @Override
    public List<ItemStack> generateDefaultDrops(WorldServer serverLevel, ItemStack shears) {
        ObjectArrayList drops = new ObjectArrayList();
        this.a(serverLevel, LootTables.aU, shears, (arg_0, arg_1) -> EntitySnowman.lambda$generateDefaultDrops$2((List)drops, arg_0, arg_1));
        return drops;
    }

    @Override
    public void shear(WorldServer level, SoundCategory soundSource, ItemStack shears, List<ItemStack> drops) {
        level.a(null, this, SoundEffects.zL, soundSource, 1.0f, 1.0f);
        this.w(false);
        drops.forEach(itemStack -> {
            this.forceDrops = true;
            this.a(level, (ItemStack)itemStack, this.cS());
            this.forceDrops = false;
        });
    }

    @Override
    public boolean a() {
        return this.bJ() && this.p();
    }

    public boolean p() {
        return (this.al.a(a) & 0x10) != 0;
    }

    public void w(boolean pumpkinEquipped) {
        byte b2 = this.al.a(a);
        if (pumpkinEquipped) {
            this.al.a(a, (byte)(b2 | 0x10));
        } else {
            this.al.a(a, (byte)(b2 & 0xFFFFFFEF));
        }
    }

    @Override
    @Nullable
    public SoundEffect s() {
        return SoundEffects.zH;
    }

    @Override
    @Nullable
    public SoundEffect e(DamageSource damageSource) {
        return SoundEffects.zJ;
    }

    @Override
    @Nullable
    public SoundEffect j_() {
        return SoundEffects.zI;
    }

    @Override
    public Vec3D cT() {
        return new Vec3D(0.0, 0.75f * this.cS(), this.dq() * 0.4f);
    }

    private static /* synthetic */ void lambda$generateDefaultDrops$2(List drops, WorldServer ignored, ItemStack stack) {
        drops.add(stack);
    }
}

