/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal;

import com.destroystokyo.paper.event.entity.TurtleGoHomeEvent;
import com.destroystokyo.paper.event.entity.TurtleLayEggEvent;
import com.destroystokyo.paper.event.entity.TurtleStartDiggingEvent;
import io.papermc.paper.event.entity.EntityFertilizeEggEvent;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.stats.StatisticList;
import net.minecraft.tags.TagsFluid;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityAttachment;
import net.minecraft.world.entity.EntityAttachments;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.EntityExperienceOrb;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLightning;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.control.ControllerMove;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.goal.PathfinderGoalBreed;
import net.minecraft.world.entity.ai.goal.PathfinderGoalGotoTarget;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalPanic;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStroll;
import net.minecraft.world.entity.ai.goal.PathfinderGoalTempt;
import net.minecraft.world.entity.ai.navigation.AmphibiousPathNavigation;
import net.minecraft.world.entity.ai.navigation.NavigationAbstract;
import net.minecraft.world.entity.ai.targeting.PathfinderTargetCondition;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockTurtleEgg;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_21_R4.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_21_R4.util.CraftLocation;
import org.bukkit.entity.ExperienceOrb;
import org.bukkit.entity.Turtle;

public class EntityTurtle
extends EntityAnimal {
    private static final DataWatcherObject<Boolean> bJ = DataWatcher.a(EntityTurtle.class, DataWatcherRegistry.k);
    private static final DataWatcherObject<Boolean> bK = DataWatcher.a(EntityTurtle.class, DataWatcherRegistry.k);
    private static final float bM = 0.3f;
    private static final EntitySize bN = EntityTypes.bC.n().a(EntityAttachments.a().a(EntityAttachment.a, 0.0f, EntityTypes.bC.m(), -0.25f)).a(0.3f);
    private static final boolean bO = false;
    int bP;
    public static final PathfinderTargetCondition.a bI = (entity, level) -> entity.e_() && !entity.bi();
    public BlockPosition bQ = BlockPosition.c;
    @Nullable
    BlockPosition bR;
    public boolean bS;

    public EntityTurtle(EntityTypes<? extends EntityTurtle> entityType, World level) {
        super((EntityTypes<? extends EntityAnimal>)entityType, level);
        this.a(PathType.j, 0.0f);
        this.a(PathType.t, -1.0f);
        this.a(PathType.s, -1.0f);
        this.a(PathType.r, -1.0f);
        this.bC = new e(this);
    }

    public void h(BlockPosition homePos) {
        this.bQ = homePos;
    }

    public boolean m() {
        return this.al.a(bJ);
    }

    public void w(boolean hasEgg) {
        this.al.a(bJ, hasEgg);
    }

    public boolean p() {
        return this.al.a(bK);
    }

    void x(boolean isLayingEgg) {
        this.bP = isLayingEgg ? 1 : 0;
        this.al.a(bK, isLayingEgg);
    }

    @Override
    protected void a(DataWatcher.a builder) {
        super.a(builder);
        builder.a(bJ, false);
        builder.a(bK, false);
    }

    @Override
    public void b(NBTTagCompound compound) {
        super.b(compound);
        compound.a("home_pos", BlockPosition.a, this.bQ);
        compound.a("has_egg", this.m());
    }

    @Override
    public void a(NBTTagCompound compound) {
        this.h(compound.a("home_pos", BlockPosition.a).orElse(this.dv()));
        super.a(compound);
        this.w(compound.b("has_egg", false));
    }

    @Override
    @Nullable
    public GroupDataEntity a(WorldAccess level, DifficultyDamageScaler difficulty, EntitySpawnReason spawnReason, @Nullable GroupDataEntity spawnGroupData) {
        this.h(this.dv());
        return super.a(level, difficulty, spawnReason, spawnGroupData);
    }

    public static boolean c(EntityTypes<EntityTurtle> entityType, GeneratorAccess level, EntitySpawnReason spawnReason, BlockPosition pos, RandomSource random) {
        return pos.v() < level.P() + 4 && BlockTurtleEgg.a(level, pos) && EntityTurtle.a(level, pos);
    }

    @Override
    protected void C() {
        this.bF.a(0, new f(this, 1.2));
        this.bF.a(1, new a(this, 1.0));
        this.bF.a(1, new d(this, 1.0));
        this.bF.a(2, new PathfinderGoalTempt(this, 1.1, itemStack -> itemStack.a(TagsItem.aB), false));
        this.bF.a(3, new c(this, 1.0));
        this.bF.a(4, new b(this, 1.0));
        this.bF.a(7, new i(this, 1.0));
        this.bF.a(8, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 8.0f));
        this.bF.a(9, new h(this, 1.0, 100));
    }

    public static AttributeProvider.Builder u() {
        return EntityAnimal.gz().a(GenericAttributes.s, 30.0).a(GenericAttributes.v, 0.25).a(GenericAttributes.B, 1.0);
    }

    @Override
    public boolean cJ() {
        return false;
    }

    @Override
    public int R() {
        return 200;
    }

    @Override
    @Nullable
    public SoundEffect s() {
        return !this.bi() && this.aH() && !this.e_() ? SoundEffects.Bj : super.s();
    }

    @Override
    protected void g(float volume) {
        super.g(volume * 1.5f);
    }

    @Override
    public SoundEffect aU() {
        return SoundEffects.Bu;
    }

    @Override
    @Nullable
    public SoundEffect e(DamageSource damageSource) {
        return this.e_() ? SoundEffects.Bq : SoundEffects.Bp;
    }

    @Override
    @Nullable
    public SoundEffect j_() {
        return this.e_() ? SoundEffects.Bl : SoundEffects.Bk;
    }

    @Override
    protected void b(BlockPosition pos, IBlockData block) {
        SoundEffect soundEvent = this.e_() ? SoundEffects.Bt : SoundEffects.Bs;
        this.a(soundEvent, 0.15f, 1.0f);
    }

    @Override
    public boolean gB() {
        return super.gB() && !this.m();
    }

    @Override
    protected float aT() {
        return this.X + 0.15f;
    }

    @Override
    public float ek() {
        return this.e_() ? 0.3f : 1.0f;
    }

    @Override
    protected NavigationAbstract b(World level) {
        return new g(this, level);
    }

    @Override
    @Nullable
    public EntityAgeable a(WorldServer level, EntityAgeable otherParent) {
        return EntityTypes.bC.a(level, EntitySpawnReason.e);
    }

    @Override
    public boolean i(ItemStack stack) {
        return stack.a(TagsItem.aB);
    }

    @Override
    public float a(BlockPosition pos, IWorldReader level) {
        if (!this.bS && level.b_(pos).a(TagsFluid.a)) {
            return 10.0f;
        }
        return BlockTurtleEgg.a(level, pos) ? 10.0f : level.x(pos);
    }

    @Override
    public void d_() {
        super.d_();
        if (this.bJ() && this.p() && this.bP >= 1 && this.bP % 5 == 0) {
            BlockPosition blockPos = this.dv();
            if (BlockTurtleEgg.a(this.dV(), blockPos)) {
                this.dV().c(2001, blockPos, Block.j(this.dV().a_(blockPos.e())));
                ((Entity)this).a(GameEvent.u);
            }
        }
    }

    @Override
    protected void h() {
        WorldServer serverLevel;
        World world;
        super.h();
        if (!this.e_() && (world = this.dV()) instanceof WorldServer && (serverLevel = (WorldServer)world).O().c(GameRules.g)) {
            this.forceDrops = true;
            this.a(serverLevel, Items.pd, 1);
            this.forceDrops = false;
        }
    }

    @Override
    public void a_(Vec3D travelVector) {
        if (this.bi()) {
            this.a(0.1f, travelVector);
            this.a(EnumMoveType.a, this.dy());
            this.i(this.dy().c(0.9));
            if (!(this.e() != null || this.bS && this.bQ.a(this.dt(), 20.0))) {
                this.i(this.dy().b(0.0, -0.005, 0.0));
            }
        } else {
            super.a_(travelVector);
        }
    }

    @Override
    public boolean w() {
        return false;
    }

    @Override
    public void a(WorldServer level, EntityLightning lightning) {
        this.a(level, this.dW().c().eventEntityDamager(lightning), Float.MAX_VALUE);
    }

    @Override
    public EntitySize e(EntityPose pose) {
        return this.e_() ? bN : super.e(pose);
    }

    static class e
    extends ControllerMove {
        private final EntityTurtle l;

        e(EntityTurtle mob) {
            super(mob);
            this.l = mob;
        }

        private void g() {
            if (this.l.bi()) {
                this.l.i(this.l.dy().b(0.0, 0.005, 0.0));
                if (!this.l.bQ.a(this.l.dt(), 16.0)) {
                    this.l.B(Math.max(this.l.fo() / 2.0f, 0.08f));
                }
                if (this.l.e_()) {
                    this.l.B(Math.max(this.l.fo() / 3.0f, 0.06f));
                }
            } else if (this.l.aH()) {
                this.l.B(Math.max(this.l.fo() / 2.0f, 0.06f));
            }
        }

        @Override
        public void a() {
            this.g();
            if (this.k == ControllerMove.Operation.b && !this.l.N().k()) {
                double d2;
                double d1;
                double d3 = this.e - this.l.dA();
                double squareRoot = Math.sqrt(d3 * d3 + (d1 = this.f - this.l.dC()) * d1 + (d2 = this.g - this.l.dG()) * d2);
                if (squareRoot < (double)1.0E-5f) {
                    this.d.B(0.0f);
                } else {
                    d1 /= squareRoot;
                    float f2 = (float)(MathHelper.d(d2, d3) * 180.0 / 3.1415927410125732) - 90.0f;
                    this.l.w(this.b(this.l.dL(), f2, 90.0f));
                    this.l.aV = this.l.dL();
                    float f1 = (float)(this.h * this.l.h(GenericAttributes.v));
                    this.l.B(MathHelper.h(0.125f, this.l.fo(), f1));
                    this.l.i(this.l.dy().b(0.0, (double)this.l.fo() * d1 * 0.1, 0.0));
                }
            } else {
                this.l.B(0.0f);
            }
        }
    }

    static class f
    extends PathfinderGoalPanic {
        f(EntityTurtle turtle, double speedModifier) {
            super(turtle, speedModifier);
        }

        @Override
        public boolean b() {
            if (!this.h()) {
                return false;
            }
            BlockPosition blockPos = this.a(this.c.dV(), this.c, 7);
            if (blockPos != null) {
                this.e = blockPos.u();
                this.f = blockPos.v();
                this.g = blockPos.w();
                return true;
            }
            return this.i();
        }
    }

    static class a
    extends PathfinderGoalBreed {
        private final EntityTurtle d;

        a(EntityTurtle turtle, double speedModifier) {
            super(turtle, speedModifier);
            this.d = turtle;
        }

        @Override
        public boolean b() {
            return super.b() && !this.d.m();
        }

        @Override
        protected void g() {
            EntityFertilizeEggEvent event;
            EntityPlayer loveCause = this.a.gD();
            if (loveCause == null && this.c.gD() != null) {
                loveCause = this.c.gD();
            }
            if ((event = CraftEventFactory.callEntityFertilizeEggEvent(this.a, this.c)).isCancelled()) {
                return;
            }
            if (loveCause != null) {
                loveCause.a(StatisticList.P);
                CriterionTriggers.p.a(loveCause, this.a, this.c, null);
            }
            this.d.w(true);
            this.a.c_(6000);
            this.c.c_(6000);
            this.a.gF();
            this.c.gF();
            RandomSource random = this.a.dY();
            if (net.minecraft.world.entity.animal.EntityTurtle$a.a(this.b).O().c(GameRules.g) && event.getExperience() > 0) {
                this.b.b(new EntityExperienceOrb(this.b, this.a.dA(), this.a.dC(), this.a.dG(), event.getExperience(), ExperienceOrb.SpawnReason.BREED, loveCause));
            }
        }
    }

    static class d
    extends PathfinderGoalGotoTarget {
        private final EntityTurtle g;

        d(EntityTurtle turtle, double speedModifier) {
            super(turtle, speedModifier, 16);
            this.g = turtle;
        }

        @Override
        public boolean b() {
            return this.g.m() && this.g.bQ.a(this.g.dt(), 9.0) && super.b();
        }

        @Override
        public boolean c() {
            return super.c() && this.g.m() && this.g.bQ.a(this.g.dt(), 9.0);
        }

        @Override
        public void a() {
            super.a();
            BlockPosition blockPos = this.g.dv();
            if (!this.g.bi() && this.m()) {
                if (this.g.bP < 1) {
                    this.g.x(new TurtleStartDiggingEvent((Turtle)this.g.getBukkitEntity(), CraftLocation.toBukkit(this.e, this.g.dV())).callEvent());
                } else if (this.g.bP > this.a(200)) {
                    int eggCount = this.g.ae.a(4) + 1;
                    TurtleLayEggEvent layEggEvent = new TurtleLayEggEvent((Turtle)this.g.getBukkitEntity(), CraftLocation.toBukkit(this.e.d(), this.g.dV()), eggCount);
                    if (layEggEvent.callEvent() && CraftEventFactory.callEntityChangeBlockEvent(this.g, this.e.d(), (IBlockData)Blocks.mL.m().b(BlockTurtleEgg.c, layEggEvent.getEggCount()))) {
                        World level = this.g.dV();
                        level.a(null, blockPos, SoundEffects.Br, SoundCategory.e, 0.3f, 0.9f + level.A.i() * 0.2f);
                        BlockPosition blockPos1 = this.e.d();
                        IBlockData blockState = (IBlockData)Blocks.mL.m().b(BlockTurtleEgg.c, layEggEvent.getEggCount());
                        level.a(blockPos1, blockState, 3);
                        level.a(GameEvent.i, blockPos1, GameEvent.a.a(this.g, blockState));
                    }
                    this.g.w(false);
                    this.g.x(false);
                    this.g.r(600);
                }
                if (this.g.p()) {
                    ++this.g.bP;
                }
            }
        }

        @Override
        protected boolean a(IWorldReader level, BlockPosition pos) {
            return level.v(pos.d()) && BlockTurtleEgg.b(level, pos);
        }
    }

    static class c
    extends PathfinderGoalGotoTarget {
        private static final int g = 1200;
        private final EntityTurtle h;

        c(EntityTurtle turtle, double speedModifier) {
            super(turtle, turtle.e_() ? 2.0 : speedModifier, 24);
            this.h = turtle;
            this.f = -1;
        }

        @Override
        public boolean c() {
            return !this.h.bi() && this.d <= 1200 && this.a(this.h.dV(), this.e);
        }

        @Override
        public boolean b() {
            return this.h.e_() && !this.h.bi() ? super.b() : !this.h.bS && !this.h.bi() && !this.h.m() && super.b();
        }

        @Override
        public boolean l() {
            return this.d % 160 == 0;
        }

        @Override
        protected boolean a(IWorldReader level, BlockPosition pos) {
            return level.a_(pos).a(Blocks.J);
        }
    }

    static class b
    extends PathfinderGoal {
        private final EntityTurtle a;
        private final double b;
        private boolean c;
        private int d;
        private static final int e = 600;

        b(EntityTurtle turtle, double speedModifier) {
            this.a = turtle;
            this.b = speedModifier;
        }

        @Override
        public boolean b() {
            return !this.a.e_() && (this.a.m() || this.a.dY().a(net.minecraft.world.entity.animal.EntityTurtle$b.b(700)) == 0 && !this.a.bQ.a(this.a.dt(), 64.0)) && new TurtleGoHomeEvent((Turtle)this.a.getBukkitEntity()).callEvent();
        }

        @Override
        public void d() {
            this.a.bS = true;
            this.c = false;
            this.d = 0;
        }

        @Override
        public void e() {
            this.a.bS = false;
        }

        @Override
        public boolean c() {
            return !this.a.bQ.a(this.a.dt(), 7.0) && !this.c && this.d <= this.a(600);
        }

        @Override
        public void a() {
            BlockPosition blockPos = this.a.bQ;
            boolean flag = blockPos.a(this.a.dt(), 16.0);
            if (flag) {
                ++this.d;
            }
            if (this.a.N().k()) {
                Vec3D vec3 = Vec3D.c(blockPos);
                Vec3D posTowards = DefaultRandomPos.a((EntityCreature)this.a, 16, 3, vec3, 0.3141592741012573);
                if (posTowards == null) {
                    posTowards = DefaultRandomPos.a((EntityCreature)this.a, 8, 7, vec3, 1.5707963705062866);
                }
                if (posTowards != null && !flag && !this.a.dV().a_(BlockPosition.a(posTowards)).a(Blocks.J)) {
                    posTowards = DefaultRandomPos.a((EntityCreature)this.a, 16, 5, vec3, 1.5707963705062866);
                }
                if (posTowards == null) {
                    this.c = true;
                    return;
                }
                this.a.N().a(posTowards.d, posTowards.e, posTowards.f, this.b);
            }
        }
    }

    static class i
    extends PathfinderGoal {
        private final EntityTurtle a;
        private final double b;
        private boolean c;

        i(EntityTurtle turtle, double speedModifier) {
            this.a = turtle;
            this.b = speedModifier;
        }

        @Override
        public boolean b() {
            return !this.a.bS && !this.a.m() && this.a.bi();
        }

        @Override
        public void d() {
            int i2 = 512;
            int i1 = 4;
            RandomSource randomSource = this.a.ae;
            int i22 = randomSource.a(1025) - 512;
            int i3 = randomSource.a(9) - 4;
            int i4 = randomSource.a(1025) - 512;
            if ((double)i3 + this.a.dC() > (double)(this.a.dV().P() - 1)) {
                i3 = 0;
            }
            this.a.bR = BlockPosition.a((double)i22 + this.a.dA(), (double)i3 + this.a.dC(), (double)i4 + this.a.dG());
            this.c = false;
        }

        @Override
        public void a() {
            if (this.a.bR == null) {
                this.c = true;
            } else if (this.a.N().k()) {
                Vec3D vec3 = Vec3D.c(this.a.bR);
                Vec3D posTowards = DefaultRandomPos.a((EntityCreature)this.a, 16, 3, vec3, 0.3141592741012573);
                if (posTowards == null) {
                    posTowards = DefaultRandomPos.a((EntityCreature)this.a, 8, 7, vec3, 1.5707963705062866);
                }
                if (posTowards != null) {
                    int floor = MathHelper.a(posTowards.d);
                    int floor1 = MathHelper.a(posTowards.f);
                    int i2 = 34;
                    if (!this.a.dV().b(floor - 34, floor1 - 34, floor + 34, floor1 + 34)) {
                        posTowards = null;
                    }
                }
                if (posTowards == null) {
                    this.c = true;
                    return;
                }
                this.a.N().a(posTowards.d, posTowards.e, posTowards.f, this.b);
            }
        }

        @Override
        public boolean c() {
            return !this.a.N().k() && !this.c && !this.a.bS && !this.a.gE() && !this.a.m();
        }

        @Override
        public void e() {
            this.a.bR = null;
            super.e();
        }
    }

    static class h
    extends PathfinderGoalRandomStroll {
        private final EntityTurtle i;

        h(EntityTurtle turtle, double speedModifier, int interval) {
            super(turtle, speedModifier, interval);
            this.i = turtle;
        }

        @Override
        public boolean b() {
            return !this.b.bi() && !this.i.bS && !this.i.m() && super.b();
        }
    }

    static class g
    extends AmphibiousPathNavigation {
        g(EntityTurtle turtle, World level) {
            super(turtle, level);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean a(BlockPosition pos) {
            block3: {
                block2: {
                    EntityInsentient entityInsentient = this.a;
                    if (!(entityInsentient instanceof EntityTurtle)) break block2;
                    EntityTurtle turtle = (EntityTurtle)entityInsentient;
                    if (turtle.bR != null) break block3;
                }
                if (this.b.a_(pos.e()).l()) return false;
                return true;
            }
            boolean bl = this.b.a_(pos).a(Blocks.J);
            return bl;
        }
    }
}

