/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal.axolotl;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Dynamic;
import io.netty.buffer.ByteBuf;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.IntFunction;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.game.PacketDebug;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.BinaryAnimator;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.INamable;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.ai.BehaviorController;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.control.SmoothSwimmingLookControl;
import net.minecraft.world.entity.ai.control.SmoothSwimmingMoveControl;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.navigation.AmphibiousPathNavigation;
import net.minecraft.world.entity.ai.navigation.NavigationAbstract;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.animal.Bucketable;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.animal.axolotl.AxolotlAi;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemLiquidUtil;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.event.entity.EntityPotionEffectEvent;

public class Axolotl
extends EntityAnimal
implements Bucketable {
    public static final int bI = 200;
    private static final int bT = 10;
    protected static final ImmutableList<? extends SensorType<? extends Sensor<? super Axolotl>>> bJ = ImmutableList.of(SensorType.c, SensorType.o, SensorType.f, SensorType.p, SensorType.q);
    protected static final ImmutableList<? extends MemoryModuleType<?>> bK = ImmutableList.of(MemoryModuleType.s, MemoryModuleType.g, MemoryModuleType.h, MemoryModuleType.k, MemoryModuleType.l, MemoryModuleType.o, MemoryModuleType.n, MemoryModuleType.F, MemoryModuleType.u, MemoryModuleType.p, MemoryModuleType.q, MemoryModuleType.L, (Object[])new MemoryModuleType[]{MemoryModuleType.z, MemoryModuleType.O, MemoryModuleType.C, MemoryModuleType.P, MemoryModuleType.Q, MemoryModuleType.S, MemoryModuleType.V, MemoryModuleType.aa});
    private static final DataWatcherObject<Integer> bU = DataWatcher.a(Axolotl.class, DataWatcherRegistry.b);
    private static final DataWatcherObject<Boolean> bV = DataWatcher.a(Axolotl.class, DataWatcherRegistry.k);
    private static final DataWatcherObject<Boolean> bW = DataWatcher.a(Axolotl.class, DataWatcherRegistry.k);
    public static final double bM = 20.0;
    public static final int bN = 1200;
    private static final int bX = 6000;
    public static final String bO = "Variant";
    private static final int bY = 1800;
    private static final int bZ = 2400;
    private static final boolean ca = false;
    public final BinaryAnimator bP = new BinaryAnimator(10, MathHelper::m);
    public final BinaryAnimator bQ = new BinaryAnimator(10, MathHelper::m);
    public final BinaryAnimator bR = new BinaryAnimator(10, MathHelper::m);
    public final BinaryAnimator bS = new BinaryAnimator(10, MathHelper::m);
    private static final int cb = 100;

    public Axolotl(EntityTypes<? extends Axolotl> entityType, World level) {
        super((EntityTypes<? extends EntityAnimal>)entityType, level);
        this.a(PathType.j, 0.0f);
        this.bC = new d(this);
        this.bB = new c(this, 20);
    }

    @Override
    public float a(BlockPosition pos, IWorldReader level) {
        return 0.0f;
    }

    @Override
    protected void a(DataWatcher.a builder) {
        super.a(builder);
        builder.a(bU, 0);
        builder.a(bV, false);
        builder.a(bW, false);
    }

    @Override
    public void b(NBTTagCompound compound) {
        super.b(compound);
        compound.a(bO, Variant.i, this.gu());
        compound.a("FromBucket", this.p());
    }

    @Override
    public void a(NBTTagCompound compound) {
        super.a(compound);
        this.a(compound.a(bO, Variant.i).orElse(Variant.f));
        this.w(compound.b("FromBucket", false));
    }

    @Override
    public void S() {
        if (!this.gv()) {
            super.S();
        }
    }

    @Override
    public GroupDataEntity a(WorldAccess level, DifficultyDamageScaler difficulty, EntitySpawnReason spawnReason, @Nullable GroupDataEntity spawnGroupData) {
        boolean flag = false;
        if (spawnReason == EntitySpawnReason.l) {
            return spawnGroupData;
        }
        RandomSource random = level.G_();
        if (spawnGroupData instanceof b) {
            if (((b)spawnGroupData).a() >= 2) {
                flag = true;
            }
        } else {
            spawnGroupData = new b(Variant.a(random), Variant.a(random));
        }
        this.a(((b)spawnGroupData).a(random));
        if (flag) {
            this.c_(-24000);
        }
        return super.a(level, difficulty, spawnReason, spawnGroupData);
    }

    @Override
    public void aw() {
        World world;
        int airSupply = this.cs();
        super.aw();
        if (!this.gj() && (world = this.dV()) instanceof WorldServer) {
            WorldServer serverLevel = (WorldServer)world;
            this.a(serverLevel, airSupply);
        }
        if (this.dV().A_()) {
            this.gx();
        }
    }

    private void gx() {
        a animationState = this.gv() ? net.minecraft.world.entity.animal.axolotl.Axolotl$a.a : (this.bi() ? net.minecraft.world.entity.animal.axolotl.Axolotl$a.b : (this.aH() ? net.minecraft.world.entity.animal.axolotl.Axolotl$a.c : net.minecraft.world.entity.animal.axolotl.Axolotl$a.d));
        this.bP.a(animationState == net.minecraft.world.entity.animal.axolotl.Axolotl$a.a);
        this.bQ.a(animationState == net.minecraft.world.entity.animal.axolotl.Axolotl$a.b);
        this.bR.a(animationState == net.minecraft.world.entity.animal.axolotl.Axolotl$a.c);
        boolean flag = this.aT.d() || this.dN() != this.O || this.dL() != this.N;
        this.bS.a(flag);
    }

    protected void a(WorldServer level, int airSupply) {
        if (this.bJ() && !this.bk()) {
            this.j(airSupply - 1);
            if (this.cs() == -20) {
                this.j(0);
                this.a(level, this.dW().t(), 2.0f);
            }
        } else {
            this.j(this.cr());
        }
    }

    public void m() {
        int i2 = this.cs() + 1800;
        this.j(Math.min(i2, this.cr()));
    }

    @Override
    public int cr() {
        return this.maxAirTicks;
    }

    public Variant gu() {
        return Variant.a(this.al.a(bU));
    }

    public void a(Variant variant) {
        this.al.a(bU, variant.a());
    }

    @Override
    @Nullable
    public <T> T a(DataComponentType<? extends T> component) {
        return component == DataComponents.aO ? Axolotl.c(component, this.gu()) : super.a(component);
    }

    @Override
    protected void a(DataComponentGetter componentGetter) {
        this.a(componentGetter, DataComponents.aO);
        super.a(componentGetter);
    }

    @Override
    protected <T> boolean b(DataComponentType<T> component, T value) {
        if (component == DataComponents.aO) {
            this.a(Axolotl.c(DataComponents.aO, value));
            return true;
        }
        return super.b(component, value);
    }

    private static boolean a(RandomSource random) {
        return random.a(1200) == 0;
    }

    @Override
    public boolean a(IWorldReader level) {
        return level.f(this);
    }

    @Override
    public boolean cJ() {
        return false;
    }

    public void x(boolean playingDead) {
        this.al.a(bV, playingDead);
    }

    public boolean gv() {
        return this.al.a(bV);
    }

    @Override
    public boolean p() {
        return this.al.a(bW);
    }

    @Override
    public void w(boolean fromBucket) {
        this.al.a(bW, fromBucket);
    }

    @Override
    @Nullable
    public EntityAgeable a(WorldServer level, EntityAgeable otherParent) {
        Axolotl axolotl = EntityTypes.i.a(level, EntitySpawnReason.e);
        if (axolotl != null) {
            Variant rareSpawnVariant = Axolotl.a(this.ae) ? Variant.b(this.ae) : (this.ae.h() ? this.gu() : ((Axolotl)otherParent).gu());
            axolotl.a(rareSpawnVariant);
            axolotl.gc();
        }
        return axolotl;
    }

    @Override
    public boolean i(ItemStack stack) {
        return stack.a(TagsItem.aE);
    }

    @Override
    public boolean w() {
        return true;
    }

    @Override
    protected void a(WorldServer level) {
        GameProfilerFiller profilerFiller = Profiler.a();
        profilerFiller.a("axolotlBrain");
        this.ec().a(level, this);
        profilerFiller.c();
        profilerFiller.a("axolotlActivityUpdate");
        AxolotlAi.a(this);
        profilerFiller.c();
        if (!this.gj()) {
            Optional<Integer> memory = this.ec().c(MemoryModuleType.O);
            this.x(memory.isPresent() && memory.get() > 0);
        }
    }

    public static AttributeProvider.Builder gw() {
        return EntityAnimal.gz().a(GenericAttributes.s, 14.0).a(GenericAttributes.v, 1.0).a(GenericAttributes.c, 2.0).a(GenericAttributes.B, 1.0);
    }

    @Override
    protected NavigationAbstract b(World level) {
        return new AmphibiousPathNavigation(this, level);
    }

    @Override
    public void gn() {
        this.a(SoundEffects.aK, 1.0f, 1.0f);
    }

    @Override
    public boolean a(WorldServer level, DamageSource damageSource, float amount) {
        float health = this.eG();
        if (!this.gj() && this.dV().A.a(3) == 0 && ((float)this.dV().A.a(3) < amount || health / this.eU() < 0.5f) && amount < health && this.bi() && (damageSource.d() != null || damageSource.c() != null) && !this.gv()) {
            this.bs.a(MemoryModuleType.O, Integer.valueOf(200));
        }
        return super.a(level, damageSource, amount);
    }

    @Override
    public int ac() {
        return 1;
    }

    @Override
    public int ae() {
        return 1;
    }

    @Override
    public EnumInteractionResult b(EntityHuman player, EnumHand hand) {
        return Bucketable.a(player, hand, this).orElse(super.b(player, hand));
    }

    @Override
    public void a_(ItemStack stack) {
        Bucketable.a((EntityInsentient)this, stack);
        stack.a(DataComponents.aO, (DataComponentGetter)this);
        CustomData.a(DataComponents.Z, stack, (NBTTagCompound tag) -> {
            tag.a("Age", this.Y_());
            BehaviorController<Axolotl> brain = this.ec();
            if (brain.a(MemoryModuleType.V)) {
                tag.a("HuntingCooldown", brain.e(MemoryModuleType.V));
            }
        });
    }

    @Override
    public void d(NBTTagCompound tag) {
        Bucketable.a((EntityInsentient)this, tag);
        this.c_(tag.b("Age", 0));
        tag.f("HuntingCooldown").ifPresentOrElse(_long -> this.ec().a(MemoryModuleType.V, true, tag.b("HuntingCooldown", 0L)), () -> this.ec().a(MemoryModuleType.V, Optional.empty()));
    }

    @Override
    public ItemStack a() {
        return new ItemStack(Items.rz);
    }

    @Override
    public SoundEffect u() {
        return SoundEffects.dk;
    }

    @Override
    public boolean ez() {
        return !this.gv() && super.ez();
    }

    public static void a(WorldServer level, Axolotl axolotl, EntityLiving target) {
        Entity entity;
        DamageSource lastDamageSource;
        if (target.eH() && (lastDamageSource = target.eI()) != null && (entity = lastDamageSource.d()) != null && entity.an() == EntityTypes.bT) {
            EntityHuman player = (EntityHuman)entity;
            List<EntityHuman> entitiesOfClass = level.a(EntityHuman.class, axolotl.cR().g(20.0));
            if (entitiesOfClass.contains(player)) {
                axolotl.a(player);
            }
        }
    }

    public void a(EntityHuman player) {
        MobEffect effect = player.c(MobEffects.j);
        if (effect == null || effect.a(2399)) {
            int i2 = effect != null ? effect.d() : 0;
            int min = Math.min(2400, 100 + i2);
            player.addEffect(new MobEffect(MobEffects.j, min, 0), this, EntityPotionEffectEvent.Cause.AXOLOTL);
        }
        player.removeEffect(MobEffects.d, EntityPotionEffectEvent.Cause.AXOLOTL);
    }

    @Override
    public boolean Y() {
        return super.Y() || this.p();
    }

    @Override
    public SoundEffect e(DamageSource damageSource) {
        return SoundEffects.aM;
    }

    @Override
    @Nullable
    public SoundEffect j_() {
        return SoundEffects.aL;
    }

    @Override
    @Nullable
    public SoundEffect s() {
        return this.bi() ? SoundEffects.aO : SoundEffects.aN;
    }

    @Override
    public SoundEffect aV() {
        return SoundEffects.aP;
    }

    @Override
    public SoundEffect aU() {
        return SoundEffects.aQ;
    }

    protected BehaviorController.b<Axolotl> ed() {
        return BehaviorController.a(bK, bJ);
    }

    @Override
    protected BehaviorController<?> a(Dynamic<?> dynamic) {
        return AxolotlAi.a(this.ed().a(dynamic));
    }

    public BehaviorController<Axolotl> ec() {
        return super.ec();
    }

    @Override
    protected void ab() {
        super.ab();
        PacketDebug.a(this);
    }

    @Override
    public void a_(Vec3D travelVector) {
        if (this.bi()) {
            this.a(this.fo(), travelVector);
            this.a(EnumMoveType.a, this.dy());
            this.i(this.dy().c(0.9));
        } else {
            super.a_(travelVector);
        }
    }

    @Override
    protected void a(EntityHuman player, EnumHand hand, ItemStack stack) {
        if (stack.a(Items.ry)) {
            player.a(hand, ItemLiquidUtil.a(stack, player, new ItemStack(Items.rp)));
        } else {
            super.a(player, hand, stack);
        }
    }

    @Override
    public boolean h(double distanceToClosestPlayer) {
        return !this.p() && !this.g_();
    }

    @Override
    @Nullable
    public EntityLiving e() {
        return this.P();
    }

    public static boolean a(EntityTypes<? extends EntityLiving> entityType, WorldAccess level, EntitySpawnReason spawnReason, BlockPosition pos, RandomSource random) {
        return level.a_(pos.e()).a(TagsBlock.cc);
    }

    @Override
    public int getDefaultMaxAirSupply() {
        return 6000;
    }

    static class d
    extends SmoothSwimmingMoveControl {
        private final Axolotl l;

        public d(Axolotl axolotl) {
            super(axolotl, 85, 10, 0.1f, 0.5f, false);
            this.l = axolotl;
        }

        @Override
        public void a() {
            if (!this.l.gv()) {
                super.a();
            }
        }
    }

    class c
    extends SmoothSwimmingLookControl {
        public c(Axolotl mob, int maxYRotFromCenter) {
            super(mob, maxYRotFromCenter);
        }

        @Override
        public void a() {
            if (!Axolotl.this.gv()) {
                super.a();
            }
        }
    }

    public static final class Variant
    extends Enum<Variant>
    implements INamable {
        public static final /* enum */ Variant a = new Variant(0, "lucy", true);
        public static final /* enum */ Variant b = new Variant(1, "wild", true);
        public static final /* enum */ Variant c = new Variant(2, "gold", true);
        public static final /* enum */ Variant d = new Variant(3, "cyan", true);
        public static final /* enum */ Variant e = new Variant(4, "blue", false);
        public static final Variant f;
        private static final IntFunction<Variant> j;
        public static final StreamCodec<ByteBuf, Variant> g;
        public static final Codec<Variant> h;
        @Deprecated
        public static final Codec<Variant> i;
        private final int k;
        private final String l;
        private final boolean m;
        private static final /* synthetic */ Variant[] n;

        public static Variant[] values() {
            return (Variant[])n.clone();
        }

        public static Variant valueOf(String name) {
            return Enum.valueOf(Variant.class, name);
        }

        private Variant(int id, String name, boolean common) {
            this.k = id;
            this.l = name;
            this.m = common;
        }

        public int a() {
            return this.k;
        }

        public String b() {
            return this.l;
        }

        @Override
        public String c() {
            return this.l;
        }

        public static Variant a(int id) {
            return j.apply(id);
        }

        public static Variant a(RandomSource random) {
            return Variant.a(random, true);
        }

        public static Variant b(RandomSource random) {
            return Variant.a(random, false);
        }

        private static Variant a(RandomSource random, boolean common) {
            Variant[] variants = (Variant[])Arrays.stream(Variant.values()).filter(variant -> variant.m == common).toArray(Variant[]::new);
            return SystemUtils.a(variants, random);
        }

        private static /* synthetic */ Variant[] d() {
            return new Variant[]{a, b, c, d, e};
        }

        static {
            n = Variant.d();
            f = a;
            j = ByIdMap.a(Variant::a, Variant.values(), ByIdMap.a.a);
            g = ByteBufCodecs.a(j, Variant::a);
            h = INamable.a(Variant::values);
            i = Codec.INT.xmap(j::apply, Variant::a);
        }
    }

    public static class b
    extends EntityAgeable.a {
        public final Variant[] a;

        public b(Variant ... types) {
            super(false);
            this.a = types;
        }

        public Variant a(RandomSource random) {
            return this.a[random.a(this.a.length)];
        }
    }

    public static final class a
    extends Enum<a> {
        public static final /* enum */ a a = new a();
        public static final /* enum */ a b = new a();
        public static final /* enum */ a c = new a();
        public static final /* enum */ a d = new a();
        private static final /* synthetic */ a[] e;

        public static a[] values() {
            return (a[])e.clone();
        }

        public static a valueOf(String name) {
            return Enum.valueOf(a.class, name);
        }

        private static /* synthetic */ a[] a() {
            return new a[]{a, b, c, d};
        }

        static {
            e = net.minecraft.world.entity.animal.axolotl.Axolotl$a.a();
        }
    }
}

