/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal.camel;

import com.google.common.annotations.VisibleForTesting;
import com.mojang.serialization.Dynamic;
import io.papermc.paper.event.entity.EntityToggleSitEvent;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.game.PacketDebug;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.ai.BehaviorController;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.control.ControllerLook;
import net.minecraft.world.entity.ai.control.ControllerMove;
import net.minecraft.world.entity.ai.control.EntityAIBodyControl;
import net.minecraft.world.entity.ai.navigation.Navigation;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.animal.camel.CamelAi;
import net.minecraft.world.entity.animal.horse.EntityHorseAbstract;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.equipment.Equippable;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec2F;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityRegainHealthEvent;

public class Camel
extends EntityHorseAbstract {
    public static final float bI = 0.45f;
    public static final int bJ = 55;
    public static final int bK = 30;
    private static final float cg = 0.1f;
    private static final float ch = 1.4285f;
    private static final float ci = 22.2222f;
    private static final int cj = 5;
    private static final int ck = 40;
    private static final int cl = 52;
    private static final int cm = 80;
    private static final float cn = 1.43f;
    private static final long cq = 0L;
    public static final DataWatcherObject<Boolean> bM = DataWatcher.a(Camel.class, DataWatcherRegistry.k);
    public static final DataWatcherObject<Long> bN = DataWatcher.a(Camel.class, DataWatcherRegistry.c);
    public final AnimationState bO = new AnimationState();
    public final AnimationState bP = new AnimationState();
    public final AnimationState bQ = new AnimationState();
    public final AnimationState bR = new AnimationState();
    public final AnimationState bS = new AnimationState();
    private static final EntitySize cr = EntitySize.b(EntityTypes.u.l(), EntityTypes.u.m() - 1.43f).b(0.845f);
    private int cs = 0;
    private int ct = 0;

    public Camel(EntityTypes<? extends Camel> entityType, World level) {
        super((EntityTypes<? extends EntityHorseAbstract>)entityType, level);
        this.bC = new c();
        this.bB = new b();
        Navigation groundPathNavigation = (Navigation)this.N();
        groundPathNavigation.a(true);
        groundPathNavigation.d(true);
    }

    @Override
    public void b(NBTTagCompound compound) {
        super.b(compound);
        compound.a("LastPoseTick", this.al.a(bN));
    }

    @Override
    public void a(NBTTagCompound compound) {
        super.a(compound);
        long longOr = compound.b("LastPoseTick", 0L);
        if (longOr < 0L) {
            this.b(EntityPose.k);
        }
        this.a(longOr);
    }

    public static AttributeProvider.Builder m() {
        return Camel.gV().a(GenericAttributes.s, 32.0).a(GenericAttributes.v, 0.09f).a(GenericAttributes.o, 0.42f).a(GenericAttributes.B, 1.5);
    }

    @Override
    protected void a(DataWatcher.a builder) {
        super.a(builder);
        builder.a(bM, false);
        builder.a(bN, 0L);
    }

    @Override
    public GroupDataEntity a(WorldAccess level, DifficultyDamageScaler difficulty, EntitySpawnReason spawnReason, @Nullable GroupDataEntity spawnGroupData) {
        CamelAi.a(this, level.G_());
        this.b(level.a().ae());
        return super.a(level, difficulty, spawnReason, spawnGroupData);
    }

    public static boolean c(EntityTypes<Camel> entityType, GeneratorAccess level, EntitySpawnReason spawnReason, BlockPosition pos, RandomSource random) {
        return level.a_(pos.e()).a(TagsBlock.cm) && Camel.a(level, pos);
    }

    protected BehaviorController.b<Camel> ed() {
        return CamelAi.a();
    }

    @Override
    protected void C() {
    }

    @Override
    protected BehaviorController<?> a(Dynamic<?> dynamic) {
        return CamelAi.a(this.ed().a(dynamic));
    }

    @Override
    public EntitySize e(EntityPose pose) {
        return pose == EntityPose.k ? cr.a(this.ek()) : super.e(pose);
    }

    @Override
    protected void a(WorldServer level) {
        GameProfilerFiller profilerFiller = Profiler.a();
        profilerFiller.a("camelBrain");
        BehaviorController<?> brain = this.ec();
        brain.a(level, this);
        profilerFiller.c();
        profilerFiller.a("camelActivityUpdate");
        CamelAi.a(this);
        profilerFiller.c();
        super.a(level);
    }

    @Override
    public void g() {
        super.g();
        if (this.u() && this.cs < 50 && (this.aH() || this.bl() || this.bY())) {
            this.w(false);
        }
        if (this.cs > 0) {
            --this.cs;
            if (this.cs == 0) {
                this.dV().a(null, this.dv(), SoundEffects.dD, SoundCategory.g, 1.0f, 1.0f);
            }
        }
        if (this.dV().A_()) {
            this.he();
        }
        if (this.p()) {
            this.af();
        }
        if (this.gx() && this.bi()) {
            this.gJ();
        }
    }

    private void he() {
        if (this.ct <= 0) {
            this.ct = this.ae.a(40) + 80;
            this.bR.a(this.af);
        } else {
            --this.ct;
        }
        if (this.gy()) {
            this.bQ.a();
            this.bS.a();
            if (this.hf()) {
                this.bO.b(this.af);
                this.bP.a();
            } else {
                this.bO.a();
                this.bP.b(this.af);
            }
        } else {
            this.bO.a();
            this.bP.a();
            this.bS.a(this.u(), this.af);
            this.bQ.a(this.gG() && this.gK() >= 0L, this.af);
        }
    }

    @Override
    protected void A(float partialTick) {
        float min = this.at() == EntityPose.a && !this.bS.b() ? Math.min(partialTick * 6.0f, 1.0f) : 0.0f;
        this.aT.a(min, 0.2f, this.e_() ? 3.0f : 1.0f);
    }

    @Override
    public void a_(Vec3D travelVector) {
        if (this.p() && this.aH()) {
            this.i(this.dy().d(0.0, 1.0, 0.0));
            travelVector = travelVector.d(0.0, 1.0, 0.0);
        }
        super.a_(travelVector);
    }

    @Override
    protected void a(EntityHuman player, Vec3D travelVector) {
        super.a(player, travelVector);
        if (player.bi > 0.0f && this.gx() && !this.gG()) {
            this.gI();
        }
    }

    public boolean p() {
        return this.gx() || this.gG();
    }

    @Override
    protected float c(EntityHuman player) {
        float f2 = player.ci() && this.c() == 0 ? 0.1f : 0.0f;
        return (float)this.h(GenericAttributes.v) + f2;
    }

    @Override
    protected Vec2F i(EntityLiving entity) {
        return this.p() ? new Vec2F(this.dN(), this.dL()) : super.i(entity);
    }

    @Override
    protected Vec3D b(EntityHuman player, Vec3D travelVector) {
        return this.p() ? Vec3D.c : super.b(player, travelVector);
    }

    @Override
    public boolean a() {
        return !this.p() && super.a();
    }

    @Override
    public void b(int jumpPower) {
        if (this.fZ() && this.cs <= 0 && this.aH()) {
            super.b(jumpPower);
        }
    }

    @Override
    public boolean dO() {
        return true;
    }

    @Override
    protected void b(float playerJumpPendingScale, Vec3D travelVector) {
        double d2 = this.fh();
        this.j(this.bS().d(1.0, 0.0, 1.0).d().c((double)(22.2222f * playerJumpPendingScale) * this.h(GenericAttributes.v) * (double)this.aS()).b(0.0, (double)(1.4285f * playerJumpPendingScale) * d2, 0.0));
        this.cs = 55;
        this.w(true);
        this.ar = true;
    }

    public boolean u() {
        return this.al.a(bM);
    }

    public void w(boolean dashing) {
        this.al.a(bM, dashing);
    }

    @Override
    public void c(int jumpPower) {
        this.b(SoundEffects.dC);
        ((Entity)this).a(GameEvent.u);
        this.w(true);
    }

    @Override
    public void b() {
    }

    @Override
    public int c() {
        return this.cs;
    }

    @Override
    public SoundEffect s() {
        return SoundEffects.dB;
    }

    @Override
    public SoundEffect j_() {
        return SoundEffects.dE;
    }

    @Override
    public SoundEffect e(DamageSource damageSource) {
        return SoundEffects.dG;
    }

    @Override
    protected void b(BlockPosition pos, IBlockData block) {
        if (block.a(TagsBlock.bs)) {
            this.a(SoundEffects.dL, 1.0f, 1.0f);
        } else {
            this.a(SoundEffects.dK, 1.0f, 1.0f);
        }
    }

    @Override
    public boolean i(ItemStack stack) {
        return stack.a(TagsItem.am);
    }

    @Override
    public EnumInteractionResult b(EntityHuman player, EnumHand hand) {
        ItemStack itemInHand = player.b(hand);
        if (player.fY() && !this.e_()) {
            this.b(player);
            return EnumInteractionResult.a;
        }
        EnumInteractionResult interactionResult = itemInHand.a(player, (EntityLiving)this, hand);
        if (interactionResult.a()) {
            return interactionResult;
        }
        if (this.i(itemInHand)) {
            return this.c(player, itemInHand);
        }
        if (this.cY().size() < 2 && !this.e_()) {
            this.a(player);
        }
        return EnumInteractionResult.a;
    }

    @Override
    public boolean a(Entity leashHolder, float distance) {
        if (distance > 6.0f && this.gx() && !this.gG() && this.gu()) {
            this.gI();
        }
        return true;
    }

    public boolean gu() {
        return this.g(this.gx() ? EntityPose.a : EntityPose.k);
    }

    @Override
    protected boolean a(EntityHuman player, ItemStack stack) {
        SoundEffect eatingSound;
        boolean isBaby;
        boolean flag1;
        boolean flag;
        if (!this.i(stack)) {
            return false;
        }
        boolean bl = flag = this.eG() < this.eU();
        if (flag) {
            this.heal(2.0f, EntityRegainHealthEvent.RegainReason.EATING);
        }
        boolean bl2 = flag1 = this.gL() && this.Y_() == 0 && this.gB();
        if (flag1) {
            this.setInLove(player, stack.v());
        }
        if (isBaby = this.e_()) {
            this.dV().a(Particles.Q, this.d(1.0), this.dD() + 0.5, this.g(1.0), 0.0, 0.0, 0.0);
            if (!this.dV().C) {
                this.b_(10);
            }
        }
        if (!(flag || flag1 || isBaby)) {
            return false;
        }
        if (!this.ba() && (eatingSound = this.gw()) != null) {
            this.dV().a(null, this.dA(), this.dC(), this.dG(), eatingSound, this.dm(), 1.0f, 1.0f + (this.ae.i() - this.ae.i()) * 0.2f);
        }
        ((Entity)this).a(GameEvent.m);
        return true;
    }

    @Override
    protected boolean gv() {
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean a(EntityAnimal otherAnimal) {
        if (otherAnimal == this) return false;
        if (!(otherAnimal instanceof Camel)) return false;
        Camel camel = (Camel)otherAnimal;
        if (!this.hc()) return false;
        if (!camel.hc()) return false;
        return true;
    }

    @Nullable
    public Camel b(WorldServer level, EntityAgeable otherParent) {
        return EntityTypes.u.a(level, EntitySpawnReason.e);
    }

    @Override
    @Nullable
    protected SoundEffect gw() {
        return SoundEffects.dF;
    }

    @Override
    public boolean actuallyHurt(WorldServer level, DamageSource damageSource, float amount, EntityDamageEvent event) {
        boolean damageResult = super.actuallyHurt(level, damageSource, amount, event);
        if (!damageResult) {
            return false;
        }
        this.gJ();
        return true;
    }

    @Override
    protected Vec3D a(Entity entity, EntitySize dimensions, float partialTick) {
        int max = Math.max(this.cY().indexOf(entity), 0);
        boolean flag = max == 0;
        float f2 = 0.5f;
        float f1 = (float)(this.dQ() ? (double)0.01f : this.a(flag, 0.0f, dimensions, partialTick));
        if (this.cY().size() > 1) {
            if (!flag) {
                f2 = -0.7f;
            }
            if (entity instanceof EntityAnimal) {
                f2 += 0.2f;
            }
        }
        return new Vec3D(0.0, f1, f2 * partialTick).b(-this.dL() * ((float)Math.PI / 180));
    }

    @Override
    public float ek() {
        return this.e_() ? 0.45f : 1.0f;
    }

    private double a(boolean firstPassenger, float partialTick, EntitySize dimensions, float scale) {
        double d2 = dimensions.b() - 0.375f * scale;
        float f2 = scale * 1.43f;
        float f1 = f2 - scale * 0.2f;
        float f22 = f2 - f1;
        boolean isInPoseTransition = this.gG();
        boolean isCamelSitting = this.gx();
        if (isInPoseTransition) {
            float f3;
            int i1;
            int i2;
            int n2 = i2 = isCamelSitting ? 40 : 52;
            if (isCamelSitting) {
                i1 = 28;
                f3 = firstPassenger ? 0.5f : 0.1f;
            } else {
                i1 = firstPassenger ? 24 : 32;
                f3 = firstPassenger ? 0.6f : 0.35f;
            }
            float f4 = MathHelper.a((float)this.gK() + partialTick, 0.0f, (float)i2);
            boolean flag = f4 < (float)i1;
            float f5 = flag ? f4 / (float)i1 : (f4 - (float)i1) / (float)(i2 - i1);
            float f6 = f2 - f3 * f1;
            d2 += isCamelSitting ? (double)MathHelper.h(f5, flag ? f2 : f6, flag ? f6 : f22) : (double)MathHelper.h(f5, flag ? f22 - f2 : f22 - f6, flag ? f22 - f6 : 0.0f);
        }
        if (isCamelSitting && !isInPoseTransition) {
            d2 += (double)f22;
        }
        return d2;
    }

    @Override
    public Vec3D t(float partialTick) {
        EntitySize dimensions = this.a(this.at());
        float ageScale = this.ek();
        return new Vec3D(0.0, this.a(true, partialTick, dimensions, ageScale) - (double)(0.2f * ageScale), dimensions.a() * 0.56f);
    }

    @Override
    public int ae() {
        return 30;
    }

    @Override
    protected boolean r(Entity passenger) {
        return this.cY().size() <= 2;
    }

    @Override
    protected void ab() {
        super.ab();
        PacketDebug.a(this);
    }

    public boolean gx() {
        return this.al.a(bN) < 0L;
    }

    public boolean gy() {
        return this.gK() < 0L != this.gx();
    }

    public boolean gG() {
        long poseTime = this.gK();
        return poseTime < (long)(this.gx() ? 40 : 52);
    }

    private boolean hf() {
        return this.gx() && this.gK() < 40L && this.gK() >= 0L;
    }

    public void gH() {
        if (!this.gx() && new EntityToggleSitEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), true).callEvent()) {
            this.b(SoundEffects.dI);
            this.b(EntityPose.k);
            ((Entity)this).a(GameEvent.u);
            this.a(-this.dV().ae());
        }
    }

    public void gI() {
        if (this.gx() && new EntityToggleSitEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), false).callEvent()) {
            this.b(SoundEffects.dJ);
            this.b(EntityPose.a);
            ((Entity)this).a(GameEvent.u);
            this.a(this.dV().ae());
        }
    }

    public void gJ() {
        if (this.gx() && !new EntityToggleSitEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), false).callEvent()) {
            return;
        }
        this.b(EntityPose.a);
        ((Entity)this).a(GameEvent.u);
        this.b(this.dV().ae());
    }

    @VisibleForTesting
    public void a(long lastPoseChangeTick) {
        this.al.a(bN, lastPoseChangeTick);
    }

    private void b(long lastPoseChangedTick) {
        this.a(Math.max(0L, lastPoseChangedTick - 52L - 1L));
    }

    public long gK() {
        return this.dV().ae() - Math.abs(this.al.a(bN));
    }

    @Override
    protected Holder<SoundEffect> a(EnumItemSlot slot, ItemStack stack, Equippable equippable) {
        return slot == EnumItemSlot.h ? SoundEffects.dH : super.a(slot, stack, equippable);
    }

    @Override
    public void a(DataWatcherObject<?> key) {
        if (!this.ak && bM.equals(key)) {
            this.cs = this.cs == 0 ? 55 : this.cs;
        }
        super.a(key);
    }

    @Override
    public boolean gL() {
        return true;
    }

    @Override
    public void b(EntityHuman player) {
        if (!this.dV().C) {
            player.a(this, this.ca);
        }
    }

    @Override
    protected EntityAIBodyControl H() {
        return new a(this);
    }

    class c
    extends ControllerMove {
        public c() {
            super(Camel.this);
        }

        @Override
        public void a() {
            if (this.k == ControllerMove.Operation.b && !Camel.this.Q_() && Camel.this.gx() && !Camel.this.gG() && Camel.this.gu()) {
                Camel.this.gI();
            }
            super.a();
        }
    }

    class b
    extends ControllerLook {
        b() {
            super(Camel.this);
        }

        @Override
        public void a() {
            if (!Camel.this.cX()) {
                super.a();
            }
        }
    }

    class a
    extends EntityAIBodyControl {
        public a(Camel mob) {
            super(mob);
        }

        @Override
        public void a() {
            if (!Camel.this.p()) {
                super.a();
            }
        }
    }
}

