/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal.frog;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Dynamic;
import io.papermc.paper.event.entity.EntityFertilizeEggEvent;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.IRegistry;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.game.PacketDebug;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsEntity;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.util.Unit;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.ai.BehaviorController;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.control.ControllerLook;
import net.minecraft.world.entity.ai.control.SmoothSwimmingMoveControl;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.navigation.AmphibiousPathNavigation;
import net.minecraft.world.entity.ai.navigation.NavigationAbstract;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.animal.frog.FrogAi;
import net.minecraft.world.entity.animal.frog.FrogVariant;
import net.minecraft.world.entity.animal.frog.FrogVariants;
import net.minecraft.world.entity.monster.EntitySlime;
import net.minecraft.world.entity.variant.SpawnContext;
import net.minecraft.world.entity.variant.VariantUtils;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.pathfinder.AmphibiousNodeEvaluator;
import net.minecraft.world.level.pathfinder.PathPoint;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.pathfinder.Pathfinder;
import net.minecraft.world.level.pathfinder.PathfindingContext;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_21_R4.event.CraftEventFactory;

public class Frog
extends EntityAnimal {
    protected static final ImmutableList<SensorType<? extends Sensor<? super Frog>>> bI = ImmutableList.of(SensorType.c, SensorType.f, SensorType.v, SensorType.s, SensorType.w);
    protected static final ImmutableList<MemoryModuleType<?>> bJ = ImmutableList.of(MemoryModuleType.o, MemoryModuleType.g, MemoryModuleType.h, MemoryModuleType.n, MemoryModuleType.F, MemoryModuleType.u, MemoryModuleType.s, MemoryModuleType.T, MemoryModuleType.U, MemoryModuleType.p, MemoryModuleType.P, MemoryModuleType.Q, (Object[])new MemoryModuleType[]{MemoryModuleType.S, MemoryModuleType.y, MemoryModuleType.z, MemoryModuleType.C, MemoryModuleType.Y, MemoryModuleType.Z, MemoryModuleType.aa, MemoryModuleType.ab});
    private static final DataWatcherObject<Holder<FrogVariant>> bP = DataWatcher.a(Frog.class, DataWatcherRegistry.C);
    private static final DataWatcherObject<OptionalInt> bQ = DataWatcher.a(Frog.class, DataWatcherRegistry.v);
    private static final int bR = 5;
    private static final ResourceKey<FrogVariant> bS = FrogVariants.a;
    public final AnimationState bK = new AnimationState();
    public final AnimationState bM = new AnimationState();
    public final AnimationState bN = new AnimationState();
    public final AnimationState bO = new AnimationState();

    public Frog(EntityTypes<? extends EntityAnimal> entityType, World level) {
        super(entityType, level);
        this.bB = new a(this);
        this.a(PathType.j, 4.0f);
        this.a(PathType.e, -1.0f);
        this.bC = new SmoothSwimmingMoveControl(this, 85, 10, 0.02f, 0.1f, true);
    }

    protected BehaviorController.b<Frog> ed() {
        return BehaviorController.a(bJ, bI);
    }

    @Override
    protected BehaviorController<?> a(Dynamic<?> dynamic) {
        return FrogAi.a(this.ed().a(dynamic));
    }

    public BehaviorController<Frog> ec() {
        return super.ec();
    }

    @Override
    protected void a(DataWatcher.a builder) {
        super.a(builder);
        IRegistry<FrogVariant> registry = this.dX().f(Registries.aT);
        builder.a(bP, VariantUtils.a(this.dX(), bS));
        builder.a(bQ, OptionalInt.empty());
    }

    public void m() {
        this.al.a(bQ, OptionalInt.empty());
    }

    public Optional<Entity> p() {
        return this.al.a(bQ).stream().mapToObj(this.dV()::a).filter(Objects::nonNull).findFirst();
    }

    public void b(Entity tongueTarget) {
        this.al.a(bQ, OptionalInt.of(tongueTarget.ao()));
    }

    @Override
    public int ag() {
        return 35;
    }

    @Override
    public int ae() {
        return 5;
    }

    public Holder<FrogVariant> u() {
        return this.al.a(bP);
    }

    public void j(Holder<FrogVariant> variant) {
        this.al.a(bP, variant);
    }

    @Override
    @Nullable
    public <T> T a(DataComponentType<? extends T> component) {
        return component == DataComponents.aK ? Frog.c(component, this.u()) : super.a(component);
    }

    @Override
    protected void a(DataComponentGetter componentGetter) {
        this.a(componentGetter, DataComponents.aK);
        super.a(componentGetter);
    }

    @Override
    protected <T> boolean b(DataComponentType<T> component, T value) {
        if (component == DataComponents.aK) {
            this.j(Frog.c(DataComponents.aK, value));
            return true;
        }
        return super.b(component, value);
    }

    @Override
    public void b(NBTTagCompound compound) {
        super.b(compound);
        VariantUtils.a(compound, this.u());
    }

    @Override
    public void a(NBTTagCompound compound) {
        super.a(compound);
        VariantUtils.a(compound, this.dX(), Registries.aT).ifPresent(this::j);
    }

    @Override
    protected void a(WorldServer level) {
        GameProfilerFiller profilerFiller = Profiler.a();
        profilerFiller.a("frogBrain");
        this.ec().a(level, this);
        profilerFiller.c();
        profilerFiller.a("frogActivityUpdate");
        FrogAi.a(this);
        profilerFiller.c();
        super.a(level);
    }

    @Override
    public void g() {
        if (this.dV().A_()) {
            this.bO.a(this.bi() && !this.aT.d(), this.af);
        }
        super.g();
    }

    @Override
    public void a(DataWatcherObject<?> key) {
        if (Entity.aq.equals(key)) {
            EntityPose pose = this.at();
            if (pose == EntityPose.g) {
                this.bK.a(this.af);
            } else {
                this.bK.a();
            }
            if (pose == EntityPose.i) {
                this.bM.a(this.af);
            } else {
                this.bM.a();
            }
            if (pose == EntityPose.j) {
                this.bN.a(this.af);
            } else {
                this.bN.a();
            }
        }
        super.a(key);
    }

    @Override
    protected void A(float partialTick) {
        float f2 = this.bK.b() ? 0.0f : Math.min(partialTick * 25.0f, 1.0f);
        this.aT.a(f2, 0.4f, this.e_() ? 3.0f : 1.0f);
    }

    @Override
    public void gA() {
        this.dV().a(null, this, SoundEffects.kr, SoundCategory.g, 2.0f, 1.0f);
    }

    @Override
    @Nullable
    public EntityAgeable a(WorldServer level, EntityAgeable otherParent) {
        Frog frog = EntityTypes.ac.a(level, EntitySpawnReason.e);
        if (frog != null) {
            FrogAi.a(frog, level.G_());
        }
        return frog;
    }

    @Override
    public boolean e_() {
        return false;
    }

    @Override
    public void a(boolean baby) {
    }

    @Override
    public void a(WorldServer level, EntityAnimal mate) {
        EntityFertilizeEggEvent result = CraftEventFactory.callEntityFertilizeEggEvent(this, mate);
        if (result.isCancelled()) {
            return;
        }
        this.finalizeSpawnChildFromBreeding(level, mate, null, result.getExperience());
        this.ec().a(MemoryModuleType.Z, Unit.a);
    }

    @Override
    public GroupDataEntity a(WorldAccess level, DifficultyDamageScaler difficulty, EntitySpawnReason spawnReason, @Nullable GroupDataEntity spawnGroupData) {
        FrogVariants.a(this.ae, this.dX(), SpawnContext.a(level, this.dv())).ifPresent(this::j);
        FrogAi.a(this, level.G_());
        return super.a(level, difficulty, spawnReason, spawnGroupData);
    }

    public static AttributeProvider.Builder gu() {
        return EntityAnimal.gz().a(GenericAttributes.v, 1.0).a(GenericAttributes.s, 10.0).a(GenericAttributes.c, 10.0).a(GenericAttributes.B, 1.0);
    }

    @Override
    @Nullable
    public SoundEffect s() {
        return SoundEffects.kp;
    }

    @Override
    @Nullable
    public SoundEffect e(DamageSource damageSource) {
        return SoundEffects.ks;
    }

    @Override
    @Nullable
    public SoundEffect j_() {
        return SoundEffects.kq;
    }

    @Override
    protected void b(BlockPosition pos, IBlockData state) {
        this.a(SoundEffects.kv, 0.15f, 1.0f);
    }

    @Override
    public boolean cJ() {
        return false;
    }

    @Override
    protected void ab() {
        super.ab();
        PacketDebug.a(this);
    }

    @Override
    protected int a(double fallDistance, float damageMultiplier) {
        return super.a(fallDistance, damageMultiplier) - 5;
    }

    @Override
    public void a_(Vec3D travelVector) {
        if (this.bi()) {
            this.a(this.fo(), travelVector);
            this.a(EnumMoveType.a, this.dy());
            this.i(this.dy().c(0.9));
        } else {
            super.a_(travelVector);
        }
    }

    public static boolean i(EntityLiving entity) {
        EntitySlime slime;
        return (!(entity instanceof EntitySlime) || (slime = (EntitySlime)entity).gv() == 1) && entity.an().a(TagsEntity.n);
    }

    @Override
    protected NavigationAbstract b(World level) {
        return new c(this, level);
    }

    @Override
    @Nullable
    public EntityLiving e() {
        return this.P();
    }

    @Override
    public boolean i(ItemStack stack) {
        return stack.a(TagsItem.aq);
    }

    public static boolean c(EntityTypes<? extends EntityAnimal> entityType, GeneratorAccess level, EntitySpawnReason spawnReason, BlockPosition pos, RandomSource random) {
        return level.a_(pos.e()).a(TagsBlock.ck) && Frog.a(level, pos);
    }

    class a
    extends ControllerLook {
        a(EntityInsentient mob) {
            super(mob);
        }

        @Override
        protected boolean c() {
            return Frog.this.p().isEmpty();
        }
    }

    static class c
    extends AmphibiousPathNavigation {
        c(Frog mob, World level) {
            super(mob, level);
        }

        @Override
        public boolean b(PathType pathType) {
            return pathType != PathType.k && super.b(pathType);
        }

        @Override
        protected Pathfinder a(int maxVisitedNodes) {
            this.o = new b(true);
            return new Pathfinder(this.o, maxVisitedNodes);
        }
    }

    static class b
    extends AmphibiousNodeEvaluator {
        private final BlockPosition.MutableBlockPosition a = new BlockPosition.MutableBlockPosition();

        public b(boolean prefersShallowSwimming) {
            super(prefersShallowSwimming);
        }

        @Override
        public PathPoint a() {
            return !this.c.bi() ? super.a() : this.c(new BlockPosition(MathHelper.a(this.c.cR().a), MathHelper.a(this.c.cR().b), MathHelper.a(this.c.cR().c)));
        }

        @Override
        public PathType a(PathfindingContext context, int x2, int y2, int z2) {
            this.a.d(x2, y2 - 1, z2);
            IBlockData blockState = context.a(this.a);
            return blockState.a(TagsBlock.bV) ? PathType.b : super.a(context, x2, y2, z2);
        }
    }
}

