/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal.goat;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Dynamic;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.game.PacketDebug;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.InstrumentTags;
import net.minecraft.tags.TagKey;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.ai.BehaviorController;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.animal.goat.GoatAi;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.item.Instrument;
import net.minecraft.world.item.InstrumentItem;
import net.minecraft.world.item.ItemLiquidUtil;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_21_R4.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_21_R4.inventory.CraftItemStack;
import org.bukkit.event.player.PlayerBucketFillEvent;

public class Goat
extends EntityAnimal {
    public static final EntitySize bI = EntitySize.b(0.9f, 1.3f).a(0.7f);
    private static final int bP = 2;
    private static final int bQ = 1;
    protected static final ImmutableList<SensorType<? extends Sensor<? super Goat>>> bJ = ImmutableList.of(SensorType.c, SensorType.d, SensorType.b, SensorType.o, SensorType.f, SensorType.r);
    protected static final ImmutableList<MemoryModuleType<?>> bK = ImmutableList.of(MemoryModuleType.o, MemoryModuleType.h, MemoryModuleType.n, MemoryModuleType.F, MemoryModuleType.u, MemoryModuleType.aw, MemoryModuleType.s, MemoryModuleType.T, MemoryModuleType.U, MemoryModuleType.P, MemoryModuleType.L, MemoryModuleType.Q, (Object[])new MemoryModuleType[]{MemoryModuleType.S, MemoryModuleType.W, MemoryModuleType.X, MemoryModuleType.aa});
    public static final int bM = 10;
    public static final double bN = 0.02;
    public static final double bO = (double)0.1f;
    private static final DataWatcherObject<Boolean> bR = DataWatcher.a(Goat.class, DataWatcherRegistry.k);
    public static final DataWatcherObject<Boolean> bS = DataWatcher.a(Goat.class, DataWatcherRegistry.k);
    public static final DataWatcherObject<Boolean> bT = DataWatcher.a(Goat.class, DataWatcherRegistry.k);
    private static final boolean bU = false;
    private static final boolean bV = true;
    private static final boolean bW = true;
    private boolean bX;
    private int bY;

    public Goat(EntityTypes<? extends Goat> entityType, World level) {
        super((EntityTypes<? extends EntityAnimal>)entityType, level);
        this.N().a(true);
        this.a(PathType.f, -1.0f);
        this.a(PathType.g, -1.0f);
    }

    public ItemStack m() {
        RandomSource randomSource = RandomSource.a(this.cG().hashCode());
        TagKey<Instrument> tagKey = this.gG() ? InstrumentTags.b : InstrumentTags.a;
        return this.dV().J_().f(Registries.aU).a(tagKey, randomSource).map(holder -> InstrumentItem.a(Items.xt, holder)).orElseGet(() -> new ItemStack(Items.xt));
    }

    protected BehaviorController.b<Goat> ed() {
        return BehaviorController.a(bK, bJ);
    }

    @Override
    protected BehaviorController<?> a(Dynamic<?> dynamic) {
        return GoatAi.a(this.ed().a(dynamic));
    }

    public static AttributeProvider.Builder p() {
        return EntityAnimal.gz().a(GenericAttributes.s, 10.0).a(GenericAttributes.v, 0.2f).a(GenericAttributes.c, 2.0);
    }

    @Override
    protected void h() {
        if (this.e_()) {
            this.g(GenericAttributes.c).a(1.0);
            this.gy();
        } else {
            this.g(GenericAttributes.c).a(2.0);
            this.gx();
        }
    }

    @Override
    protected int a(double fallDistance, float damageMultiplier) {
        return super.a(fallDistance, damageMultiplier) - 10;
    }

    @Override
    public SoundEffect s() {
        return this.gG() ? SoundEffects.lx : SoundEffects.lo;
    }

    @Override
    public SoundEffect e(DamageSource damageSource) {
        return this.gG() ? SoundEffects.lA : SoundEffects.lr;
    }

    @Override
    public SoundEffect j_() {
        return this.gG() ? SoundEffects.ly : SoundEffects.lp;
    }

    @Override
    protected void b(BlockPosition pos, IBlockData state) {
        this.a(SoundEffects.lF, 0.15f, 1.0f);
    }

    protected SoundEffect u() {
        return this.gG() ? SoundEffects.lC : SoundEffects.lt;
    }

    @Nullable
    public Goat b(WorldServer level, EntityAgeable otherParent) {
        Goat goat = EntityTypes.ai.a(level, EntitySpawnReason.e);
        if (goat != null) {
            EntityAgeable goat1;
            GoatAi.a(goat, level.G_());
            EntityAgeable ageableMob = level.G_().h() ? this : otherParent;
            boolean flag = ageableMob instanceof Goat && ((Goat)(goat1 = ageableMob)).gG() || level.G_().j() < 0.02;
            goat.w(flag);
        }
        return goat;
    }

    public BehaviorController<Goat> ec() {
        return super.ec();
    }

    @Override
    protected void a(WorldServer level) {
        GameProfilerFiller profilerFiller = Profiler.a();
        profilerFiller.a("goatBrain");
        this.ec().a(level, this);
        profilerFiller.c();
        profilerFiller.a("goatActivityUpdate");
        GoatAi.a(this);
        profilerFiller.c();
        super.a(level);
    }

    @Override
    public int ae() {
        return 15;
    }

    @Override
    public void r(float yHeadRot) {
        int maxHeadYRot = this.ae();
        float f2 = MathHelper.c(this.aV, yHeadRot);
        float f1 = MathHelper.a(f2, (float)(-maxHeadYRot), (float)maxHeadYRot);
        super.r(this.aV + f1);
    }

    @Override
    protected void gA() {
        this.dV().a(null, this, this.gG() ? SoundEffects.lz : SoundEffects.lq, SoundCategory.g, 1.0f, MathHelper.b(this.dV().A, 0.8f, 1.2f));
    }

    @Override
    public boolean i(ItemStack stack) {
        return stack.a(TagsItem.ag);
    }

    @Override
    public EnumInteractionResult b(EntityHuman player, EnumHand hand) {
        ItemStack itemInHand = player.b(hand);
        if (itemInHand.a(Items.ro) && !this.e_()) {
            PlayerBucketFillEvent event = CraftEventFactory.callPlayerBucketFillEvent(player.dV(), player, this.dv(), this.dv(), null, itemInHand, Items.ru, hand);
            if (event.isCancelled()) {
                player.bR.b();
                return EnumInteractionResult.e;
            }
            player.a(this.u(), 1.0f, 1.0f);
            ItemStack itemStack = ItemLiquidUtil.a(itemInHand, player, CraftItemStack.asNMSCopy(event.getItemStack()));
            player.a(hand, itemStack);
            return EnumInteractionResult.a;
        }
        boolean isFood = this.i(itemInHand);
        EnumInteractionResult interactionResult = super.b(player, hand);
        if (interactionResult.a() && isFood) {
            this.gA();
        }
        return interactionResult;
    }

    @Override
    public GroupDataEntity a(WorldAccess level, DifficultyDamageScaler difficulty, EntitySpawnReason spawnReason, @Nullable GroupDataEntity spawnGroupData) {
        RandomSource random = level.G_();
        GoatAi.a(this, random);
        this.w(random.j() < 0.02);
        this.h();
        if (!this.e_() && random.i() < 0.1f) {
            DataWatcherObject<Boolean> entityDataAccessor = random.h() ? bS : bT;
            this.al.a(entityDataAccessor, false);
        }
        return super.a(level, difficulty, spawnReason, spawnGroupData);
    }

    @Override
    protected void ab() {
        super.ab();
        PacketDebug.a(this);
    }

    @Override
    public EntitySize e(EntityPose pose) {
        return pose == EntityPose.g ? bI.a(this.ek()) : super.e(pose);
    }

    @Override
    public void b(NBTTagCompound compound) {
        super.b(compound);
        compound.a("IsScreamingGoat", this.gG());
        compound.a("HasLeftHorn", this.gu());
        compound.a("HasRightHorn", this.gv());
    }

    @Override
    public void a(NBTTagCompound compound) {
        super.a(compound);
        this.w(compound.b("IsScreamingGoat", false));
        this.al.a(bS, compound.b("HasLeftHorn", true));
        this.al.a(bT, compound.b("HasRightHorn", true));
    }

    @Override
    public void b(byte id) {
        if (id == 58) {
            this.bX = true;
        } else if (id == 59) {
            this.bX = false;
        } else {
            super.b(id);
        }
    }

    @Override
    public void d_() {
        this.bY = this.bX ? ++this.bY : (this.bY -= 2);
        this.bY = MathHelper.a(this.bY, 0, 20);
        super.d_();
    }

    @Override
    protected void a(DataWatcher.a builder) {
        super.a(builder);
        builder.a(bR, false);
        builder.a(bS, true);
        builder.a(bT, true);
    }

    public boolean gu() {
        return this.al.a(bS);
    }

    public boolean gv() {
        return this.al.a(bT);
    }

    public boolean gw() {
        boolean hasLeftHorn = this.gu();
        boolean hasRightHorn = this.gv();
        if (!hasLeftHorn && !hasRightHorn) {
            return false;
        }
        DataWatcherObject<Boolean> entityDataAccessor = !hasLeftHorn ? bT : (!hasRightHorn ? bS : (this.ae.h() ? bS : bT));
        this.al.a(entityDataAccessor, false);
        Vec3D vec3 = this.dt();
        ItemStack itemStack = this.m();
        double d2 = MathHelper.b(this.ae, -0.2f, 0.2f);
        double d1 = MathHelper.b(this.ae, 0.3f, 0.7f);
        double d22 = MathHelper.b(this.ae, -0.2f, 0.2f);
        EntityItem itemEntity = new EntityItem(this.dV(), vec3.a(), vec3.b(), vec3.c(), itemStack, d2, d1, d22);
        return this.spawnAtLocation((WorldServer)this.dV(), itemEntity) != null;
    }

    public void gx() {
        this.al.a(bS, true);
        this.al.a(bT, true);
    }

    public void gy() {
        this.al.a(bS, false);
        this.al.a(bT, false);
    }

    public boolean gG() {
        return this.al.a(bR);
    }

    public void w(boolean isScreamingGoat) {
        this.al.a(bR, isScreamingGoat);
    }

    public float gH() {
        return (float)this.bY / 20.0f * 30.0f * ((float)Math.PI / 180);
    }

    public static boolean c(EntityTypes<? extends EntityAnimal> entityType, GeneratorAccess level, EntitySpawnReason spawnReason, BlockPosition pos, RandomSource random) {
        return level.a_(pos.e()).a(TagsBlock.cd) && Goat.a(level, pos);
    }

    public void ram(EntityLiving entity) {
        BehaviorController<Goat> brain = this.ec();
        brain.a(MemoryModuleType.X, entity.dt());
        brain.b(MemoryModuleType.W);
        brain.b(MemoryModuleType.s);
        brain.b(MemoryModuleType.P);
        brain.a(Activity.r);
    }
}

