/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal.horse;

import java.util.function.DoubleSupplier;
import java.util.function.IntUnaryOperator;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.IInventory;
import net.minecraft.world.InventorySubcontainer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntityReference;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.EnumMainHand;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.HasCustomInventoryScreen;
import net.minecraft.world.entity.IJumpable;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.ai.attributes.AttributeBase;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.PathfinderGoalBreed;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFollowParent;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalPanic;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomLookaround;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStrollLand;
import net.minecraft.world.entity.ai.goal.PathfinderGoalTame;
import net.minecraft.world.entity.ai.goal.PathfinderGoalTempt;
import net.minecraft.world.entity.ai.goal.RandomStandGoal;
import net.minecraft.world.entity.ai.targeting.PathfinderTargetCondition;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.animal.horse.EntityLlama;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.vehicle.DismountUtil;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.item.equipment.Equippable;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundEffectType;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec2F;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_21_R4.event.CraftEventFactory;
import org.bukkit.entity.AbstractHorse;
import org.bukkit.event.entity.EntityRegainHealthEvent;
import org.bukkit.inventory.InventoryHolder;

public abstract class EntityHorseAbstract
extends EntityAnimal
implements HasCustomInventoryScreen,
OwnableEntity,
IJumpable {
    public static final int bT = 499;
    public static final int bU = 500;
    public static final double bV = 0.15;
    private static final float bI = (float)EntityHorseAbstract.b(() -> 0.0);
    private static final float bJ = (float)EntityHorseAbstract.b(() -> 1.0);
    private static final float bK = (float)EntityHorseAbstract.a(() -> 0.0);
    private static final float bM = (float)EntityHorseAbstract.a(() -> 1.0);
    private static final float bN = EntityHorseAbstract.a((int i2) -> 0);
    private static final float bO = EntityHorseAbstract.a((int i2) -> i2 - 1);
    private static final float bP = 0.25f;
    private static final float bQ = 0.5f;
    private static final PathfinderTargetCondition.a bR = (entity, level) -> {
        EntityHorseAbstract abstractHorse;
        return entity instanceof EntityHorseAbstract && (abstractHorse = (EntityHorseAbstract)entity).gQ();
    };
    private static final PathfinderTargetCondition bS = PathfinderTargetCondition.b().a(16.0).d().a(bR);
    private static final DataWatcherObject<Byte> cg = DataWatcher.a(EntityHorseAbstract.class, DataWatcherRegistry.a);
    private static final int ch = 2;
    private static final int ci = 8;
    private static final int cj = 16;
    private static final int ck = 32;
    private static final int cl = 64;
    public static final int bW = 3;
    private static final int cm = 0;
    private static final boolean cn = false;
    private static final boolean cq = false;
    private static final boolean cr = false;
    private int cs;
    private int ct;
    private int cu;
    public int bX;
    public int bY;
    protected boolean bZ;
    public InventorySubcontainer ca;
    protected int cb = 0;
    protected float cc;
    protected boolean cd;
    private float cv;
    private float cw;
    private float cx;
    private float cy;
    private float cz;
    private float cA;
    protected boolean ce = true;
    protected int cf;
    @Nullable
    public EntityReference<EntityLiving> cB;
    public int maxDomestication = 100;

    protected EntityHorseAbstract(EntityTypes<? extends EntityHorseAbstract> entityType, World level) {
        super((EntityTypes<? extends EntityAnimal>)entityType, level);
        this.gT();
    }

    @Override
    protected void C() {
        this.bF.a(1, new PathfinderGoalPanic(this, 1.2));
        this.bF.a(1, new PathfinderGoalTame(this, 1.2));
        this.bF.a(2, new PathfinderGoalBreed(this, 1.0, EntityHorseAbstract.class));
        this.bF.a(4, new PathfinderGoalFollowParent(this, 1.0));
        this.bF.a(6, new PathfinderGoalRandomStrollLand(this, 0.7));
        this.bF.a(7, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 6.0f));
        this.bF.a(8, new PathfinderGoalRandomLookaround(this));
        if (this.gv()) {
            this.bF.a(9, new RandomStandGoal(this));
        }
        this.gM();
    }

    protected void gM() {
        this.bF.a(0, new PathfinderGoalFloat(this));
        this.bF.a(3, new PathfinderGoalTempt(this, 1.25, stack -> stack.a(TagsItem.al), false));
    }

    @Override
    protected void a(DataWatcher.a builder) {
        super.a(builder);
        builder.a(cg, (byte)0);
    }

    protected boolean s(int flagId) {
        return (this.al.a(cg) & flagId) != 0;
    }

    protected void d(int flagId, boolean value) {
        byte b2 = this.al.a(cg);
        if (value) {
            this.al.a(cg, (byte)(b2 | flagId));
        } else {
            this.al.a(cg, (byte)(b2 & ~flagId));
        }
    }

    public boolean gL() {
        return this.s(2);
    }

    @Override
    @Nullable
    public EntityReference<EntityLiving> d() {
        return this.cB;
    }

    public void j(@Nullable EntityLiving owner) {
        this.cB = owner != null ? new EntityReference<EntityLiving>(owner) : null;
    }

    public boolean gN() {
        return this.bZ;
    }

    public void x(boolean tamed) {
        this.d(2, tamed);
    }

    public void y(boolean jumping) {
        this.bZ = jumping;
    }

    @Override
    public boolean a(Entity leashHolder, float distance) {
        if (distance > 6.0f && this.gO()) {
            this.A(false);
        }
        return true;
    }

    public boolean gO() {
        return this.s(16);
    }

    public boolean gP() {
        return this.s(32);
    }

    public boolean gQ() {
        return this.s(8);
    }

    public void z(boolean breeding) {
        this.d(8, breeding);
    }

    @Override
    public boolean e(EnumItemSlot slot) {
        return slot != EnumItemSlot.h ? super.e(slot) : this.bJ() && !this.e_() && this.gL();
    }

    public void b(EntityHuman player, ItemStack stack) {
        if (this.a(stack, EnumItemSlot.g)) {
            this.h(stack.b(1, (EntityLiving)player));
        }
    }

    @Override
    protected boolean f(EnumItemSlot slot) {
        return (slot == EnumItemSlot.g || slot == EnumItemSlot.h) && this.gL() || super.f(slot);
    }

    public int gR() {
        return this.cb;
    }

    public void t(int temper) {
        this.cb = temper;
    }

    public int u(int addedTemper) {
        int i2 = MathHelper.a(this.gR() + addedTemper, 0, this.gW());
        this.t(i2);
        return i2;
    }

    @Override
    public boolean isCollidable(boolean ignoreClimbing) {
        return !this.bZ();
    }

    private void m() {
        SoundEffect eatingSound;
        this.u();
        if (!this.ba() && (eatingSound = this.gw()) != null) {
            this.dV().a(null, this.dA(), this.dC(), this.dG(), eatingSound, this.dm(), 1.0f, 1.0f + (this.ae.i() - this.ae.i()) * 0.2f);
        }
    }

    @Override
    public boolean a(double fallDistance, float damageMultiplier, DamageSource damageSource) {
        int i2;
        if (fallDistance > 1.0) {
            this.a(SoundEffects.nr, 0.4f, 1.0f);
        }
        if ((i2 = this.a(fallDistance, damageMultiplier)) <= 0) {
            return false;
        }
        this.a(damageSource, (float)i2);
        this.b(fallDistance, damageMultiplier, damageSource);
        this.eQ();
        return true;
    }

    public final int gS() {
        return EntityHorseAbstract.v(this.ab_());
    }

    public static int v(int columns) {
        return columns * 3;
    }

    public void gT() {
        InventorySubcontainer simpleContainer = this.ca;
        this.ca = new InventorySubcontainer(this.gS(), (InventoryHolder)((AbstractHorse)this.getBukkitEntity()));
        if (simpleContainer != null) {
            int min = Math.min(simpleContainer.b(), this.ca.b());
            for (int i2 = 0; i2 < min; ++i2) {
                ItemStack item = simpleContainer.a(i2);
                if (item.f()) continue;
                this.ca.a(i2, item.v());
            }
        }
    }

    @Override
    protected Holder<SoundEffect> a(EnumItemSlot slot, ItemStack stack, Equippable equippable) {
        return slot == EnumItemSlot.h ? SoundEffects.ns : super.a(slot, stack, equippable);
    }

    @Override
    public boolean a(WorldServer level, DamageSource damageSource, float amount) {
        boolean flag = super.a(level, damageSource, amount);
        if (flag && this.ae.a(3) == 0) {
            this.gZ();
        }
        return flag;
    }

    protected boolean gv() {
        return true;
    }

    @Nullable
    protected SoundEffect gw() {
        return null;
    }

    @Nullable
    protected SoundEffect gU() {
        return null;
    }

    @Override
    protected void b(BlockPosition pos, IBlockData block) {
        if (!block.n()) {
            IBlockData blockState = this.dV().a_(pos.d());
            SoundEffectType soundType = block.A();
            if (blockState.a(Blocks.ed)) {
                soundType = blockState.A();
            }
            if (this.bZ() && this.ce) {
                ++this.cf;
                if (this.cf > 5 && this.cf % 3 == 0) {
                    this.a(soundType);
                } else if (this.cf <= 5) {
                    this.a(SoundEffects.nu, soundType.a() * 0.15f, soundType.b());
                }
            } else if (this.b(soundType)) {
                this.a(SoundEffects.nu, soundType.a() * 0.15f, soundType.b());
            } else {
                this.a(SoundEffects.nt, soundType.a() * 0.15f, soundType.b());
            }
        }
    }

    private boolean b(SoundEffectType soundType) {
        return soundType == SoundEffectType.b || soundType == SoundEffectType.aV || soundType == SoundEffectType.B || soundType == SoundEffectType.aW || soundType == SoundEffectType.aU;
    }

    protected void a(SoundEffectType soundType) {
        this.a(SoundEffects.no, soundType.a() * 0.15f, soundType.b());
    }

    public static AttributeProvider.Builder gV() {
        return EntityAnimal.gz().a(GenericAttributes.o, 0.7).a(GenericAttributes.s, 53.0).a(GenericAttributes.v, 0.225f).a(GenericAttributes.B, 1.0).a(GenericAttributes.x, 6.0).a(GenericAttributes.k, 0.5);
    }

    @Override
    public int fX() {
        return 6;
    }

    public int gW() {
        return this.maxDomestication;
    }

    @Override
    public float fe() {
        return 0.8f;
    }

    @Override
    public int R() {
        return 400;
    }

    @Override
    public void b(EntityHuman player) {
        if (!this.dV().C && (!this.bZ() || this.y(player)) && this.gL()) {
            player.a(this, this.ca);
        }
    }

    public EnumInteractionResult c(EntityHuman player, ItemStack stack) {
        boolean flag = this.a(player, stack);
        if (flag) {
            stack.a(1, (EntityLiving)player);
        }
        return (EnumInteractionResult)((Object)(!flag && !this.dV().C ? EnumInteractionResult.e : EnumInteractionResult.b));
    }

    protected boolean a(EntityHuman player, ItemStack stack) {
        boolean flag = false;
        float f2 = 0.0f;
        int i2 = 0;
        int i1 = 0;
        if (stack.a(Items.qk)) {
            f2 = 2.0f;
            i2 = 20;
            i1 = 3;
        } else if (stack.a(Items.sI)) {
            f2 = 1.0f;
            i2 = 30;
            i1 = 3;
        } else if (stack.a(Blocks.iL.h())) {
            f2 = 20.0f;
            i2 = 180;
        } else if (stack.a(Items.pi)) {
            f2 = 3.0f;
            i2 = 60;
            i1 = 3;
        } else if (stack.a(Items.vu)) {
            f2 = 4.0f;
            i2 = 60;
            i1 = 5;
            if (!this.dV().C && this.gL() && this.Y_() == 0 && !this.gE()) {
                flag = true;
                this.setInLove(player, stack.v());
            }
        } else if (stack.a(Items.qO) || stack.a(Items.qP)) {
            f2 = 10.0f;
            i2 = 240;
            i1 = 10;
            if (!this.dV().C && this.gL() && this.Y_() == 0 && !this.gE()) {
                flag = true;
                this.setInLove(player, stack.v());
            }
        }
        if (this.eG() < this.eU() && f2 > 0.0f) {
            this.heal(f2, EntityRegainHealthEvent.RegainReason.EATING);
            flag = true;
        }
        if (this.e_() && i2 > 0) {
            this.dV().a(Particles.Q, this.d(1.0), this.dD() + 0.5, this.g(1.0), 0.0, 0.0, 0.0);
            if (!this.dV().C) {
                this.b_(i2);
                flag = true;
            }
        }
        if (!(i1 <= 0 || !flag && this.gL() || this.gR() >= this.gW() || this.dV().C)) {
            this.u(i1);
            flag = true;
        }
        if (flag) {
            this.m();
            ((Entity)this).a(GameEvent.m);
        }
        return flag;
    }

    protected void a(EntityHuman player) {
        this.A(false);
        this.B(false);
        if (!this.dV().C) {
            player.w(this.dL());
            player.x(this.dN());
            player.n(this);
        }
    }

    @Override
    public boolean fg() {
        return super.fg() && this.bZ() && this.fZ() || this.gO() || this.gP();
    }

    @Override
    public boolean i(ItemStack stack) {
        return stack.a(TagsItem.ak);
    }

    private void p() {
        this.bX = 1;
    }

    @Override
    protected void f(WorldServer level) {
        super.f(level);
        if (this.ca != null) {
            for (int i2 = 0; i2 < this.ca.b(); ++i2) {
                ItemStack item = this.ca.a(i2);
                if (item.f() || EnchantmentManager.a(item, EnchantmentEffectComponents.D)) continue;
                this.a(level, item);
            }
        }
    }

    @Override
    public void d_() {
        if (this.ae.a(200) == 0) {
            this.p();
        }
        super.d_();
        World world = this.dV();
        if (world instanceof WorldServer) {
            WorldServer serverLevel = (WorldServer)world;
            if (this.bJ()) {
                if (this.ae.a(900) == 0 && this.aP == 0) {
                    this.heal(1.0f, EntityRegainHealthEvent.RegainReason.REGEN);
                }
                if (this.gX()) {
                    if (!this.gO() && !this.bZ() && this.ae.a(300) == 0 && serverLevel.a_(this.dv().e()).a(Blocks.i)) {
                        this.A(true);
                    }
                    if (this.gO() && ++this.cs > 50) {
                        this.cs = 0;
                        this.A(false);
                    }
                }
                this.g(serverLevel);
            }
        }
    }

    protected void g(WorldServer level) {
        EntityHorseAbstract nearestEntity;
        if (this.gQ() && this.e_() && !this.gO() && (nearestEntity = level.a(EntityHorseAbstract.class, bS, this, this.dA(), this.dC(), this.dG(), this.cR().g(16.0))) != null && this.g((Entity)nearestEntity) > 4.0) {
            this.bE.a((Entity)nearestEntity, 0);
        }
    }

    public boolean gX() {
        return true;
    }

    @Override
    public void g() {
        super.g();
        if (this.ct > 0 && ++this.ct > 30) {
            this.ct = 0;
            this.d(64, false);
        }
        if (this.dj() && this.cu > 0 && ++this.cu > 20) {
            this.cu = 0;
            this.B(false);
        }
        if (this.bX > 0 && ++this.bX > 8) {
            this.bX = 0;
        }
        if (this.bY > 0) {
            ++this.bY;
            if (this.bY > 300) {
                this.bY = 0;
            }
        }
        this.cw = this.cv;
        if (this.gO()) {
            this.cv += (1.0f - this.cv) * 0.4f + 0.05f;
            if (this.cv > 1.0f) {
                this.cv = 1.0f;
            }
        } else {
            this.cv += (0.0f - this.cv) * 0.4f - 0.05f;
            if (this.cv < 0.0f) {
                this.cv = 0.0f;
            }
        }
        this.cy = this.cx;
        if (this.gP()) {
            this.cw = this.cv = 0.0f;
            this.cx += (1.0f - this.cx) * 0.4f + 0.05f;
            if (this.cx > 1.0f) {
                this.cx = 1.0f;
            }
        } else {
            this.cd = false;
            this.cx += (0.8f * this.cx * this.cx * this.cx - this.cx) * 0.6f - 0.05f;
            if (this.cx < 0.0f) {
                this.cx = 0.0f;
            }
        }
        this.cA = this.cz;
        if (this.s(64)) {
            this.cz += (1.0f - this.cz) * 0.7f + 0.05f;
            if (this.cz > 1.0f) {
                this.cz = 1.0f;
            }
        } else {
            this.cz += (0.0f - this.cz) * 0.7f - 0.05f;
            if (this.cz < 0.0f) {
                this.cz = 0.0f;
            }
        }
    }

    public void setMouthOpen(boolean open) {
        this.d(64, open);
    }

    public boolean isMouthOpen() {
        return this.s(64);
    }

    @Override
    public EnumInteractionResult b(EntityHuman player, EnumHand hand) {
        if (this.bZ() || this.e_()) {
            return super.b(player, hand);
        }
        if (this.gL() && player.fY()) {
            this.b(player);
            return EnumInteractionResult.a;
        }
        ItemStack itemInHand = player.b(hand);
        if (!itemInHand.f()) {
            EnumInteractionResult interactionResult = itemInHand.a(player, (EntityLiving)this, hand);
            if (interactionResult.a()) {
                return interactionResult;
            }
            if (this.a(itemInHand, EnumItemSlot.g) && !this.ga()) {
                this.b(player, itemInHand);
                return EnumInteractionResult.a;
            }
        }
        this.a(player);
        return EnumInteractionResult.a;
    }

    private void u() {
        if (!this.dV().C) {
            this.ct = 1;
            this.d(64, true);
        }
    }

    public void A(boolean eating) {
        this.d(16, eating);
    }

    public void setForceStanding(boolean standing) {
        this.d(32, standing);
    }

    public void B(boolean standing) {
        if (standing) {
            this.A(false);
        }
        this.d(32, standing);
    }

    @Nullable
    public SoundEffect gY() {
        return this.s();
    }

    public void gZ() {
        if (this.gv() && this.dj()) {
            this.cu = 1;
            this.B(true);
        }
    }

    public void ha() {
        if (!this.gP()) {
            this.gZ();
            this.b(this.gU());
        }
    }

    public boolean f(EntityHuman player) {
        this.j(player);
        this.x(true);
        if (player instanceof EntityPlayer) {
            CriterionTriggers.y.a((EntityPlayer)player, this);
        }
        this.dV().a((Entity)this, (byte)7);
        return true;
    }

    @Override
    protected void a(EntityHuman player, Vec3D travelVector) {
        super.a(player, travelVector);
        Vec2F riddenRotation = this.i(player);
        this.b(riddenRotation.k, riddenRotation.j);
        this.aV = this.aX = this.dL();
        this.N = this.aX;
        if (this.dg()) {
            if (travelVector.f <= 0.0) {
                this.cf = 0;
            }
            if (this.aH()) {
                this.y(false);
                if (this.cc > 0.0f && !this.gN()) {
                    this.b(this.cc, travelVector);
                }
                this.cc = 0.0f;
            }
        }
    }

    protected Vec2F i(EntityLiving entity) {
        return new Vec2F(entity.dN() * 0.5f, entity.dL());
    }

    @Override
    protected Vec3D b(EntityHuman player, Vec3D travelVector) {
        if (this.aH() && this.cc == 0.0f && this.gP() && !this.cd) {
            return Vec3D.c;
        }
        float f2 = player.bg * 0.5f;
        float f1 = player.bi;
        if (f1 <= 0.0f) {
            f1 *= 0.25f;
        }
        return new Vec3D(f2, 0.0, f1);
    }

    @Override
    protected float c(EntityHuman player) {
        return (float)this.h(GenericAttributes.v);
    }

    protected void b(float playerJumpPendingScale, Vec3D travelVector) {
        double d2 = this.z(playerJumpPendingScale);
        Vec3D deltaMovement = this.dy();
        this.n(deltaMovement.d, d2, deltaMovement.f);
        this.y(true);
        this.ar = true;
        if (travelVector.f > 0.0) {
            float sin = MathHelper.a(this.dL() * ((float)Math.PI / 180));
            float cos = MathHelper.b(this.dL() * ((float)Math.PI / 180));
            this.i(this.dy().b(-0.4f * sin * playerJumpPendingScale, 0.0, 0.4f * cos * playerJumpPendingScale));
        }
    }

    protected void hb() {
        this.a(SoundEffects.nq, 0.4f, 1.0f);
    }

    @Override
    public void b(NBTTagCompound compound) {
        super.b(compound);
        compound.a("EatingHaystack", this.gO());
        compound.a("Bred", this.gQ());
        compound.a("Temper", this.gR());
        compound.a("Tame", this.gL());
        if (this.cB != null) {
            this.cB.a(compound, "Owner");
        }
        compound.a("Bukkit.MaxDomestication", this.maxDomestication);
    }

    @Override
    public void a(NBTTagCompound compound) {
        super.a(compound);
        this.A(compound.b("EatingHaystack", false));
        this.z(compound.b("Bred", false));
        this.t(compound.b("Temper", 0));
        this.x(compound.b("Tame", false));
        this.cB = EntityReference.a(compound, "Owner", this.dV());
        this.maxDomestication = compound.b("Bukkit.MaxDomestication", this instanceof EntityLlama ? 30 : 100);
    }

    @Override
    public boolean a(EntityAnimal otherAnimal) {
        return false;
    }

    protected boolean hc() {
        return !this.bZ() && !this.bY() && this.gL() && !this.e_() && this.eG() >= this.eU() && this.gE();
    }

    @Override
    @Nullable
    public EntityAgeable a(WorldServer level, EntityAgeable otherParent) {
        return null;
    }

    protected void a(EntityAgeable parent, EntityHorseAbstract child) {
        this.a(parent, child, GenericAttributes.s, (double)bN, (double)bO);
        this.a(parent, child, GenericAttributes.o, (double)bK, (double)bM);
        this.a(parent, child, GenericAttributes.v, (double)bI, (double)bJ);
    }

    private void a(EntityAgeable parent, EntityHorseAbstract child, Holder<AttributeBase> attribute, double min, double max) {
        double d2 = EntityHorseAbstract.a(this.i(attribute), parent.i(attribute), min, max, this.ae);
        child.g(attribute).a(d2);
    }

    static double a(double value1, double value2, double min, double max, RandomSource random) {
        double d3;
        if (max <= min) {
            throw new IllegalArgumentException("Incorrect range for an attribute");
        }
        value1 = MathHelper.a(value1, min, max);
        value2 = MathHelper.a(value2, min, max);
        double d2 = 0.15 * (max - min);
        double d22 = (value1 + value2) / 2.0;
        double d1 = Math.abs(value1 - value2) + d2 * 2.0;
        double d4 = d22 + d1 * (d3 = (random.j() + random.j() + random.j()) / 3.0 - 0.5);
        if (d4 > max) {
            double d5 = d4 - max;
            return max - d5;
        }
        if (d4 < min) {
            double d5 = min - d4;
            return min + d5;
        }
        return d4;
    }

    public float J(float partialTick) {
        return MathHelper.h(partialTick, this.cw, this.cv);
    }

    public float K(float partialTick) {
        return MathHelper.h(partialTick, this.cy, this.cx);
    }

    public float L(float partialTick) {
        return MathHelper.h(partialTick, this.cA, this.cz);
    }

    @Override
    public void b(int jumpPower) {
        if (this.fZ()) {
            if (jumpPower < 0) {
                jumpPower = 0;
            } else {
                this.cd = true;
                this.gZ();
            }
            this.cc = jumpPower >= 90 ? 1.0f : 0.4f + 0.4f * (float)jumpPower / 90.0f;
        }
    }

    @Override
    public boolean a() {
        return this.fZ();
    }

    @Override
    public void c(int jumpPower) {
        float power = jumpPower >= 90 ? 1.0f : 0.4f + 0.4f * (float)jumpPower / 90.0f;
        if (!CraftEventFactory.callHorseJumpEvent(this, power)) {
            return;
        }
        this.cd = true;
        this.gZ();
        this.hb();
    }

    @Override
    public void b() {
    }

    protected void C(boolean tamed) {
        ParticleType particleOptions = tamed ? Particles.S : Particles.ah;
        for (int i2 = 0; i2 < 7; ++i2) {
            double d2 = this.ae.k() * 0.02;
            double d1 = this.ae.k() * 0.02;
            double d22 = this.ae.k() * 0.02;
            this.dV().a(particleOptions, this.d(1.0), this.dD() + 0.5, this.g(1.0), d2, d1, d22);
        }
    }

    @Override
    public void b(byte id) {
        if (id == 7) {
            this.C(true);
        } else if (id == 6) {
            this.C(false);
        } else {
            super.b(id);
        }
    }

    @Override
    protected void a(Entity passenger, Entity.MoveFunction callback) {
        super.a(passenger, callback);
        if (passenger instanceof EntityLiving) {
            ((EntityLiving)passenger).aV = this.aV;
        }
    }

    protected static float a(IntUnaryOperator operator) {
        return 15.0f + (float)operator.applyAsInt(8) + (float)operator.applyAsInt(9);
    }

    protected static double a(DoubleSupplier supplier) {
        return (double)0.4f + supplier.getAsDouble() * 0.2 + supplier.getAsDouble() * 0.2 + supplier.getAsDouble() * 0.2;
    }

    protected static double b(DoubleSupplier supplier) {
        return ((double)0.45f + supplier.getAsDouble() * 0.3 + supplier.getAsDouble() * 0.3 + supplier.getAsDouble() * 0.3) * 0.25;
    }

    @Override
    public boolean k_() {
        return false;
    }

    @Override
    public SlotAccess a_(int slot) {
        int i2 = slot - 500;
        return i2 >= 0 && i2 < this.ca.b() ? SlotAccess.a(this.ca, i2) : super.a_(slot);
    }

    @Override
    @Nullable
    public EntityLiving cW() {
        EntityLiving entityLiving;
        Entity entity;
        if (this.fZ() && (entity = this.cZ()) instanceof EntityHuman) {
            EntityHuman player = (EntityHuman)entity;
            entityLiving = player;
        } else {
            entityLiving = super.cW();
        }
        return entityLiving;
    }

    @Nullable
    private Vec3D a(Vec3D direction, EntityLiving passenger) {
        double d2 = this.dA() + direction.d;
        double d1 = this.cR().b;
        double d22 = this.dG() + direction.f;
        BlockPosition.MutableBlockPosition mutableBlockPos = new BlockPosition.MutableBlockPosition();
        block0: for (EntityPose pose : passenger.fO()) {
            mutableBlockPos.b(d2, d1, d22);
            double d3 = this.cR().e + 0.75;
            do {
                double blockFloorHeight = this.dV().j(mutableBlockPos);
                if ((double)mutableBlockPos.v() + blockFloorHeight > d3) continue block0;
                if (DismountUtil.a(blockFloorHeight)) {
                    AxisAlignedBB localBoundsForPose = passenger.f(pose);
                    Vec3D vec3 = new Vec3D(d2, (double)mutableBlockPos.v() + blockFloorHeight, d22);
                    if (DismountUtil.a(this.dV(), passenger, localBoundsForPose.c(vec3))) {
                        passenger.b(pose);
                        return vec3;
                    }
                }
                mutableBlockPos.c(EnumDirection.b);
            } while (!((double)mutableBlockPos.v() < d3));
        }
        return null;
    }

    @Override
    public Vec3D b(EntityLiving livingEntity) {
        Vec3D collisionHorizontalEscapeVector = EntityHorseAbstract.a(this.dq(), (double)livingEntity.dq(), this.dL() + (livingEntity.fy() == EnumMainHand.b ? 90.0f : -90.0f));
        Vec3D dismountLocationInDirection = this.a(collisionHorizontalEscapeVector, livingEntity);
        if (dismountLocationInDirection != null) {
            return dismountLocationInDirection;
        }
        Vec3D collisionHorizontalEscapeVector1 = EntityHorseAbstract.a(this.dq(), (double)livingEntity.dq(), this.dL() + (livingEntity.fy() == EnumMainHand.a ? 90.0f : -90.0f));
        Vec3D dismountLocationInDirection1 = this.a(collisionHorizontalEscapeVector1, livingEntity);
        return dismountLocationInDirection1 != null ? dismountLocationInDirection1 : this.dt();
    }

    protected void a(RandomSource random) {
    }

    @Override
    @Nullable
    public GroupDataEntity a(WorldAccess level, DifficultyDamageScaler difficulty, EntitySpawnReason spawnReason, @Nullable GroupDataEntity spawnGroupData) {
        if (spawnGroupData == null) {
            spawnGroupData = new EntityAgeable.a(0.2f);
        }
        this.a(level.G_());
        return super.a(level, difficulty, spawnReason, spawnGroupData);
    }

    public boolean a(IInventory inventory) {
        return this.ca != inventory;
    }

    public int hd() {
        return this.R();
    }

    @Override
    protected Vec3D a(Entity entity, EntitySize dimensions, float partialTick) {
        return super.a(entity, dimensions, partialTick).e(new Vec3D(0.0, 0.15 * (double)this.cy * (double)partialTick, -0.7 * (double)this.cy * (double)partialTick).b(-this.dL() * ((float)Math.PI / 180)));
    }

    public int ab_() {
        return 0;
    }
}

