/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal.horse;

import com.mojang.serialization.Codec;
import io.netty.buffer.ByteBuf;
import java.util.function.IntFunction;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.INamable;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityAttachment;
import net.minecraft.world.entity.EntityAttachments;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.goal.PathfinderGoalArrowAttack;
import net.minecraft.world.entity.ai.goal.PathfinderGoalBreed;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFollowParent;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLlamaFollow;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalPanic;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomLookaround;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStrollLand;
import net.minecraft.world.entity.ai.goal.PathfinderGoalTame;
import net.minecraft.world.entity.ai.goal.PathfinderGoalTempt;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalHurtByTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.animal.horse.EntityHorseChestedAbstract;
import net.minecraft.world.entity.animal.wolf.EntityWolf;
import net.minecraft.world.entity.monster.IRangedEntity;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.EntityLlamaSpit;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.event.entity.EntityRegainHealthEvent;

public class EntityLlama
extends EntityHorseChestedAbstract
implements IRangedEntity {
    private static final int bI = 5;
    private static final DataWatcherObject<Integer> bJ = DataWatcher.a(EntityLlama.class, DataWatcherRegistry.b);
    private static final DataWatcherObject<Integer> bK = DataWatcher.a(EntityLlama.class, DataWatcherRegistry.b);
    private static final EntitySize bM = EntityTypes.ay.n().a(EntityAttachments.a().a(EntityAttachment.a, 0.0f, EntityTypes.ay.m() - 0.8125f, -0.3f)).a(0.5f);
    boolean bN;
    @Nullable
    private EntityLlama bO;
    @Nullable
    public EntityLlama bP;

    public EntityLlama(EntityTypes<? extends EntityLlama> entityType, World level) {
        super((EntityTypes<? extends EntityHorseChestedAbstract>)entityType, level);
        this.N().a(40.0f);
        this.maxDomestication = 30;
    }

    public boolean gx() {
        return false;
    }

    public void setStrengthPublic(int strength) {
        this.w(strength);
    }

    private void w(int strength) {
        this.al.a(bJ, Math.max(1, Math.min(5, strength)));
    }

    private void b(RandomSource random) {
        int i2 = random.i() < 0.04f ? 5 : 3;
        this.w(1 + random.a(i2));
    }

    public int gy() {
        return this.al.a(bJ);
    }

    @Override
    public void b(NBTTagCompound compound) {
        super.b(compound);
        compound.a("Variant", Variant.g, this.gH());
        compound.a("Strength", this.gy());
    }

    @Override
    public void a(NBTTagCompound compound) {
        this.w(compound.b("Strength", 0));
        super.a(compound);
        this.a(compound.a("Variant", Variant.g).orElse(Variant.e));
    }

    @Override
    protected void C() {
        this.bF.a(0, new PathfinderGoalFloat(this));
        this.bF.a(1, new PathfinderGoalTame(this, 1.2));
        this.bF.a(2, new PathfinderGoalLlamaFollow(this, 2.1f));
        this.bF.a(3, new PathfinderGoalArrowAttack(this, 1.25, 40, 20.0f));
        this.bF.a(3, new PathfinderGoalPanic(this, 1.2));
        this.bF.a(4, new PathfinderGoalBreed(this, 1.0));
        this.bF.a(5, new PathfinderGoalTempt(this, 1.25, itemStack -> itemStack.a(TagsItem.at), false));
        this.bF.a(6, new PathfinderGoalFollowParent(this, 1.0));
        this.bF.a(7, new PathfinderGoalRandomStrollLand(this, 0.7));
        this.bF.a(8, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 6.0f));
        this.bF.a(9, new PathfinderGoalRandomLookaround(this));
        this.bG.a(1, new c(this));
        this.bG.a(2, new a(this));
    }

    public static AttributeProvider.Builder gG() {
        return EntityLlama.m();
    }

    @Override
    protected void a(DataWatcher.a builder) {
        super.a(builder);
        builder.a(bJ, 0);
        builder.a(bK, 0);
    }

    public Variant gH() {
        return Variant.a(this.al.a(bK));
    }

    public void a(Variant variant) {
        this.al.a(bK, variant.j);
    }

    @Override
    @Nullable
    public <T> T a(DataComponentType<? extends T> component) {
        return component == DataComponents.aN ? EntityLlama.c(component, this.gH()) : super.a(component);
    }

    @Override
    protected void a(DataComponentGetter componentGetter) {
        this.a(componentGetter, DataComponents.aN);
        super.a(componentGetter);
    }

    @Override
    protected <T> boolean b(DataComponentType<T> component, T value) {
        if (component == DataComponents.aN) {
            this.a(EntityLlama.c(DataComponents.aN, value));
            return true;
        }
        return super.b(component, value);
    }

    @Override
    public boolean i(ItemStack stack) {
        return stack.a(TagsItem.as);
    }

    @Override
    protected boolean a(EntityHuman player, ItemStack stack) {
        SoundEffect eatingSound;
        int i2 = 0;
        int i1 = 0;
        float f2 = 0.0f;
        boolean flag = false;
        if (stack.a(Items.qk)) {
            i2 = 10;
            i1 = 3;
            f2 = 2.0f;
        } else if (stack.a(Blocks.iL.h())) {
            i2 = 90;
            i1 = 6;
            f2 = 10.0f;
            if (this.gL() && this.Y_() == 0 && this.gB()) {
                flag = true;
                this.setInLove(player, stack.v());
            }
        }
        if (this.eG() < this.eU() && f2 > 0.0f) {
            this.heal(f2, EntityRegainHealthEvent.RegainReason.EATING);
            flag = true;
        }
        if (this.e_() && i2 > 0) {
            this.dV().a(Particles.Q, this.d(1.0), this.dD() + 0.5, this.g(1.0), 0.0, 0.0, 0.0);
            if (!this.dV().C) {
                this.b_(i2);
                flag = true;
            }
        }
        if (!(i1 <= 0 || !flag && this.gL() || this.gR() >= this.gW() || this.dV().C)) {
            this.u(i1);
            flag = true;
        }
        if (flag && !this.ba() && (eatingSound = this.gw()) != null) {
            this.dV().a(null, this.dA(), this.dC(), this.dG(), this.gw(), this.dm(), 1.0f, 1.0f + (this.ae.i() - this.ae.i()) * 0.2f);
        }
        return flag;
    }

    @Override
    public boolean fg() {
        return this.eH() || this.gO();
    }

    @Override
    @Nullable
    public GroupDataEntity a(WorldAccess level, DifficultyDamageScaler difficulty, EntitySpawnReason spawnReason, @Nullable GroupDataEntity spawnGroupData) {
        Variant variant;
        RandomSource random = level.G_();
        this.b(random);
        if (spawnGroupData instanceof b) {
            variant = ((b)spawnGroupData).a;
        } else {
            variant = SystemUtils.a(Variant.values(), random);
            spawnGroupData = new b(variant);
        }
        this.a(variant);
        return super.a(level, difficulty, spawnReason, spawnGroupData);
    }

    @Override
    protected boolean gv() {
        return false;
    }

    @Override
    protected SoundEffect gU() {
        return SoundEffects.oL;
    }

    @Override
    public SoundEffect s() {
        return SoundEffects.oK;
    }

    @Override
    public SoundEffect e(DamageSource damageSource) {
        return SoundEffects.oP;
    }

    @Override
    public SoundEffect j_() {
        return SoundEffects.oN;
    }

    @Override
    @Nullable
    protected SoundEffect gw() {
        return SoundEffects.oO;
    }

    @Override
    protected void b(BlockPosition pos, IBlockData block) {
        this.a(SoundEffects.oR, 0.15f, 1.0f);
    }

    @Override
    protected void u() {
        this.a(SoundEffects.oM, 1.0f, (this.ae.i() - this.ae.i()) * 0.2f + 1.0f);
    }

    @Override
    public int ab_() {
        return this.p() ? this.gy() : 0;
    }

    @Override
    public boolean e(EnumItemSlot slot) {
        return true;
    }

    @Override
    public int gW() {
        return super.gW();
    }

    @Override
    public boolean a(EntityAnimal otherAnimal) {
        return otherAnimal != this && otherAnimal instanceof EntityLlama && this.hc() && ((EntityLlama)otherAnimal).hc();
    }

    @Nullable
    public EntityLlama b(WorldServer level, EntityAgeable otherParent) {
        EntityLlama llama = this.gI();
        if (llama != null) {
            this.a(otherParent, llama);
            EntityLlama llama1 = (EntityLlama)otherParent;
            int i2 = this.ae.a(Math.max(this.gy(), llama1.gy())) + 1;
            if (this.ae.i() < 0.03f) {
                ++i2;
            }
            llama.w(i2);
            llama.a(this.ae.h() ? this.gH() : llama1.gH());
        }
        return llama;
    }

    @Nullable
    protected EntityLlama gI() {
        return EntityTypes.ay.a(this.dV(), EntitySpawnReason.e);
    }

    private void k(EntityLiving target) {
        EntityLlamaSpit llamaSpit = new EntityLlamaSpit(this.dV(), this);
        double d2 = target.dA() - this.dA();
        double d1 = target.e(0.3333333333333333) - llamaSpit.dC();
        double d22 = target.dG() - this.dG();
        double d3 = Math.sqrt(d2 * d2 + d22 * d22) * (double)0.2f;
        World world = this.dV();
        if (world instanceof WorldServer) {
            WorldServer serverLevel = (WorldServer)world;
            IProjectile.a(llamaSpit, serverLevel, ItemStack.l, d2, d1 + d3, d22, 1.5f, 10.0f);
        }
        if (!this.ba()) {
            this.dV().a(null, this.dA(), this.dC(), this.dG(), SoundEffects.oQ, this.dm(), 1.0f, 1.0f + (this.ae.i() - this.ae.i()) * 0.2f);
        }
        this.bN = true;
    }

    void D(boolean didSpit) {
        this.bN = didSpit;
    }

    @Override
    public boolean a(double fallDistance, float damageMultiplier, DamageSource damageSource) {
        int i2 = this.a(fallDistance, damageMultiplier);
        if (i2 <= 0) {
            return false;
        }
        if (fallDistance >= 6.0) {
            this.a(damageSource, (float)i2);
            this.b(fallDistance, damageMultiplier, damageSource);
        }
        this.eQ();
        return true;
    }

    public void gJ() {
        if (this.bO != null) {
            this.bO.bP = null;
        }
        this.bO = null;
    }

    public void a(EntityLlama caravanHead) {
        this.bO = caravanHead;
        this.bO.bP = this;
    }

    public boolean gK() {
        return this.bP != null;
    }

    public boolean he() {
        return this.bO != null;
    }

    @Nullable
    public EntityLlama hf() {
        return this.bO;
    }

    @Override
    protected double gt() {
        return 2.0;
    }

    @Override
    protected void g(WorldServer level) {
        if (!this.he() && this.e_()) {
            super.g(level);
        }
    }

    @Override
    public boolean gX() {
        return false;
    }

    @Override
    public void a(EntityLiving target, float distanceFactor) {
        this.k(target);
    }

    @Override
    public Vec3D cT() {
        return new Vec3D(0.0, 0.75 * (double)this.cS(), (double)this.dq() * 0.5);
    }

    @Override
    public EntitySize e(EntityPose pose) {
        return this.e_() ? bM : super.e(pose);
    }

    @Override
    protected Vec3D a(Entity entity, EntitySize dimensions, float partialTick) {
        return EntityLlama.a((Entity)this, entity, dimensions.d());
    }

    public static final class Variant
    extends Enum<Variant>
    implements INamable {
        public static final /* enum */ Variant a = new Variant(0, "creamy");
        public static final /* enum */ Variant b = new Variant(1, "white");
        public static final /* enum */ Variant c = new Variant(2, "brown");
        public static final /* enum */ Variant d = new Variant(3, "gray");
        public static final Variant e;
        private static final IntFunction<Variant> i;
        public static final Codec<Variant> f;
        @Deprecated
        public static final Codec<Variant> g;
        public static final StreamCodec<ByteBuf, Variant> h;
        final int j;
        private final String k;
        private static final /* synthetic */ Variant[] l;

        public static Variant[] values() {
            return (Variant[])l.clone();
        }

        public static Variant valueOf(String name) {
            return Enum.valueOf(Variant.class, name);
        }

        private Variant(int id, String name) {
            this.j = id;
            this.k = name;
        }

        public int a() {
            return this.j;
        }

        public static Variant a(int id) {
            return i.apply(id);
        }

        @Override
        public String c() {
            return this.k;
        }

        private static /* synthetic */ Variant[] b() {
            return new Variant[]{a, b, c, d};
        }

        static {
            l = Variant.b();
            e = a;
            i = ByIdMap.a(Variant::a, Variant.values(), ByIdMap.a.c);
            f = INamable.a(Variant::values);
            g = Codec.INT.xmap(i::apply, Variant::a);
            h = ByteBufCodecs.a(i, Variant::a);
        }
    }

    static class c
    extends PathfinderGoalHurtByTarget {
        public c(EntityLlama llama) {
            super(llama, new Class[0]);
        }

        @Override
        public boolean c() {
            EntityInsentient entityInsentient = this.e;
            if (entityInsentient instanceof EntityLlama) {
                EntityLlama llama = (EntityLlama)entityInsentient;
                if (llama.bN) {
                    llama.D(false);
                    return false;
                }
            }
            return super.c();
        }
    }

    static class a
    extends PathfinderGoalNearestAttackableTarget<EntityWolf> {
        public a(EntityLlama llama) {
            super(llama, EntityWolf.class, 16, false, true, (entity, level) -> !((EntityWolf)entity).m());
        }

        @Override
        protected double l() {
            return super.l() * 0.25;
        }
    }

    static class b
    extends EntityAgeable.a {
        public final Variant a;

        b(Variant variant) {
            super(true);
            this.a = variant;
        }
    }
}

