/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal.sheep;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.ARGB;
import net.minecraft.util.MathHelper;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.IShearable;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.PathfinderGoalBreed;
import net.minecraft.world.entity.ai.goal.PathfinderGoalEatTile;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFollowParent;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalPanic;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomLookaround;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStrollLand;
import net.minecraft.world.entity.ai.goal.PathfinderGoalTempt;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.animal.sheep.SheepColorSpawnRules;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.EnumColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.loot.LootTables;
import org.bukkit.craftbukkit.v1_21_R4.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_21_R4.inventory.CraftItemStack;
import org.bukkit.entity.Sheep;
import org.bukkit.event.entity.SheepRegrowWoolEvent;
import org.bukkit.event.player.PlayerShearEntityEvent;

public class EntitySheep
extends EntityAnimal
implements IShearable {
    private static final int bI = 40;
    private static final DataWatcherObject<Byte> bJ = DataWatcher.a(EntitySheep.class, DataWatcherRegistry.a);
    private static final Map<EnumColor, Integer> bK = SystemUtils.a(EnumColor.class, EntitySheep::c);
    private static final EnumColor bM = EnumColor.a;
    private static final boolean bN = false;
    private int bO;
    private PathfinderGoalEatTile bP;

    private static int c(EnumColor color) {
        if (color == EnumColor.a) {
            return -1644826;
        }
        int textureDiffuseColor = color.d();
        float f2 = 0.75f;
        return ARGB.a(255, MathHelper.d((float)ARGB.b(textureDiffuseColor) * 0.75f), MathHelper.d((float)ARGB.c(textureDiffuseColor) * 0.75f), MathHelper.d((float)ARGB.d(textureDiffuseColor) * 0.75f));
    }

    public static int a(EnumColor color) {
        return bK.get(color);
    }

    public EntitySheep(EntityTypes<? extends EntitySheep> entityType, World level) {
        super((EntityTypes<? extends EntityAnimal>)entityType, level);
    }

    @Override
    protected void C() {
        this.bP = new PathfinderGoalEatTile(this);
        this.bF.a(0, new PathfinderGoalFloat(this));
        this.bF.a(1, new PathfinderGoalPanic(this, 1.25));
        this.bF.a(2, new PathfinderGoalBreed(this, 1.0));
        this.bF.a(3, new PathfinderGoalTempt(this, 1.1, stack -> stack.a(TagsItem.ah), false));
        this.bF.a(4, new PathfinderGoalFollowParent(this, 1.1));
        this.bF.a(5, this.bP);
        this.bF.a(6, new PathfinderGoalRandomStrollLand(this, 1.0));
        this.bF.a(7, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 6.0f));
        this.bF.a(8, new PathfinderGoalRandomLookaround(this));
    }

    @Override
    public boolean i(ItemStack stack) {
        return stack.a(TagsItem.ah);
    }

    @Override
    protected void a(WorldServer level) {
        this.bO = this.bP.h();
        super.a(level);
    }

    @Override
    public void d_() {
        if (this.dV().C) {
            this.bO = Math.max(0, this.bO - 1);
        }
        super.d_();
    }

    public static AttributeProvider.Builder m() {
        return EntityAnimal.gz().a(GenericAttributes.s, 8.0).a(GenericAttributes.v, 0.23f);
    }

    @Override
    protected void a(DataWatcher.a builder) {
        super.a(builder);
        builder.a(bJ, (byte)0);
    }

    @Override
    public void b(byte id) {
        if (id == 10) {
            this.bO = 40;
        } else {
            super.b(id);
        }
    }

    public float J(float partialTick) {
        if (this.bO <= 0) {
            return 0.0f;
        }
        if (this.bO >= 4 && this.bO <= 36) {
            return 1.0f;
        }
        return this.bO < 4 ? ((float)this.bO - partialTick) / 4.0f : -((float)(this.bO - 40) - partialTick) / 4.0f;
    }

    public float K(float partialTick) {
        if (this.bO > 4 && this.bO <= 36) {
            float f2 = ((float)(this.bO - 4) - partialTick) / 32.0f;
            return 0.62831855f + 0.21991149f * MathHelper.a(f2 * 28.7f);
        }
        return this.bO > 0 ? 0.62831855f : this.k(partialTick) * ((float)Math.PI / 180);
    }

    @Override
    public EnumInteractionResult b(EntityHuman player, EnumHand hand) {
        ItemStack itemInHand = player.b(hand);
        if (itemInHand.a(Items.td)) {
            World world = this.dV();
            if (world instanceof WorldServer) {
                WorldServer serverLevel = (WorldServer)world;
                if (this.a()) {
                    List<ItemStack> drops = this.generateDefaultDrops(serverLevel, itemInHand);
                    PlayerShearEntityEvent event = CraftEventFactory.handlePlayerShearEntityEvent(player, this, itemInHand, hand, drops);
                    if (event != null) {
                        if (event.isCancelled()) {
                            return EnumInteractionResult.e;
                        }
                        drops = CraftItemStack.asNMSCopy(event.getDrops());
                    }
                    this.shear(serverLevel, SoundCategory.h, itemInHand, drops);
                    this.a(GameEvent.M, (Entity)player);
                    itemInHand.a(1, (EntityLiving)player, EntitySheep.d(hand));
                    return EnumInteractionResult.b;
                }
            }
            return EnumInteractionResult.c;
        }
        return super.b(player, hand);
    }

    @Override
    public void a(WorldServer level, SoundCategory soundSource, ItemStack shears) {
        this.shear(level, soundSource, shears, this.generateDefaultDrops(level, shears));
    }

    @Override
    public List<ItemStack> generateDefaultDrops(WorldServer serverLevel, ItemStack shears) {
        ObjectArrayList drops = new ObjectArrayList();
        this.a(serverLevel, LootTables.aV, shears, (arg_0, arg_1) -> EntitySheep.lambda$generateDefaultDrops$1((List)drops, arg_0, arg_1));
        return drops;
    }

    @Override
    public void shear(WorldServer level, SoundCategory soundSource, ItemStack shears, List<ItemStack> drops) {
        level.a(null, this, SoundEffects.xr, soundSource, 1.0f, 1.0f);
        drops.forEach(itemStack -> {
            this.forceDrops = true;
            EntityItem itemEntity = this.a(level, (ItemStack)itemStack, 1.0f);
            this.forceDrops = false;
            if (itemEntity != null) {
                itemEntity.i(itemEntity.dy().b((this.ae.i() - this.ae.i()) * 0.1f, this.ae.i() * 0.05f, (this.ae.i() - this.ae.i()) * 0.1f));
            }
        });
        this.w(true);
    }

    @Override
    public boolean a() {
        return this.bJ() && !this.u() && !this.e_();
    }

    @Override
    public void b(NBTTagCompound compound) {
        super.b(compound);
        compound.a("Sheared", this.u());
        compound.a("Color", EnumColor.s, this.p());
    }

    @Override
    public void a(NBTTagCompound compound) {
        super.a(compound);
        this.w(compound.b("Sheared", false));
        this.b(compound.a("Color", EnumColor.s).orElse(bM));
    }

    @Override
    public SoundEffect s() {
        return SoundEffects.xo;
    }

    @Override
    public SoundEffect e(DamageSource damageSource) {
        return SoundEffects.xq;
    }

    @Override
    public SoundEffect j_() {
        return SoundEffects.xp;
    }

    @Override
    protected void b(BlockPosition pos, IBlockData state) {
        this.a(SoundEffects.xs, 0.15f, 1.0f);
    }

    public EnumColor p() {
        return EnumColor.a(this.al.a(bJ) & 0xF);
    }

    public void b(EnumColor color) {
        byte b2 = this.al.a(bJ);
        this.al.a(bJ, (byte)(b2 & 0xF0 | color.a() & 0xF));
    }

    @Override
    @Nullable
    public <T> T a(DataComponentType<? extends T> component) {
        return component == DataComponents.aR ? EntitySheep.c(component, this.p()) : super.a(component);
    }

    @Override
    protected void a(DataComponentGetter componentGetter) {
        this.a(componentGetter, DataComponents.aR);
        super.a(componentGetter);
    }

    @Override
    protected <T> boolean b(DataComponentType<T> component, T value) {
        if (component == DataComponents.aR) {
            this.b(EntitySheep.c(DataComponents.aR, value));
            return true;
        }
        return super.b(component, value);
    }

    public boolean u() {
        return (this.al.a(bJ) & 0x10) != 0;
    }

    public void w(boolean sheared) {
        byte b2 = this.al.a(bJ);
        if (sheared) {
            this.al.a(bJ, (byte)(b2 | 0x10));
        } else {
            this.al.a(bJ, (byte)(b2 & 0xFFFFFFEF));
        }
    }

    public static EnumColor a(WorldAccess level, BlockPosition pos) {
        Holder<BiomeBase> biome = level.u(pos);
        return SheepColorSpawnRules.a(biome, level.G_());
    }

    @Nullable
    public EntitySheep b(WorldServer level, EntityAgeable otherParent) {
        EntitySheep sheep = EntityTypes.bc.a(level, EntitySpawnReason.e);
        if (sheep != null) {
            EnumColor color = this.p();
            EnumColor color1 = ((EntitySheep)otherParent).p();
            sheep.b(EnumColor.a(level, color, color1));
        }
        return sheep;
    }

    @Override
    public void Q() {
        if (!new SheepRegrowWoolEvent((Sheep)this.getBukkitEntity()).callEvent()) {
            return;
        }
        super.Q();
        this.w(false);
        if (this.e_()) {
            this.b_(60);
        }
    }

    @Override
    @Nullable
    public GroupDataEntity a(WorldAccess level, DifficultyDamageScaler difficulty, EntitySpawnReason spawnReason, @Nullable GroupDataEntity spawnGroupData) {
        this.b(EntitySheep.a(level, this.dv()));
        return super.a(level, difficulty, spawnReason, spawnGroupData);
    }

    private static /* synthetic */ void lambda$generateDefaultDrops$1(List drops, WorldServer ignored, ItemStack stack) {
        for (int i2 = 0; i2 < stack.M(); ++i2) {
            drops.add(stack.c(1));
        }
    }
}

