/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal.wolf;

import io.papermc.paper.event.entity.EntityDyeEvent;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.IRegistry;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleParamItem;
import net.minecraft.core.particles.Particles;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.util.TimeRange;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Crackiness;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTameableAnimal;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.IEntityAngerable;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.PathfinderGoalAvoidTarget;
import net.minecraft.world.entity.ai.goal.PathfinderGoalBeg;
import net.minecraft.world.entity.ai.goal.PathfinderGoalBreed;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFollowOwner;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLeapAtTarget;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalMeleeAttack;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomLookaround;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStrollLand;
import net.minecraft.world.entity.ai.goal.PathfinderGoalSit;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalHurtByTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalOwnerHurtByTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalOwnerHurtTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalRandomTargetNonTamed;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalUniversalAngerReset;
import net.minecraft.world.entity.ai.targeting.PathfinderTargetCondition;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.animal.EntityTurtle;
import net.minecraft.world.entity.animal.horse.EntityHorseAbstract;
import net.minecraft.world.entity.animal.horse.EntityLlama;
import net.minecraft.world.entity.animal.wolf.WolfSoundVariant;
import net.minecraft.world.entity.animal.wolf.WolfSoundVariants;
import net.minecraft.world.entity.animal.wolf.WolfVariant;
import net.minecraft.world.entity.animal.wolf.WolfVariants;
import net.minecraft.world.entity.decoration.EntityArmorStand;
import net.minecraft.world.entity.monster.EntityCreeper;
import net.minecraft.world.entity.monster.EntityGhast;
import net.minecraft.world.entity.monster.EntitySkeletonAbstract;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.variant.SpawnContext;
import net.minecraft.world.entity.variant.VariantUtils;
import net.minecraft.world.food.FoodInfo;
import net.minecraft.world.item.EnumColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDye;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.DyeColor;
import org.bukkit.craftbukkit.v1_21_R4.event.CraftEventFactory;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityRegainHealthEvent;
import org.bukkit.event.entity.EntityTargetEvent;

public class EntityWolf
extends EntityTameableAnimal
implements IEntityAngerable {
    private static final DataWatcherObject<Boolean> bO = DataWatcher.a(EntityWolf.class, DataWatcherRegistry.k);
    private static final DataWatcherObject<Integer> bP = DataWatcher.a(EntityWolf.class, DataWatcherRegistry.b);
    private static final DataWatcherObject<Integer> bQ = DataWatcher.a(EntityWolf.class, DataWatcherRegistry.b);
    private static final DataWatcherObject<Holder<WolfVariant>> bR = DataWatcher.a(EntityWolf.class, DataWatcherRegistry.A);
    private static final DataWatcherObject<Holder<WolfSoundVariant>> bS = DataWatcher.a(EntityWolf.class, DataWatcherRegistry.B);
    public static final PathfinderTargetCondition.a bM = (entity, level) -> {
        EntityTypes<?> type = entity.an();
        return type == EntityTypes.bc || type == EntityTypes.aZ || type == EntityTypes.ab;
    };
    private static final float bT = 8.0f;
    private static final float bU = 40.0f;
    private static final float bV = 0.125f;
    public static final float bN = 0.62831855f;
    private static final EnumColor bW = EnumColor.o;
    private float bX;
    private float bY;
    public boolean bZ;
    private boolean ca;
    private float cb;
    private float cc;
    private static final UniformInt cd = TimeRange.a(20, 39);
    @Nullable
    private UUID ce;

    public EntityWolf(EntityTypes<? extends EntityWolf> entityType, World level) {
        super((EntityTypes<? extends EntityTameableAnimal>)entityType, level);
        this.a(false, false);
        this.a(PathType.f, -1.0f);
        this.a(PathType.g, -1.0f);
    }

    @Override
    protected void C() {
        this.bF.a(1, new PathfinderGoalFloat(this));
        this.bF.a(1, new EntityTameableAnimal.a(1.5, DamageTypeTags.G));
        this.bF.a(2, new PathfinderGoalSit(this));
        this.bF.a(3, new a<EntityLlama>(this, EntityLlama.class, 24.0f, 1.5, 1.5));
        this.bF.a(4, new PathfinderGoalLeapAtTarget(this, 0.4f));
        this.bF.a(5, new PathfinderGoalMeleeAttack(this, 1.0, true));
        this.bF.a(6, new PathfinderGoalFollowOwner(this, 1.0, 10.0f, 2.0f));
        this.bF.a(7, new PathfinderGoalBreed(this, 1.0));
        this.bF.a(8, new PathfinderGoalRandomStrollLand(this, 1.0));
        this.bF.a(9, new PathfinderGoalBeg(this, 8.0f));
        this.bF.a(10, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 8.0f));
        this.bF.a(10, new PathfinderGoalRandomLookaround(this));
        this.bG.a(1, new PathfinderGoalOwnerHurtByTarget(this));
        this.bG.a(2, new PathfinderGoalOwnerHurtTarget(this));
        this.bG.a(3, new PathfinderGoalHurtByTarget(this, new Class[0]).a(new Class[0]));
        this.bG.a(4, new PathfinderGoalNearestAttackableTarget<EntityHuman>(this, EntityHuman.class, 10, true, false, this::a));
        this.bG.a(5, new PathfinderGoalRandomTargetNonTamed<EntityAnimal>(this, EntityAnimal.class, false, bM));
        this.bG.a(6, new PathfinderGoalRandomTargetNonTamed<EntityTurtle>(this, EntityTurtle.class, false, EntityTurtle.bI));
        this.bG.a(7, new PathfinderGoalNearestAttackableTarget<EntitySkeletonAbstract>((EntityInsentient)this, EntitySkeletonAbstract.class, false));
        this.bG.a(8, new PathfinderGoalUniversalAngerReset<EntityWolf>(this, true));
    }

    public MinecraftKey gG() {
        WolfVariant wolfVariant = this.gL().a();
        if (this.m()) {
            return wolfVariant.b().b().b();
        }
        return this.ac_() ? wolfVariant.b().c().b() : wolfVariant.b().a().b();
    }

    public Holder<WolfVariant> gL() {
        return this.al.a(bR);
    }

    public void j(Holder<WolfVariant> variant) {
        this.al.a(bR, variant);
    }

    public Holder<WolfSoundVariant> gM() {
        return this.al.a(bS);
    }

    public void k(Holder<WolfSoundVariant> soundVariant) {
        this.al.a(bS, soundVariant);
    }

    @Override
    @Nullable
    public <T> T a(DataComponentType<? extends T> component) {
        if (component == DataComponents.aw) {
            return EntityWolf.c(component, this.gL());
        }
        if (component == DataComponents.ax) {
            return EntityWolf.c(component, this.gM());
        }
        return component == DataComponents.ay ? EntityWolf.c(component, this.gJ()) : super.a(component);
    }

    @Override
    protected void a(DataComponentGetter componentGetter) {
        this.a(componentGetter, DataComponents.aw);
        this.a(componentGetter, DataComponents.ax);
        this.a(componentGetter, DataComponents.ay);
        super.a(componentGetter);
    }

    @Override
    protected <T> boolean b(DataComponentType<T> component, T value) {
        if (component == DataComponents.aw) {
            this.j(EntityWolf.c(DataComponents.aw, value));
            return true;
        }
        if (component == DataComponents.ax) {
            this.k(EntityWolf.c(DataComponents.ax, value));
            return true;
        }
        if (component == DataComponents.ay) {
            this.a(EntityWolf.c(DataComponents.ay, value));
            return true;
        }
        return super.b(component, value);
    }

    public static AttributeProvider.Builder gH() {
        return EntityAnimal.gz().a(GenericAttributes.v, 0.3f).a(GenericAttributes.s, 8.0).a(GenericAttributes.c, 4.0);
    }

    @Override
    protected void a(DataWatcher.a builder) {
        super.a(builder);
        IRegistry<WolfSoundVariant> registry = this.dX().f(Registries.bn);
        builder.a(bR, VariantUtils.a(this.dX(), WolfVariants.j));
        builder.a(bS, (Holder)registry.a(WolfSoundVariants.a).or(registry::a).orElseThrow());
        builder.a(bO, false);
        builder.a(bP, bW.a());
        builder.a(bQ, 0);
    }

    @Override
    protected void b(BlockPosition pos, IBlockData state) {
        this.a(SoundEffects.DR, 0.15f, 1.0f);
    }

    @Override
    public void b(NBTTagCompound compound) {
        super.b(compound);
        compound.a("CollarColor", EnumColor.s, this.gJ());
        VariantUtils.a(compound, this.gL());
        this.a_(compound);
        this.gM().e().ifPresent(resourceKey -> compound.a("sound_variant", ResourceKey.a(Registries.bn), resourceKey));
    }

    @Override
    public void a(NBTTagCompound compound) {
        super.a(compound);
        VariantUtils.a(compound, this.dX(), Registries.bm).ifPresent(this::j);
        this.a(compound.a("CollarColor", EnumColor.s).orElse(bW));
        this.a(this.dV(), compound);
        compound.a("sound_variant", ResourceKey.a(Registries.bn)).flatMap(resourceKey -> this.dX().f(Registries.bn).a((ResourceKey)resourceKey)).ifPresent(this::k);
    }

    @Override
    @Nullable
    public GroupDataEntity a(WorldAccess level, DifficultyDamageScaler difficulty, EntitySpawnReason spawnReason, @Nullable GroupDataEntity spawnGroupData) {
        if (spawnGroupData instanceof b) {
            b wolfPackData = (b)spawnGroupData;
            this.j(wolfPackData.a);
        } else {
            Optional<? extends Holder<WolfVariant>> optional = WolfVariants.a(this.ae, this.dX(), SpawnContext.a(level, this.dv()));
            if (optional.isPresent()) {
                this.j(optional.get());
                spawnGroupData = new b(optional.get());
            }
        }
        this.k(WolfSoundVariants.a(this.dX(), this.ae));
        return super.a(level, difficulty, spawnReason, spawnGroupData);
    }

    @Override
    public SoundEffect s() {
        if (this.ac_()) {
            return this.gM().a().c().a();
        }
        if (this.ae.a(3) == 0) {
            return this.m() && this.eG() < 20.0f ? this.gM().a().f().a() : this.gM().a().e().a();
        }
        return this.gM().a().a().a();
    }

    @Override
    public SoundEffect e(DamageSource damageSource) {
        return this.i(damageSource) ? SoundEffects.DO : this.gM().a().d().a();
    }

    @Override
    public SoundEffect j_() {
        return this.gM().a().b().a();
    }

    @Override
    public float fe() {
        return 0.4f;
    }

    @Override
    public void d_() {
        super.d_();
        if (!this.dV().C && this.bZ && !this.ca && !this.gq() && this.aH()) {
            this.ca = true;
            this.cb = 0.0f;
            this.cc = 0.0f;
            this.dV().a((Entity)this, (byte)8);
        }
        if (!this.dV().C) {
            this.a((WorldServer)this.dV(), true);
        }
    }

    @Override
    public void g() {
        super.g();
        if (this.bJ()) {
            this.bY = this.bX;
            this.bX = this.gK() ? (this.bX += (1.0f - this.bX) * 0.4f) : (this.bX += (0.0f - this.bX) * 0.4f);
            if (this.bk()) {
                this.bZ = true;
                if (this.ca && !this.dV().C) {
                    this.dV().a((Entity)this, (byte)56);
                    this.gN();
                }
            } else if ((this.bZ || this.ca) && this.ca) {
                if (this.cb == 0.0f) {
                    this.a(SoundEffects.DQ, this.fe(), (this.ae.i() - this.ae.i()) * 0.2f + 1.0f);
                    ((Entity)this).a(GameEvent.u);
                }
                this.cc = this.cb;
                this.cb += 0.05f;
                if (this.cc >= 2.0f) {
                    this.bZ = false;
                    this.ca = false;
                    this.cc = 0.0f;
                    this.cb = 0.0f;
                }
                if (this.cb > 0.4f) {
                    float f2 = (float)this.dC();
                    int i2 = (int)(MathHelper.a((this.cb - 0.4f) * (float)Math.PI) * 7.0f);
                    Vec3D deltaMovement = this.dy();
                    for (int i1 = 0; i1 < i2; ++i1) {
                        float f1 = (this.ae.i() * 2.0f - 1.0f) * this.dq() * 0.5f;
                        float f22 = (this.ae.i() * 2.0f - 1.0f) * this.dq() * 0.5f;
                        this.dV().a(Particles.ap, this.dA() + (double)f1, (double)(f2 + 0.8f), this.dG() + (double)f22, deltaMovement.d, deltaMovement.e, deltaMovement.f);
                    }
                }
            }
        }
    }

    private void gN() {
        this.ca = false;
        this.cb = 0.0f;
        this.cc = 0.0f;
    }

    @Override
    public void a(DamageSource cause) {
        this.bZ = false;
        this.ca = false;
        this.cc = 0.0f;
        this.cb = 0.0f;
        super.a(cause);
    }

    public float J(float partialTick) {
        return !this.bZ ? 1.0f : Math.min(0.75f + MathHelper.h(partialTick, this.cc, this.cb) / 2.0f * 0.25f, 1.0f);
    }

    public float K(float partialTick) {
        return MathHelper.h(partialTick, this.cc, this.cb);
    }

    public float L(float partialTick) {
        return MathHelper.h(partialTick, this.bY, this.bX) * 0.15f * (float)Math.PI;
    }

    @Override
    public int ac() {
        return this.u() ? 20 : super.ac();
    }

    @Override
    public boolean a(WorldServer level, DamageSource damageSource, float amount) {
        if (this.a(level, damageSource)) {
            return false;
        }
        if (!super.a(level, damageSource, amount)) {
            return false;
        }
        this.y(false);
        return true;
    }

    @Override
    public boolean actuallyHurt(WorldServer level, DamageSource damageSource, float amount, EntityDamageEvent event) {
        if (!this.i(damageSource)) {
            return super.actuallyHurt(level, damageSource, amount, event);
        }
        if (event.isCancelled()) {
            return false;
        }
        ItemStack bodyArmorItem = this.fY();
        int damageValue = bodyArmorItem.o();
        int maxDamage = bodyArmorItem.p();
        bodyArmorItem.a(MathHelper.f(amount), (EntityLiving)this, EnumItemSlot.g);
        if (Crackiness.b.a(damageValue, maxDamage) != Crackiness.b.a(this.fY())) {
            this.a(SoundEffects.DN);
            level.a(new ParticleParamItem(Particles.U, Items.pe.m()), this.dA(), this.dC() + 1.0, this.dG(), 20, 0.2, 0.1, 0.2, 0.1);
        }
        return true;
    }

    private boolean i(DamageSource damageSource) {
        return this.fY().a(Items.pf) && !damageSource.a(DamageTypeTags.C);
    }

    @Override
    protected void p() {
        if (this.m()) {
            this.g(GenericAttributes.s).a(40.0);
            this.d(this.eU());
        } else {
            this.g(GenericAttributes.s).a(8.0);
        }
    }

    @Override
    protected void c(DamageSource damageSource, float damageAmount) {
        this.a(damageSource, damageAmount, EnumItemSlot.g);
    }

    @Override
    public EnumInteractionResult b(EntityHuman player, EnumHand hand) {
        block16: {
            ItemStack itemInHand;
            block13: {
                ItemDye dyeItem;
                block15: {
                    block14: {
                        itemInHand = player.b(hand);
                        Item item = itemInHand.h();
                        if (!this.m()) break block13;
                        if (this.i(itemInHand) && this.eG() < this.eU()) {
                            this.a(player, hand, itemInHand);
                            FoodInfo foodProperties = itemInHand.a(DataComponents.v);
                            float f2 = foodProperties != null ? (float)foodProperties.a() : 1.0f;
                            this.heal(2.0f * f2, EntityRegainHealthEvent.RegainReason.EATING);
                            return EnumInteractionResult.a;
                        }
                        if (!(item instanceof ItemDye)) break block14;
                        dyeItem = (ItemDye)item;
                        if (this.j(player)) break block15;
                    }
                    if (this.a(itemInHand, EnumItemSlot.g) && !this.ga() && this.j(player) && !this.e_()) {
                        this.h(itemInHand.c(1));
                        itemInHand.a(1, (EntityLiving)player);
                        return EnumInteractionResult.a;
                    }
                    if (!itemInHand.a(Items.td) || !this.j(player) || !this.ga() || EnchantmentManager.a(this.fY(), EnchantmentEffectComponents.E) && !player.gz()) {
                        if (this.u() && this.ga() && this.j(player) && this.fY().n() && this.fY().c(itemInHand)) {
                            itemInHand.h(1);
                            this.a(SoundEffects.DP);
                            ItemStack bodyArmorItem = this.fY();
                            int i2 = (int)((float)bodyArmorItem.p() * 0.125f);
                            bodyArmorItem.b(Math.max(0, bodyArmorItem.o() - i2));
                            return EnumInteractionResult.a;
                        }
                        EnumInteractionResult interactionResult = super.b(player, hand);
                        if (!interactionResult.a() && this.j(player)) {
                            this.y(!this.gu());
                            this.bf = false;
                            this.bE.m();
                            this.setTarget(null, EntityTargetEvent.TargetReason.FORGOT_TARGET);
                            return EnumInteractionResult.a.b();
                        }
                        return interactionResult;
                    }
                    itemInHand.a(1, (EntityLiving)player, EntityWolf.d(hand));
                    this.a(SoundEffects.az);
                    ItemStack bodyArmorItem = this.fY();
                    this.h(ItemStack.l);
                    World world = this.dV();
                    if (world instanceof WorldServer) {
                        WorldServer serverLevel = (WorldServer)world;
                        this.forceDrops = true;
                        this.a(serverLevel, bodyArmorItem);
                        this.forceDrops = false;
                    }
                    return EnumInteractionResult.a;
                }
                EnumColor dyeColor = dyeItem.a();
                if (dyeColor != this.gJ()) {
                    EntityDyeEvent event = new EntityDyeEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), DyeColor.getByWoolData((byte)((byte)dyeColor.a())), (Player)player.getBukkitEntity());
                    if (!event.callEvent()) {
                        return EnumInteractionResult.d;
                    }
                    dyeColor = EnumColor.a(event.getColor().getWoolData());
                    this.a(dyeColor);
                    itemInHand.a(1, (EntityLiving)player);
                    return EnumInteractionResult.a;
                }
                break block16;
            }
            if (!this.dV().C && itemInHand.a(Items.sH) && !this.ac_()) {
                itemInHand.a(1, (EntityLiving)player);
                this.f(player);
                return EnumInteractionResult.b;
            }
        }
        return super.b(player, hand);
    }

    private void f(EntityHuman player) {
        if (this.ae.a(3) == 0 && !CraftEventFactory.callEntityTameEvent(this, player).isCancelled()) {
            this.a(player);
            this.bE.m();
            this.g((EntityLiving)null);
            this.y(true);
            this.dV().a((Entity)this, (byte)7);
        } else {
            this.dV().a((Entity)this, (byte)6);
        }
    }

    @Override
    public void b(byte id) {
        if (id == 8) {
            this.ca = true;
            this.cb = 0.0f;
            this.cc = 0.0f;
        } else if (id == 56) {
            this.gN();
        } else {
            super.b(id);
        }
    }

    public float gI() {
        if (this.ac_()) {
            return 1.5393804f;
        }
        if (this.m()) {
            float maxHealth = this.eU();
            float f2 = (maxHealth - this.eG()) / maxHealth;
            return (0.55f - f2 * 0.4f) * (float)Math.PI;
        }
        return 0.62831855f;
    }

    @Override
    public boolean i(ItemStack stack) {
        return stack.a(TagsItem.ai);
    }

    @Override
    public int fX() {
        return 8;
    }

    @Override
    public int a() {
        return this.al.a(bQ);
    }

    @Override
    public void a(int remainingPersistentAngerTime) {
        this.al.a(bQ, remainingPersistentAngerTime);
    }

    @Override
    public void c() {
        this.a(cd.a(this.ae));
    }

    @Override
    @Nullable
    public UUID b() {
        return this.ce;
    }

    @Override
    public void a(@Nullable UUID persistentAngerTarget) {
        this.ce = persistentAngerTarget;
    }

    public EnumColor gJ() {
        return EnumColor.a(this.al.a(bP));
    }

    public void a(EnumColor color) {
        this.al.a(bP, color.a());
    }

    @Nullable
    public EntityWolf b(WorldServer level, EntityAgeable otherParent) {
        EntityWolf wolf = EntityTypes.bN.a(level, EntitySpawnReason.e);
        if (wolf != null && otherParent instanceof EntityWolf) {
            EntityWolf wolf1 = (EntityWolf)otherParent;
            if (this.ae.h()) {
                wolf.j(this.gL());
            } else {
                wolf.j(wolf1.gL());
            }
            if (this.m()) {
                ((EntityTameableAnimal)wolf).a(this.d());
                wolf.a(true, true);
                EnumColor collarColor = this.gJ();
                EnumColor collarColor1 = wolf1.gJ();
                wolf.a(EnumColor.a(level, collarColor, collarColor1));
            }
            wolf.k(WolfSoundVariants.a(this.dX(), this.ae));
        }
        return wolf;
    }

    public void z(boolean isInterested) {
        this.al.a(bO, isInterested);
    }

    @Override
    public boolean a(EntityAnimal otherAnimal) {
        EntityWolf wolf;
        return otherAnimal != this && this.m() && otherAnimal instanceof EntityWolf && (wolf = (EntityWolf)otherAnimal).m() && !wolf.u() && this.gE() && wolf.gE();
    }

    public boolean gK() {
        return this.al.a(bO);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean a(EntityLiving target, EntityLiving owner) {
        if (target instanceof EntityCreeper) return false;
        if (target instanceof EntityGhast) return false;
        if (target instanceof EntityArmorStand) {
            return false;
        }
        if (target instanceof EntityWolf) {
            EntityWolf wolf = (EntityWolf)target;
            if (!wolf.m()) return true;
            if (wolf.T_() == owner) return false;
            return true;
        }
        if (target instanceof EntityHuman) {
            EntityHuman player = (EntityHuman)target;
            if (owner instanceof EntityHuman) {
                EntityHuman player1 = (EntityHuman)owner;
                if (!player1.a(player)) return false;
            }
        }
        if (target instanceof EntityHorseAbstract) {
            EntityHorseAbstract abstractHorse = (EntityHorseAbstract)target;
            if (abstractHorse.gL()) return false;
        }
        if (!(target instanceof EntityTameableAnimal)) return true;
        EntityTameableAnimal tamableAnimal = (EntityTameableAnimal)target;
        if (tamableAnimal.m()) return false;
        return true;
    }

    @Override
    public boolean w() {
        return !this.ac_();
    }

    @Override
    public Vec3D cT() {
        return new Vec3D(0.0, 0.6f * this.cS(), this.dq() * 0.4f);
    }

    public static boolean c(EntityTypes<EntityWolf> entityType, GeneratorAccess level, EntitySpawnReason spawnReason, BlockPosition pos, RandomSource random) {
        return level.a_(pos.e()).a(TagsBlock.cj) && EntityWolf.a(level, pos);
    }

    class a<T extends EntityLiving>
    extends PathfinderGoalAvoidTarget<T> {
        private final EntityWolf j;

        public a(EntityWolf wolf, Class<T> avoidClass, float maxDistance, double walkSpeedModifier, double sprintSpeedModifier) {
            super(wolf, avoidClass, maxDistance, walkSpeedModifier, sprintSpeedModifier);
            this.j = wolf;
        }

        @Override
        public boolean b() {
            return super.b() && this.b instanceof EntityLlama && !this.j.m() && this.a((EntityLlama)this.b);
        }

        private boolean a(EntityLlama llama) {
            return llama.gy() >= EntityWolf.this.ae.a(5);
        }

        @Override
        public void d() {
            EntityWolf.this.g((EntityLiving)null);
            super.d();
        }

        @Override
        public void a() {
            EntityWolf.this.g((EntityLiving)null);
            super.a();
        }
    }

    public static class b
    extends EntityAgeable.a {
        public final Holder<WolfVariant> a;

        public b(Holder<WolfVariant> type) {
            super(false);
            this.a = type;
        }
    }
}

