/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.boss.wither;

import com.google.common.collect.ImmutableList;
import java.util.EnumSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.particles.ColorParticleOption;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.game.PacketPlayOutWorldEvent;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.BossBattleServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.world.BossBattle;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.control.ControllerMoveFlying;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.goal.PathfinderGoalArrowAttack;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomFly;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomLookaround;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalHurtByTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.ai.navigation.NavigationAbstract;
import net.minecraft.world.entity.ai.navigation.NavigationFlying;
import net.minecraft.world.entity.ai.targeting.PathfinderTargetCondition;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.monster.EntityMonster;
import net.minecraft.world.entity.monster.IRangedEntity;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.EntityArrow;
import net.minecraft.world.entity.projectile.EntityWitherSkull;
import net.minecraft.world.entity.projectile.windcharge.WindCharge;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_21_R4.event.CraftEventFactory;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityRegainHealthEvent;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.entity.EntityTargetEvent;
import org.bukkit.event.entity.ExplosionPrimeEvent;

public class EntityWither
extends EntityMonster
implements IRangedEntity {
    private static final DataWatcherObject<Integer> a = DataWatcher.a(EntityWither.class, DataWatcherRegistry.b);
    private static final DataWatcherObject<Integer> b = DataWatcher.a(EntityWither.class, DataWatcherRegistry.b);
    private static final DataWatcherObject<Integer> c = DataWatcher.a(EntityWither.class, DataWatcherRegistry.b);
    private static final List<DataWatcherObject<Integer>> d = ImmutableList.of(a, b, c);
    private static final DataWatcherObject<Integer> e = DataWatcher.a(EntityWither.class, DataWatcherRegistry.b);
    private static final int f = 220;
    private static final int bI = 0;
    private final float[] bJ = new float[2];
    private final float[] bK = new float[2];
    private final float[] bL = new float[2];
    private final float[] bM = new float[2];
    private final int[] bN = new int[2];
    private final int[] bO = new int[2];
    private int bP;
    private boolean canPortal = false;
    public final BossBattleServer bQ = (BossBattleServer)new BossBattleServer(this.P_(), BossBattle.BarColor.f, BossBattle.BarStyle.a).a(true);
    private static final PathfinderTargetCondition.a bR = (entity, level) -> !entity.an().a(TagsEntity.y) && entity.fM();
    private static final PathfinderTargetCondition bS = PathfinderTargetCondition.a().a(20.0).a(bR);

    public EntityWither(EntityTypes<? extends EntityWither> entityType, World level) {
        super((EntityTypes<? extends EntityMonster>)entityType, level);
        this.bC = new ControllerMoveFlying(this, 10, false);
        this.d(this.eU());
        this.bA = 50;
    }

    @Override
    protected NavigationAbstract b(World level) {
        NavigationFlying flyingPathNavigation = new NavigationFlying(this, level);
        flyingPathNavigation.b(false);
        flyingPathNavigation.a(true);
        return flyingPathNavigation;
    }

    @Override
    protected void C() {
        this.bF.a(0, new a());
        this.bF.a(2, new PathfinderGoalArrowAttack(this, 1.0, 40, 20.0f));
        this.bF.a(5, new PathfinderGoalRandomFly(this, 1.0));
        this.bF.a(6, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 8.0f));
        this.bF.a(7, new PathfinderGoalRandomLookaround(this));
        this.bG.a(1, new PathfinderGoalHurtByTarget(this, new Class[0]));
        this.bG.a(2, new PathfinderGoalNearestAttackableTarget<EntityLiving>(this, EntityLiving.class, 0, false, false, bR));
    }

    @Override
    protected void a(DataWatcher.a builder) {
        super.a(builder);
        builder.a(a, 0);
        builder.a(b, 0);
        builder.a(c, 0);
        builder.a(e, 0);
    }

    @Override
    public void b(NBTTagCompound compound) {
        super.b(compound);
        compound.a("Invul", this.gv());
    }

    @Override
    public void a(NBTTagCompound compound) {
        super.a(compound);
        this.b(compound.b("Invul", 0));
        if (this.g_()) {
            this.bQ.a(this.P_());
        }
    }

    @Override
    public void b(@Nullable IChatBaseComponent name) {
        super.b(name);
        this.bQ.a(this.P_());
    }

    @Override
    public SoundEffect s() {
        return SoundEffects.DC;
    }

    @Override
    public SoundEffect e(DamageSource damageSource) {
        return SoundEffects.DF;
    }

    @Override
    public SoundEffect j_() {
        return SoundEffects.DE;
    }

    @Override
    public void d_() {
        int i2;
        Entity entity;
        Vec3D vec3 = this.dy().d(1.0, 0.6, 1.0);
        if (!this.dV().C && this.c(0) > 0 && (entity = this.dV().a(this.c(0))) != null) {
            double d2 = vec3.e;
            if (this.dC() < entity.dC() || !this.gw() && this.dC() < entity.dC() + 5.0) {
                d2 = Math.max(0.0, d2);
                d2 += 0.3 - d2 * (double)0.6f;
            }
            vec3 = new Vec3D(vec3.d, d2, vec3.f);
            Vec3D vec31 = new Vec3D(entity.dA() - this.dA(), 0.0, entity.dG() - this.dG());
            if (vec31.j() > 9.0) {
                Vec3D vec32 = vec31.d();
                vec3 = vec3.b(vec32.d * 0.3 - vec3.d * 0.6, 0.0, vec32.f * 0.3 - vec3.f * 0.6);
            }
        }
        this.i(vec3);
        if (vec3.j() > 0.05) {
            this.w((float)MathHelper.d(vec3.f, vec3.d) * 57.295776f - 90.0f);
        }
        super.d_();
        for (i2 = 0; i2 < 2; ++i2) {
            this.bM[i2] = this.bK[i2];
            this.bL[i2] = this.bJ[i2];
        }
        for (i2 = 0; i2 < 2; ++i2) {
            int alternativeTarget = this.c(i2 + 1);
            Entity entity1 = null;
            if (alternativeTarget > 0) {
                entity1 = this.dV().a(alternativeTarget);
            }
            if (entity1 != null) {
                double headX = this.r(i2 + 1);
                double headY = this.s(i2 + 1);
                double headZ = this.t(i2 + 1);
                double d1 = entity1.dA() - headX;
                double d2 = entity1.dE() - headY;
                double d3 = entity1.dG() - headZ;
                double squareRoot = Math.sqrt(d1 * d1 + d3 * d3);
                float f2 = (float)(MathHelper.d(d3, d1) * 180.0 / 3.1415927410125732) - 90.0f;
                float f1 = (float)(-(MathHelper.d(d2, squareRoot) * 180.0 / 3.1415927410125732));
                this.bJ[i2] = this.a(this.bJ[i2], f1, 40.0f);
                this.bK[i2] = this.a(this.bK[i2], f2, 10.0f);
                continue;
            }
            this.bK[i2] = this.a(this.bK[i2], this.aV, 10.0f);
        }
        boolean isPowered = this.gw();
        for (int alternativeTargetx = 0; alternativeTargetx < 3; ++alternativeTargetx) {
            double headX1 = this.r(alternativeTargetx);
            double headY1 = this.s(alternativeTargetx);
            double headZ1 = this.t(alternativeTargetx);
            float f2 = 0.3f * this.el();
            this.dV().a(Particles.ah, headX1 + this.ae.k() * (double)f2, headY1 + this.ae.k() * (double)f2, headZ1 + this.ae.k() * (double)f2, 0.0, 0.0, 0.0);
            if (!isPowered || this.dV().A.a(4) != 0) continue;
            this.dV().a(ColorParticleOption.a(Particles.u, 0.7f, 0.7f, 0.5f), headX1 + this.ae.k() * (double)f2, headY1 + this.ae.k() * (double)f2, headZ1 + this.ae.k() * (double)f2, 0.0, 0.0, 0.0);
        }
        if (this.gv() > 0) {
            float f3 = 3.3f * this.el();
            for (int i1 = 0; i1 < 3; ++i1) {
                this.dV().a(ColorParticleOption.a(Particles.u, 0.7f, 0.7f, 0.9f), this.dA() + this.ae.k(), this.dC() + (double)(this.ae.i() * f3), this.dG() + this.ae.k(), 0.0, 0.0, 0.0);
            }
        }
    }

    @Override
    protected void a(WorldServer level) {
        if (this.gv() > 0) {
            int i2 = this.gv() - 1;
            this.bQ.a(1.0f - (float)i2 / 220.0f);
            if (i2 <= 0) {
                ExplosionPrimeEvent event = new ExplosionPrimeEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), 7.0f, false);
                level.getCraftServer().getPluginManager().callEvent((Event)event);
                if (!event.isCancelled()) {
                    level.a((Entity)this, this.dA(), this.dE(), this.dG(), event.getRadius(), event.getFire(), World.a.c);
                }
                if (!this.ba()) {
                    int viewDistance = level.getCraftServer().getViewDistance() * 16;
                    for (EntityPlayer player : level.getPlayersForGlobalSoundGamerule()) {
                        double deltaX = this.dA() - player.dA();
                        double deltaZ = this.dG() - player.dG();
                        double distanceSquared = MathHelper.k(deltaX) + MathHelper.k(deltaZ);
                        double soundRadiusSquared = level.getGlobalSoundRangeSquared(config -> config.witherSpawnSoundRadius);
                        if (!level.O().c(GameRules.Y) && distanceSquared > soundRadiusSquared) continue;
                        if (distanceSquared > (double)MathHelper.h(viewDistance)) {
                            double deltaLength = Math.sqrt(distanceSquared);
                            double relativeX = player.dA() + deltaX / deltaLength * (double)viewDistance;
                            double relativeZ = player.dG() + deltaZ / deltaLength * (double)viewDistance;
                            player.f.b(new PacketPlayOutWorldEvent(1023, new BlockPosition((int)relativeX, (int)this.dC(), (int)relativeZ), 0, true));
                            continue;
                        }
                        player.f.b(new PacketPlayOutWorldEvent(1023, this.dv(), 0, true));
                    }
                }
            }
            this.b(i2);
            if (this.af % 10 == 0) {
                this.heal(10.0f, EntityRegainHealthEvent.RegainReason.WITHER_SPAWN);
            }
        } else {
            int alternativeTarget;
            super.a(level);
            for (int ix = 1; ix < 3; ++ix) {
                EntityLiving livingEntity1;
                if (this.af < this.bN[ix - 1]) continue;
                this.bN[ix - 1] = this.af + 10 + this.ae.a(10);
                if (level.an() == EnumDifficulty.c || level.an() == EnumDifficulty.d) {
                    int n2 = ix - 1;
                    int n3 = this.bO[n2];
                    this.bO[n2] = n3 + 1;
                    if (n3 > 15) {
                        float f2 = 10.0f;
                        float f1 = 5.0f;
                        double randomDouble = MathHelper.a(this.ae, this.dA() - 10.0, this.dA() + 10.0);
                        double randomDouble1 = MathHelper.a(this.ae, this.dC() - 5.0, this.dC() + 5.0);
                        double randomDouble2 = MathHelper.a(this.ae, this.dG() - 10.0, this.dG() + 10.0);
                        this.a(ix + 1, randomDouble, randomDouble1, randomDouble2, true);
                        this.bO[ix - 1] = 0;
                    }
                }
                if ((alternativeTarget = this.c(ix)) > 0) {
                    EntityLiving livingEntity = (EntityLiving)level.a(alternativeTarget);
                    if (livingEntity != null && this.c(livingEntity) && !(this.g((Entity)livingEntity) > 900.0) && this.E(livingEntity)) {
                        this.a(ix + 1, livingEntity);
                        this.bN[ix - 1] = this.af + 40 + this.ae.a(20);
                        this.bO[ix - 1] = 0;
                        continue;
                    }
                    this.a(ix, 0);
                    continue;
                }
                List<EntityLiving> nearbyEntities = level.a(EntityLiving.class, bS, this, this.cR().c(20.0, 8.0, 20.0));
                if (nearbyEntities.isEmpty() || CraftEventFactory.callEntityTargetLivingEvent(this, livingEntity1 = nearbyEntities.get(this.ae.a(nearbyEntities.size())), EntityTargetEvent.TargetReason.CLOSEST_ENTITY).isCancelled()) continue;
                this.a(ix, livingEntity1.ao());
            }
            if (this.e() != null) {
                this.a(0, this.e().ao());
            } else {
                this.a(0, 0);
            }
            if (this.bP > 0) {
                --this.bP;
                if (this.bP == 0 && level.O().c(GameRules.d)) {
                    boolean flag = false;
                    alternativeTarget = MathHelper.d(this.dq() / 2.0f + 1.0f);
                    int floor = MathHelper.d(this.dr());
                    for (BlockPosition blockPos : BlockPosition.b(this.dz() - alternativeTarget, this.dB(), this.dF() - alternativeTarget, this.dz() + alternativeTarget, this.dB() + floor, this.dF() + alternativeTarget)) {
                        IBlockData blockState = level.a_(blockPos);
                        if (!EntityWither.c(blockState) || !CraftEventFactory.callEntityChangeBlockEvent(this, blockPos, blockState.y().g())) continue;
                        flag = level.a(blockPos, true, this) || flag;
                    }
                    if (flag) {
                        level.a(null, 1022, this.dv(), 0);
                    }
                }
            }
            if (this.af % 20 == 0) {
                this.heal(1.0f, EntityRegainHealthEvent.RegainReason.REGEN);
            }
            this.bQ.a(this.eG() / this.eU());
        }
    }

    public static boolean c(IBlockData state) {
        return !state.l() && !state.a(TagsBlock.aH);
    }

    public void m() {
        this.b(220);
        this.bQ.a(0.0f);
        this.d(this.eU() / 3.0f);
    }

    @Override
    public void a(IBlockData state, Vec3D motionMultiplier) {
    }

    @Override
    public void d(EntityPlayer player) {
        super.d(player);
        this.bQ.a(player);
    }

    @Override
    public void e(EntityPlayer player) {
        super.e(player);
        this.bQ.b(player);
    }

    private double r(int head) {
        if (head <= 0) {
            return this.dA();
        }
        float f2 = (this.aV + (float)(180 * (head - 1))) * ((float)Math.PI / 180);
        float cos = MathHelper.b(f2);
        return this.dA() + (double)cos * 1.3 * (double)this.el();
    }

    private double s(int head) {
        float f2 = head <= 0 ? 3.0f : 2.2f;
        return this.dC() + (double)(f2 * this.el());
    }

    private double t(int head) {
        if (head <= 0) {
            return this.dG();
        }
        float f2 = (this.aV + (float)(180 * (head - 1))) * ((float)Math.PI / 180);
        float sin = MathHelper.a(f2);
        return this.dG() + (double)sin * 1.3 * (double)this.el();
    }

    private float a(float angle, float targetAngle, float max) {
        float f2 = MathHelper.h(targetAngle - angle);
        if (f2 > max) {
            f2 = max;
        }
        if (f2 < -max) {
            f2 = -max;
        }
        return angle + f2;
    }

    private void a(int head, EntityLiving target) {
        this.a(head, target.dA(), target.dC() + (double)target.cS() * 0.5, target.dG(), head == 0 && this.ae.i() < 0.001f);
    }

    private void a(int head, double x2, double y2, double z2, boolean isDangerous) {
        if (!this.ba()) {
            this.dV().a(null, 1024, this.dv(), 0);
        }
        double headX = this.r(head);
        double headY = this.s(head);
        double headZ = this.t(head);
        double d2 = x2 - headX;
        double d1 = y2 - headY;
        double d22 = z2 - headZ;
        Vec3D vec3 = new Vec3D(d2, d1, d22);
        EntityWitherSkull witherSkull = new EntityWitherSkull(this.dV(), this, vec3.d());
        witherSkull.c(this);
        if (isDangerous) {
            witherSkull.a(true);
        }
        witherSkull.a_(headX, headY, headZ);
        this.dV().b(witherSkull);
    }

    @Override
    public void a(EntityLiving target, float distanceFactor) {
        this.a(0, target);
    }

    @Override
    public boolean a(WorldServer level, DamageSource damageSource, float amount) {
        Entity directEntity;
        if (this.a(level, damageSource)) {
            return false;
        }
        if (damageSource.a(DamageTypeTags.t) || damageSource.d() instanceof EntityWither) {
            return false;
        }
        if (this.gv() > 0 && !damageSource.a(DamageTypeTags.d)) {
            return false;
        }
        if (this.gw() && ((directEntity = damageSource.c()) instanceof EntityArrow || directEntity instanceof WindCharge)) {
            return false;
        }
        directEntity = damageSource.d();
        if (directEntity != null && directEntity.an().a(TagsEntity.y)) {
            return false;
        }
        if (this.bP <= 0) {
            this.bP = 20;
        }
        for (int i2 = 0; i2 < this.bO.length; ++i2) {
            this.bO[i2] = this.bO[i2] + 3;
        }
        return super.a(level, damageSource, amount);
    }

    @Override
    protected void a(WorldServer level, DamageSource damageSource, boolean recentlyHit) {
        super.a(level, damageSource, recentlyHit);
        EntityItem itemEntity = this.spawnAtLocation(level, new ItemStack(Items.vC), 0.0f, EntityItem::s);
        if (itemEntity != null) {
            itemEntity.s();
        }
    }

    @Override
    public void dH() {
        if (this.dV().an() == EnumDifficulty.a && this.Z()) {
            this.discard(EntityRemoveEvent.Cause.DESPAWN);
        } else {
            this.bd = 0;
        }
    }

    @Override
    public boolean b(MobEffect effectInstance, @Nullable Entity entity) {
        return false;
    }

    public static AttributeProvider.Builder p() {
        return EntityMonster.gA().a(GenericAttributes.s, 300.0).a(GenericAttributes.v, 0.6f).a(GenericAttributes.l, 0.6f).a(GenericAttributes.m, 40.0).a(GenericAttributes.a, 4.0);
    }

    public float[] u() {
        return this.bK;
    }

    public float[] gu() {
        return this.bJ;
    }

    public int gv() {
        return this.al.a(e);
    }

    public void b(int invulnerableTicks) {
        this.al.a(e, invulnerableTicks);
    }

    public int c(int head) {
        return this.al.a(d.get(head));
    }

    public void a(int targetOffset, int newId) {
        this.al.a(d.get(targetOffset), newId);
    }

    public boolean gw() {
        return this.eG() <= this.eU() / 2.0f;
    }

    @Override
    protected boolean o(Entity entity) {
        return false;
    }

    @Override
    public boolean n(boolean allowPassengers) {
        return this.canPortal;
    }

    public void setCanTravelThroughPortals(boolean canPortal) {
        this.canPortal = canPortal;
    }

    @Override
    public boolean b(MobEffect potioneffect) {
        return (!potioneffect.a(MobEffects.t) || !this.dV().paperConfig().entities.mobEffects.immuneToWitherEffect.wither) && super.b(potioneffect);
    }

    class a
    extends PathfinderGoal {
        public a() {
            this.a(EnumSet.of(PathfinderGoal.Type.a, PathfinderGoal.Type.c, PathfinderGoal.Type.b));
        }

        @Override
        public boolean b() {
            return EntityWither.this.gv() > 0;
        }
    }
}

