/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.decoration;

import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Vector3f;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleParamBlock;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLightning;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.EnumMainHand;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.vehicle.EntityMinecartAbstract;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.EnumSkyBlock;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.EnumPistonReaction;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_21_R4.CraftEquipmentSlot;
import org.bukkit.craftbukkit.v1_21_R4.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_21_R4.inventory.CraftItemStack;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.player.PlayerArmorStandManipulateEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;

public class EntityArmorStand
extends EntityLiving {
    public static final int a = 5;
    private static final boolean bE = true;
    public static final Vector3f b = new Vector3f(0.0f, 0.0f, 0.0f);
    public static final Vector3f c = new Vector3f(0.0f, 0.0f, 0.0f);
    public static final Vector3f d = new Vector3f(-10.0f, 0.0f, -10.0f);
    public static final Vector3f e = new Vector3f(-15.0f, 0.0f, 10.0f);
    public static final Vector3f f = new Vector3f(-1.0f, 0.0f, -1.0f);
    public static final Vector3f g = new Vector3f(1.0f, 0.0f, 1.0f);
    private static final EntitySize bF = EntitySize.c(0.0f, 0.0f);
    private static final EntitySize bG = EntityTypes.g.n().a(0.5f).b(0.9875f);
    private static final double bH = 0.1;
    private static final double bI = 0.9;
    private static final double bJ = 0.4;
    private static final double bK = 1.6;
    public static final int h = 8;
    public static final int i = 16;
    public static final int j = 1;
    public static final int k = 4;
    public static final int bu = 8;
    public static final int bv = 16;
    public static final DataWatcherObject<Byte> bw = DataWatcher.a(EntityArmorStand.class, DataWatcherRegistry.a);
    public static final DataWatcherObject<Vector3f> bx = DataWatcher.a(EntityArmorStand.class, DataWatcherRegistry.n);
    public static final DataWatcherObject<Vector3f> by = DataWatcher.a(EntityArmorStand.class, DataWatcherRegistry.n);
    public static final DataWatcherObject<Vector3f> bz = DataWatcher.a(EntityArmorStand.class, DataWatcherRegistry.n);
    public static final DataWatcherObject<Vector3f> bA = DataWatcher.a(EntityArmorStand.class, DataWatcherRegistry.n);
    public static final DataWatcherObject<Vector3f> bB = DataWatcher.a(EntityArmorStand.class, DataWatcherRegistry.n);
    public static final DataWatcherObject<Vector3f> bC = DataWatcher.a(EntityArmorStand.class, DataWatcherRegistry.n);
    private static final Predicate<Entity> bL = entity -> {
        EntityMinecartAbstract abstractMinecart;
        return entity instanceof EntityMinecartAbstract && (abstractMinecart = (EntityMinecartAbstract)entity).y();
    };
    private static final boolean bM = false;
    private static final int bN = 0;
    private static final boolean bO = false;
    private static final boolean bP = false;
    private static final boolean bQ = false;
    private static final boolean bR = false;
    private boolean bS = false;
    public long bD;
    public int bT = 0;
    public Vector3f bU = b;
    public Vector3f bV = c;
    public Vector3f bW = d;
    public Vector3f bX = e;
    public Vector3f bY = f;
    public Vector3f bZ = g;
    public boolean canMove = true;
    public boolean canTick = true;
    public boolean canTickSetByAPI = false;
    private boolean noTickPoseDirty = false;
    private boolean noTickEquipmentDirty = false;

    public EntityArmorStand(EntityTypes<? extends EntityArmorStand> entityType, World level) {
        super((EntityTypes<? extends EntityLiving>)entityType, level);
        if (level != null) {
            this.canTick = level.paperConfig().entities.armorStands.tick;
        }
    }

    public EntityArmorStand(World level, double x2, double y2, double z2) {
        this((EntityTypes<? extends EntityArmorStand>)EntityTypes.g, level);
        this.a_(x2, y2, z2);
    }

    public static AttributeProvider.Builder m() {
        return EntityArmorStand.ee().a(GenericAttributes.B, 0.0);
    }

    @Override
    public float getBukkitYaw() {
        return this.dL();
    }

    @Override
    public void h_() {
        double x2 = this.dA();
        double y2 = this.dC();
        double z2 = this.dG();
        super.h_();
        this.a_(x2, y2, z2);
    }

    private boolean D() {
        return !this.w() && !this.bb();
    }

    @Override
    public boolean dj() {
        return super.dj() && this.D();
    }

    @Override
    protected void a(DataWatcher.a builder) {
        super.a(builder);
        builder.a(bw, (byte)0);
        builder.a(bx, b);
        builder.a(by, c);
        builder.a(bz, d);
        builder.a(bA, e);
        builder.a(bB, f);
        builder.a(bC, g);
    }

    @Override
    public boolean e(EnumItemSlot slot) {
        return slot != EnumItemSlot.g && slot != EnumItemSlot.h && !this.g(slot);
    }

    @Override
    public void setItemSlot(EnumItemSlot slot, net.minecraft.world.item.ItemStack stack, boolean silent) {
        super.setItemSlot(slot, stack, silent);
        this.noTickEquipmentDirty = true;
    }

    @Override
    public void b(NBTTagCompound compound) {
        super.b(compound);
        compound.a("Invisible", this.co());
        compound.a("Small", this.p());
        compound.a("ShowArms", this.s());
        compound.a("DisabledSlots", this.bT);
        compound.a("NoBasePlate", !this.u());
        if (this.w()) {
            compound.a("Marker", this.w());
        }
        compound.a("Pose", this.E());
        if (this.canTickSetByAPI) {
            compound.a("Paper.CanTickOverride", this.canTick);
        }
    }

    @Override
    public void a(NBTTagCompound compound) {
        super.a(compound);
        this.k(compound.b("Invisible", false));
        this.t(compound.b("Small", false));
        this.a(compound.b("ShowArms", false));
        this.bT = compound.b("DisabledSlots", 0);
        this.b(compound.b("NoBasePlate", false));
        this.u(compound.b("Marker", false));
        this.ad = !this.D();
        this.c(compound.n("Pose"));
        compound.q("Paper.CanTickOverride").ifPresent(canTick -> {
            this.canTick = canTick;
            this.canTickSetByAPI = true;
        });
    }

    private void c(NBTTagCompound compound) {
        this.a(compound.a("Head", Vector3f.a).orElse(b));
        this.b(compound.a("Body", Vector3f.a).orElse(c));
        this.c(compound.a("LeftArm", Vector3f.a).orElse(d));
        this.d(compound.a("RightArm", Vector3f.a).orElse(e));
        this.e(compound.a("LeftLeg", Vector3f.a).orElse(f));
        this.f(compound.a("RightLeg", Vector3f.a).orElse(g));
    }

    private NBTTagCompound E() {
        NBTTagCompound compoundTag = new NBTTagCompound();
        if (!b.equals(this.bU)) {
            compoundTag.a("Head", Vector3f.a, this.bU);
        }
        if (!c.equals(this.bV)) {
            compoundTag.a("Body", Vector3f.a, this.bV);
        }
        if (!d.equals(this.bW)) {
            compoundTag.a("LeftArm", Vector3f.a, this.bW);
        }
        if (!e.equals(this.bX)) {
            compoundTag.a("RightArm", Vector3f.a, this.bX);
        }
        if (!f.equals(this.bY)) {
            compoundTag.a("LeftLeg", Vector3f.a, this.bY);
        }
        if (!g.equals(this.bZ)) {
            compoundTag.a("RightLeg", Vector3f.a, this.bZ);
        }
        return compoundTag;
    }

    @Override
    public boolean isCollidable(boolean ignoreClimbing) {
        return false;
    }

    @Override
    protected void D(Entity entity) {
    }

    @Override
    protected void n() {
        if (!this.dV().paperConfig().entities.armorStands.doCollisionEntityLookups) {
            return;
        }
        for (Entity entity : this.dV().a(EntityMinecartAbstract.class, this.cR(), bL)) {
            if (!(this.g(entity) <= 0.2)) continue;
            entity.h(this);
        }
    }

    @Override
    public EnumInteractionResult a(EntityHuman player, Vec3D vec, EnumHand hand) {
        net.minecraft.world.item.ItemStack itemInHand = player.b(hand);
        if (this.w() || itemInHand.a(Items.vW)) {
            return EnumInteractionResult.e;
        }
        if (player.ak()) {
            return EnumInteractionResult.a;
        }
        if (player.dV().C) {
            return EnumInteractionResult.b;
        }
        EnumItemSlot equipmentSlotForItem = this.f(itemInHand);
        if (itemInHand.f()) {
            EnumItemSlot equipmentSlot;
            EnumItemSlot clickedSlot = this.l(vec);
            EnumItemSlot enumItemSlot = equipmentSlot = this.g(clickedSlot) ? equipmentSlotForItem : clickedSlot;
            if (this.d(equipmentSlot) && this.a(player, equipmentSlot, itemInHand, hand)) {
                return EnumInteractionResult.b;
            }
        } else {
            if (this.g(equipmentSlotForItem)) {
                return EnumInteractionResult.d;
            }
            if (equipmentSlotForItem.a() == EnumItemSlot.Function.a && !this.s()) {
                return EnumInteractionResult.d;
            }
            if (this.a(player, equipmentSlotForItem, itemInHand, hand)) {
                return EnumInteractionResult.b;
            }
        }
        return EnumInteractionResult.e;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private EnumItemSlot l(Vec3D vector) {
        EnumItemSlot equipmentSlot = EnumItemSlot.a;
        boolean isSmall = this.p();
        double d2 = vector.e / (double)(this.el() * this.ek());
        EnumItemSlot equipmentSlot1 = EnumItemSlot.c;
        if (d2 >= 0.1) {
            double d3 = isSmall ? 0.8 : 0.45;
            if (d2 < 0.1 + d3 && this.d(equipmentSlot1)) {
                return EnumItemSlot.c;
            }
        }
        double d4 = isSmall ? 0.3 : 0.0;
        if (d2 >= 0.9 + d4) {
            double d5 = isSmall ? 1.0 : 0.7;
            if (d2 < 0.9 + d5 && this.d(EnumItemSlot.e)) {
                return EnumItemSlot.e;
            }
        }
        if (d2 >= 0.4) {
            double d6 = isSmall ? 1.0 : 0.8;
            if (d2 < 0.4 + d6 && this.d(EnumItemSlot.d)) {
                return EnumItemSlot.d;
            }
        }
        if (d2 >= 1.6 && this.d(EnumItemSlot.f)) {
            return EnumItemSlot.f;
        }
        if (this.d(EnumItemSlot.a)) return equipmentSlot;
        if (!this.d(EnumItemSlot.b)) return equipmentSlot;
        return EnumItemSlot.b;
    }

    public boolean g(EnumItemSlot slot) {
        return (this.bT & 1 << slot.b(0)) != 0 || slot.a() == EnumItemSlot.Function.a && !this.s();
    }

    private boolean a(EntityHuman player, EnumItemSlot slot, net.minecraft.world.item.ItemStack stack, EnumHand hand) {
        net.minecraft.world.item.ItemStack itemBySlot = this.a(slot);
        if (!itemBySlot.f() && (this.bT & 1 << slot.b(8)) != 0) {
            return false;
        }
        if (itemBySlot.f() && (this.bT & 1 << slot.b(16)) != 0) {
            return false;
        }
        CraftItemStack armorStandItem = CraftItemStack.asCraftMirror(itemBySlot);
        CraftItemStack playerHeldItem = CraftItemStack.asCraftMirror(stack);
        Player player1 = (Player)player.getBukkitEntity();
        ArmorStand self = (ArmorStand)this.getBukkitEntity();
        EquipmentSlot slot1 = CraftEquipmentSlot.getSlot(slot);
        EquipmentSlot hand1 = CraftEquipmentSlot.getHand(hand);
        PlayerArmorStandManipulateEvent armorStandManipulateEvent = new PlayerArmorStandManipulateEvent(player1, self, (ItemStack)playerHeldItem, (ItemStack)armorStandItem, slot1, hand1);
        this.dV().getCraftServer().getPluginManager().callEvent((Event)armorStandManipulateEvent);
        if (armorStandManipulateEvent.isCancelled()) {
            return true;
        }
        if (player.fV() && itemBySlot.f() && !stack.f()) {
            this.a(slot, stack.c(1));
            return true;
        }
        if (stack.f() || stack.M() <= 1) {
            this.a(slot, stack);
            player.a(hand, itemBySlot);
            return true;
        }
        if (!itemBySlot.f()) {
            return false;
        }
        this.a(slot, stack.a(1));
        return true;
    }

    @Override
    public boolean a(WorldServer level, DamageSource damageSource, float amount) {
        if (this.dQ()) {
            return false;
        }
        if (!level.O().c(GameRules.d) && damageSource.d() instanceof EntityInsentient) {
            return false;
        }
        if (damageSource.a(DamageTypeTags.d)) {
            if (CraftEventFactory.handleNonLivingEntityDamageEvent(this, damageSource, amount)) {
                return false;
            }
            this.kill(level, damageSource);
            return false;
        }
        if (this.a(level, damageSource) || this.w()) {
            return false;
        }
        if (damageSource.a(DamageTypeTags.l)) {
            if (CraftEventFactory.handleNonLivingEntityDamageEvent(this, damageSource, amount, true, this.bS)) {
                return false;
            }
            EntityDeathEvent event = this.brokenByAnything(level, damageSource);
            if (!event.isCancelled()) {
                this.kill(level, damageSource, false);
            }
            return false;
        }
        if (damageSource.a(DamageTypeTags.u)) {
            if (CraftEventFactory.handleNonLivingEntityDamageEvent(this, damageSource, amount, true, this.bS)) {
                return false;
            }
            if (this.bX()) {
                this.d(level, damageSource, 0.15f);
            } else {
                this.e(5.0f);
            }
            return false;
        }
        if (damageSource.a(DamageTypeTags.v) && this.eG() > 0.5f) {
            if (CraftEventFactory.handleNonLivingEntityDamageEvent(this, damageSource, amount, true, this.bS)) {
                return false;
            }
            this.d(level, damageSource, 4.0f);
            return false;
        }
        if (CraftEventFactory.handleNonLivingEntityDamageEvent(this, damageSource, amount, true, this.bS)) {
            return false;
        }
        boolean isCanBreakArmorStand = damageSource.a(DamageTypeTags.B);
        boolean isAlwaysKillsArmorStands = damageSource.a(DamageTypeTags.A);
        if (!isCanBreakArmorStand && !isAlwaysKillsArmorStands) {
            return false;
        }
        Entity entity = damageSource.d();
        if (entity instanceof EntityHuman) {
            EntityHuman player = (EntityHuman)entity;
            if (!player.gk().e) {
                return false;
            }
        }
        if (damageSource.h()) {
            this.G();
            this.F();
            this.kill(level, damageSource);
            return true;
        }
        long gameTime = level.ae();
        if (gameTime - this.bD > 5L && !isAlwaysKillsArmorStands) {
            level.a((Entity)this, (byte)32);
            this.a(GameEvent.o, damageSource.d());
            this.bD = gameTime;
        } else {
            EntityDeathEvent event = this.brokenByPlayer(level, damageSource);
            this.F();
            if (!event.isCancelled()) {
                this.kill(level, damageSource, false);
            }
        }
        return true;
    }

    @Override
    public void b(byte id) {
        if (id == 32) {
            if (this.dV().C) {
                this.dV().a(this.dA(), this.dC(), this.dG(), SoundEffects.aC, this.dm(), 0.3f, 1.0f, false);
                this.bD = this.dV().ae();
            }
        } else {
            super.b(id);
        }
    }

    @Override
    public boolean a(double distance) {
        double d2 = this.cR().a() * 4.0;
        if (Double.isNaN(d2) || d2 == 0.0) {
            d2 = 4.0;
        }
        return distance < (d2 *= 64.0) * d2;
    }

    private void F() {
        if (this.dV() instanceof WorldServer) {
            ((WorldServer)this.dV()).a(new ParticleParamBlock(Particles.b, Blocks.n.m()), this.dA(), this.e(0.6666666666666666), this.dG(), 10, (double)(this.dq() / 4.0f), (double)(this.dr() / 4.0f), (double)(this.dq() / 4.0f), 0.05);
        }
    }

    private void d(WorldServer level, DamageSource damageSource, float damageAmount) {
        float health = this.eG();
        if ((health -= damageAmount) <= 0.5f) {
            EntityDeathEvent event = this.brokenByAnything(level, damageSource);
            if (!event.isCancelled()) {
                this.kill(level, damageSource, false);
            }
        } else {
            this.d(health);
            this.a(GameEvent.o, damageSource.d());
        }
    }

    private EntityDeathEvent brokenByPlayer(WorldServer level, DamageSource damageSource) {
        net.minecraft.world.item.ItemStack itemStack = new net.minecraft.world.item.ItemStack(Items.vQ);
        itemStack.b(DataComponents.g, this.aj());
        this.drops.add(new Entity.DefaultDrop(itemStack, stack -> Block.a(this.dV(), this.dv(), stack)));
        return this.brokenByAnything(level, damageSource);
    }

    private EntityDeathEvent brokenByAnything(WorldServer level, DamageSource damageSource) {
        this.G();
        for (EnumItemSlot equipmentSlot : EnumItemSlot.j) {
            net.minecraft.world.item.ItemStack itemStack = this.bt.a(equipmentSlot);
            if (itemStack.f()) continue;
            this.drops.add(new Entity.DefaultDrop(itemStack, stack -> Block.a(this.dV(), this.dv().d(), stack)));
        }
        EntityDeathEvent event = this.dropAllDeathLoot(level, damageSource);
        if (!event.isCancelled()) {
            for (EnumItemSlot equipmentSlot : EnumItemSlot.j) {
                this.bt.a(equipmentSlot, net.minecraft.world.item.ItemStack.l);
            }
        }
        return event;
    }

    @Override
    private void G() {
        this.dV().a(null, this.dA(), this.dC(), this.dG(), SoundEffects.aA, this.dm(), 1.0f, 1.0f);
    }

    @Override
    protected void C(float yBodyRot) {
        this.aW = this.N;
        this.aV = this.dL();
    }

    @Override
    public void a_(Vec3D travelVector) {
        if (this.D()) {
            super.a_(travelVector);
        }
    }

    @Override
    public void s(float offset) {
        this.aW = this.N = offset;
        this.aY = this.aX = offset;
    }

    @Override
    public void r(float rotation) {
        this.aW = this.N = rotation;
        this.aY = this.aX = rotation;
    }

    @Override
    public void g() {
        if (!this.canTick) {
            if (this.noTickPoseDirty) {
                this.noTickPoseDirty = false;
                this.updatePose();
            }
            if (this.noTickEquipmentDirty) {
                this.noTickEquipmentDirty = false;
                this.G();
            }
            return;
        }
        super.g();
        this.updatePose();
    }

    public void updatePose() {
        Vector3f rotations5;
        Vector3f rotations4;
        Vector3f rotations3;
        Vector3f rotations2;
        Vector3f rotations1;
        Vector3f rotations = this.al.a(bx);
        if (!this.bU.equals(rotations)) {
            this.a(rotations);
        }
        if (!this.bV.equals(rotations1 = this.al.a(by))) {
            this.b(rotations1);
        }
        if (!this.bW.equals(rotations2 = this.al.a(bz))) {
            this.c(rotations2);
        }
        if (!this.bX.equals(rotations3 = this.al.a(bA))) {
            this.d(rotations3);
        }
        if (!this.bY.equals(rotations4 = this.al.a(bB))) {
            this.e(rotations4);
        }
        if (!this.bZ.equals(rotations5 = this.al.a(bC))) {
            this.f(rotations5);
        }
    }

    @Override
    protected void J() {
        this.k(this.bS);
    }

    @Override
    public void k(boolean invisible) {
        this.bS = invisible;
        super.k(invisible);
    }

    @Override
    public boolean e_() {
        return this.p();
    }

    @Override
    public boolean eo() {
        return true;
    }

    @Override
    public void c(WorldServer level) {
        this.kill(level, null);
    }

    public void kill(WorldServer level, @Nullable DamageSource damageSource) {
        this.kill(level, damageSource, true);
    }

    public void kill(WorldServer level, @Nullable DamageSource damageSource, boolean callEvent) {
        EntityDeathEvent event;
        if (callEvent && (event = CraftEventFactory.callEntityDeathEvent(this, damageSource == null ? this.dW().y() : damageSource, this.drops)).isCancelled()) {
            return;
        }
        this.remove(Entity.RemovalReason.a, EntityRemoveEvent.Cause.DEATH);
        ((Entity)this).a(GameEvent.p);
    }

    @Override
    public boolean a(Explosion explosion) {
        return !explosion.h() || this.co();
    }

    @Override
    public EnumPistonReaction i_() {
        return this.w() ? EnumPistonReaction.d : super.i_();
    }

    @Override
    public boolean n_() {
        return this.w();
    }

    public void t(boolean small) {
        this.al.a(bw, this.a(this.al.a(bw), 1, small));
    }

    public boolean p() {
        return (this.al.a(bw) & 1) != 0;
    }

    public void a(boolean showArms) {
        this.al.a(bw, this.a(this.al.a(bw), 4, showArms));
    }

    public boolean s() {
        return (this.al.a(bw) & 4) != 0;
    }

    public void b(boolean noBasePlate) {
        this.al.a(bw, this.a(this.al.a(bw), 8, noBasePlate));
    }

    public boolean u() {
        return (this.al.a(bw) & 8) == 0;
    }

    public void u(boolean marker) {
        this.al.a(bw, this.a(this.al.a(bw), 16, marker));
    }

    public boolean w() {
        return (this.al.a(bw) & 0x10) != 0;
    }

    private byte a(byte oldBit, int offset, boolean value) {
        oldBit = value ? (byte)(oldBit | offset) : (byte)(oldBit & ~offset);
        return oldBit;
    }

    public void a(Vector3f headPose) {
        this.bU = headPose;
        this.al.a(bx, headPose);
        this.noTickPoseDirty = true;
    }

    public void b(Vector3f bodyPose) {
        this.bV = bodyPose;
        this.al.a(by, bodyPose);
        this.noTickPoseDirty = true;
    }

    public void c(Vector3f leftArmPose) {
        this.bW = leftArmPose;
        this.al.a(bz, leftArmPose);
        this.noTickPoseDirty = true;
    }

    public void d(Vector3f rightArmPose) {
        this.bX = rightArmPose;
        this.al.a(bA, rightArmPose);
        this.noTickPoseDirty = true;
    }

    public void e(Vector3f leftLegPose) {
        this.bY = leftLegPose;
        this.al.a(bB, leftLegPose);
        this.noTickPoseDirty = true;
    }

    public void f(Vector3f rightLegPose) {
        this.bZ = rightLegPose;
        this.al.a(bC, rightLegPose);
        this.noTickPoseDirty = true;
    }

    public Vector3f x() {
        return this.bU;
    }

    public Vector3f y() {
        return this.bV;
    }

    public Vector3f z() {
        return this.bW;
    }

    public Vector3f A() {
        return this.bX;
    }

    public Vector3f B() {
        return this.bY;
    }

    public Vector3f C() {
        return this.bZ;
    }

    @Override
    public boolean bF() {
        return super.bF() && !this.w();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean v(Entity entity) {
        if (!(entity instanceof EntityHuman)) return false;
        EntityHuman player = (EntityHuman)entity;
        if (this.dV().a((Entity)player, this.dv())) return false;
        return true;
    }

    @Override
    public EnumMainHand fy() {
        return EnumMainHand.b;
    }

    @Override
    public EntityLiving.a eO() {
        return new EntityLiving.a(SoundEffects.aB, SoundEffects.aB);
    }

    @Override
    @Nullable
    public SoundEffect e(DamageSource damageSource) {
        return SoundEffects.aC;
    }

    @Override
    @Nullable
    public SoundEffect j_() {
        return SoundEffects.aA;
    }

    @Override
    public void a(WorldServer level, EntityLightning lightning) {
    }

    @Override
    public boolean fL() {
        return false;
    }

    @Override
    public void a(DataWatcherObject<?> key) {
        if (bw.equals(key)) {
            this.h_();
            this.I = !this.w();
        }
        super.a(key);
    }

    @Override
    public boolean fM() {
        return false;
    }

    @Override
    public EntitySize e(EntityPose pose) {
        return this.v(this.w());
    }

    private EntitySize v(boolean isMarker) {
        if (isMarker) {
            return bF;
        }
        return this.e_() ? bG : this.an().n();
    }

    @Override
    public Vec3D o(float partialTicks) {
        if (this.w()) {
            AxisAlignedBB aabb = this.v(false).a(this.dt());
            BlockPosition blockPos = this.dv();
            int i2 = Integer.MIN_VALUE;
            for (BlockPosition blockPos1 : BlockPosition.c(BlockPosition.a(aabb.a, aabb.b, aabb.c), BlockPosition.a(aabb.d, aabb.e, aabb.f))) {
                int max = Math.max(this.dV().a(EnumSkyBlock.b, blockPos1), this.dV().a(EnumSkyBlock.a, blockPos1));
                if (max == 15) {
                    return Vec3D.b(blockPos1);
                }
                if (max <= i2) continue;
                i2 = max;
                blockPos = blockPos1.j();
            }
            return Vec3D.b(blockPos);
        }
        return super.o(partialTicks);
    }

    @Override
    public net.minecraft.world.item.ItemStack dI() {
        return new net.minecraft.world.item.ItemStack(Items.vQ);
    }

    @Override
    public boolean eA() {
        return !this.co() && !this.w();
    }

    @Override
    public void a(EnumMoveType type, Vec3D movement) {
        if (this.canMove) {
            super.a(type, movement);
        }
    }
}

