/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.decoration;

import com.mojang.serialization.DynamicOps;
import io.papermc.paper.event.player.PlayerItemFrameChangeEvent;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.resources.RegistryOps;
import net.minecraft.server.level.EntityTrackerEntry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.MathHelper;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.decoration.EntityHanging;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemWorldMap;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.BlockDiodeAbstract;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.saveddata.maps.MapId;
import net.minecraft.world.level.saveddata.maps.WorldMap;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import org.apache.commons.lang3.Validate;
import org.bukkit.craftbukkit.v1_21_R4.event.CraftEventFactory;
import org.bukkit.entity.ItemFrame;
import org.bukkit.entity.Player;

public class EntityItemFrame
extends EntityHanging {
    public static final DataWatcherObject<ItemStack> e = DataWatcher.a(EntityItemFrame.class, DataWatcherRegistry.h);
    public static final DataWatcherObject<Integer> f = DataWatcher.a(EntityItemFrame.class, DataWatcherRegistry.b);
    public static final int d = 8;
    private static final float g = 0.0625f;
    private static final float h = 0.75f;
    private static final float i = 0.75f;
    private static final byte j = 0;
    private static final float k = 1.0f;
    private static final boolean l = false;
    private static final boolean m = false;
    public float n = 1.0f;
    public boolean o = false;
    @Nullable
    public MapId cachedMapId;

    public EntityItemFrame(EntityTypes<? extends EntityItemFrame> entityType, World level) {
        super((EntityTypes<? extends EntityHanging>)entityType, level);
        this.k(false);
    }

    public EntityItemFrame(World level, BlockPosition pos, EnumDirection facingDirection) {
        this(EntityTypes.at, level, pos, facingDirection);
    }

    public EntityItemFrame(EntityTypes<? extends EntityItemFrame> entityType, World level, BlockPosition pos, EnumDirection direction) {
        super((EntityTypes<? extends EntityHanging>)entityType, level, pos);
        this.a(direction);
        this.k(false);
    }

    @Override
    protected void a(DataWatcher.a builder) {
        builder.a(e, ItemStack.l);
        builder.a(f, 0);
    }

    @Override
    public void a(EnumDirection facingDirection) {
        Validate.notNull((Object)facingDirection);
        this.c = facingDirection;
        if (facingDirection.o().d()) {
            this.x(0.0f);
            this.w(this.c.e() * 90);
        } else {
            this.x(-90 * facingDirection.f().a());
            this.w(0.0f);
        }
        this.O = this.dN();
        this.N = this.dL();
        this.e();
    }

    @Override
    protected AxisAlignedBB a(BlockPosition pos, EnumDirection direction) {
        return EntityItemFrame.calculateBoundingBoxStatic(pos, direction);
    }

    public static AxisAlignedBB calculateBoundingBoxStatic(BlockPosition pos, EnumDirection direction) {
        float f2 = 0.46875f;
        Vec3D vec3 = Vec3D.b(pos).a(direction, -0.46875);
        EnumDirection.EnumAxis axis = direction.o();
        double d2 = axis == EnumDirection.EnumAxis.a ? 0.0625 : 0.75;
        double d1 = axis == EnumDirection.EnumAxis.b ? 0.0625 : 0.75;
        double d22 = axis == EnumDirection.EnumAxis.c ? 0.0625 : 0.75;
        return AxisAlignedBB.a(vec3, d2, d1, d22);
    }

    @Override
    public boolean f() {
        if (this.o) {
            return true;
        }
        if (!this.dV().g(this)) {
            return false;
        }
        IBlockData blockState = this.dV().a_(this.a.a(this.c.g()));
        return (blockState.e() || this.c.o().d() && BlockDiodeAbstract.n(blockState)) && this.dV().a((Entity)this, this.cR(), EntityHanging.b).isEmpty();
    }

    @Override
    public void a(EnumMoveType type, Vec3D pos) {
        if (!this.o) {
            super.a(type, pos);
        }
    }

    @Override
    public void push(double x2, double y2, double z2, @Nullable Entity pushingEntity) {
        if (!this.o) {
            super.push(x2, y2, z2, pushingEntity);
        }
    }

    @Override
    public void c(WorldServer level) {
        this.d(this.v());
        super.c(level);
    }

    private boolean a(DamageSource damageSource) {
        return !damageSource.a(DamageTypeTags.l) && !this.v().f();
    }

    private static boolean e(DamageSource damageSource) {
        return damageSource.a(DamageTypeTags.d) || damageSource.h();
    }

    @Override
    public boolean b(DamageSource damageSource) {
        return (!this.o || EntityItemFrame.e(damageSource)) && !this.d(damageSource);
    }

    @Override
    public boolean a(WorldServer level, DamageSource damageSource, float amount) {
        if (!this.o) {
            if (this.d(damageSource)) {
                return false;
            }
            if (this.a(damageSource)) {
                if (CraftEventFactory.handleNonLivingEntityDamageEvent(this, damageSource, amount, false) || this.dQ()) {
                    return true;
                }
                Entity entity = damageSource.d();
                if (entity instanceof EntityHuman) {
                    EntityHuman player = (EntityHuman)entity;
                    PlayerItemFrameChangeEvent event = new PlayerItemFrameChangeEvent((Player)player.getBukkitEntity(), (ItemFrame)this.getBukkitEntity(), this.v().asBukkitCopy(), PlayerItemFrameChangeEvent.ItemFrameChangeAction.REMOVE);
                    if (!event.callEvent()) {
                        return true;
                    }
                    this.a(ItemStack.fromBukkitCopy(event.getItemStack()), false);
                }
                this.a(level, damageSource.d(), false);
                this.a(GameEvent.c, damageSource.d());
                this.a(this.l(), 1.0f, 1.0f);
                return true;
            }
            return super.a(level, damageSource, amount);
        }
        return EntityItemFrame.e(damageSource) && super.a(level, damageSource, amount);
    }

    public SoundEffect l() {
        return SoundEffects.og;
    }

    @Override
    public boolean a(double distance) {
        double d2 = 16.0;
        return distance < (d2 *= 64.0 * EntityItemFrame.cK()) * d2;
    }

    @Override
    public void a(WorldServer level, @Nullable Entity entity) {
        this.a(this.m(), 1.0f, 1.0f);
        this.a(level, entity, true);
        this.a(GameEvent.c, entity);
    }

    public SoundEffect m() {
        return SoundEffects.oe;
    }

    @Override
    public void u() {
        this.a(this.n(), 1.0f, 1.0f);
    }

    public SoundEffect n() {
        return SoundEffects.of;
    }

    private void a(WorldServer level, @Nullable Entity entity, boolean dropItem) {
        if (!this.o) {
            EntityHuman player;
            ItemStack item = this.v();
            this.b(ItemStack.l);
            if (!level.O().c(GameRules.j)) {
                if (entity == null) {
                    this.d(item);
                }
            } else if (entity instanceof EntityHuman && (player = (EntityHuman)entity).fV()) {
                this.d(item);
            } else {
                if (dropItem) {
                    this.a(level, this.s());
                }
                if (!item.f()) {
                    item = item.v();
                    this.d(item);
                    if (this.ae.i() < this.n) {
                        this.a(level, item);
                    }
                }
            }
        }
    }

    private void d(ItemStack stack) {
        WorldMap savedData;
        MapId framedMapId = this.a(stack);
        if (framedMapId != null && (savedData = ItemWorldMap.a(framedMapId, this.dV())) != null) {
            savedData.a(this.a, this.ao());
        }
        stack.a((Entity)null);
    }

    public ItemStack v() {
        return this.ar().a(e);
    }

    @Override
    @Nullable
    public EntityItem a(WorldServer serverLevel, ItemStack stack) {
        return this.a(serverLevel, stack, this.cO() == EnumDirection.a ? -0.6f : 0.0f);
    }

    @Nullable
    public MapId a(ItemStack stack) {
        return stack.a(DataComponents.M);
    }

    public boolean w() {
        return this.v().c(DataComponents.M);
    }

    public void b(ItemStack stack) {
        this.a(stack, true);
    }

    public void a(ItemStack stack, boolean updateNeighbours) {
        this.setItem(stack, updateNeighbours, true);
    }

    public void setItem(ItemStack stack, boolean updateNeighbours, boolean playSound) {
        if (!stack.f()) {
            stack = stack.c(1);
        }
        this.e(stack);
        this.ar().a(e, stack);
        if (!stack.f() && updateNeighbours && playSound) {
            this.a(this.p(), 1.0f, 1.0f);
        }
        if (updateNeighbours && this.a != null) {
            this.dV().b(this.a, Blocks.a);
        }
    }

    public SoundEffect p() {
        return SoundEffects.od;
    }

    @Override
    public SlotAccess a_(int slot) {
        return slot == 0 ? SlotAccess.a(this::v, this::b) : super.a_(slot);
    }

    @Override
    public void a(DataWatcherObject<?> key) {
        if (key.equals(e)) {
            this.e(this.v());
        }
    }

    private void e(ItemStack item) {
        this.cachedMapId = item.a().a(DataComponents.M);
        if (!item.f() && item.I() != this) {
            item.a(this);
        }
        this.e();
    }

    public int x() {
        return this.ar().a(f);
    }

    public void b(int rotation) {
        this.a(rotation, true);
    }

    private void a(int rotation, boolean updateNeighbours) {
        this.ar().a(f, rotation % 8);
        if (updateNeighbours && this.a != null) {
            this.dV().b(this.a, Blocks.a);
        }
    }

    @Override
    public void b(NBTTagCompound compound) {
        super.b(compound);
        ItemStack item = this.v();
        if (!item.f()) {
            RegistryOps<NBTBase> registryOps = this.dX().a(DynamicOpsNBT.a);
            compound.a("Item", ItemStack.b, registryOps, item);
        }
        compound.a("ItemRotation", (byte)this.x());
        compound.a("ItemDropChance", this.n);
        compound.a("Facing", EnumDirection.k, this.c);
        compound.a("Invisible", this.co());
        compound.a("Fixed", this.o);
    }

    @Override
    public void a(NBTTagCompound compound) {
        super.a(compound);
        RegistryOps<NBTBase> registryOps = this.dX().a(DynamicOpsNBT.a);
        ItemStack itemStack = compound.a("Item", ItemStack.b, (DynamicOps<NBTBase>)registryOps).orElse(ItemStack.l);
        ItemStack item = this.v();
        if (!item.f() && !ItemStack.a(itemStack, item)) {
            this.d(item);
        }
        this.a(itemStack, false);
        this.a(compound.b("ItemRotation", (byte)0), false);
        this.n = compound.b("ItemDropChance", 1.0f);
        this.a(compound.a("Facing", EnumDirection.k).orElse(EnumDirection.a));
        this.k(compound.b("Invisible", false));
        this.o = compound.b("Fixed", false);
    }

    @Override
    public EnumInteractionResult a(EntityHuman player, EnumHand hand) {
        boolean flag1;
        ItemStack itemInHand = player.b(hand);
        boolean flag = !this.v().f();
        boolean bl = flag1 = !itemInHand.f();
        if (this.o) {
            return EnumInteractionResult.e;
        }
        if (!player.dV().C) {
            if (!flag) {
                if (flag1 && !this.dQ()) {
                    WorldMap savedData = ItemWorldMap.b(itemInHand, this.dV());
                    if (savedData != null && savedData.a(256)) {
                        return EnumInteractionResult.d;
                    }
                    PlayerItemFrameChangeEvent event = new PlayerItemFrameChangeEvent((Player)player.getBukkitEntity(), (ItemFrame)this.getBukkitEntity(), itemInHand.asBukkitCopy(), PlayerItemFrameChangeEvent.ItemFrameChangeAction.PLACE);
                    if (!event.callEvent()) {
                        return EnumInteractionResult.d;
                    }
                    this.b(ItemStack.fromBukkitCopy(event.getItemStack()));
                    this.a(GameEvent.c, (Entity)player);
                    itemInHand.a(1, (EntityLiving)player);
                    return EnumInteractionResult.a;
                }
                return EnumInteractionResult.e;
            }
            PlayerItemFrameChangeEvent event = new PlayerItemFrameChangeEvent((Player)player.getBukkitEntity(), (ItemFrame)this.getBukkitEntity(), this.v().asBukkitCopy(), PlayerItemFrameChangeEvent.ItemFrameChangeAction.ROTATE);
            if (!event.callEvent()) {
                return EnumInteractionResult.d;
            }
            this.setItem(ItemStack.fromBukkitCopy(event.getItemStack()), false, false);
            this.a(this.r(), 1.0f, 1.0f);
            this.b(this.x() + 1);
            this.a(GameEvent.c, (Entity)player);
            return EnumInteractionResult.a;
        }
        return (EnumInteractionResult)((Object)(!flag && !flag1 ? EnumInteractionResult.e : EnumInteractionResult.a));
    }

    public SoundEffect r() {
        return SoundEffects.oh;
    }

    public int y() {
        return this.v().f() ? 0 : this.x() % 8 + 1;
    }

    @Override
    public Packet<PacketListenerPlayOut> a(EntityTrackerEntry entity) {
        return new PacketPlayOutSpawnEntity((Entity)this, this.c.d(), this.i());
    }

    @Override
    public void a(PacketPlayOutSpawnEntity packet) {
        super.a(packet);
        this.a(EnumDirection.a(packet.p()));
    }

    @Override
    public ItemStack dI() {
        ItemStack item = this.v();
        return item.f() ? this.s() : item.v();
    }

    protected ItemStack s() {
        return new ItemStack(Items.vm);
    }

    @Override
    public float dM() {
        EnumDirection direction = this.cO();
        int i2 = direction.o().b() ? 90 * direction.f().a() : 0;
        return MathHelper.b(180 + direction.e() * 90 + this.x() * 45 + i2);
    }
}

