/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.decoration;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.network.protocol.game.PacketPlayOutAttachEntity;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.EntityTrackerEntry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsBlock;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.Leashable;
import net.minecraft.world.entity.decoration.BlockAttachedEntity;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemLeash;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.World;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_21_R4.event.CraftEventFactory;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.player.PlayerUnleashEntityEvent;

public class EntityLeash
extends BlockAttachedEntity {
    public static final double b = 0.375;

    public EntityLeash(EntityTypes<? extends EntityLeash> entityType, World level) {
        super((EntityTypes<? extends BlockAttachedEntity>)entityType, level);
    }

    public EntityLeash(World level, BlockPosition pos) {
        super(EntityTypes.aw, level, pos);
        this.a_(pos.u(), pos.v(), pos.w());
    }

    @Override
    protected void a(DataWatcher.a builder) {
    }

    @Override
    protected void e() {
        this.o((double)this.a.u() + 0.5, (double)this.a.v() + 0.375, (double)this.a.w() + 0.5);
        double d2 = (double)this.an().l() / 2.0;
        double d1 = this.an().m();
        this.a(new AxisAlignedBB(this.dA() - d2, this.dC(), this.dG() - d2, this.dA() + d2, this.dC() + d1, this.dG() + d2));
    }

    @Override
    public boolean a(double distance) {
        return distance < 1024.0;
    }

    @Override
    public void a(WorldServer level, @Nullable Entity entity) {
        this.a(SoundEffects.oE, 1.0f, 1.0f);
    }

    @Override
    public void b(NBTTagCompound compound) {
    }

    @Override
    public void a(NBTTagCompound compound) {
    }

    @Override
    public EnumInteractionResult a(EntityHuman player, EnumHand hand) {
        if (this.dV().C) {
            return EnumInteractionResult.a;
        }
        boolean flag = false;
        List<Leashable> list = ItemLeash.a(this.dV(), this.i(), (Leashable leashable2) -> {
            Entity leashHolder = leashable2.B();
            return leashHolder == player || leashHolder == this;
        });
        for (Leashable leashable : list) {
            Entity leashed;
            if (leashable.B() != player) continue;
            if (leashable instanceof Entity && CraftEventFactory.callPlayerLeashEntityEvent(leashed = (Entity)((Object)leashable), this, player, hand).isCancelled()) {
                ((EntityPlayer)player).f.b(new PacketPlayOutAttachEntity(leashed, leashable.B()));
                flag = true;
                continue;
            }
            leashable.a_(this, true);
            flag = true;
        }
        boolean flag1 = false;
        if (!flag) {
            boolean die = true;
            for (Leashable leashable1 : list) {
                boolean dropLeash;
                if (!leashable1.Q_() || leashable1.B() != this) continue;
                boolean bl = dropLeash = !player.fV();
                if (leashable1 instanceof Entity) {
                    Entity leashed = (Entity)((Object)leashable1);
                    PlayerUnleashEntityEvent event = CraftEventFactory.callPlayerUnleashEntityEvent(leashed, player, hand, dropLeash);
                    dropLeash = event.isDropLeash();
                    if (event.isCancelled()) {
                        die = false;
                        continue;
                    }
                }
                if (!dropLeash) {
                    leashable1.y();
                } else {
                    leashable1.x();
                }
                flag1 = true;
            }
            if (die) {
                this.discard(EntityRemoveEvent.Cause.DROP);
            }
        }
        if (flag || flag1) {
            this.a(GameEvent.b, (Entity)player);
        }
        return EnumInteractionResult.a;
    }

    @Override
    public boolean f() {
        return this.dV().a_(this.a).a(TagsBlock.U);
    }

    public static EntityLeash b(World level, BlockPosition pos) {
        int x2 = pos.u();
        int y2 = pos.v();
        int z2 = pos.w();
        for (EntityLeash leashFenceKnotEntity : level.a(EntityLeash.class, new AxisAlignedBB((double)x2 - 1.0, (double)y2 - 1.0, (double)z2 - 1.0, (double)x2 + 1.0, (double)y2 + 1.0, (double)z2 + 1.0))) {
            if (!leashFenceKnotEntity.i().equals(pos)) continue;
            return leashFenceKnotEntity;
        }
        EntityLeash leashFenceKnotEntity1 = new EntityLeash(level, pos);
        level.b(leashFenceKnotEntity1);
        return leashFenceKnotEntity1;
    }

    public void l() {
        this.a(SoundEffects.oF, 1.0f, 1.0f);
    }

    @Override
    public Packet<PacketListenerPlayOut> a(EntityTrackerEntry entity) {
        return new PacketPlayOutSpawnEntity((Entity)this, 0, this.i());
    }

    @Override
    public Vec3D v(float partialTicks) {
        return this.p(partialTicks).b(0.0, 0.2, 0.0);
    }

    @Override
    public ItemStack dI() {
        return new ItemStack(Items.vV);
    }
}

