/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.decoration;

import java.util.ArrayList;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.EntityTrackerEntry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.PaintingVariantTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.decoration.EntityHanging;
import net.minecraft.world.entity.decoration.PaintingVariant;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.variant.VariantUtils;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.World;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;

public class EntityPainting
extends EntityHanging {
    private static final DataWatcherObject<Holder<PaintingVariant>> e = DataWatcher.a(EntityPainting.class, DataWatcherRegistry.E);
    public static final float d = 0.0625f;

    public EntityPainting(EntityTypes<? extends EntityPainting> entityType, World level) {
        super((EntityTypes<? extends EntityHanging>)entityType, level);
    }

    @Override
    protected void a(DataWatcher.a builder) {
        builder.a(e, VariantUtils.b(this.dX(), Registries.aZ));
    }

    @Override
    public void a(DataWatcherObject<?> key) {
        if (e.equals(key)) {
            this.e();
        }
    }

    public void b(Holder<PaintingVariant> variant) {
        this.al.a(e, variant);
    }

    public Holder<PaintingVariant> l() {
        return this.al.a(e);
    }

    @Override
    @Nullable
    public <T> T a(DataComponentType<? extends T> component) {
        return component == DataComponents.aM ? EntityPainting.c(component, this.l()) : super.a(component);
    }

    @Override
    protected void a(DataComponentGetter componentGetter) {
        this.a(componentGetter, DataComponents.aM);
        super.a(componentGetter);
    }

    @Override
    protected <T> boolean b(DataComponentType<T> component, T value) {
        if (component == DataComponents.aM) {
            this.b(EntityPainting.c(DataComponents.aM, value));
            return true;
        }
        return super.b(component, value);
    }

    public static Optional<EntityPainting> a(World level, BlockPosition pos, EnumDirection direction) {
        EntityPainting painting = new EntityPainting(level, pos);
        ArrayList<Holder> list = new ArrayList<Holder>();
        level.J_().f(Registries.aZ).c(PaintingVariantTags.a).forEach(list::add);
        if (list.isEmpty()) {
            return Optional.empty();
        }
        painting.a(direction);
        list.removeIf(holder -> {
            painting.b((Holder<PaintingVariant>)holder);
            return !painting.f();
        });
        if (list.isEmpty()) {
            return Optional.empty();
        }
        int i2 = list.stream().mapToInt(EntityPainting::c).max().orElse(0);
        list.removeIf(holder -> EntityPainting.c(holder) < i2);
        Optional randomSafe = SystemUtils.b(list, painting.ae);
        if (randomSafe.isEmpty()) {
            return Optional.empty();
        }
        painting.b((Holder)randomSafe.get());
        painting.a(direction);
        return Optional.of(painting);
    }

    private static int c(Holder<PaintingVariant> variant) {
        return variant.a().a();
    }

    private EntityPainting(World level, BlockPosition pos) {
        super((EntityTypes<? extends EntityHanging>)EntityTypes.aL, level, pos);
    }

    public EntityPainting(World level, BlockPosition pos, EnumDirection direction, Holder<PaintingVariant> variant) {
        this(level, pos);
        this.b(variant);
        this.a(direction);
    }

    @Override
    public void b(NBTTagCompound compound) {
        compound.a("facing", EnumDirection.l, this.c);
        super.b(compound);
        VariantUtils.a(compound, this.l());
    }

    @Override
    public void a(NBTTagCompound compound) {
        this.c = compound.a("facing", EnumDirection.l).orElse(EnumDirection.d);
        super.a(compound);
        this.a(this.c);
        VariantUtils.a(compound, this.dX(), Registries.aZ).ifPresent(this::b);
    }

    @Override
    protected AxisAlignedBB a(BlockPosition pos, EnumDirection direction) {
        PaintingVariant variant = this.l().a();
        return EntityPainting.calculateBoundingBoxStatic(pos, direction, variant.b(), variant.c());
    }

    public static AxisAlignedBB calculateBoundingBoxStatic(BlockPosition pos, EnumDirection direction, int width, int height) {
        float f2 = 0.46875f;
        Vec3D vec3 = Vec3D.b(pos).a(direction, -0.46875);
        double d2 = EntityPainting.b(width);
        double d1 = EntityPainting.b(height);
        EnumDirection counterClockWise = direction.i();
        Vec3D vec31 = vec3.a(counterClockWise, d2).a(EnumDirection.b, d1);
        EnumDirection.EnumAxis axis = direction.o();
        double d22 = axis == EnumDirection.EnumAxis.a ? 0.0625 : (double)width;
        double d3 = height;
        double d4 = axis == EnumDirection.EnumAxis.c ? 0.0625 : (double)width;
        return AxisAlignedBB.a(vec31, d22, d3, d4);
    }

    private static double b(int size) {
        return size % 2 == 0 ? 0.5 : 0.0;
    }

    @Override
    public void a(WorldServer level, @Nullable Entity entity) {
        if (level.O().c(GameRules.j)) {
            EntityHuman player;
            this.a(SoundEffects.te, 1.0f, 1.0f);
            if (!(entity instanceof EntityHuman) || !(player = (EntityHuman)entity).fV()) {
                this.a(level, Items.qN);
            }
        }
    }

    @Override
    public void u() {
        this.a(SoundEffects.tf, 1.0f, 1.0f);
    }

    @Override
    public void b(double x2, double y2, double z2, float yRot, float xRot) {
        this.a_(x2, y2, z2);
    }

    @Override
    public Vec3D du() {
        return Vec3D.a(this.a);
    }

    @Override
    public Packet<PacketListenerPlayOut> a(EntityTrackerEntry entity) {
        return new PacketPlayOutSpawnEntity((Entity)this, this.c.d(), this.i());
    }

    @Override
    public void a(PacketPlayOutSpawnEntity packet) {
        super.a(packet);
        this.a(EnumDirection.a(packet.p()));
    }

    @Override
    public ItemStack dI() {
        return new ItemStack(Items.qN);
    }
}

