/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.item;

import com.mojang.logging.LogUtils;
import com.mojang.serialization.DynamicOps;
import io.papermc.paper.configuration.GlobalConfiguration;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.CrashReportSystemDetails;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.network.protocol.game.PacketPlayOutBlockChange;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.EntityTrackerEntry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsFluid;
import net.minecraft.util.MathHelper;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockActionContextDirectional;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.RayTrace;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockAnvil;
import net.minecraft.world.level.block.BlockConcretePowder;
import net.minecraft.world.level.block.BlockFalling;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Fallable;
import net.minecraft.world.level.block.GameMasterBlock;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.material.FluidTypes;
import net.minecraft.world.level.portal.TeleportTransition;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_21_R4.event.CraftEventFactory;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.slf4j.Logger;

public class EntityFallingBlock
extends Entity {
    private static final Logger f = LogUtils.getLogger();
    private static final IBlockData g = Blocks.L.m();
    private static final int h = 0;
    private static final float i = 0.0f;
    private static final int j = 40;
    private static final boolean k = true;
    private static final boolean l = false;
    public IBlockData m = g;
    public int a = 0;
    public boolean b = true;
    public boolean n = false;
    public boolean o;
    public int p = 40;
    public float q = 0.0f;
    @Nullable
    public NBTTagCompound c;
    public boolean d;
    protected static final DataWatcherObject<BlockPosition> e = DataWatcher.a(EntityFallingBlock.class, DataWatcherRegistry.o);
    public boolean autoExpire = true;

    public EntityFallingBlock(EntityTypes<? extends EntityFallingBlock> entityType, World level) {
        super(entityType, level);
    }

    public EntityFallingBlock(World level, double x2, double y2, double z2, IBlockData state) {
        this((EntityTypes<? extends EntityFallingBlock>)EntityTypes.Y, level);
        this.m = state;
        this.I = true;
        this.a_(x2, y2, z2);
        this.i(Vec3D.c);
        this.K = x2;
        this.L = y2;
        this.M = z2;
        this.a(this.dv());
    }

    public static EntityFallingBlock a(World level, BlockPosition pos, IBlockData blockState) {
        EntityFallingBlock fallingBlockEntity = new EntityFallingBlock(level, (double)pos.u() + 0.5, pos.v(), (double)pos.w() + 0.5, blockState.b(BlockProperties.I) ? (IBlockData)blockState.b(BlockProperties.I, false) : blockState);
        if (!CraftEventFactory.callEntityChangeBlockEvent(fallingBlockEntity, pos, blockState.y().g())) {
            return fallingBlockEntity;
        }
        level.a(pos, blockState.y().g(), 3);
        level.b(fallingBlockEntity);
        return fallingBlockEntity;
    }

    @Override
    public boolean cB() {
        return false;
    }

    @Override
    public final boolean a(WorldServer level, DamageSource damageSource, float amount) {
        if (!this.d(damageSource)) {
            this.bB();
        }
        return false;
    }

    public void a(BlockPosition startPos) {
        this.al.a(e, startPos);
    }

    public BlockPosition e() {
        return this.al.a(e);
    }

    @Override
    protected Entity.MovementEmission bf() {
        return Entity.MovementEmission.a;
    }

    @Override
    protected void a(DataWatcher.a builder) {
        builder.a(e, BlockPosition.c);
    }

    @Override
    public boolean bF() {
        return !this.dQ();
    }

    @Override
    protected double bc() {
        return 0.04;
    }

    @Override
    public void g() {
        if (this.m.l()) {
            this.discard(EntityRemoveEvent.Cause.DESPAWN);
        } else {
            Block block = this.m.b();
            ++this.a;
            this.be();
            this.a(EnumMoveType.a, this.dy());
            this.aI();
            if (this.dV().paperConfig().fixes.fallingBlockHeightNerf.test(v2 -> this.dC() > (double)v2)) {
                WorldServer serverLevel;
                World world;
                if (this.b && (world = this.dV()) instanceof WorldServer && (serverLevel = (WorldServer)world).O().c(GameRules.j)) {
                    this.a(serverLevel, block);
                }
                this.discard(EntityRemoveEvent.Cause.OUT_OF_WORLD);
                return;
            }
            this.bV();
            World world = this.dV();
            if (world instanceof WorldServer) {
                WorldServer serverLevel = (WorldServer)world;
                if (this.bJ() || this.d) {
                    MovingObjectPositionBlock blockHitResult;
                    BlockPosition blockPos = this.dv();
                    boolean flag = this.m.b() instanceof BlockConcretePowder;
                    boolean flag1 = flag && this.dV().b_(blockPos).a(TagsFluid.a);
                    double d2 = this.dy().h();
                    if (flag && d2 > 1.0 && (blockHitResult = this.dV().a(new RayTrace(new Vec3D(this.K, this.L, this.M), this.dt(), RayTrace.BlockCollisionOption.a, RayTrace.FluidCollisionOption.b, this))).d() != MovingObjectPosition.EnumMovingObjectType.a && this.dV().b_(blockHitResult.b()).a(TagsFluid.a)) {
                        blockPos = blockHitResult.b();
                        flag1 = true;
                    }
                    if (!this.aH() && !flag1) {
                        if (this.a > 100 && this.autoExpire && (blockPos.v() <= this.dV().K_() || blockPos.v() > this.dV().ao()) || this.a > 600 && this.autoExpire) {
                            if (this.b && serverLevel.O().c(GameRules.j)) {
                                this.a(serverLevel, block);
                            }
                            this.discard(EntityRemoveEvent.Cause.DROP);
                        }
                    } else {
                        IBlockData blockState = this.dV().a_(blockPos);
                        this.i(this.dy().d(0.7, -0.5, 0.7));
                        if (!blockState.a(Blocks.ca)) {
                            if (!this.n) {
                                boolean flag3;
                                boolean canBeReplaced = blockState.a(new BlockActionContextDirectional(this.dV(), blockPos, EnumDirection.a, ItemStack.l, EnumDirection.b));
                                boolean flag2 = BlockFalling.n(this.dV().a_(blockPos.e())) && (!flag || !flag1);
                                boolean bl = flag3 = this.m.a((IWorldReader)this.dV(), blockPos) && !flag2;
                                if (canBeReplaced && flag3) {
                                    if (this.m.b(BlockProperties.I) && this.dV().b_(blockPos).a() == FluidTypes.c) {
                                        this.m = (IBlockData)this.m.b(BlockProperties.I, true);
                                    }
                                    if (!CraftEventFactory.callEntityChangeBlockEvent(this, blockPos, this.m)) {
                                        this.discard(EntityRemoveEvent.Cause.DESPAWN);
                                        return;
                                    }
                                    if (this.dV().a(blockPos, this.m, 3)) {
                                        TileEntity blockEntity;
                                        ((WorldServer)this.dV()).m().a.a(this, new PacketPlayOutBlockChange(blockPos, this.dV().a_(blockPos)));
                                        this.discard(EntityRemoveEvent.Cause.DESPAWN);
                                        if (block instanceof Fallable) {
                                            ((Fallable)((Object)block)).a(this.dV(), blockPos, this.m, blockState, this);
                                        }
                                        if (this.c != null && this.m.x() && (blockEntity = this.dV().c_(blockPos)) != null) {
                                            NBTTagCompound compoundTag = blockEntity.d(this.dV().J_());
                                            this.c.a((String string, NBTBase tag) -> compoundTag.a((String)string, tag.d()));
                                            try {
                                                blockEntity.c(compoundTag, this.dV().J_());
                                            }
                                            catch (Exception var15) {
                                                f.error("Failed to load block entity from falling block", (Throwable)var15);
                                            }
                                            blockEntity.e();
                                        }
                                    } else if (this.b && serverLevel.O().c(GameRules.j)) {
                                        this.discard(EntityRemoveEvent.Cause.DROP);
                                        this.a(block, blockPos);
                                        this.a(serverLevel, block);
                                    }
                                } else {
                                    this.discard(EntityRemoveEvent.Cause.DROP);
                                    if (this.b && serverLevel.O().c(GameRules.j)) {
                                        this.a(block, blockPos);
                                        this.a(serverLevel, block);
                                    }
                                }
                            } else {
                                this.discard(EntityRemoveEvent.Cause.DESPAWN);
                                this.a(block, blockPos);
                            }
                        }
                    }
                }
            }
            this.i(this.dy().c(0.98));
        }
    }

    public void a(Block block, BlockPosition pos) {
        if (block instanceof Fallable) {
            ((Fallable)((Object)block)).a(this.dV(), pos, this);
        }
    }

    @Override
    public boolean a(double fallDistance, float damageMultiplier, DamageSource damageSource) {
        DamageSource damageSource2;
        if (!this.o) {
            return false;
        }
        int ceil = MathHelper.c(fallDistance - 1.0);
        if (ceil < 0) {
            return false;
        }
        Predicate<Entity> predicate = IEntitySelector.e.and(IEntitySelector.b);
        Block block = this.m.b();
        if (block instanceof Fallable) {
            Fallable fallable = (Fallable)((Object)block);
            damageSource2 = fallable.a(this);
        } else {
            damageSource2 = this.dW().a(this);
        }
        DamageSource damageSource1 = damageSource2;
        float f2 = Math.min(MathHelper.d((float)ceil * this.q), this.p);
        this.dV().a((Entity)this, this.cR(), predicate).forEach(entity -> entity.a(damageSource1, f2));
        boolean isAnvil = this.m.a(TagsBlock.O);
        if (isAnvil && f2 > 0.0f && this.ae.i() < 0.05f + (float)ceil * 0.05f) {
            IBlockData blockState = BlockAnvil.e(this.m);
            if (blockState == null) {
                this.n = true;
            } else {
                this.m = blockState;
            }
        }
        return false;
    }

    @Override
    protected void b(NBTTagCompound compound) {
        RegistryOps<NBTBase> registryOps = this.dX().a(DynamicOpsNBT.a);
        compound.a("BlockState", IBlockData.a, registryOps, this.m);
        compound.a("Time", this.a);
        compound.a("DropItem", this.b);
        compound.a("HurtEntities", this.o);
        compound.a("FallHurtAmount", this.q);
        compound.a("FallHurtMax", this.p);
        if (this.c != null) {
            compound.a("TileEntityData", this.c);
        }
        compound.a("CancelDrop", this.n);
        if (!this.autoExpire) {
            compound.a("Paper.AutoExpire", false);
        }
    }

    @Override
    protected void a(NBTTagCompound compound) {
        RegistryOps<NBTBase> registryOps = this.dX().a(DynamicOpsNBT.a);
        this.m = compound.a("BlockState", IBlockData.a, (DynamicOps<NBTBase>)registryOps).orElse(g);
        this.a = compound.b("Time", 0);
        boolean isAnvil = this.m.a(TagsBlock.O);
        this.o = compound.b("HurtEntities", isAnvil);
        this.q = compound.b("FallHurtAmount", 0.0f);
        this.p = compound.b("FallHurtMax", 40);
        this.b = compound.b("DropItem", true);
        this.c = compound.m("TileEntityData").map(blockData -> this.dV().paperConfig().entities.spawning.filterBadTileEntityNbtFromFallingBlocks && this.m.b() instanceof GameMasterBlock ? null : blockData).map(NBTTagCompound::l).orElse(null);
        this.n = compound.b("CancelDrop", false);
        this.autoExpire = compound.b("Paper.AutoExpire", true);
    }

    public void b(float fallDamagePerDistance, int fallDamageMax) {
        this.o = true;
        this.q = fallDamagePerDistance;
        this.p = fallDamageMax;
    }

    public void f() {
        this.n = true;
    }

    @Override
    public boolean cF() {
        return false;
    }

    @Override
    public void a(CrashReportSystemDetails category) {
        super.a(category);
        category.a("Immitating BlockState", this.m.toString());
    }

    public IBlockData i() {
        return this.m;
    }

    @Override
    protected IChatBaseComponent cz() {
        return IChatBaseComponent.a("entity.minecraft.falling_block_type", this.m.b().f());
    }

    @Override
    public Packet<PacketListenerPlayOut> a(EntityTrackerEntry entity) {
        return new PacketPlayOutSpawnEntity((Entity)this, entity, Block.j(this.i()));
    }

    @Override
    public void a(PacketPlayOutSpawnEntity packet) {
        super.a(packet);
        this.m = Block.a(packet.p());
        this.I = true;
        double x2 = packet.g();
        double y2 = packet.h();
        double z2 = packet.i();
        this.a_(x2, y2, z2);
        this.a(this.dv());
    }

    @Override
    @Nullable
    public Entity b(TeleportTransition teleportTransition) {
        ResourceKey<World> resourceKey = teleportTransition.b().aj();
        ResourceKey<World> resourceKey1 = this.dV().aj();
        boolean flag = (resourceKey1 == World.k || resourceKey == World.k) && resourceKey1 != resourceKey;
        Entity entity = super.b(teleportTransition);
        this.d = entity != null && flag && GlobalConfiguration.get().unsupportedSettings.allowUnsafeEndPortalTeleportation;
        return entity;
    }
}

