/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.item;

import com.mojang.logging.LogUtils;
import com.mojang.serialization.DynamicOps;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;
import net.kyori.adventure.util.TriState;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.UUIDUtil;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.resources.RegistryOps;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.stats.StatisticList;
import net.minecraft.tags.TagsFluid;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.MathHelper;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.TraceableEntity;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.World;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.portal.TeleportTransition;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import org.bukkit.craftbukkit.v1_21_R4.event.CraftEventFactory;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityPickupItemEvent;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.player.PlayerAttemptPickupItemEvent;
import org.bukkit.event.player.PlayerPickupItemEvent;

public class EntityItem
extends Entity
implements TraceableEntity {
    private static final DataWatcherObject<ItemStack> c = DataWatcher.a(EntityItem.class, DataWatcherRegistry.h);
    private static final float d = 0.1f;
    public static final float a = 0.2125f;
    private static final int e = 6000;
    private static final int f = Short.MAX_VALUE;
    private static final int g = Short.MIN_VALUE;
    private static final int h = 5;
    private static final short i = 0;
    private static final short j = 0;
    public int k = 0;
    public int l = 0;
    public int m = 5;
    @Nullable
    public UUID n;
    @Nullable
    private Entity o;
    @Nullable
    public UUID p;
    public final float b;
    public boolean canMobPickup = true;
    private int despawnRate = -1;
    public TriState frictionState = TriState.NOT_SET;

    public EntityItem(EntityTypes<? extends EntityItem> entityType, World level) {
        super(entityType, level);
        this.b = this.ae.i() * (float)Math.PI * 2.0f;
        this.w(this.ae.i() * 360.0f);
    }

    public EntityItem(World level, double posX, double posY, double posZ, ItemStack itemStack) {
        this((EntityTypes<? extends EntityItem>)EntityTypes.ar, level);
        this.a_(posX, posY, posZ);
        this.n(this.ae.j() * 0.2 - 0.1, 0.2, this.ae.j() * 0.2 - 0.1);
        this.a(itemStack);
    }

    public EntityItem(World level, double posX, double posY, double posZ, ItemStack itemStack, double deltaX, double deltaY, double deltaZ) {
        this((EntityTypes<? extends EntityItem>)EntityTypes.ar, level);
        this.a_(posX, posY, posZ);
        this.n(deltaX, deltaY, deltaZ);
        this.a(itemStack);
    }

    private EntityItem(EntityItem other) {
        super(other.an(), other.dV());
        this.a(other.e().v());
        this.w(other);
        this.k = other.k;
        this.b = other.b;
    }

    @Override
    public boolean bg() {
        return this.e().a(TagsItem.bt);
    }

    @Override
    @Nullable
    public Entity p() {
        World world;
        if (this.o != null && !this.o.dQ()) {
            return this.o;
        }
        if (this.n != null && (world = this.dV()) instanceof WorldServer) {
            WorldServer serverLevel = (WorldServer)world;
            this.o = serverLevel.b(this.n);
            return this.o;
        }
        return null;
    }

    @Override
    public void x(Entity entity) {
        super.x(entity);
        if (entity instanceof EntityItem) {
            EntityItem itemEntity = (EntityItem)entity;
            this.o = itemEntity.o;
        }
    }

    @Override
    protected Entity.MovementEmission bf() {
        return Entity.MovementEmission.a;
    }

    @Override
    protected void a(DataWatcher.a builder) {
        builder.a(c, ItemStack.l);
    }

    @Override
    protected double bc() {
        return 0.04;
    }

    @Override
    public void inactiveTick() {
        super.inactiveTick();
        if (this.l > 0 && this.l != Short.MAX_VALUE) {
            --this.l;
        }
        if (this.k != Short.MIN_VALUE) {
            ++this.k;
        }
        if (!this.dV().C && this.k >= this.despawnRate) {
            if (CraftEventFactory.callItemDespawnEvent(this).isCancelled()) {
                this.k = 0;
                return;
            }
            this.discard(EntityRemoveEvent.Cause.DESPAWN);
        }
    }

    @Override
    public void g() {
        if (this.e().f()) {
            this.discard(EntityRemoveEvent.Cause.DESPAWN);
        } else {
            double d2;
            int i2;
            super.g();
            if (this.l > 0 && this.l != Short.MAX_VALUE) {
                --this.l;
            }
            this.K = this.dA();
            this.L = this.dC();
            this.M = this.dG();
            Vec3D deltaMovement = this.dy();
            if (this.bi() && this.b(TagsFluid.a) > (double)0.1f) {
                this.v();
            } else if (this.bv() && this.b(TagsFluid.b) > (double)0.1f) {
                this.w();
            } else {
                this.be();
            }
            if (this.dV().C) {
                this.ad = false;
            } else {
                boolean bl = this.ad = !this.dV().a((Entity)this, this.cR().h(1.0E-7));
                if (this.ad) {
                    this.l(this.dA(), (this.cR().b + this.cR().e) / 2.0, this.dG());
                }
            }
            if (!this.aH() || this.dy().j() > (double)1.0E-5f || (this.af + this.ao()) % 4 == 0) {
                this.a(EnumMoveType.a, this.dy());
                this.aI();
                float f2 = 0.98f;
                if (this.frictionState == TriState.FALSE) {
                    f2 = 1.0f;
                } else if (this.aH()) {
                    f2 = this.dV().a_(this.aP()).b().g() * 0.98f;
                }
                this.i(this.dy().d(f2, 0.98, f2));
                if (this.aH()) {
                    Vec3D deltaMovement1 = this.dy();
                    if (deltaMovement1.e < 0.0) {
                        this.i(deltaMovement1.d(1.0, -0.5, 1.0));
                    }
                }
            }
            boolean flag = MathHelper.a(this.K) != MathHelper.a(this.dA()) || MathHelper.a(this.L) != MathHelper.a(this.dC()) || MathHelper.a(this.M) != MathHelper.a(this.dG());
            int n2 = i2 = flag ? 2 : 40;
            if (this.af % i2 == 0 && !this.dV().C && this.y()) {
                this.x();
            }
            if (this.k != Short.MIN_VALUE) {
                ++this.k;
            }
            this.ar |= this.bo();
            if (!this.dV().C && (d2 = this.dy().d(deltaMovement).h()) > 0.01) {
                this.ar = true;
            }
            if (!this.dV().C && this.k >= this.despawnRate) {
                if (CraftEventFactory.callItemDespawnEvent(this).isCancelled()) {
                    this.k = 0;
                    return;
                }
                this.discard(EntityRemoveEvent.Cause.DESPAWN);
            }
        }
    }

    @Override
    public BlockPosition aP() {
        return this.f(0.999999f);
    }

    private void v() {
        this.h((double)0.99f);
    }

    private void w() {
        this.h((double)0.95f);
    }

    private void h(double multiplier) {
        Vec3D deltaMovement = this.dy();
        this.n(deltaMovement.d * multiplier, deltaMovement.e + (double)(deltaMovement.e < (double)0.06f ? 5.0E-4f : 0.0f), deltaMovement.f * multiplier);
    }

    private void x() {
        if (this.y()) {
            double radius = this.dV().spigotConfig.itemMerge;
            for (EntityItem itemEntity : this.dV().a(EntityItem.class, this.cR().c(radius, this.dV().paperConfig().entities.behavior.onlyMergeItemsHorizontally ? 0.0 : radius - 0.5, radius), (? super T neighbour) -> neighbour != this && neighbour.y())) {
                if (!itemEntity.y() || this.dV().paperConfig().fixes.fixItemsMergingThroughWalls && this.dV().clipDirect(this.dt(), itemEntity.dt(), VoxelShapeCollision.a(this)) == MovingObjectPosition.EnumMovingObjectType.b) continue;
                this.a(itemEntity);
                if (!this.dQ()) continue;
                break;
            }
        }
    }

    private boolean y() {
        ItemStack item = this.e();
        return this.bJ() && this.l != Short.MAX_VALUE && this.k != Short.MIN_VALUE && this.k < this.despawnRate && item.M() < item.k();
    }

    private void a(EntityItem itemEntity) {
        ItemStack item = this.e();
        ItemStack item1 = itemEntity.e();
        if (Objects.equals(this.p, itemEntity.p) && EntityItem.a(item, item1)) {
            if (item1.M() < item.M()) {
                EntityItem.a(this, item, itemEntity, item1);
            } else {
                EntityItem.a(itemEntity, item1, this, item);
            }
        }
    }

    public static boolean a(ItemStack destinationStack, ItemStack originStack) {
        return originStack.M() + destinationStack.M() <= originStack.k() && ItemStack.c(destinationStack, originStack);
    }

    public static ItemStack a(ItemStack destinationStack, ItemStack originStack, int amount) {
        int min = Math.min(Math.min(destinationStack.k(), amount) - destinationStack.M(), originStack.M());
        ItemStack itemStack = destinationStack.c(destinationStack.M() + min);
        originStack.h(min);
        return itemStack;
    }

    private static void a(EntityItem destinationEntity, ItemStack destinationStack, ItemStack originStack) {
        ItemStack itemStack = EntityItem.a(destinationStack, originStack, 64);
        destinationEntity.a(itemStack);
    }

    private static void a(EntityItem destinationEntity, ItemStack destinationStack, EntityItem originEntity, ItemStack originStack) {
        if (!CraftEventFactory.callItemMergeEvent(originEntity, destinationEntity)) {
            return;
        }
        EntityItem.a(destinationEntity, destinationStack, originStack);
        destinationEntity.l = Math.max(destinationEntity.l, originEntity.l);
        destinationEntity.k = Math.min(destinationEntity.k, originEntity.k);
        if (originStack.f()) {
            originEntity.discard(EntityRemoveEvent.Cause.MERGE);
        }
    }

    @Override
    public boolean bh() {
        return !this.e().a(this.dW().a()) || super.bh();
    }

    @Override
    protected boolean aD() {
        return this.m <= 0 || this.af % 10 == 0;
    }

    @Override
    public final boolean b(DamageSource damageSource) {
        return !this.d(damageSource) && this.e().a(damageSource);
    }

    @Override
    public final boolean a(WorldServer level, DamageSource damageSource, float amount) {
        if (this.d(damageSource)) {
            return false;
        }
        if (!level.O().c(GameRules.d) && damageSource.d() instanceof EntityInsentient) {
            return false;
        }
        if (!this.e().a(damageSource)) {
            return false;
        }
        if (CraftEventFactory.handleNonLivingEntityDamageEvent(this, damageSource, amount)) {
            return false;
        }
        this.bB();
        this.m = (int)((float)this.m - amount);
        this.a(GameEvent.o, damageSource.d());
        if (this.m <= 0) {
            this.e().a(this);
            this.discard(EntityRemoveEvent.Cause.DEATH);
        }
        return true;
    }

    @Override
    public boolean a(Explosion explosion) {
        return !explosion.h() || super.a(explosion);
    }

    @Override
    public void b(NBTTagCompound compound) {
        compound.a("Health", (short)this.m);
        compound.a("Age", (short)this.k);
        compound.a("PickupDelay", (short)this.l);
        compound.b("Thrower", UUIDUtil.a, this.n);
        compound.b("Owner", UUIDUtil.a, this.p);
        if (!this.e().f()) {
            RegistryOps<NBTBase> registryOps = this.dX().a(DynamicOpsNBT.a);
            compound.a("Item", ItemStack.b, registryOps, this.e());
        }
        if (this.frictionState != TriState.NOT_SET) {
            compound.a("Paper.FrictionState", this.frictionState.toString());
        }
    }

    @Override
    public void a(NBTTagCompound compound) {
        this.m = compound.b("Health", (short)5);
        this.k = compound.b("Age", (short)0);
        this.l = compound.b("PickupDelay", (short)0);
        this.p = compound.a("Owner", UUIDUtil.a).orElse(null);
        this.n = compound.a("Thrower", UUIDUtil.a).orElse(null);
        this.o = null;
        RegistryOps<NBTBase> registryOps = this.dX().a(DynamicOpsNBT.a);
        this.a(compound.a("Item", ItemStack.b, (DynamicOps<NBTBase>)registryOps).orElse(ItemStack.l));
        compound.i("Paper.FrictionState").ifPresent(frictionState -> {
            try {
                this.frictionState = TriState.valueOf((String)frictionState);
            }
            catch (Exception ignored) {
                LogUtils.getLogger().error("Unknown friction state {} for {}", frictionState, (Object)this);
            }
        });
        if (this.e().f()) {
            this.discard(null);
        }
    }

    @Override
    public void a_(EntityHuman entity) {
        if (!this.dV().C) {
            ItemStack item = this.e();
            Item item1 = item.h();
            int count = item.M();
            int canHold = entity.gj().canHold(item);
            int remaining = count - canHold;
            boolean flyAtPlayer = false;
            if (this.l <= 0) {
                PlayerAttemptPickupItemEvent attemptEvent = new PlayerAttemptPickupItemEvent((Player)entity.getBukkitEntity(), (org.bukkit.entity.Item)this.getBukkitEntity(), remaining);
                this.dV().getCraftServer().getPluginManager().callEvent((Event)attemptEvent);
                flyAtPlayer = attemptEvent.getFlyAtPlayer();
                if (attemptEvent.isCancelled()) {
                    if (flyAtPlayer) {
                        entity.a((Entity)this, count);
                    }
                    return;
                }
            }
            if (this.l <= 0 && canHold > 0) {
                EntityPickupItemEvent entityEvent;
                item.e(canHold);
                PlayerPickupItemEvent playerEvent = new PlayerPickupItemEvent((Player)entity.getBukkitEntity(), (org.bukkit.entity.Item)this.getBukkitEntity(), remaining);
                playerEvent.setCancelled(!playerEvent.getPlayer().getCanPickupItems());
                this.dV().getCraftServer().getPluginManager().callEvent((Event)playerEvent);
                flyAtPlayer = playerEvent.getFlyAtPlayer();
                if (playerEvent.isCancelled()) {
                    item.e(count);
                    if (flyAtPlayer) {
                        entity.a((Entity)this, count);
                    }
                    return;
                }
                entityEvent.setCancelled(!(entityEvent = new EntityPickupItemEvent((LivingEntity)entity.getBukkitEntity(), (org.bukkit.entity.Item)this.getBukkitEntity(), remaining)).getEntity().getCanPickupItems());
                this.dV().getCraftServer().getPluginManager().callEvent((Event)entityEvent);
                if (entityEvent.isCancelled()) {
                    item.e(count);
                    return;
                }
                ItemStack current = this.e();
                if (!item.equals(current)) {
                    item = current;
                } else {
                    item.e(canHold + remaining);
                }
                this.l = 0;
            } else if (this.l == 0) {
                this.l = -1;
            }
            if (this.l == 0 && (this.p == null || this.p.equals(entity.cG())) && entity.gj().g(item)) {
                if (flyAtPlayer) {
                    entity.a((Entity)this, count);
                }
                if (item.f()) {
                    this.discard(EntityRemoveEvent.Cause.PICKUP);
                    item.e(count);
                }
                entity.a(StatisticList.e.b(item1), count);
                entity.a(this);
            }
        }
    }

    @Override
    public IChatBaseComponent ah() {
        IChatBaseComponent customName = this.aj();
        return customName != null ? customName : this.e().A();
    }

    @Override
    public boolean cB() {
        return false;
    }

    @Override
    @Nullable
    public Entity b(TeleportTransition teleportTransition) {
        Entity entity = super.b(teleportTransition);
        if (!this.dV().C && entity instanceof EntityItem) {
            EntityItem itemEntity = (EntityItem)entity;
            itemEntity.x();
        }
        return entity;
    }

    public ItemStack e() {
        return this.ar().a(c);
    }

    public void a(ItemStack stack) {
        this.ar().a(c, stack);
        this.despawnRate = this.dV().paperConfig().entities.spawning.altItemDespawnRate.enabled ? this.dV().paperConfig().entities.spawning.altItemDespawnRate.items.getOrDefault((Object)stack.h(), this.dV().spigotConfig.itemDespawnRate) : this.dV().spigotConfig.itemDespawnRate;
    }

    @Override
    public void a(DataWatcherObject<?> key) {
        super.a(key);
        if (c.equals(key)) {
            this.e().a((Entity)this);
        }
    }

    public void b(@Nullable UUID target) {
        this.p = target;
    }

    public void b(Entity thrower) {
        this.n = thrower.cG();
        this.o = thrower;
    }

    public int f() {
        return this.k;
    }

    public void i() {
        this.l = 10;
    }

    public void l() {
        this.l = 0;
    }

    public void m() {
        this.l = Short.MAX_VALUE;
    }

    public void b(int pickupDelay) {
        this.l = pickupDelay;
    }

    public boolean n() {
        return this.l > 0;
    }

    public void r() {
        this.k = Short.MIN_VALUE;
    }

    public void s() {
        this.k = -6000;
    }

    public void t() {
        this.m();
        this.k = this.despawnRate - 1;
    }

    public static float f(float age, float bobOffset) {
        return age / 20.0f + bobOffset;
    }

    public EntityItem u() {
        return new EntityItem(this);
    }

    @Override
    public SoundCategory dm() {
        return SoundCategory.i;
    }

    @Override
    public float dM() {
        return 180.0f - EntityItem.f((float)this.f() + 0.5f, this.b) / ((float)Math.PI * 2) * 360.0f;
    }

    @Override
    public SlotAccess a_(int slot) {
        return slot == 0 ? SlotAccess.a(this::e, this::a) : super.a_(slot);
    }
}

