/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster;

import com.destroystokyo.paper.event.entity.CreeperIgniteEvent;
import java.util.Collection;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.MathHelper;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAreaEffectCloud;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLightning;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.PathfinderGoalAvoidTarget;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalMeleeAttack;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomLookaround;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStrollLand;
import net.minecraft.world.entity.ai.goal.PathfinderGoalSwell;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalHurtByTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.animal.EntityCat;
import net.minecraft.world.entity.animal.EntityOcelot;
import net.minecraft.world.entity.animal.goat.Goat;
import net.minecraft.world.entity.monster.EntityMonster;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.World;
import net.minecraft.world.level.gameevent.GameEvent;
import org.bukkit.craftbukkit.v1_21_R4.event.CraftEventFactory;
import org.bukkit.entity.Creeper;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.CreeperPowerEvent;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.entity.EntityTargetEvent;
import org.bukkit.event.entity.ExplosionPrimeEvent;

public class EntityCreeper
extends EntityMonster {
    private static final DataWatcherObject<Integer> a = DataWatcher.a(EntityCreeper.class, DataWatcherRegistry.b);
    private static final DataWatcherObject<Boolean> b = DataWatcher.a(EntityCreeper.class, DataWatcherRegistry.k);
    private static final DataWatcherObject<Boolean> c = DataWatcher.a(EntityCreeper.class, DataWatcherRegistry.k);
    private static final boolean d = false;
    private static final boolean e = false;
    private static final short f = 30;
    private static final byte bI = 3;
    private int bJ;
    public int bK;
    public int bL = 30;
    public int bM = 3;
    private int bN;
    @Nullable
    public Entity entityIgniter;

    public EntityCreeper(EntityTypes<? extends EntityCreeper> entityType, World level) {
        super((EntityTypes<? extends EntityMonster>)entityType, level);
    }

    @Override
    protected void C() {
        this.bF.a(1, new PathfinderGoalFloat(this));
        this.bF.a(2, new PathfinderGoalSwell(this));
        this.bF.a(3, new PathfinderGoalAvoidTarget<EntityOcelot>(this, EntityOcelot.class, 6.0f, 1.0, 1.2));
        this.bF.a(3, new PathfinderGoalAvoidTarget<EntityCat>(this, EntityCat.class, 6.0f, 1.0, 1.2));
        this.bF.a(4, new PathfinderGoalMeleeAttack(this, 1.0, false));
        this.bF.a(5, new PathfinderGoalRandomStrollLand(this, 0.8));
        this.bF.a(6, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 8.0f));
        this.bF.a(6, new PathfinderGoalRandomLookaround(this));
        this.bG.a(1, new PathfinderGoalNearestAttackableTarget<EntityHuman>((EntityInsentient)this, EntityHuman.class, true));
        this.bG.a(2, new PathfinderGoalHurtByTarget(this, new Class[0]));
    }

    public static AttributeProvider.Builder m() {
        return EntityMonster.gA().a(GenericAttributes.v, 0.25);
    }

    @Override
    public int cE() {
        return this.e() == null ? this.y(0.0f) : this.y(this.eG() - 1.0f);
    }

    @Override
    public boolean a(double fallDistance, float damageMultiplier, DamageSource damageSource) {
        boolean flag = super.a(fallDistance, damageMultiplier, damageSource);
        this.bK += (int)(fallDistance * 1.5);
        if (this.bK > this.bL - 5) {
            this.bK = this.bL - 5;
        }
        return flag;
    }

    @Override
    protected void a(DataWatcher.a builder) {
        super.a(builder);
        builder.a(a, -1);
        builder.a(b, false);
        builder.a(c, false);
    }

    @Override
    public void b(NBTTagCompound compound) {
        super.b(compound);
        compound.a("powered", this.p());
        compound.a("Fuse", (short)this.bL);
        compound.a("ExplosionRadius", (byte)this.bM);
        compound.a("ignited", this.gu());
    }

    @Override
    public void a(NBTTagCompound compound) {
        super.a(compound);
        this.al.a(b, compound.b("powered", false));
        this.bL = compound.b("Fuse", (short)30);
        this.bM = compound.b("ExplosionRadius", (byte)3);
        if (compound.b("ignited", false)) {
            this.al.a(c, true);
        }
    }

    @Override
    public void g() {
        if (this.bJ()) {
            int swellDir;
            this.bJ = this.bK;
            if (this.gu()) {
                this.b(1);
            }
            if ((swellDir = this.u()) > 0 && this.bK == 0) {
                this.a(SoundEffects.gH, 1.0f, 0.5f);
                ((Entity)this).a(GameEvent.I);
            }
            this.bK += swellDir;
            if (this.bK < 0) {
                this.bK = 0;
            }
            if (this.bK >= this.bL) {
                this.bK = this.bL;
                this.gy();
            }
        }
        super.g();
    }

    @Override
    public boolean setTarget(@Nullable EntityLiving target, @Nullable EntityTargetEvent.TargetReason reason) {
        if (!(target instanceof Goat)) {
            return super.setTarget(target, reason);
        }
        return false;
    }

    @Override
    public SoundEffect e(DamageSource damageSource) {
        return SoundEffects.gG;
    }

    @Override
    public SoundEffect j_() {
        return SoundEffects.gF;
    }

    @Override
    protected void a(WorldServer level, DamageSource damageSource, boolean recentlyHit) {
        EntityCreeper creeper;
        super.a(level, damageSource, recentlyHit);
        Entity entity = damageSource.d();
        if (entity != this && entity instanceof EntityCreeper && (creeper = (EntityCreeper)entity).gw()) {
            creeper.gx();
            this.a(level, Items.vz);
        }
    }

    @Override
    public boolean c(WorldServer level, Entity source) {
        return true;
    }

    public boolean p() {
        return this.al.a(b);
    }

    public float J(float partialTicks) {
        return MathHelper.h(partialTicks, this.bJ, this.bK) / (float)(this.bL - 2);
    }

    public int u() {
        return this.al.a(a);
    }

    public void b(int state) {
        this.al.a(a, state);
    }

    @Override
    public void a(WorldServer level, EntityLightning lightning) {
        super.a(level, lightning);
        if (CraftEventFactory.callCreeperPowerEvent(this, lightning, CreeperPowerEvent.PowerCause.LIGHTNING).isCancelled()) {
            return;
        }
        this.al.a(b, true);
    }

    public void setPowered(boolean powered) {
        this.al.a(b, powered);
    }

    @Override
    protected EnumInteractionResult b(EntityHuman player, EnumHand hand) {
        ItemStack itemInHand = player.b(hand);
        if (itemInHand.a(TagsItem.bx)) {
            SoundEffect soundEvent = itemInHand.a(Items.vg) ? SoundEffects.jn : SoundEffects.jD;
            this.dV().a((Entity)player, this.dA(), this.dC(), this.dG(), soundEvent, this.dm(), 1.0f, this.ae.i() * 0.4f + 0.8f);
            if (!this.dV().C) {
                this.entityIgniter = player;
                this.gv();
                if (itemInHand.p() == 0) {
                    itemInHand.h(1);
                } else {
                    itemInHand.a(1, (EntityLiving)player, EntityCreeper.d(hand));
                }
            }
            return EnumInteractionResult.a;
        }
        return super.b(player, hand);
    }

    public void gy() {
        World world = this.dV();
        if (world instanceof WorldServer) {
            WorldServer serverLevel = (WorldServer)world;
            float f2 = this.p() ? 2.0f : 1.0f;
            ExplosionPrimeEvent event = CraftEventFactory.callExplosionPrimeEvent(this, (float)this.bM * f2, false);
            if (!event.isCancelled()) {
                this.bc = true;
                serverLevel.a((Entity)this, this.dA(), this.dC(), this.dG(), event.getRadius(), event.getFire(), World.a.c);
                this.gB();
                this.a(serverLevel, Entity.RemovalReason.a);
                this.discard(EntityRemoveEvent.Cause.EXPLODE);
            } else {
                this.bK = 0;
                this.al.a(c, false);
            }
        }
    }

    private void gB() {
        Collection<MobEffect> activeEffects = this.eD();
        if (!activeEffects.isEmpty() && !this.dV().paperConfig().entities.behavior.disableCreeperLingeringEffect) {
            EntityAreaEffectCloud areaEffectCloud = new EntityAreaEffectCloud(this.dV(), this.dA(), this.dC(), this.dG());
            areaEffectCloud.a(this);
            areaEffectCloud.a(2.5f);
            areaEffectCloud.c(-0.5f);
            areaEffectCloud.c(10);
            areaEffectCloud.a(300);
            areaEffectCloud.b(0.25f);
            areaEffectCloud.d(-areaEffectCloud.c() / (float)areaEffectCloud.h());
            for (MobEffect mobEffectInstance : activeEffects) {
                areaEffectCloud.a(new MobEffect(mobEffectInstance));
            }
            this.dV().addFreshEntity(areaEffectCloud, CreatureSpawnEvent.SpawnReason.EXPLOSION);
        }
    }

    public void setIgnited(boolean ignited) {
        CreeperIgniteEvent event;
        if (this.gu() != ignited && (event = new CreeperIgniteEvent((Creeper)this.getBukkitEntity(), ignited)).callEvent()) {
            this.al.a(c, event.isIgnited());
        }
    }

    public boolean gu() {
        return this.al.a(c);
    }

    public void gv() {
        this.setIgnited(true);
    }

    public boolean gw() {
        return this.p() && this.bN < 1;
    }

    public void gx() {
        ++this.bN;
    }
}

