/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster;

import com.destroystokyo.paper.event.entity.EndermanAttackPlayerEvent;
import com.destroystokyo.paper.event.entity.EndermanEscapeEvent;
import com.mojang.serialization.DynamicOps;
import java.util.EnumSet;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.RegistryOps;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsFluid;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.util.TimeRange;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.IEntityAngerable;
import net.minecraft.world.entity.ai.attributes.AttributeModifiable;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalMeleeAttack;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomLookaround;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStrollLand;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalHurtByTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalUniversalAngerReset;
import net.minecraft.world.entity.ai.targeting.PathfinderTargetCondition;
import net.minecraft.world.entity.monster.EntityEndermite;
import net.minecraft.world.entity.monster.EntityMonster;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.EntityPotion;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.item.enchantment.providers.VanillaEnchantmentProviders;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.RayTrace;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameters;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_21_R4.entity.CraftEnderman;
import org.bukkit.craftbukkit.v1_21_R4.event.CraftEventFactory;
import org.bukkit.entity.Enderman;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.EntityTargetEvent;

public class EntityEnderman
extends EntityMonster
implements IEntityAngerable {
    private static final MinecraftKey c = MinecraftKey.b("attacking");
    private static final AttributeModifier d = new AttributeModifier(c, 0.15f, AttributeModifier.Operation.a);
    private static final int e = 400;
    private static final int f = 600;
    private static final DataWatcherObject<Optional<IBlockData>> bI = DataWatcher.a(EntityEnderman.class, DataWatcherRegistry.j);
    private static final DataWatcherObject<Boolean> bJ = DataWatcher.a(EntityEnderman.class, DataWatcherRegistry.k);
    private static final DataWatcherObject<Boolean> bK = DataWatcher.a(EntityEnderman.class, DataWatcherRegistry.k);
    private int bL = Integer.MIN_VALUE;
    private int bM;
    private static final UniformInt bN = TimeRange.a(20, 39);
    private int bO;
    @Nullable
    private UUID bP;

    public EntityEnderman(EntityTypes<? extends EntityEnderman> entityType, World level) {
        super((EntityTypes<? extends EntityMonster>)entityType, level);
        this.a(PathType.j, -1.0f);
    }

    @Override
    protected void C() {
        this.bF.a(0, new PathfinderGoalFloat(this));
        this.bF.a(1, new a(this));
        this.bF.a(2, new PathfinderGoalMeleeAttack(this, 1.0, false));
        this.bF.a(7, new PathfinderGoalRandomStrollLand((EntityCreature)this, 1.0, 0.0f));
        this.bF.a(8, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 8.0f));
        this.bF.a(8, new PathfinderGoalRandomLookaround(this));
        this.bF.a(10, new PathfinderGoalEndermanPlaceBlock(this));
        this.bF.a(11, new PathfinderGoalEndermanPickupBlock(this));
        this.bG.a(1, new PathfinderGoalPlayerWhoLookedAtTarget(this, this::a));
        this.bG.a(2, new PathfinderGoalHurtByTarget(this, new Class[0]));
        this.bG.a(3, new PathfinderGoalNearestAttackableTarget<EntityEndermite>((EntityInsentient)this, EntityEndermite.class, true, false));
        this.bG.a(4, new PathfinderGoalUniversalAngerReset<EntityEnderman>(this, false));
    }

    public static AttributeProvider.Builder m() {
        return EntityMonster.gA().a(GenericAttributes.s, 40.0).a(GenericAttributes.v, 0.3f).a(GenericAttributes.c, 7.0).a(GenericAttributes.m, 64.0).a(GenericAttributes.B, 1.0);
    }

    private boolean tryEscape(EndermanEscapeEvent.Reason reason) {
        return new EndermanEscapeEvent((Enderman)((CraftEnderman)this.getBukkitEntity()), reason).callEvent();
    }

    @Override
    public boolean setTarget(@Nullable EntityLiving livingEntity, @Nullable EntityTargetEvent.TargetReason reason) {
        if (!super.setTarget(livingEntity, reason)) {
            return false;
        }
        livingEntity = this.e();
        AttributeModifiable attribute = this.g(GenericAttributes.v);
        if (livingEntity == null) {
            this.bM = 0;
            this.al.a(bJ, false);
            this.al.a(bK, false);
            attribute.c(c);
        } else {
            this.bM = this.af;
            this.al.a(bJ, true);
            if (!attribute.b(c)) {
                attribute.b(d);
            }
        }
        return true;
    }

    @Override
    protected void a(DataWatcher.a builder) {
        super.a(builder);
        builder.a(bI, Optional.empty());
        builder.a(bJ, false);
        builder.a(bK, false);
    }

    @Override
    public void c() {
        this.a(bN.a(this.ae));
    }

    @Override
    public void a(int time) {
        this.bO = time;
    }

    @Override
    public int a() {
        return this.bO;
    }

    @Override
    public void a(@Nullable UUID target) {
        this.bP = target;
    }

    @Override
    @Nullable
    public UUID b() {
        return this.bP;
    }

    public void p() {
        if (this.af >= this.bL + 400) {
            this.bL = this.af;
            if (!this.ba()) {
                this.dV().a(this.dA(), this.dE(), this.dG(), SoundEffects.iL, this.dm(), 2.5f, 1.0f, false);
            }
        }
    }

    @Override
    public void a(DataWatcherObject<?> key) {
        if (bJ.equals(key) && this.gw() && this.dV().C) {
            this.p();
        }
        super.a(key);
    }

    @Override
    public void b(NBTTagCompound compound) {
        super.b(compound);
        IBlockData carriedBlock = this.gu();
        if (carriedBlock != null) {
            RegistryOps<NBTBase> registryOps = this.dX().a(DynamicOpsNBT.a);
            compound.a("carriedBlockState", IBlockData.a, registryOps, carriedBlock);
        }
        this.a_(compound);
    }

    @Override
    public void a(NBTTagCompound compound) {
        super.a(compound);
        RegistryOps<NBTBase> registryOps = this.dX().a(DynamicOpsNBT.a);
        this.c((IBlockData)compound.a("carriedBlockState", IBlockData.a, (DynamicOps<NBTBase>)registryOps).filter(blockState -> !blockState.l()).orElse(null));
        this.a(this.dV(), compound);
    }

    boolean a(EntityHuman player) {
        boolean shouldAttack = this.isBeingStaredBy0(player);
        EndermanAttackPlayerEvent event = new EndermanAttackPlayerEvent((Enderman)this.getBukkitEntity(), (Player)player.getBukkitEntity());
        event.setCancelled(!shouldAttack);
        return event.callEvent();
    }

    boolean isBeingStaredBy0(EntityHuman player) {
        return EntityLiving.aH.test(player) && this.a(player, 0.025, true, false, this.dE());
    }

    @Override
    public void d_() {
        if (this.dV().C) {
            for (int i2 = 0; i2 < 2; ++i2) {
                this.dV().a(Particles.af, this.d(0.5), this.dD() - 0.25, this.g(0.5), (this.ae.j() - 0.5) * 2.0, -this.ae.j(), (this.ae.j() - 0.5) * 2.0);
            }
        }
        this.bf = false;
        if (!this.dV().C) {
            this.a((WorldServer)this.dV(), true);
        }
        super.d_();
    }

    @Override
    public boolean fr() {
        return true;
    }

    @Override
    protected void a(WorldServer level) {
        float lightLevelDependentMagicValue;
        if (level.V() && this.af >= this.bM + 600 && (lightLevelDependentMagicValue = this.bw()) > 0.5f && level.h(this.dv()) && this.ae.i() * 30.0f < (lightLevelDependentMagicValue - 0.4f) * 2.0f && this.tryEscape(EndermanEscapeEvent.Reason.RUNAWAY)) {
            this.g((EntityLiving)null);
            this.u();
        }
        super.a(level);
    }

    public boolean u() {
        if (!this.dV().A_() && this.bJ()) {
            double d2 = this.dA() + (this.ae.j() - 0.5) * 64.0;
            double d1 = this.dC() + (double)(this.ae.a(64) - 32);
            double d22 = this.dG() + (this.ae.j() - 0.5) * 64.0;
            return this.q(d2, d1, d22);
        }
        return false;
    }

    public boolean b(Entity target) {
        Vec3D vec3 = new Vec3D(this.dA() - target.dA(), this.e(0.5) - target.dE(), this.dG() - target.dG());
        vec3 = vec3.d();
        double d2 = 16.0;
        double d1 = this.dA() + (this.ae.j() - 0.5) * 8.0 - vec3.d * 16.0;
        double d22 = this.dC() + (double)(this.ae.a(16) - 8) - vec3.e * 16.0;
        double d3 = this.dG() + (this.ae.j() - 0.5) * 8.0 - vec3.f * 16.0;
        return this.q(d1, d22, d3);
    }

    private boolean q(double x2, double y2, double z2) {
        BlockPosition.MutableBlockPosition mutableBlockPos = new BlockPosition.MutableBlockPosition(x2, y2, z2);
        while (mutableBlockPos.v() > this.dV().K_() && !this.dV().a_(mutableBlockPos).d()) {
            mutableBlockPos.c(EnumDirection.a);
        }
        IBlockData blockState = this.dV().a_(mutableBlockPos);
        boolean flag = blockState.d();
        boolean isWater = blockState.y().a(TagsFluid.a);
        if (flag && !isWater) {
            Vec3D vec3 = this.dt();
            boolean flag1 = this.b(x2, y2, z2, true);
            if (flag1) {
                this.dV().a(GameEvent.R, vec3, GameEvent.a.a(this));
                if (!this.ba()) {
                    this.dV().a(null, this.K, this.L, this.M, SoundEffects.iM, this.dm(), 1.0f, 1.0f);
                    this.a(SoundEffects.iM, 1.0f, 1.0f);
                }
            }
            return flag1;
        }
        return false;
    }

    @Override
    public SoundEffect s() {
        return this.gv() ? SoundEffects.iK : SoundEffects.iH;
    }

    @Override
    public SoundEffect e(DamageSource damageSource) {
        return SoundEffects.iJ;
    }

    @Override
    public SoundEffect j_() {
        return SoundEffects.iI;
    }

    @Override
    protected void a(WorldServer level, DamageSource damageSource, boolean recentlyHit) {
        super.a(level, damageSource, recentlyHit);
        IBlockData carriedBlock = this.gu();
        if (carriedBlock != null) {
            ItemStack itemStack = new ItemStack(Items.pX);
            EnchantmentManager.a(itemStack, level.J_(), VanillaEnchantmentProviders.g, level.d_(this.dv()), this.dY());
            LootParams.a builder = new LootParams.a((WorldServer)this.dV()).a(LootContextParameters.f, this.dt()).a(LootContextParameters.i, itemStack).b(LootContextParameters.a, this);
            for (ItemStack itemStack1 : carriedBlock.a(builder)) {
                this.a(level, itemStack1);
            }
        }
    }

    public void c(@Nullable IBlockData state) {
        this.al.a(bI, Optional.ofNullable(state));
    }

    @Nullable
    public IBlockData gu() {
        return this.al.a(bI).orElse(null);
    }

    @Override
    public boolean a(WorldServer level, DamageSource damageSource, float amount) {
        boolean flag;
        EntityPotion abstractThrownPotion;
        EntityPotion abstractThrownPotion1;
        if (this.a(level, damageSource)) {
            return false;
        }
        Entity entity = damageSource.c();
        EntityPotion entityPotion = abstractThrownPotion1 = entity instanceof EntityPotion ? (abstractThrownPotion = (EntityPotion)entity) : null;
        if (!damageSource.a(DamageTypeTags.j) && abstractThrownPotion1 == null) {
            boolean flag2 = super.a(level, damageSource, amount);
            if (!(damageSource.d() instanceof EntityLiving) && this.ae.a(10) != 0) {
                this.u();
            }
            return flag2;
        }
        boolean bl = flag = abstractThrownPotion1 != null && this.a(level, damageSource, abstractThrownPotion1, amount);
        if (this.tryEscape(EndermanEscapeEvent.Reason.INDIRECT)) {
            for (int i2 = 0; i2 < 64; ++i2) {
                if (!this.u()) continue;
                return true;
            }
        }
        return flag;
    }

    private boolean a(WorldServer level, DamageSource damageSource, EntityPotion potion, float damageAmount) {
        ItemStack item = potion.e();
        PotionContents potionContents = item.a(DataComponents.R, PotionContents.a);
        return potionContents.a(Potions.a) && super.a(level, damageSource, damageAmount);
    }

    public boolean gv() {
        return this.al.a(bJ);
    }

    public boolean gw() {
        return this.al.a(bK);
    }

    public void gx() {
        this.al.a(bK, true);
    }

    public void setCreepy(boolean creepy) {
        this.al.a(bJ, creepy);
    }

    public void setHasBeenStaredAt(boolean hasBeenStaredAt) {
        this.al.a(bK, hasBeenStaredAt);
    }

    @Override
    public boolean Y() {
        return super.Y() || this.gu() != null;
    }

    static class a
    extends PathfinderGoal {
        private final EntityEnderman a;
        @Nullable
        private EntityLiving b;

        public a(EntityEnderman enderman) {
            this.a = enderman;
            this.a(EnumSet.of(PathfinderGoal.Type.c, PathfinderGoal.Type.a));
        }

        @Override
        public boolean b() {
            this.b = this.a.e();
            EntityLiving entityLiving = this.b;
            if (entityLiving instanceof EntityHuman) {
                EntityHuman player = (EntityHuman)entityLiving;
                double d2 = this.b.g(this.a);
                return !(d2 > 256.0) && this.a.a(player);
            }
            return false;
        }

        @Override
        public void d() {
            this.a.N().m();
        }

        @Override
        public void a() {
            this.a.I().a(this.b.dA(), this.b.dE(), this.b.dG());
        }
    }

    static class PathfinderGoalEndermanPlaceBlock
    extends PathfinderGoal {
        private final EntityEnderman a;

        public PathfinderGoalEndermanPlaceBlock(EntityEnderman enderman) {
            this.a = enderman;
        }

        @Override
        public boolean b() {
            return this.a.gu() != null && PathfinderGoalEndermanPlaceBlock.a(this.a).O().c(GameRules.d) && this.a.dY().a(PathfinderGoalEndermanPlaceBlock.b(2000)) == 0;
        }

        @Override
        public void a() {
            int floor2;
            int floor1;
            int floor;
            BlockPosition blockPos;
            RandomSource random = this.a.dY();
            World level = this.a.dV();
            IBlockData blockState = level.getBlockStateIfLoaded(blockPos = new BlockPosition(floor = MathHelper.a(this.a.dA() - 1.0 + random.j() * 2.0), floor1 = MathHelper.a(this.a.dC() + random.j() * 2.0), floor2 = MathHelper.a(this.a.dG() - 1.0 + random.j() * 2.0)));
            if (blockState == null) {
                return;
            }
            BlockPosition blockPos1 = blockPos.e();
            IBlockData blockState1 = level.a_(blockPos1);
            IBlockData carriedBlock = this.a.gu();
            if (carriedBlock != null && this.a(level, blockPos, carriedBlock = Block.b(carriedBlock, this.a.dV(), blockPos), blockState, blockState1, blockPos1) && CraftEventFactory.callEntityChangeBlockEvent(this.a, blockPos, carriedBlock)) {
                level.a(blockPos, carriedBlock, 3);
                level.a(GameEvent.i, blockPos, GameEvent.a.a(this.a, carriedBlock));
                this.a.c((IBlockData)null);
            }
        }

        private boolean a(World level, BlockPosition destinationPos, IBlockData carriedState, IBlockData destinationState, IBlockData belowDestinationState, BlockPosition belowDestinationPos) {
            return destinationState.l() && !belowDestinationState.l() && !belowDestinationState.a(Blocks.I) && belowDestinationState.m(level, belowDestinationPos) && carriedState.a((IWorldReader)level, destinationPos) && level.a_(this.a, AxisAlignedBB.a(Vec3D.a(destinationPos))).isEmpty();
        }
    }

    static class PathfinderGoalEndermanPickupBlock
    extends PathfinderGoal {
        private final EntityEnderman a;

        public PathfinderGoalEndermanPickupBlock(EntityEnderman enderman) {
            this.a = enderman;
        }

        @Override
        public boolean b() {
            return this.a.gu() == null && PathfinderGoalEndermanPickupBlock.a(this.a).O().c(GameRules.d) && this.a.dY().a(PathfinderGoalEndermanPickupBlock.b(20)) == 0;
        }

        @Override
        public void a() {
            int floor2;
            int floor1;
            int floor;
            BlockPosition blockPos;
            RandomSource random = this.a.dY();
            World level = this.a.dV();
            IBlockData blockState = level.getBlockStateIfLoaded(blockPos = new BlockPosition(floor = MathHelper.a(this.a.dA() - 2.0 + random.j() * 4.0), floor1 = MathHelper.a(this.a.dC() + random.j() * 3.0), floor2 = MathHelper.a(this.a.dG() - 2.0 + random.j() * 4.0)));
            if (blockState == null) {
                return;
            }
            Vec3D vec3 = new Vec3D((double)this.a.dz() + 0.5, (double)floor1 + 0.5, (double)this.a.dF() + 0.5);
            Vec3D vec31 = new Vec3D((double)floor + 0.5, (double)floor1 + 0.5, (double)floor2 + 0.5);
            MovingObjectPositionBlock blockHitResult = level.a(new RayTrace(vec3, vec31, RayTrace.BlockCollisionOption.b, RayTrace.FluidCollisionOption.a, this.a));
            boolean flag = blockHitResult.b().equals(blockPos);
            if (blockState.a(TagsBlock.ao) && flag && CraftEventFactory.callEntityChangeBlockEvent(this.a, blockPos, blockState.y().g())) {
                level.a(blockPos, false);
                level.a(GameEvent.f, blockPos, GameEvent.a.a(this.a, blockState));
                this.a.c(blockState.b().m());
            }
        }
    }

    static class PathfinderGoalPlayerWhoLookedAtTarget
    extends PathfinderGoalNearestAttackableTarget<EntityHuman> {
        private final EntityEnderman i;
        @Nullable
        private EntityHuman j;
        private int k;
        private int l;
        private final PathfinderTargetCondition m;
        private final PathfinderTargetCondition n = PathfinderTargetCondition.a().d();
        private final PathfinderTargetCondition.a o;

        public PathfinderGoalPlayerWhoLookedAtTarget(EntityEnderman enderman, @Nullable PathfinderTargetCondition.a selector) {
            super(enderman, EntityHuman.class, 10, false, false, selector);
            this.i = enderman;
            this.o = (entity, level) -> (enderman.a((EntityHuman)entity) || enderman.a(entity, level)) && !enderman.A(entity);
            this.m = PathfinderTargetCondition.a().a(this.l()).a(this.o);
        }

        @Override
        public boolean b() {
            this.j = PathfinderGoalPlayerWhoLookedAtTarget.a(this.i).a(this.m.a(this.l()), this.i);
            return this.j != null;
        }

        @Override
        public void d() {
            this.k = this.a(5);
            this.l = 0;
            this.i.gx();
        }

        @Override
        public void e() {
            this.j = null;
            super.e();
        }

        @Override
        public boolean c() {
            if (this.j != null) {
                if (!this.o.test(this.j, PathfinderGoalPlayerWhoLookedAtTarget.a(this.i))) {
                    return false;
                }
                this.i.a((Entity)this.j, 10.0f, 10.0f);
                return true;
            }
            if (this.c != null) {
                if (this.i.A(this.c)) {
                    return false;
                }
                if (this.n.a(PathfinderGoalPlayerWhoLookedAtTarget.a(this.i), this.i, this.c)) {
                    return true;
                }
            }
            return super.c();
        }

        @Override
        public void a() {
            if (this.i.e() == null) {
                super.a((EntityLiving)null);
            }
            if (this.j != null) {
                if (--this.k <= 0) {
                    this.c = this.j;
                    this.j = null;
                    super.d();
                }
            } else {
                if (this.c != null && !this.i.bY()) {
                    if (this.i.a((EntityHuman)this.c)) {
                        if (this.c.g(this.i) < 16.0 && this.i.tryEscape(EndermanEscapeEvent.Reason.STARE)) {
                            this.i.u();
                        }
                        this.l = 0;
                    } else if (this.c.g(this.i) > 256.0 && this.l++ >= this.a(30) && this.i.b((Entity)this.c)) {
                        this.l = 0;
                    }
                }
                super.a();
            }
        }
    }
}

