/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster;

import java.util.EnumSet;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityFlying;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.control.ControllerMove;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.monster.IMonster;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.EntityLargeFireball;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;

public class EntityGhast
extends EntityFlying
implements IMonster {
    private static final DataWatcherObject<Boolean> a = DataWatcher.a(EntityGhast.class, DataWatcherRegistry.k);
    private static final byte b = 1;
    private int c = 1;

    public EntityGhast(EntityTypes<? extends EntityGhast> entityType, World level) {
        super((EntityTypes<? extends EntityFlying>)entityType, level);
        this.bA = 5;
        this.bC = new ControllerGhast(this);
    }

    @Override
    protected void C() {
        this.bF.a(5, new PathfinderGoalGhastIdleMove(this));
        this.bF.a(7, new PathfinderGoalGhastMoveTowardsTarget(this));
        this.bF.a(7, new PathfinderGoalGhastAttackTarget(this));
        this.bG.a(1, new PathfinderGoalNearestAttackableTarget<EntityHuman>(this, EntityHuman.class, 10, true, false, (entity, level) -> Math.abs(entity.dC() - this.dC()) <= 4.0));
    }

    public boolean m() {
        return this.al.a(a);
    }

    public void w(boolean charging) {
        this.al.a(a, charging);
    }

    public int p() {
        return this.c;
    }

    public void setExplosionPower(int explosionPower) {
        this.c = explosionPower;
    }

    @Override
    protected boolean Z() {
        return true;
    }

    private static boolean i(DamageSource damageSource) {
        return damageSource.c() instanceof EntityLargeFireball && damageSource.d() instanceof EntityHuman;
    }

    @Override
    public boolean a(WorldServer level, DamageSource damageSource) {
        return this.cC() && !damageSource.a(DamageTypeTags.d) || !EntityGhast.i(damageSource) && super.a(level, damageSource);
    }

    @Override
    public boolean a(WorldServer level, DamageSource damageSource, float amount) {
        if (EntityGhast.i(damageSource)) {
            super.a(level, damageSource, 1000.0f);
            return true;
        }
        return !this.a(level, damageSource) && super.a(level, damageSource, amount);
    }

    @Override
    protected void a(DataWatcher.a builder) {
        super.a(builder);
        builder.a(a, false);
    }

    public static AttributeProvider.Builder u() {
        return EntityInsentient.D().a(GenericAttributes.s, 10.0).a(GenericAttributes.m, 100.0);
    }

    @Override
    public SoundCategory dm() {
        return SoundCategory.f;
    }

    @Override
    public SoundEffect s() {
        return SoundEffects.kO;
    }

    @Override
    public SoundEffect e(DamageSource damageSource) {
        return SoundEffects.kQ;
    }

    @Override
    public SoundEffect j_() {
        return SoundEffects.kP;
    }

    @Override
    public float fe() {
        return 5.0f;
    }

    public static boolean b(EntityTypes<EntityGhast> entityType, GeneratorAccess level, EntitySpawnReason spawnReason, BlockPosition pos, RandomSource random) {
        return level.an() != EnumDifficulty.a && random.a(20) == 0 && EntityGhast.a(entityType, level, spawnReason, pos, random);
    }

    @Override
    public int fX() {
        return 1;
    }

    @Override
    public void b(NBTTagCompound compound) {
        super.b(compound);
        compound.a("ExplosionPower", (byte)this.c);
    }

    @Override
    public void a(NBTTagCompound compound) {
        super.a(compound);
        this.c = compound.b("ExplosionPower", (byte)1);
    }

    static class ControllerGhast
    extends ControllerMove {
        private final EntityGhast l;
        private int m;

        public ControllerGhast(EntityGhast mob) {
            super(mob);
            this.l = mob;
        }

        @Override
        public void a() {
            if (this.k == ControllerMove.Operation.b && this.m-- <= 0) {
                this.m = this.m + this.l.dY().a(5) + 2;
                Vec3D vec3 = new Vec3D(this.e - this.l.dA(), this.f - this.l.dC(), this.g - this.l.dG());
                double len = vec3.g();
                if (this.a(vec3 = vec3.d(), MathHelper.c(len))) {
                    this.l.i(this.l.dy().e(vec3.c(0.1)));
                } else {
                    this.k = ControllerMove.Operation.a;
                }
            }
        }

        private boolean a(Vec3D pos, int length) {
            AxisAlignedBB boundingBox = this.l.cR();
            for (int i2 = 1; i2 < length; ++i2) {
                boundingBox = boundingBox.c(pos);
                if (this.l.dV().a((Entity)this.l, boundingBox)) continue;
                return false;
            }
            return true;
        }
    }

    static class PathfinderGoalGhastIdleMove
    extends PathfinderGoal {
        private final EntityGhast a;

        public PathfinderGoalGhastIdleMove(EntityGhast ghast) {
            this.a = ghast;
            this.a(EnumSet.of(PathfinderGoal.Type.a));
        }

        @Override
        public boolean b() {
            double d2;
            double d1;
            ControllerMove moveControl = this.a.K();
            if (!moveControl.b()) {
                return true;
            }
            double d3 = moveControl.d() - this.a.dA();
            double d32 = d3 * d3 + (d1 = moveControl.e() - this.a.dC()) * d1 + (d2 = moveControl.f() - this.a.dG()) * d2;
            return d32 < 1.0 || d32 > 3600.0;
        }

        @Override
        public boolean c() {
            return false;
        }

        @Override
        public void d() {
            RandomSource random = this.a.dY();
            double d2 = this.a.dA() + (double)((random.i() * 2.0f - 1.0f) * 16.0f);
            double d1 = this.a.dC() + (double)((random.i() * 2.0f - 1.0f) * 16.0f);
            double d22 = this.a.dG() + (double)((random.i() * 2.0f - 1.0f) * 16.0f);
            this.a.K().a(d2, d1, d22, 1.0);
        }
    }

    static class PathfinderGoalGhastMoveTowardsTarget
    extends PathfinderGoal {
        private final EntityGhast a;

        public PathfinderGoalGhastMoveTowardsTarget(EntityGhast ghast) {
            this.a = ghast;
            this.a(EnumSet.of(PathfinderGoal.Type.b));
        }

        @Override
        public boolean b() {
            return true;
        }

        @Override
        public boolean W_() {
            return true;
        }

        @Override
        public void a() {
            if (this.a.e() == null) {
                Vec3D deltaMovement = this.a.dy();
                this.a.w(-((float)MathHelper.d(deltaMovement.d, deltaMovement.f)) * 57.295776f);
                this.a.aV = this.a.dL();
            } else {
                EntityLiving target = this.a.e();
                double d2 = 64.0;
                if (target.g(this.a) < 4096.0) {
                    double d1 = target.dA() - this.a.dA();
                    double d22 = target.dG() - this.a.dG();
                    this.a.w(-((float)MathHelper.d(d1, d22)) * 57.295776f);
                    this.a.aV = this.a.dL();
                }
            }
        }
    }

    static class PathfinderGoalGhastAttackTarget
    extends PathfinderGoal {
        private final EntityGhast b;
        public int a;

        public PathfinderGoalGhastAttackTarget(EntityGhast ghast) {
            this.b = ghast;
        }

        @Override
        public boolean b() {
            return this.b.e() != null;
        }

        @Override
        public void d() {
            this.a = 0;
        }

        @Override
        public void e() {
            this.b.w(false);
        }

        @Override
        public boolean W_() {
            return true;
        }

        @Override
        public void a() {
            EntityLiving target = this.b.e();
            if (target != null) {
                double d2 = 64.0;
                if (target.g(this.b) < 4096.0 && this.b.E(target)) {
                    World level = this.b.dV();
                    ++this.a;
                    if (this.a == 10 && !this.b.ba()) {
                        level.a(null, 1015, this.b.dv(), 0);
                    }
                    if (this.a == 20) {
                        double d1 = 4.0;
                        Vec3D viewVector = this.b.h(1.0f);
                        double d22 = target.dA() - (this.b.dA() + viewVector.d * 4.0);
                        double d3 = target.e(0.5) - (0.5 + this.b.e(0.5));
                        double d4 = target.dG() - (this.b.dG() + viewVector.f * 4.0);
                        Vec3D vec3 = new Vec3D(d22, d3, d4);
                        if (!this.b.ba()) {
                            level.a(null, 1016, this.b.dv(), 0);
                        }
                        EntityLargeFireball largeFireball = new EntityLargeFireball(level, (EntityLiving)this.b, vec3.d(), this.b.p());
                        largeFireball.e = this.b.p();
                        largeFireball.bukkitYield = largeFireball.e;
                        largeFireball.a_(this.b.dA() + viewVector.d * 4.0, this.b.e(0.5) + 0.5, largeFireball.dG() + viewVector.f * 4.0);
                        level.b(largeFireball);
                        this.a = -40;
                    }
                } else if (this.a > 0) {
                    --this.a;
                }
                this.b.w(this.a > 10);
            }
        }
    }
}

