/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster;

import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.particles.Particles;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.TagsFluid;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.control.ControllerLook;
import net.minecraft.world.entity.ai.control.ControllerMove;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalMoveTowardsRestriction;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomLookaround;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStroll;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.ai.navigation.NavigationAbstract;
import net.minecraft.world.entity.ai.navigation.NavigationGuardian;
import net.minecraft.world.entity.ai.targeting.PathfinderTargetCondition;
import net.minecraft.world.entity.animal.EntitySquid;
import net.minecraft.world.entity.animal.axolotl.Axolotl;
import net.minecraft.world.entity.monster.EntityGuardianElder;
import net.minecraft.world.entity.monster.EntityMonster;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.Vec3D;

public class EntityGuardian
extends EntityMonster {
    protected static final int b = 80;
    private static final DataWatcherObject<Boolean> a = DataWatcher.a(EntityGuardian.class, DataWatcherRegistry.k);
    private static final DataWatcherObject<Integer> d = DataWatcher.a(EntityGuardian.class, DataWatcherRegistry.b);
    private float e;
    private float f;
    private float bI;
    private float bJ;
    private float bK;
    @Nullable
    private EntityLiving bL;
    private int bM;
    private boolean bN;
    @Nullable
    public PathfinderGoalRandomStroll c;
    public PathfinderGoalGuardianAttack guardianAttackGoal;

    public EntityGuardian(EntityTypes<? extends EntityGuardian> entityType, World level) {
        super((EntityTypes<? extends EntityMonster>)entityType, level);
        this.bA = 10;
        this.a(PathType.j, 0.0f);
        this.bC = new ControllerMoveGuardian(this);
        this.f = this.e = this.ae.i();
    }

    @Override
    protected void C() {
        PathfinderGoalMoveTowardsRestriction moveTowardsRestrictionGoal = new PathfinderGoalMoveTowardsRestriction(this, 1.0);
        this.c = new PathfinderGoalRandomStroll(this, 1.0, 80);
        this.guardianAttackGoal = new PathfinderGoalGuardianAttack(this);
        this.bF.a(4, this.guardianAttackGoal);
        this.bF.a(5, moveTowardsRestrictionGoal);
        this.bF.a(7, this.c);
        this.bF.a(8, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 8.0f));
        this.bF.a(8, new PathfinderGoalLookAtPlayer(this, EntityGuardian.class, 12.0f, 0.01f));
        this.bF.a(9, new PathfinderGoalRandomLookaround(this));
        this.c.a(EnumSet.of(PathfinderGoal.Type.a, PathfinderGoal.Type.b));
        moveTowardsRestrictionGoal.a(EnumSet.of(PathfinderGoal.Type.a, PathfinderGoal.Type.b));
        this.bG.a(1, new PathfinderGoalNearestAttackableTarget<EntityLiving>(this, EntityLiving.class, 10, true, false, new EntitySelectorGuardianTargetHumanSquid(this)));
    }

    public static AttributeProvider.Builder gu() {
        return EntityMonster.gA().a(GenericAttributes.c, 6.0).a(GenericAttributes.v, 0.5).a(GenericAttributes.s, 30.0);
    }

    @Override
    protected NavigationAbstract b(World level) {
        return new NavigationGuardian(this, level);
    }

    @Override
    protected void a(DataWatcher.a builder) {
        super.a(builder);
        builder.a(a, false);
        builder.a(d, 0);
    }

    public boolean gv() {
        return this.al.a(a);
    }

    void w(boolean moving) {
        this.al.a(a, moving);
    }

    public int p() {
        return 80;
    }

    public void b(int activeAttackTargetId) {
        this.al.a(d, activeAttackTargetId);
    }

    public boolean gw() {
        return this.al.a(d) != 0;
    }

    @Nullable
    public EntityLiving gx() {
        if (!this.gw()) {
            return null;
        }
        if (this.dV().C) {
            if (this.bL != null) {
                return this.bL;
            }
            Entity entity = this.dV().a(this.al.a(d));
            if (entity instanceof EntityLiving) {
                this.bL = (EntityLiving)entity;
                return this.bL;
            }
            return null;
        }
        return this.e();
    }

    @Override
    public void a(DataWatcherObject<?> key) {
        super.a(key);
        if (d.equals(key)) {
            this.bM = 0;
            this.bL = null;
        }
    }

    @Override
    public int R() {
        return 160;
    }

    @Override
    public SoundEffect s() {
        return this.bi() ? SoundEffects.lS : SoundEffects.lT;
    }

    @Override
    public SoundEffect e(DamageSource damageSource) {
        return this.bi() ? SoundEffects.lY : SoundEffects.lZ;
    }

    @Override
    public SoundEffect j_() {
        return this.bi() ? SoundEffects.lV : SoundEffects.lW;
    }

    @Override
    protected Entity.MovementEmission bf() {
        return Entity.MovementEmission.c;
    }

    @Override
    public float a(BlockPosition pos, IWorldReader level) {
        return level.b_(pos).a(TagsFluid.a) ? 10.0f + level.x(pos) : super.a(pos, level);
    }

    @Override
    public void d_() {
        if (this.bJ()) {
            if (this.dV().C) {
                Vec3D deltaMovement;
                this.f = this.e;
                if (!this.bi()) {
                    this.bI = 2.0f;
                    deltaMovement = this.dy();
                    if (deltaMovement.e > 0.0 && this.bN && !this.ba()) {
                        this.dV().a(this.dA(), this.dC(), this.dG(), this.u(), this.dm(), 1.0f, 1.0f, false);
                    }
                    this.bN = deltaMovement.e < 0.0 && this.dV().a(this.dv().e(), this);
                } else {
                    this.bI = this.gv() ? (this.bI < 0.5f ? 4.0f : (this.bI += (0.5f - this.bI) * 0.1f)) : (this.bI += (0.125f - this.bI) * 0.2f);
                }
                this.e += this.bI;
                this.bK = this.bJ;
                this.bJ = !this.bi() ? this.ae.i() : (this.gv() ? (this.bJ += (0.0f - this.bJ) * 0.25f) : (this.bJ += (1.0f - this.bJ) * 0.06f));
                if (this.gv() && this.bi()) {
                    deltaMovement = this.h(0.0f);
                    for (int i2 = 0; i2 < 2; ++i2) {
                        this.dV().a(Particles.d, this.d(0.5) - deltaMovement.d * 1.5, this.dD() - deltaMovement.e * 1.5, this.g(0.5) - deltaMovement.f * 1.5, 0.0, 0.0, 0.0);
                    }
                }
                if (this.gw()) {
                    EntityLiving activeAttackTarget;
                    if (this.bM < this.p()) {
                        ++this.bM;
                    }
                    if ((activeAttackTarget = this.gx()) != null) {
                        this.I().a(activeAttackTarget, 90.0f, 90.0f);
                        this.I().a();
                        double d2 = this.L(0.0f);
                        double d1 = activeAttackTarget.dA() - this.dA();
                        double d22 = activeAttackTarget.e(0.5) - this.dE();
                        double d3 = activeAttackTarget.dG() - this.dG();
                        double squareRoot = Math.sqrt(d1 * d1 + d22 * d22 + d3 * d3);
                        d1 /= squareRoot;
                        d22 /= squareRoot;
                        d3 /= squareRoot;
                        double randomDouble = this.ae.j();
                        while (randomDouble < squareRoot) {
                            this.dV().a(Particles.d, this.dA() + d1 * (randomDouble += 1.8 - d2 + this.ae.j() * (1.7 - d2)), this.dE() + d22 * randomDouble, this.dG() + d3 * randomDouble, 0.0, 0.0, 0.0);
                        }
                    }
                }
            }
            if (this.bi()) {
                this.j(300);
            } else if (this.aH()) {
                this.i(this.dy().b((this.ae.i() * 2.0f - 1.0f) * 0.4f, 0.5, (this.ae.i() * 2.0f - 1.0f) * 0.4f));
                this.w(this.ae.i() * 360.0f);
                this.d(false);
                this.ar = true;
            }
            if (this.gw()) {
                this.w(this.aX);
            }
        }
        super.d_();
    }

    protected SoundEffect u() {
        return SoundEffects.lX;
    }

    public float J(float partialTick) {
        return MathHelper.h(partialTick, this.f, this.e);
    }

    public float K(float partialTick) {
        return MathHelper.h(partialTick, this.bK, this.bJ);
    }

    public float L(float partialTick) {
        return ((float)this.bM + partialTick) / (float)this.p();
    }

    public float gy() {
        return this.bM;
    }

    @Override
    public boolean a(IWorldReader level) {
        return level.f(this);
    }

    public static boolean b(EntityTypes<? extends EntityGuardian> entityType, GeneratorAccess level, EntitySpawnReason spawnReason, BlockPosition pos, RandomSource random) {
        return !(random.a(20) != 0 && level.w(pos) || level.an() == EnumDifficulty.a || !EntitySpawnReason.a(spawnReason) && !level.b_(pos).a(TagsFluid.a) || !level.b_(pos.e()).a(TagsFluid.a));
    }

    @Override
    public boolean a(WorldServer level, DamageSource damageSource, float amount) {
        Entity entity;
        if (!this.gv() && !damageSource.a(DamageTypeTags.w) && !damageSource.a(DamageTypes.P) && (entity = damageSource.c()) instanceof EntityLiving) {
            EntityLiving livingEntity = (EntityLiving)entity;
            livingEntity.a(level, this.dW().d(this), 2.0f);
        }
        if (this.c != null) {
            this.c.i();
        }
        return super.a(level, damageSource, amount);
    }

    @Override
    public int ac() {
        return 180;
    }

    @Override
    public void a_(Vec3D travelVector) {
        if (this.bi()) {
            this.a(0.1f, travelVector);
            this.a(EnumMoveType.a, this.dy());
            this.i(this.dy().c(0.9));
            if (!this.gv() && this.e() == null) {
                this.i(this.dy().b(0.0, -0.005, 0.0));
            }
        } else {
            super.a_(travelVector);
        }
    }

    static class ControllerMoveGuardian
    extends ControllerMove {
        private final EntityGuardian l;

        public ControllerMoveGuardian(EntityGuardian mob) {
            super(mob);
            this.l = mob;
        }

        @Override
        public void a() {
            if (this.k == ControllerMove.Operation.b && !this.l.N().k()) {
                Vec3D vec3 = new Vec3D(this.e - this.l.dA(), this.f - this.l.dC(), this.g - this.l.dG());
                double len = vec3.g();
                double d2 = vec3.d / len;
                double d1 = vec3.e / len;
                double d22 = vec3.f / len;
                float f2 = (float)(MathHelper.d(vec3.f, vec3.d) * 180.0 / 3.1415927410125732) - 90.0f;
                this.l.w(this.b(this.l.dL(), f2, 90.0f));
                this.l.aV = this.l.dL();
                float f1 = (float)(this.h * this.l.h(GenericAttributes.v));
                float f22 = MathHelper.h(0.125f, this.l.fo(), f1);
                this.l.B(f22);
                double d3 = Math.sin((double)(this.l.af + this.l.ao()) * 0.5) * 0.05;
                double cos = Math.cos(this.l.dL() * ((float)Math.PI / 180));
                double sin = Math.sin(this.l.dL() * ((float)Math.PI / 180));
                double d4 = Math.sin((double)(this.l.af + this.l.ao()) * 0.75) * 0.05;
                this.l.i(this.l.dy().b(d3 * cos, d4 * (sin + cos) * 0.25 + (double)f22 * d1 * 0.1, d3 * sin));
                ControllerLook lookControl = this.l.I();
                double d5 = this.l.dA() + d2 * 2.0;
                double d6 = this.l.dE() + d1 / len;
                double d7 = this.l.dG() + d22 * 2.0;
                double wantedX = lookControl.e();
                double wantedY = lookControl.f();
                double wantedZ = lookControl.g();
                if (!lookControl.d()) {
                    wantedX = d5;
                    wantedY = d6;
                    wantedZ = d7;
                }
                this.l.I().a(MathHelper.d(0.125, wantedX, d5), MathHelper.d(0.125, wantedY, d6), MathHelper.d(0.125, wantedZ, d7), 10.0f, 40.0f);
                this.l.w(true);
            } else {
                this.l.B(0.0f);
                this.l.w(false);
            }
        }
    }

    public static class PathfinderGoalGuardianAttack
    extends PathfinderGoal {
        private final EntityGuardian a;
        public int b;
        private final boolean c;

        public PathfinderGoalGuardianAttack(EntityGuardian guardian) {
            this.a = guardian;
            this.c = guardian instanceof EntityGuardianElder;
            this.a(EnumSet.of(PathfinderGoal.Type.a, PathfinderGoal.Type.b));
        }

        @Override
        public boolean b() {
            EntityLiving target = this.a.e();
            return target != null && target.bJ();
        }

        @Override
        public boolean c() {
            return super.c() && (this.c || this.a.e() != null && this.a.g((Entity)this.a.e()) > 9.0);
        }

        @Override
        public void d() {
            this.b = -10;
            this.a.N().m();
            EntityLiving target = this.a.e();
            if (target != null) {
                this.a.I().a(target, 90.0f, 90.0f);
            }
            this.a.ar = true;
        }

        @Override
        public void e() {
            this.a.b(0);
            this.a.g((EntityLiving)null);
            this.a.c.i();
        }

        @Override
        public boolean W_() {
            return true;
        }

        @Override
        public void a() {
            EntityLiving target = this.a.e();
            if (target != null) {
                this.a.N().m();
                this.a.I().a(target, 90.0f, 90.0f);
                if (!this.a.E(target)) {
                    this.a.g((EntityLiving)null);
                } else {
                    ++this.b;
                    if (this.b == 0) {
                        this.a.b(target.ao());
                        if (!this.a.ba()) {
                            this.a.dV().a((Entity)this.a, (byte)21);
                        }
                    } else if (this.b >= this.a.p()) {
                        float f2 = 1.0f;
                        if (this.a.dV().an() == EnumDifficulty.d) {
                            f2 += 2.0f;
                        }
                        if (this.c) {
                            f2 += 2.0f;
                        }
                        WorldServer serverLevel = PathfinderGoalGuardianAttack.a(this.a);
                        target.a(serverLevel, this.a.dW().c((Entity)this.a, (Entity)this.a), f2);
                        this.a.c(serverLevel, (Entity)target);
                        this.a.g((EntityLiving)null);
                    }
                    super.a();
                }
            }
        }
    }

    static class EntitySelectorGuardianTargetHumanSquid
    implements PathfinderTargetCondition.a {
        private final EntityGuardian a;

        public EntitySelectorGuardianTargetHumanSquid(EntityGuardian guardian) {
            this.a = guardian;
        }

        @Override
        public boolean test(@Nullable EntityLiving entity, WorldServer level) {
            return (entity instanceof EntityHuman || entity instanceof EntitySquid || entity instanceof Axolotl) && entity.g(this.a) > 9.0;
        }
    }
}

