/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster;

import javax.annotation.Nullable;
import net.minecraft.core.particles.Particles;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.PathfinderGoalAvoidTarget;
import net.minecraft.world.entity.ai.goal.PathfinderGoalBowShoot;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStroll;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalHurtByTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.animal.EntityIronGolem;
import net.minecraft.world.entity.monster.EntityIllagerAbstract;
import net.minecraft.world.entity.monster.EntityIllagerWizard;
import net.minecraft.world.entity.monster.EntityMonster;
import net.minecraft.world.entity.monster.IRangedEntity;
import net.minecraft.world.entity.monster.creaking.Creaking;
import net.minecraft.world.entity.npc.EntityVillagerAbstract;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.EntityArrow;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.entity.projectile.ProjectileHelper;
import net.minecraft.world.entity.raid.EntityRaider;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_21_R4.event.CraftEventFactory;
import org.bukkit.event.entity.EntityPotionEffectEvent;
import org.bukkit.event.entity.EntityShootBowEvent;

public class EntityIllagerIllusioner
extends EntityIllagerWizard
implements IRangedEntity {
    private static final int e = 4;
    private static final int f = 3;
    public static final int a = 3;
    private int bI;
    private final Vec3D[][] bJ;

    public EntityIllagerIllusioner(EntityTypes<? extends EntityIllagerIllusioner> entityType, World level) {
        super((EntityTypes<? extends EntityIllagerWizard>)entityType, level);
        this.bA = 5;
        this.bJ = new Vec3D[2][4];
        for (int i2 = 0; i2 < 4; ++i2) {
            this.bJ[0][i2] = Vec3D.c;
            this.bJ[1][i2] = Vec3D.c;
        }
    }

    @Override
    protected void C() {
        super.C();
        this.bF.a(0, new PathfinderGoalFloat(this));
        this.bF.a(1, new EntityIllagerWizard.b(this));
        this.bF.a(3, new PathfinderGoalAvoidTarget<Creaking>(this, Creaking.class, 8.0f, 1.0, 1.2));
        this.bF.a(4, new b());
        this.bF.a(5, new a());
        this.bF.a(6, new PathfinderGoalBowShoot<EntityIllagerIllusioner>(this, 0.5, 20, 15.0f));
        this.bF.a(8, new PathfinderGoalRandomStroll(this, 0.6));
        this.bF.a(9, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 3.0f, 1.0f));
        this.bF.a(10, new PathfinderGoalLookAtPlayer(this, EntityInsentient.class, 8.0f));
        this.bG.a(1, new PathfinderGoalHurtByTarget(this, EntityRaider.class).a(new Class[0]));
        this.bG.a(2, new PathfinderGoalNearestAttackableTarget<EntityHuman>((EntityInsentient)this, EntityHuman.class, true).c(300));
        this.bG.a(3, new PathfinderGoalNearestAttackableTarget<EntityVillagerAbstract>((EntityInsentient)this, EntityVillagerAbstract.class, false).c(300));
        this.bG.a(3, new PathfinderGoalNearestAttackableTarget<EntityIronGolem>((EntityInsentient)this, EntityIronGolem.class, false).c(300));
    }

    public static AttributeProvider.Builder p() {
        return EntityMonster.gA().a(GenericAttributes.v, 0.5).a(GenericAttributes.m, 18.0).a(GenericAttributes.s, 32.0);
    }

    @Override
    public GroupDataEntity a(WorldAccess level, DifficultyDamageScaler difficulty, EntitySpawnReason spawnReason, @Nullable GroupDataEntity spawnGroupData) {
        this.a(EnumItemSlot.a, new ItemStack(Items.pj));
        return super.a(level, difficulty, spawnReason, spawnGroupData);
    }

    @Override
    public void d_() {
        super.d_();
        if (this.dV().C && this.co()) {
            --this.bI;
            if (this.bI < 0) {
                this.bI = 0;
            }
            if (this.aN == 1 || this.af % 1200 == 0) {
                int i1;
                this.bI = 3;
                float f2 = -6.0f;
                int i2 = 13;
                for (i1 = 0; i1 < 4; ++i1) {
                    this.bJ[0][i1] = this.bJ[1][i1];
                    this.bJ[1][i1] = new Vec3D((double)(-6.0f + (float)this.ae.a(13)) * 0.5, Math.max(0, this.ae.a(6) - 4), (double)(-6.0f + (float)this.ae.a(13)) * 0.5);
                }
                for (i1 = 0; i1 < 16; ++i1) {
                    this.dV().a(Particles.e, this.d(0.5), this.dD(), this.f(0.5), 0.0, 0.0, 0.0);
                }
                this.dV().a(this.dA(), this.dC(), this.dG(), SoundEffects.nK, this.dm(), 1.0f, 1.0f, false);
            } else if (this.aN == this.aO - 1) {
                this.bI = 3;
                for (int i2 = 0; i2 < 4; ++i2) {
                    this.bJ[0][i2] = this.bJ[1][i2];
                    this.bJ[1][i2] = new Vec3D(0.0, 0.0, 0.0);
                }
            }
        }
    }

    @Override
    public SoundEffect af_() {
        return SoundEffects.nG;
    }

    public Vec3D[] J(float partialTick) {
        if (this.bI <= 0) {
            return this.bJ[1];
        }
        double d2 = ((float)this.bI - partialTick) / 3.0f;
        d2 = Math.pow(d2, 0.25);
        Vec3D[] vec3s = new Vec3D[4];
        for (int i2 = 0; i2 < 4; ++i2) {
            vec3s[i2] = this.bJ[1][i2].c(1.0 - d2).e(this.bJ[0][i2].c(d2));
        }
        return vec3s;
    }

    @Override
    public SoundEffect s() {
        return SoundEffects.nG;
    }

    @Override
    public SoundEffect j_() {
        return SoundEffects.nI;
    }

    @Override
    public SoundEffect e(DamageSource damageSource) {
        return SoundEffects.nJ;
    }

    @Override
    protected SoundEffect gu() {
        return SoundEffects.nH;
    }

    @Override
    public void a(WorldServer level, int wave, boolean unused) {
    }

    @Override
    public void a(EntityLiving target, float distanceFactor) {
        ItemStack itemInHand = this.b(ProjectileHelper.a(this, Items.pj));
        ItemStack projectile = this.d(itemInHand);
        EntityArrow mobArrow = ProjectileHelper.a(this, projectile, distanceFactor, itemInHand);
        double d2 = target.dA() - this.dA();
        double d1 = target.e(0.3333333333333333) - mobArrow.dC();
        double d22 = target.dG() - this.dG();
        double squareRoot = Math.sqrt(d2 * d2 + d22 * d22);
        World world = this.dV();
        if (world instanceof WorldServer) {
            WorldServer serverLevel = (WorldServer)world;
            EntityShootBowEvent event = CraftEventFactory.callEntityShootBowEvent(this, this.fb(), mobArrow.m(), mobArrow, target.fA(), distanceFactor, true);
            if (event.isCancelled()) {
                event.getProjectile().remove();
                return;
            }
            if (event.getProjectile() == mobArrow.getBukkitEntity()) {
                IProjectile.a(mobArrow, serverLevel, projectile, d2, d1 + squareRoot * (double)0.2f, d22, 1.6f, 14 - serverLevel.an().a() * 4);
            }
        }
        this.a(SoundEffects.yd, 1.0f, 1.0f / (this.dY().i() * 0.4f + 0.8f));
    }

    @Override
    public EntityIllagerAbstract.a m() {
        if (this.gE()) {
            return EntityIllagerAbstract.a.c;
        }
        return this.gl() ? EntityIllagerAbstract.a.d : EntityIllagerAbstract.a.a;
    }

    class b
    extends EntityIllagerWizard.PathfinderGoalCastSpell {
        b() {
            super(EntityIllagerIllusioner.this);
        }

        @Override
        public boolean b() {
            return super.b() && !EntityIllagerIllusioner.this.b(MobEffects.n);
        }

        @Override
        protected int h() {
            return 20;
        }

        @Override
        protected int i() {
            return 340;
        }

        @Override
        protected void k() {
            EntityIllagerIllusioner.this.addEffect(new MobEffect(MobEffects.n, 1200), EntityPotionEffectEvent.Cause.ILLUSION);
        }

        @Override
        @Nullable
        protected SoundEffect l() {
            return SoundEffects.nM;
        }

        @Override
        protected EntityIllagerWizard.Spell m() {
            return EntityIllagerWizard.Spell.e;
        }
    }

    class a
    extends EntityIllagerWizard.PathfinderGoalCastSpell {
        private int e;

        a() {
            super(EntityIllagerIllusioner.this);
        }

        @Override
        public boolean b() {
            return super.b() && EntityIllagerIllusioner.this.e() != null && EntityIllagerIllusioner.this.e().ao() != this.e && EntityIllagerIllusioner.this.dV().d_(EntityIllagerIllusioner.this.dv()).a(EnumDifficulty.c.ordinal());
        }

        @Override
        public void d() {
            super.d();
            EntityLiving target = EntityIllagerIllusioner.this.e();
            if (target != null) {
                this.e = target.ao();
            }
        }

        @Override
        protected int h() {
            return 20;
        }

        @Override
        protected int i() {
            return 180;
        }

        @Override
        protected void k() {
            EntityIllagerIllusioner.this.e().addEffect(new MobEffect(MobEffects.o, 400), EntityIllagerIllusioner.this, EntityPotionEffectEvent.Cause.ATTACK);
        }

        @Override
        protected SoundEffect l() {
            return SoundEffects.nL;
        }

        @Override
        protected EntityIllagerWizard.Spell m() {
            return EntityIllagerWizard.Spell.f;
        }
    }
}

