/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster;

import java.util.function.Predicate;
import net.minecraft.core.BlockPosition;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.RandomSource;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.monster.IMonster;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemProjectileWeapon;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.EnumSkyBlock;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.dimension.DimensionManager;

public abstract class EntityMonster
extends EntityCreature
implements IMonster {
    protected EntityMonster(EntityTypes<? extends EntityMonster> entityType, World level) {
        super((EntityTypes<? extends EntityCreature>)entityType, level);
        this.bA = 5;
    }

    @Override
    public SoundCategory dm() {
        return SoundCategory.f;
    }

    @Override
    public void d_() {
        this.eZ();
        this.gz();
        super.d_();
    }

    protected void gz() {
        float lightLevelDependentMagicValue = this.bw();
        if (lightLevelDependentMagicValue > 0.5f) {
            this.bd += 2;
        }
    }

    @Override
    protected boolean Z() {
        return true;
    }

    @Override
    public SoundEffect aU() {
        return SoundEffects.nA;
    }

    @Override
    public SoundEffect aV() {
        return SoundEffects.nz;
    }

    @Override
    public SoundEffect e(DamageSource damageSource) {
        return SoundEffects.nx;
    }

    @Override
    public SoundEffect j_() {
        return SoundEffects.nw;
    }

    @Override
    public EntityLiving.a eO() {
        return new EntityLiving.a(SoundEffects.ny, SoundEffects.nv);
    }

    @Override
    public float a(BlockPosition pos, IWorldReader level) {
        return -level.x(pos);
    }

    public static boolean a(WorldAccess level, BlockPosition pos, RandomSource random) {
        if (level.a(EnumSkyBlock.a, pos) > random.a(32)) {
            return false;
        }
        DimensionManager dimensionType = level.F_();
        int i2 = level.a().paperConfig().entities.spawning.monsterSpawnMaxLightLevel.or(dimensionType.e());
        if (i2 < 15 && level.a(EnumSkyBlock.b, pos) > i2) {
            return false;
        }
        int i1 = level.a().ag() ? level.c(pos, 10) : level.B(pos);
        return i1 <= dimensionType.d().a(random);
    }

    public static boolean b(EntityTypes<? extends EntityMonster> entityType, WorldAccess level, EntitySpawnReason spawnReason, BlockPosition pos, RandomSource random) {
        return level.an() != EnumDifficulty.a && (EntitySpawnReason.b(spawnReason) || EntityMonster.a(level, pos, random)) && EntityMonster.a(entityType, level, spawnReason, pos, random);
    }

    public static boolean c(EntityTypes<? extends EntityMonster> entityType, GeneratorAccess level, EntitySpawnReason spawnReason, BlockPosition pos, RandomSource random) {
        return level.an() != EnumDifficulty.a && EntityMonster.a(entityType, level, spawnReason, pos, random);
    }

    public static AttributeProvider.Builder gA() {
        return EntityInsentient.D().a(GenericAttributes.c);
    }

    @Override
    public boolean eo() {
        return true;
    }

    @Override
    protected boolean ep() {
        return true;
    }

    public boolean a(WorldServer level, EntityHuman player) {
        return true;
    }

    @Override
    public ItemStack d(ItemStack shootable) {
        if (shootable.h() instanceof ItemProjectileWeapon) {
            Predicate<ItemStack> supportedHeldProjectiles = ((ItemProjectileWeapon)shootable.h()).c();
            ItemStack heldProjectile = ItemProjectileWeapon.a(this, supportedHeldProjectiles);
            return heldProjectile.f() ? new ItemStack(Items.pk) : heldProjectile;
        }
        return ItemStack.l;
    }
}

