/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster;

import io.papermc.paper.event.entity.ShulkerDuplicateEvent;
import java.util.EnumSet;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.MathHelper;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.entity.InterpolationHandler;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.control.ControllerLook;
import net.minecraft.world.entity.ai.control.EntityAIBodyControl;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomLookaround;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalHurtByTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.animal.EntityGolem;
import net.minecraft.world.entity.monster.IMonster;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.EntityArrow;
import net.minecraft.world.entity.projectile.EntityShulkerBullet;
import net.minecraft.world.item.EnumColor;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_21_R4.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_21_R4.util.CraftLocation;
import org.bukkit.entity.Shulker;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityTeleportEvent;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class EntityShulker
extends EntityGolem
implements IMonster {
    private static final MinecraftKey d = MinecraftKey.b("covered");
    private static final AttributeModifier e = new AttributeModifier(d, 20.0, AttributeModifier.Operation.a);
    protected static final DataWatcherObject<EnumDirection> a = DataWatcher.a(EntityShulker.class, DataWatcherRegistry.q);
    protected static final DataWatcherObject<Byte> b = DataWatcher.a(EntityShulker.class, DataWatcherRegistry.a);
    public static final DataWatcherObject<Byte> c = DataWatcher.a(EntityShulker.class, DataWatcherRegistry.a);
    private static final int f = 6;
    private static final byte bI = 16;
    private static final byte bJ = 16;
    private static final int bK = 8;
    private static final int bL = 8;
    private static final int bM = 5;
    private static final float bN = 0.05f;
    private static final byte bO = 0;
    private static final EnumDirection bP = EnumDirection.a;
    static final Vector3f bQ = SystemUtils.a(() -> {
        BaseBlockPosition unitVec3i = EnumDirection.d.q();
        return new Vector3f((float)unitVec3i.u(), (float)unitVec3i.v(), (float)unitVec3i.w());
    });
    private static final float bR = 3.0f;
    private float bS;
    private float bT;
    @Nullable
    private BlockPosition bU;
    private int bV;
    private static final float bW = 1.0f;

    public EntityShulker(EntityTypes<? extends EntityShulker> entityType, World level) {
        super((EntityTypes<? extends EntityGolem>)entityType, level);
        this.bA = 5;
        this.bB = new d(this);
    }

    @Override
    protected void C() {
        this.bF.a(1, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 8.0f, 0.02f, true));
        this.bF.a(4, new a());
        this.bF.a(7, new f());
        this.bF.a(8, new PathfinderGoalRandomLookaround(this));
        this.bG.a(1, new PathfinderGoalHurtByTarget(this, this.getClass()).a(new Class[0]));
        this.bG.a(2, new e(this));
        this.bG.a(3, new c(this));
    }

    @Override
    protected Entity.MovementEmission bf() {
        return Entity.MovementEmission.a;
    }

    @Override
    public SoundCategory dm() {
        return SoundCategory.f;
    }

    @Override
    public SoundEffect s() {
        return SoundEffects.xB;
    }

    @Override
    public void S() {
        if (!this.gz()) {
            super.S();
        }
    }

    @Override
    public SoundEffect j_() {
        return SoundEffects.xH;
    }

    @Override
    public SoundEffect e(DamageSource damageSource) {
        return this.gz() ? SoundEffects.xJ : SoundEffects.xI;
    }

    @Override
    protected void a(DataWatcher.a builder) {
        super.a(builder);
        builder.a(a, bP);
        builder.a(b, (byte)0);
        builder.a(c, (byte)16);
    }

    public static AttributeProvider.Builder m() {
        return EntityInsentient.D().a(GenericAttributes.s, 30.0);
    }

    @Override
    protected EntityAIBodyControl H() {
        return new b(this);
    }

    @Override
    public void a(NBTTagCompound compound) {
        super.a(compound);
        this.a(compound.a("AttachFace", EnumDirection.k).orElse(bP));
        this.al.a(b, compound.b("Peek", (byte)0));
        this.al.a(c, compound.b("Color", (byte)16));
    }

    @Override
    public void b(NBTTagCompound compound) {
        super.b(compound);
        compound.a("AttachFace", EnumDirection.k, this.u());
        compound.a("Peek", this.al.a(b));
        compound.a("Color", this.al.a(c));
    }

    @Override
    public void g() {
        super.g();
        if (!(this.dV().C || this.bY() || this.a(this.dv(), this.u()))) {
            this.gw();
        }
        if (this.gx()) {
            this.gy();
        }
        if (this.dV().C) {
            if (this.bV > 0) {
                --this.bV;
            } else {
                this.bU = null;
            }
        }
    }

    private void gw() {
        EnumDirection direction = this.h(this.dv());
        if (direction != null) {
            this.a(direction);
        } else {
            this.p();
        }
    }

    @Override
    protected AxisAlignedBB c(Vec3D position) {
        float physicalPeek = EntityShulker.L(this.bT);
        EnumDirection opposite = this.u().g();
        return EntityShulker.a(this.el(), opposite, physicalPeek, position);
    }

    private static float L(float peek) {
        return 0.5f - MathHelper.a((0.5f + peek) * (float)Math.PI) * 0.5f;
    }

    private boolean gx() {
        this.bS = this.bT;
        float f2 = (float)this.gB() * 0.01f;
        if (this.bT == f2) {
            return false;
        }
        this.bT = this.bT > f2 ? MathHelper.a(this.bT - 0.05f, f2, 1.0f) : MathHelper.a(this.bT + 0.05f, 0.0f, f2);
        return true;
    }

    private void gy() {
        this.av();
        float physicalPeek = EntityShulker.L(this.bT);
        float physicalPeek1 = EntityShulker.L(this.bS);
        EnumDirection opposite = this.u().g();
        float f2 = (physicalPeek - physicalPeek1) * this.el();
        if (!(f2 <= 0.0f)) {
            for (Entity entity : this.dV().a((Entity)this, EntityShulker.a(this.el(), opposite, physicalPeek1, physicalPeek, this.dt()), IEntitySelector.f.and(entity1 -> !entity1.z(this)))) {
                if (entity instanceof EntityShulker || entity.ad) continue;
                entity.a(EnumMoveType.e, new Vec3D(f2 * (float)opposite.j(), f2 * (float)opposite.k(), f2 * (float)opposite.l()));
            }
        }
    }

    public static AxisAlignedBB a(float scale, EnumDirection expansionDirection, float peek, Vec3D position) {
        return EntityShulker.a(scale, expansionDirection, -1.0f, peek, position);
    }

    public static AxisAlignedBB a(float scale, EnumDirection expansionDirection, float currentPeek, float oldPeek, Vec3D position) {
        AxisAlignedBB aabb = new AxisAlignedBB((double)(-scale) * 0.5, 0.0, (double)(-scale) * 0.5, (double)scale * 0.5, scale, (double)scale * 0.5);
        double d2 = Math.max(currentPeek, oldPeek);
        double d1 = Math.min(currentPeek, oldPeek);
        AxisAlignedBB aabb1 = aabb.b((double)expansionDirection.j() * d2 * (double)scale, (double)expansionDirection.k() * d2 * (double)scale, (double)expansionDirection.l() * d2 * (double)scale).a((double)(-expansionDirection.j()) * (1.0 + d1) * (double)scale, (double)(-expansionDirection.k()) * (1.0 + d1) * (double)scale, (double)(-expansionDirection.l()) * (1.0 + d1) * (double)scale);
        return aabb1.d(position.d, position.e, position.f);
    }

    @Override
    public boolean a(Entity entity, boolean force) {
        if (this.dV().A_()) {
            this.bU = null;
            this.bV = 0;
        }
        this.a(EnumDirection.a);
        return super.a(entity, force);
    }

    @Override
    public void bO() {
        this.stopRiding(false);
    }

    @Override
    public void stopRiding(boolean suppressCancellation) {
        super.stopRiding(suppressCancellation);
        if (this.dV().C) {
            this.bU = this.dv();
        }
        this.aW = 0.0f;
        this.aV = 0.0f;
    }

    @Override
    @Nullable
    public GroupDataEntity a(WorldAccess level, DifficultyDamageScaler difficulty, EntitySpawnReason spawnReason, @Nullable GroupDataEntity spawnGroupData) {
        this.w(0.0f);
        this.aX = this.dL();
        this.bx();
        return super.a(level, difficulty, spawnReason, spawnGroupData);
    }

    @Override
    public void a(EnumMoveType type, Vec3D pos) {
        if (type == EnumMoveType.d) {
            this.p();
        } else {
            super.a(type, pos);
        }
    }

    @Override
    public Vec3D dy() {
        return Vec3D.c;
    }

    @Override
    public void i(Vec3D deltaMovement) {
    }

    @Override
    public void a_(double x2, double y2, double z2) {
        BlockPosition blockPos1;
        BlockPosition blockPos = this.dv();
        if (this.bY()) {
            super.a_(x2, y2, z2);
        } else {
            super.a_((double)MathHelper.a(x2) + 0.5, MathHelper.a(y2 + 0.5), (double)MathHelper.a(z2) + 0.5);
        }
        if (this.af != 0 && !(blockPos1 = this.dv()).equals(blockPos)) {
            this.al.a(b, (byte)0);
            this.ar = true;
            if (this.dV().C && !this.bY() && !blockPos1.equals(this.bU)) {
                this.bU = blockPos;
                this.bV = 6;
                this.aa = this.dA();
                this.ab = this.dC();
                this.ac = this.dG();
            }
        }
    }

    @Nullable
    protected EnumDirection h(BlockPosition pos) {
        for (EnumDirection direction : EnumDirection.values()) {
            if (!this.a(pos, direction)) continue;
            return direction;
        }
        return null;
    }

    boolean a(BlockPosition pos, EnumDirection facing) {
        if (this.i(pos)) {
            return false;
        }
        EnumDirection opposite = facing.g();
        if (!this.dV().a(pos.a(facing), this, opposite)) {
            return false;
        }
        AxisAlignedBB aabb = EntityShulker.a(this.el(), opposite, 1.0f, pos.c()).h(1.0E-6);
        return this.dV().a((Entity)this, aabb);
    }

    private boolean i(BlockPosition pos) {
        IBlockData blockState = this.dV().a_(pos);
        if (blockState.l()) {
            return false;
        }
        boolean flag = blockState.a(Blocks.ca) && pos.equals(this.dv());
        return !flag;
    }

    protected boolean p() {
        if (!this.gj() && this.bJ()) {
            BlockPosition blockPos = this.dv();
            for (int i2 = 0; i2 < 5; ++i2) {
                BlockPosition blockPos1 = blockPos.b(MathHelper.b(this.ae, -8, 8), MathHelper.b(this.ae, -8, 8), MathHelper.b(this.ae, -8, 8));
                if (blockPos1.v() <= this.dV().K_() || !this.dV().v(blockPos1) || !this.dV().E_().a(blockPos1) || !this.dV().a((Entity)this, new AxisAlignedBB(blockPos1).h(1.0E-6))) continue;
                EnumDirection direction = this.h(blockPos1);
                EntityTeleportEvent teleportEvent = CraftEventFactory.callEntityTeleportEvent(this, blockPos1.u(), blockPos1.v(), blockPos1.w());
                if (teleportEvent.isCancelled() || teleportEvent.getTo() == null) {
                    return false;
                }
                blockPos1 = CraftLocation.toBlockPosition(teleportEvent.getTo());
                if (direction == null) continue;
                this.al();
                this.a(direction);
                this.a(SoundEffects.xM, 1.0f, 1.0f);
                this.a_((double)blockPos1.u() + 0.5, blockPos1.v(), (double)blockPos1.w() + 0.5);
                this.dV().a(GameEvent.R, blockPos, GameEvent.a.a(this));
                this.al.a(b, (byte)0);
                this.g((EntityLiving)null);
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    public InterpolationHandler l_() {
        return null;
    }

    @Override
    public boolean a(WorldServer level, DamageSource damageSource, float amount) {
        Entity directEntity;
        if (this.gz() && (directEntity = damageSource.c()) instanceof EntityArrow) {
            return false;
        }
        if (!super.a(level, damageSource, amount)) {
            return false;
        }
        if ((double)this.eG() < (double)this.eU() * 0.5 && this.ae.a(4) == 0) {
            this.p();
        } else if (damageSource.a(DamageTypeTags.j) && (directEntity = damageSource.c()) != null && directEntity.an() == EntityTypes.be) {
            this.gA();
        }
        return true;
    }

    private boolean gz() {
        return this.gB() == 0;
    }

    private void gA() {
        Vec3D vec3 = this.dt();
        AxisAlignedBB boundingBox = this.cR();
        if (!this.gz() && this.p()) {
            EntityShulker shulker;
            int size = this.dV().a(EntityTypes.bd, boundingBox.g(8.0), Entity::bJ).size();
            float f2 = (float)(size - 1) / 5.0f;
            if (!(this.dV().A.i() < f2) && (shulker = EntityTypes.bd.a(this.dV(), EntitySpawnReason.e)) != null) {
                shulker.a(this.gu());
                shulker.f(vec3);
                if (!new ShulkerDuplicateEvent((Shulker)shulker.getBukkitEntity(), (Shulker)this.getBukkitEntity()).callEvent()) {
                    return;
                }
                this.dV().addFreshEntity(shulker, CreatureSpawnEvent.SpawnReason.BREEDING);
            }
        }
    }

    @Override
    public boolean bL() {
        return this.bJ();
    }

    public EnumDirection u() {
        return this.al.a(a);
    }

    public void a(EnumDirection attachFace) {
        this.al.a(a, attachFace);
    }

    @Override
    public void a(DataWatcherObject<?> key) {
        if (a.equals(key)) {
            this.a(this.au());
        }
        super.a(key);
    }

    public int gB() {
        return this.al.a(b).byteValue();
    }

    public void b(int peekAmount) {
        if (!this.dV().C) {
            this.g(GenericAttributes.a).c(d);
            if (peekAmount == 0) {
                this.g(GenericAttributes.a).d(e);
                this.a(SoundEffects.xG, 1.0f, 1.0f);
                ((Entity)this).a(GameEvent.j);
            } else {
                this.a(SoundEffects.xK, 1.0f, 1.0f);
                ((Entity)this).a(GameEvent.k);
            }
        }
        this.al.a(b, (byte)peekAmount);
    }

    public float J(float partialTick) {
        return MathHelper.h(partialTick, this.bS, this.bT);
    }

    @Override
    public void a(PacketPlayOutSpawnEntity packet) {
        super.a(packet);
        this.aV = 0.0f;
        this.aW = 0.0f;
    }

    @Override
    public int ac() {
        return 180;
    }

    @Override
    public int ae() {
        return 180;
    }

    @Override
    public void h(Entity entity) {
    }

    @Nullable
    public Vec3D K(float partialTick) {
        if (this.bU != null && this.bV > 0) {
            double d2 = (double)((float)this.bV - partialTick) / 6.0;
            d2 *= d2;
            BlockPosition blockPos = this.dv();
            double d1 = (double)(blockPos.u() - this.bU.u()) * (d2 *= (double)this.el());
            double d22 = (double)(blockPos.v() - this.bU.v()) * d2;
            double d3 = (double)(blockPos.w() - this.bU.w()) * d2;
            return new Vec3D(-d1, -d22, -d3);
        }
        return null;
    }

    @Override
    protected float b(float scale) {
        return Math.min(scale, 3.0f);
    }

    private void a(Optional<EnumColor> variant) {
        this.al.a(c, variant.map(color -> (byte)color.a()).orElse((byte)16));
    }

    public Optional<EnumColor> gu() {
        return Optional.ofNullable(this.gv());
    }

    @Nullable
    public EnumColor gv() {
        byte b2 = this.al.a(c);
        return b2 != 16 && b2 <= 15 ? EnumColor.a(b2) : null;
    }

    @Override
    @Nullable
    public <T> T a(DataComponentType<? extends T> component) {
        return component == DataComponents.aS ? EntityShulker.c(component, this.gv()) : super.a(component);
    }

    @Override
    protected void a(DataComponentGetter componentGetter) {
        this.a(componentGetter, DataComponents.aS);
        super.a(componentGetter);
    }

    @Override
    protected <T> boolean b(DataComponentType<T> component, T value) {
        if (component == DataComponents.aS) {
            this.a(Optional.of(EntityShulker.c(DataComponents.aS, value)));
            return true;
        }
        return super.b(component, value);
    }

    class d
    extends ControllerLook {
        public d(EntityInsentient mob) {
            super(mob);
        }

        @Override
        protected void b() {
        }

        @Override
        protected Optional<Float> i() {
            EnumDirection opposite = EntityShulker.this.u().g();
            Vector3f vector3f = opposite.b().transform(new Vector3f((Vector3fc)bQ));
            BaseBlockPosition unitVec3i = opposite.q();
            Vector3f vector3f1 = new Vector3f((float)unitVec3i.u(), (float)unitVec3i.v(), (float)unitVec3i.w());
            vector3f1.cross((Vector3fc)vector3f);
            double d2 = this.e - this.a.dA();
            double d1 = this.f - this.a.dE();
            double d22 = this.g - this.a.dG();
            Vector3f vector3f2 = new Vector3f((float)d2, (float)d1, (float)d22);
            float f2 = vector3f1.dot((Vector3fc)vector3f2);
            float f1 = vector3f.dot((Vector3fc)vector3f2);
            return !(Math.abs(f2) > 1.0E-5f) && !(Math.abs(f1) > 1.0E-5f) ? Optional.empty() : Optional.of(Float.valueOf((float)(MathHelper.d((double)(-f2), (double)f1) * 180.0 / 3.1415927410125732)));
        }

        @Override
        protected Optional<Float> h() {
            return Optional.of(Float.valueOf(0.0f));
        }
    }

    class a
    extends PathfinderGoal {
        private int b;

        public a() {
            this.a(EnumSet.of(PathfinderGoal.Type.a, PathfinderGoal.Type.b));
        }

        @Override
        public boolean b() {
            EntityLiving target = EntityShulker.this.e();
            return target != null && target.bJ() && EntityShulker.this.dV().an() != EnumDifficulty.a;
        }

        @Override
        public void d() {
            this.b = 20;
            EntityShulker.this.b(100);
        }

        @Override
        public void e() {
            EntityShulker.this.b(0);
        }

        @Override
        public boolean W_() {
            return true;
        }

        @Override
        public void a() {
            if (EntityShulker.this.dV().an() != EnumDifficulty.a) {
                --this.b;
                EntityLiving target = EntityShulker.this.e();
                if (target != null) {
                    EntityShulker.this.I().a(target, 180.0f, 180.0f);
                    double d2 = EntityShulker.this.g((Entity)target);
                    if (d2 < 400.0) {
                        if (this.b <= 0) {
                            this.b = 20 + EntityShulker.this.ae.a(10) * 20 / 2;
                            EntityShulker.this.dV().b(new EntityShulkerBullet(EntityShulker.this.dV(), EntityShulker.this, target, EntityShulker.this.u().o()));
                            EntityShulker.this.a(SoundEffects.xL, 2.0f, (EntityShulker.this.ae.i() - EntityShulker.this.ae.i()) * 0.2f + 1.0f);
                        }
                    } else {
                        EntityShulker.this.g((EntityLiving)null);
                    }
                    super.a();
                }
            }
        }
    }

    class f
    extends PathfinderGoal {
        private int b;

        f() {
        }

        @Override
        public boolean b() {
            return EntityShulker.this.e() == null && EntityShulker.this.ae.a(net.minecraft.world.entity.monster.EntityShulker$f.b(40)) == 0 && EntityShulker.this.a(EntityShulker.this.dv(), EntityShulker.this.u());
        }

        @Override
        public boolean c() {
            return EntityShulker.this.e() == null && this.b > 0;
        }

        @Override
        public void d() {
            this.b = this.a(20 * (1 + EntityShulker.this.ae.a(3)));
            EntityShulker.this.b(30);
        }

        @Override
        public void e() {
            if (EntityShulker.this.e() == null) {
                EntityShulker.this.b(0);
            }
        }

        @Override
        public void a() {
            --this.b;
        }
    }

    class e
    extends PathfinderGoalNearestAttackableTarget<EntityHuman> {
        public e(EntityShulker shulker) {
            super((EntityInsentient)shulker, EntityHuman.class, true);
        }

        @Override
        public boolean b() {
            return EntityShulker.this.dV().an() != EnumDifficulty.a && super.b();
        }

        @Override
        protected AxisAlignedBB a(double targetDistance) {
            EnumDirection attachFace = ((EntityShulker)this.e).u();
            if (attachFace.o() == EnumDirection.EnumAxis.a) {
                return this.e.cR().c(4.0, targetDistance, targetDistance);
            }
            return attachFace.o() == EnumDirection.EnumAxis.c ? this.e.cR().c(targetDistance, targetDistance, 4.0) : this.e.cR().c(targetDistance, 4.0, targetDistance);
        }
    }

    static class c
    extends PathfinderGoalNearestAttackableTarget<EntityLiving> {
        public c(EntityShulker shulker) {
            super(shulker, EntityLiving.class, 10, true, false, (entity, level) -> entity instanceof IMonster);
        }

        @Override
        public boolean b() {
            return this.e.cq() != null && super.b();
        }

        @Override
        protected AxisAlignedBB a(double targetDistance) {
            EnumDirection attachFace = ((EntityShulker)this.e).u();
            if (attachFace.o() == EnumDirection.EnumAxis.a) {
                return this.e.cR().c(4.0, targetDistance, targetDistance);
            }
            return attachFace.o() == EnumDirection.EnumAxis.c ? this.e.cR().c(targetDistance, targetDistance, 4.0) : this.e.cR().c(targetDistance, 4.0, targetDistance);
        }
    }

    static class b
    extends EntityAIBodyControl {
        public b(EntityInsentient mob) {
            super(mob);
        }

        @Override
        public void a() {
        }
    }
}

