/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster;

import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.ClimbOnTopOfPowderSnowGoal;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalMeleeAttack;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStroll;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalHurtByTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.monster.EntityMonster;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockMonsterEggs;
import net.minecraft.world.level.block.state.IBlockData;
import org.bukkit.craftbukkit.v1_21_R4.event.CraftEventFactory;
import org.bukkit.event.entity.EntityRemoveEvent;

public class EntitySilverfish
extends EntityMonster {
    @Nullable
    private PathfinderGoalSilverfishWakeOthers a;

    public EntitySilverfish(EntityTypes<? extends EntitySilverfish> entityType, World level) {
        super((EntityTypes<? extends EntityMonster>)entityType, level);
    }

    @Override
    protected void C() {
        this.a = new PathfinderGoalSilverfishWakeOthers(this);
        this.bF.a(1, new PathfinderGoalFloat(this));
        this.bF.a(1, new ClimbOnTopOfPowderSnowGoal(this, this.dV()));
        this.bF.a(3, this.a);
        this.bF.a(4, new PathfinderGoalMeleeAttack(this, 1.0, false));
        this.bF.a(5, new PathfinderGoalSilverfishHideInBlock(this));
        this.bG.a(1, new PathfinderGoalHurtByTarget(this, new Class[0]).a(new Class[0]));
        this.bG.a(2, new PathfinderGoalNearestAttackableTarget<EntityHuman>((EntityInsentient)this, EntityHuman.class, true));
    }

    public static AttributeProvider.Builder m() {
        return EntityMonster.gA().a(GenericAttributes.s, 8.0).a(GenericAttributes.v, 0.25).a(GenericAttributes.c, 1.0);
    }

    @Override
    protected Entity.MovementEmission bf() {
        return Entity.MovementEmission.c;
    }

    @Override
    public SoundEffect s() {
        return SoundEffects.xN;
    }

    @Override
    public SoundEffect e(DamageSource damageSource) {
        return SoundEffects.xP;
    }

    @Override
    public SoundEffect j_() {
        return SoundEffects.xO;
    }

    @Override
    protected void b(BlockPosition pos, IBlockData block) {
        this.a(SoundEffects.xQ, 0.15f, 1.0f);
    }

    @Override
    public boolean a(WorldServer level, DamageSource damageSource, float amount) {
        if (this.a(level, damageSource)) {
            return false;
        }
        if ((damageSource.d() != null || damageSource.a(DamageTypeTags.x)) && this.a != null) {
            this.a.h();
        }
        return super.a(level, damageSource, amount);
    }

    @Override
    public void g() {
        this.aV = this.dL();
        super.g();
    }

    @Override
    public void s(float offset) {
        this.w(offset);
        super.s(offset);
    }

    @Override
    public float a(BlockPosition pos, IWorldReader level) {
        return BlockMonsterEggs.o(level.a_(pos.e())) ? 10.0f : super.a(pos, level);
    }

    public static boolean b(EntityTypes<EntitySilverfish> entityType, GeneratorAccess level, EntitySpawnReason spawnReason, BlockPosition pos, RandomSource random) {
        if (!EntitySilverfish.c(entityType, level, spawnReason, pos, random)) {
            return false;
        }
        if (EntitySpawnReason.a(spawnReason)) {
            return true;
        }
        EntityHuman nearestPlayer = level.a((double)pos.u() + 0.5, (double)pos.v() + 0.5, (double)pos.w() + 0.5, 5.0, true);
        return (nearestPlayer == null || nearestPlayer.affectsSpawning) && nearestPlayer == null;
    }

    static class PathfinderGoalSilverfishWakeOthers
    extends PathfinderGoal {
        private final EntitySilverfish a;
        private int b;

        public PathfinderGoalSilverfishWakeOthers(EntitySilverfish silverfish) {
            this.a = silverfish;
        }

        public void h() {
            if (this.b == 0) {
                this.b = this.a(20);
            }
        }

        @Override
        public boolean b() {
            return this.b > 0;
        }

        @Override
        public void a() {
            --this.b;
            if (this.b <= 0) {
                World level = this.a.dV();
                RandomSource random = this.a.dY();
                BlockPosition blockPos = this.a.dv();
                int i2 = 0;
                while (i2 <= 5 && i2 >= -5) {
                    int i1 = 0;
                    while (i1 <= 10 && i1 >= -10) {
                        int i22 = 0;
                        while (i22 <= 10 && i22 >= -10) {
                            BlockPosition blockPos1 = blockPos.b(i1, i2, i22);
                            IBlockData blockState = level.a_(blockPos1);
                            Block block = blockState.b();
                            if (block instanceof BlockMonsterEggs) {
                                IBlockData afterState;
                                IBlockData iBlockData = afterState = PathfinderGoalSilverfishWakeOthers.a(level).O().c(GameRules.d) ? blockState.y().g() : ((BlockMonsterEggs)block).q(level.a_(blockPos1));
                                if (CraftEventFactory.callEntityChangeBlockEvent(this.a, blockPos1, afterState)) {
                                    if (PathfinderGoalSilverfishWakeOthers.a(level).O().c(GameRules.d)) {
                                        level.a(blockPos1, true, this.a);
                                    } else {
                                        level.a(blockPos1, ((BlockMonsterEggs)block).q(level.a_(blockPos1)), 3);
                                    }
                                    if (random.h()) {
                                        return;
                                    }
                                }
                            }
                            i22 = (i22 <= 0 ? 1 : 0) - i22;
                        }
                        i1 = (i1 <= 0 ? 1 : 0) - i1;
                    }
                    i2 = (i2 <= 0 ? 1 : 0) - i2;
                }
            }
        }
    }

    static class PathfinderGoalSilverfishHideInBlock
    extends PathfinderGoalRandomStroll {
        @Nullable
        private EnumDirection i;
        private boolean j;

        public PathfinderGoalSilverfishHideInBlock(EntitySilverfish silverfish) {
            super(silverfish, 1.0, 10);
            this.a(EnumSet.of(PathfinderGoal.Type.a));
        }

        @Override
        public boolean b() {
            if (this.b.e() != null) {
                return false;
            }
            if (!this.b.N().k()) {
                return false;
            }
            RandomSource random = this.b.dY();
            if (PathfinderGoalSilverfishHideInBlock.a(this.b).O().c(GameRules.d) && random.a(PathfinderGoalSilverfishHideInBlock.b(10)) == 0) {
                this.i = EnumDirection.b(random);
                BlockPosition blockPos = BlockPosition.a(this.b.dA(), this.b.dC() + 0.5, this.b.dG()).a(this.i);
                IBlockData blockState = this.b.dV().a_(blockPos);
                if (BlockMonsterEggs.o(blockState)) {
                    this.j = true;
                    return true;
                }
            }
            this.j = false;
            return super.b();
        }

        @Override
        public boolean c() {
            return !this.j && super.c();
        }

        @Override
        public void d() {
            if (!this.j) {
                super.d();
            } else {
                BlockPosition blockPos;
                World levelAccessor = this.b.dV();
                IBlockData blockState = levelAccessor.a_(blockPos = BlockPosition.a(this.b.dA(), this.b.dC() + 0.5, this.b.dG()).a(this.i));
                if (BlockMonsterEggs.o(blockState)) {
                    if (!CraftEventFactory.callEntityChangeBlockEvent(this.b, blockPos, BlockMonsterEggs.p(blockState))) {
                        return;
                    }
                    levelAccessor.a(blockPos, BlockMonsterEggs.p(blockState), 3);
                    this.b.T();
                    this.b.discard(EntityRemoveEvent.Cause.ENTER_BLOCK);
                }
            }
        }
    }
}

