/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster;

import com.destroystokyo.paper.event.entity.SlimeChangeDirectionEvent;
import com.destroystokyo.paper.event.entity.SlimeSwimEvent;
import com.destroystokyo.paper.event.entity.SlimeTargetLivingEntityEvent;
import com.destroystokyo.paper.event.entity.SlimeWanderEvent;
import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.particles.ParticleParam;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.BiomeTags;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.ConversionParams;
import net.minecraft.world.entity.ConversionType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.control.ControllerMove;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.animal.EntityIronGolem;
import net.minecraft.world.entity.monster.IMonster;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.GeneratorAccessSeed;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.levelgen.SeededRandom;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.scores.ScoreboardTeam;
import org.bukkit.craftbukkit.v1_21_R4.event.CraftEventFactory;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Slime;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.entity.EntityTransformEvent;
import org.bukkit.event.entity.SlimeSplitEvent;

public class EntitySlime
extends EntityInsentient
implements IMonster {
    private static final DataWatcherObject<Integer> bH = DataWatcher.a(EntitySlime.class, DataWatcherRegistry.b);
    public static final int a = 1;
    public static final int b = 127;
    public static final int c = 4;
    private static final boolean bI = false;
    public float d;
    public float e;
    public float f;
    private boolean bJ = false;
    private boolean canWander = true;

    public EntitySlime(EntityTypes<? extends EntitySlime> entityType, World level) {
        super((EntityTypes<? extends EntityInsentient>)entityType, level);
        this.cN();
        this.bC = new ControllerMoveSlime(this);
    }

    @Override
    protected void C() {
        this.bF.a(1, new PathfinderGoalSlimeRandomJump(this));
        this.bF.a(2, new PathfinderGoalSlimeNearestPlayer(this));
        this.bF.a(3, new PathfinderGoalSlimeRandomDirection(this));
        this.bF.a(5, new PathfinderGoalSlimeIdle(this));
        this.bG.a(1, new PathfinderGoalNearestAttackableTarget<EntityHuman>(this, EntityHuman.class, 10, true, false, (entity, level) -> Math.abs(entity.dC() - this.dC()) <= 4.0));
        this.bG.a(3, new PathfinderGoalNearestAttackableTarget<EntityIronGolem>((EntityInsentient)this, EntityIronGolem.class, true));
    }

    @Override
    public SoundCategory dm() {
        return SoundCategory.f;
    }

    @Override
    protected void a(DataWatcher.a builder) {
        super.a(builder);
        builder.a(bH, 1);
    }

    @VisibleForTesting
    public void a(int size, boolean resetHealth) {
        int i2 = MathHelper.a(size, 1, 127);
        this.al.a(bH, i2);
        this.av();
        this.h_();
        this.g(GenericAttributes.s).a(i2 * i2);
        this.g(GenericAttributes.v).a(0.2f + 0.1f * (float)i2);
        this.g(GenericAttributes.c).a(i2);
        if (resetHealth) {
            this.d(this.eU());
        }
        this.bA = i2;
    }

    public int gv() {
        return this.al.a(bH);
    }

    @Override
    public void b(NBTTagCompound compound) {
        super.b(compound);
        compound.a("Size", this.gv() - 1);
        compound.a("wasOnGround", this.bJ);
        compound.a("Paper.canWander", this.canWander);
    }

    @Override
    public void a(NBTTagCompound compound) {
        this.a(compound.b("Size", 0) + 1, false);
        super.a(compound);
        this.bJ = compound.b("wasOnGround", false);
        this.canWander = compound.b("Paper.canWander", true);
    }

    public boolean gw() {
        return this.gv() <= 1;
    }

    protected ParticleParam p() {
        return Particles.X;
    }

    @Override
    protected boolean Z() {
        return this.gv() > 0;
    }

    @Override
    public void g() {
        this.f = this.e;
        this.e += (this.d - this.e) * 0.5f;
        super.g();
        if (this.aH() && !this.bJ) {
            float f2 = this.a(this.at()).a() * 2.0f;
            float f1 = f2 / 2.0f;
            int i2 = 0;
            while ((float)i2 < f2 * 16.0f) {
                float f22 = this.ae.i() * ((float)Math.PI * 2);
                float f3 = this.ae.i() * 0.5f + 0.5f;
                float f4 = MathHelper.a(f22) * f1 * f3;
                float f5 = MathHelper.b(f22) * f1 * f3;
                this.dV().a(this.p(), this.dA() + (double)f4, this.dC(), this.dG() + (double)f5, 0.0, 0.0, 0.0);
                ++i2;
            }
            this.a(this.gt(), this.fe(), ((this.ae.i() - this.ae.i()) * 0.2f + 1.0f) / 0.8f);
            this.d = -0.5f;
        } else if (!this.aH() && this.bJ) {
            this.d = 1.0f;
        }
        this.bJ = this.aH();
        this.gq();
    }

    protected void gq() {
        this.d *= 0.6f;
    }

    protected int u() {
        return this.ae.a(20) + 10;
    }

    @Override
    public void h_() {
        double x2 = this.dA();
        double y2 = this.dC();
        double z2 = this.dG();
        super.h_();
        this.a_(x2, y2, z2);
    }

    @Override
    public void a(DataWatcherObject<?> key) {
        if (bH.equals(key)) {
            this.h_();
            this.w(this.aX);
            this.aV = this.aX;
            if (this.bi() && this.ae.a(20) == 0) {
                this.bq();
            }
        }
        super.a(key);
    }

    public EntityTypes<? extends EntitySlime> an() {
        return super.an();
    }

    @Override
    public void remove(Entity.RemovalReason reason, @Nullable EntityRemoveEvent.Cause eventCause) {
        int size = this.gv();
        if (!this.dV().C && size > 1 && this.eH()) {
            float width = this.a(this.at()).a();
            float f2 = width / 2.0f;
            int i2 = size / 2;
            int i1 = 2 + this.ae.a(3);
            ScoreboardTeam team = this.cq();
            SlimeSplitEvent event = new SlimeSplitEvent((Slime)this.getBukkitEntity(), i1);
            if (!event.callEvent() || event.getCount() <= 0) {
                super.remove(reason, eventCause);
                return;
            }
            i1 = event.getCount();
            ArrayList<EntityLiving> slimes = new ArrayList<EntityLiving>(i1);
            for (int i22 = 0; i22 < i1; ++i22) {
                float f1 = ((float)(i22 % 2) - 0.5f) * f2;
                float f22 = ((float)(i22 / 2) - 0.5f) * f2;
                EntitySlime converted = this.convertTo(this.an(), new ConversionParams(ConversionType.b, false, false, team), EntitySpawnReason.k, (T mob) -> {
                    mob.a(i2, true);
                    mob.b(this.dA() + (double)f1, this.dC() + 0.5, this.dG() + (double)f22, this.ae.i() * 360.0f, 0.0f);
                }, null, null);
                if (converted == null) continue;
                slimes.add(converted);
            }
            if (!slimes.isEmpty() && CraftEventFactory.callEntityTransformEvent((EntityLiving)this, slimes, EntityTransformEvent.TransformReason.SPLIT).isCancelled()) {
                super.remove(reason, eventCause);
                return;
            }
            for (EntityLiving living : slimes) {
                this.dV().addFreshEntity(living, CreatureSpawnEvent.SpawnReason.SLIME_SPLIT);
            }
        }
        super.remove(reason, eventCause);
    }

    @Override
    public void h(Entity entity) {
        super.h(entity);
        if (entity instanceof EntityIronGolem && this.gr()) {
            this.i((EntityLiving)entity);
        }
    }

    @Override
    public void a_(EntityHuman entity) {
        if (this.gr()) {
            this.i(entity);
        }
    }

    protected void i(EntityLiving livingEntity) {
        World world = this.dV();
        if (world instanceof WorldServer) {
            DamageSource damageSource;
            WorldServer serverLevel = (WorldServer)world;
            if (this.bJ() && this.h(livingEntity) && this.E(livingEntity) && livingEntity.a(serverLevel, damageSource = this.dW().b(this), this.gs())) {
                this.a(SoundEffects.yf, 1.0f, (this.ae.i() - this.ae.i()) * 0.2f + 1.0f);
                EnchantmentManager.a(serverLevel, (Entity)livingEntity, damageSource);
            }
        }
    }

    @Override
    protected Vec3D a(Entity entity, EntitySize dimensions, float partialTick) {
        return new Vec3D(0.0, (double)dimensions.b() - 0.015625 * (double)this.gv() * (double)partialTick, 0.0);
    }

    protected boolean gr() {
        return !this.gw() && this.dj();
    }

    protected float gs() {
        return (float)this.h(GenericAttributes.c);
    }

    @Override
    public SoundEffect e(DamageSource damageSource) {
        return this.gw() ? SoundEffects.zk : SoundEffects.yh;
    }

    @Override
    public SoundEffect j_() {
        return this.gw() ? SoundEffects.zj : SoundEffects.yg;
    }

    protected SoundEffect gt() {
        return this.gw() ? SoundEffects.zm : SoundEffects.yj;
    }

    public static boolean c(EntityTypes<EntitySlime> entityType, GeneratorAccess level, EntitySpawnReason spawnReason, BlockPosition pos, RandomSource random) {
        if (level.an() != EnumDifficulty.a) {
            if (EntitySpawnReason.a(spawnReason)) {
                return EntitySlime.a(entityType, level, spawnReason, pos, random);
            }
            double maxHeightSwamp = level.getMinecraftWorld().paperConfig().entities.spawning.slimeSpawnHeight.surfaceBiome.maximum;
            double minHeightSwamp = level.getMinecraftWorld().paperConfig().entities.spawning.slimeSpawnHeight.surfaceBiome.minimum;
            if (level.u(pos).a(BiomeTags.as) && (double)pos.v() > minHeightSwamp && (double)pos.v() < maxHeightSwamp && random.i() < 0.5f && random.i() < level.as() && level.B(pos) <= random.a(8)) {
                return EntitySlime.a(entityType, level, spawnReason, pos, random);
            }
            if (!(level instanceof GeneratorAccessSeed)) {
                return false;
            }
            ChunkCoordIntPair chunkPos = new ChunkCoordIntPair(pos);
            boolean flag = level.getMinecraftWorld().paperConfig().entities.spawning.allChunksAreSlimeChunks || SeededRandom.a(chunkPos.h, chunkPos.i, ((GeneratorAccessSeed)level).E(), level.getMinecraftWorld().spigotConfig.slimeSeed).a(10) == 0;
            double maxHeightSlimeChunk = level.getMinecraftWorld().paperConfig().entities.spawning.slimeSpawnHeight.slimeChunk.maximum;
            if (random.a(10) == 0 && flag && (double)pos.v() < maxHeightSlimeChunk) {
                return EntitySlime.a(entityType, level, spawnReason, pos, random);
            }
        }
        return false;
    }

    @Override
    public float fe() {
        return 0.4f * (float)this.gv();
    }

    @Override
    public int ac() {
        return 0;
    }

    protected boolean gx() {
        return this.gv() > 0;
    }

    @Override
    public void r() {
        Vec3D deltaMovement = this.dy();
        this.n(deltaMovement.d, this.fh(), deltaMovement.f);
        this.ar = true;
    }

    @Override
    @Nullable
    public GroupDataEntity a(WorldAccess level, DifficultyDamageScaler difficulty, EntitySpawnReason spawnReason, @Nullable GroupDataEntity spawnGroupData) {
        RandomSource random = level.G_();
        int randomInt = random.a(3);
        if (randomInt < 2 && random.i() < 0.5f * difficulty.d()) {
            ++randomInt;
        }
        int i2 = 1 << randomInt;
        this.a(i2, true);
        return super.a(level, difficulty, spawnReason, spawnGroupData);
    }

    float m() {
        float f2 = this.gw() ? 1.4f : 0.8f;
        return ((this.ae.i() - this.ae.i()) * 0.2f + 1.0f) * f2;
    }

    protected SoundEffect gu() {
        return this.gw() ? SoundEffects.zl : SoundEffects.yi;
    }

    @Override
    public EntitySize e(EntityPose pose) {
        return super.e(pose).a(this.gv());
    }

    public boolean canWander() {
        return this.canWander;
    }

    public void setWander(boolean canWander) {
        this.canWander = canWander;
    }

    static class ControllerMoveSlime
    extends ControllerMove {
        private float l;
        private int m;
        private final EntitySlime n;
        private boolean o;

        public ControllerMoveSlime(EntitySlime mob) {
            super(mob);
            this.n = mob;
            this.l = 180.0f * mob.dL() / (float)Math.PI;
        }

        public void a(float yRot, boolean aggressive) {
            this.l = yRot;
            this.o = aggressive;
        }

        public void a(double speed) {
            this.h = speed;
            this.k = ControllerMove.Operation.b;
        }

        @Override
        public void a() {
            this.d.w(this.b(this.d.dL(), this.l, 90.0f));
            this.d.aX = this.d.dL();
            this.d.aV = this.d.dL();
            if (this.k != ControllerMove.Operation.b) {
                this.d.G(0.0f);
            } else {
                this.k = ControllerMove.Operation.a;
                if (this.d.aH()) {
                    this.d.B((float)(this.h * this.d.h(GenericAttributes.v)));
                    if (this.m-- <= 0) {
                        this.m = this.n.u();
                        if (this.o) {
                            this.m /= 3;
                        }
                        this.n.M().a();
                        if (this.n.gx()) {
                            this.n.a(this.n.gu(), this.n.fe(), this.n.m());
                        }
                    } else {
                        this.n.bg = 0.0f;
                        this.n.bi = 0.0f;
                        this.d.B(0.0f);
                    }
                } else {
                    this.d.B((float)(this.h * this.d.h(GenericAttributes.v)));
                }
            }
        }
    }

    static class PathfinderGoalSlimeRandomJump
    extends PathfinderGoal {
        private final EntitySlime a;

        public PathfinderGoalSlimeRandomJump(EntitySlime slime) {
            this.a = slime;
            this.a(EnumSet.of(PathfinderGoal.Type.c, PathfinderGoal.Type.a));
            slime.N().a(true);
        }

        @Override
        public boolean b() {
            return (this.a.bi() || this.a.bv()) && this.a.K() instanceof ControllerMoveSlime && this.a.canWander && new SlimeSwimEvent((Slime)this.a.getBukkitEntity()).callEvent();
        }

        @Override
        public boolean W_() {
            return true;
        }

        @Override
        public void a() {
            ControllerMove controllerMove;
            if (this.a.dY().i() < 0.8f) {
                this.a.M().a();
            }
            if ((controllerMove = this.a.K()) instanceof ControllerMoveSlime) {
                ControllerMoveSlime slimeMoveControl = (ControllerMoveSlime)controllerMove;
                slimeMoveControl.a(1.2);
            }
        }
    }

    static class PathfinderGoalSlimeNearestPlayer
    extends PathfinderGoal {
        private final EntitySlime a;
        private int b;

        public PathfinderGoalSlimeNearestPlayer(EntitySlime slime) {
            this.a = slime;
            this.a(EnumSet.of(PathfinderGoal.Type.b));
        }

        @Override
        public boolean b() {
            EntityLiving target = this.a.e();
            if (target == null || !target.bJ()) {
                return false;
            }
            if (!this.a.c(target)) {
                return false;
            }
            return this.a.K() instanceof ControllerMoveSlime && this.a.canWander && new SlimeTargetLivingEntityEvent((Slime)this.a.getBukkitEntity(), (LivingEntity)target.getBukkitEntity()).callEvent();
        }

        @Override
        public void d() {
            this.b = PathfinderGoalSlimeNearestPlayer.b(300);
            super.d();
        }

        @Override
        public boolean c() {
            EntityLiving target = this.a.e();
            if (target == null || !target.bJ()) {
                return false;
            }
            if (!this.a.c(target)) {
                return false;
            }
            return --this.b > 0 && this.a.canWander && new SlimeTargetLivingEntityEvent((Slime)this.a.getBukkitEntity(), (LivingEntity)target.getBukkitEntity()).callEvent();
        }

        @Override
        public boolean W_() {
            return true;
        }

        @Override
        public void a() {
            ControllerMove controllerMove;
            EntityLiving target = this.a.e();
            if (target != null) {
                this.a.a((Entity)target, 10.0f, 10.0f);
            }
            if ((controllerMove = this.a.K()) instanceof ControllerMoveSlime) {
                ControllerMoveSlime slimeMoveControl = (ControllerMoveSlime)controllerMove;
                slimeMoveControl.a(this.a.dL(), this.a.gr());
            }
        }

        @Override
        public void e() {
            this.b = 0;
            this.a.g((EntityLiving)null);
        }
    }

    static class PathfinderGoalSlimeRandomDirection
    extends PathfinderGoal {
        private final EntitySlime a;
        private float b;
        private int c;

        public PathfinderGoalSlimeRandomDirection(EntitySlime slime) {
            this.a = slime;
            this.a(EnumSet.of(PathfinderGoal.Type.b));
        }

        @Override
        public boolean b() {
            return this.a.e() == null && this.a.canWander && (this.a.aH() || this.a.bi() || this.a.bv() || this.a.b(MobEffects.y)) && this.a.K() instanceof ControllerMoveSlime;
        }

        @Override
        public void a() {
            ControllerMove controllerMove;
            if (--this.c <= 0) {
                this.c = this.a(40 + this.a.dY().a(60));
                this.b = this.a.dY().a(360);
                SlimeChangeDirectionEvent event = new SlimeChangeDirectionEvent((Slime)this.a.getBukkitEntity(), this.b);
                if (!this.a.canWander || !event.callEvent()) {
                    return;
                }
                this.b = event.getNewYaw();
            }
            if ((controllerMove = this.a.K()) instanceof ControllerMoveSlime) {
                ControllerMoveSlime slimeMoveControl = (ControllerMoveSlime)controllerMove;
                slimeMoveControl.a(this.b, false);
            }
        }
    }

    static class PathfinderGoalSlimeIdle
    extends PathfinderGoal {
        private final EntitySlime a;

        public PathfinderGoalSlimeIdle(EntitySlime slime) {
            this.a = slime;
            this.a(EnumSet.of(PathfinderGoal.Type.c, PathfinderGoal.Type.a));
        }

        @Override
        public boolean b() {
            return !this.a.bY() && this.a.canWander && new SlimeWanderEvent((Slime)this.a.getBukkitEntity()).callEvent();
        }

        @Override
        public void a() {
            ControllerMove controllerMove = this.a.K();
            if (controllerMove instanceof ControllerMoveSlime) {
                ControllerMoveSlime slimeMoveControl = (ControllerMoveSlime)controllerMove;
                slimeMoveControl.a(1.0);
            }
        }
    }
}

