/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster;

import io.papermc.paper.FeatureHooks;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectList;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.PathfinderGoalAvoidTarget;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLeapAtTarget;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalMeleeAttack;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomLookaround;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStrollLand;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalHurtByTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.ai.navigation.NavigationAbstract;
import net.minecraft.world.entity.ai.navigation.NavigationSpider;
import net.minecraft.world.entity.animal.EntityIronGolem;
import net.minecraft.world.entity.animal.armadillo.Armadillo;
import net.minecraft.world.entity.monster.EntityMonster;
import net.minecraft.world.entity.monster.EntitySkeleton;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.event.entity.EntityPotionEffectEvent;

public class EntitySpider
extends EntityMonster {
    private static final DataWatcherObject<Byte> a = DataWatcher.a(EntitySpider.class, DataWatcherRegistry.a);
    private static final float b = 0.1f;

    public EntitySpider(EntityTypes<? extends EntitySpider> entityType, World level) {
        super((EntityTypes<? extends EntityMonster>)entityType, level);
    }

    @Override
    protected void C() {
        this.bF.a(1, new PathfinderGoalFloat(this));
        this.bF.a(2, new PathfinderGoalAvoidTarget<Armadillo>(this, Armadillo.class, 6.0f, 1.0, 1.2, livingEntity -> !((Armadillo)livingEntity).p()));
        this.bF.a(3, new PathfinderGoalLeapAtTarget(this, 0.4f));
        this.bF.a(4, new PathfinderGoalSpiderMeleeAttack(this));
        this.bF.a(5, new PathfinderGoalRandomStrollLand(this, 0.8));
        this.bF.a(6, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 8.0f));
        this.bF.a(6, new PathfinderGoalRandomLookaround(this));
        this.bG.a(1, new PathfinderGoalHurtByTarget(this, new Class[0]));
        this.bG.a(2, new PathfinderGoalSpiderNearestAttackableTarget<EntityHuman>(this, EntityHuman.class));
        this.bG.a(3, new PathfinderGoalSpiderNearestAttackableTarget<EntityIronGolem>(this, EntityIronGolem.class));
    }

    @Override
    protected NavigationAbstract b(World level) {
        return new NavigationSpider(this, level);
    }

    @Override
    protected void a(DataWatcher.a builder) {
        super.a(builder);
        builder.a(a, (byte)0);
    }

    @Override
    public void g() {
        super.g();
        if (!this.dV().C) {
            this.w(this.P && (this.dV().paperConfig().entities.behavior.allowSpiderWorldBorderClimbing || !FeatureHooks.isSpiderCollidingWithWorldBorder(this) || !this.dV().E_().a(this, this.cR())));
        }
    }

    public static AttributeProvider.Builder p() {
        return EntityMonster.gA().a(GenericAttributes.s, 16.0).a(GenericAttributes.v, 0.3f);
    }

    @Override
    public SoundEffect s() {
        return SoundEffects.zP;
    }

    @Override
    public SoundEffect e(DamageSource damageSource) {
        return SoundEffects.zR;
    }

    @Override
    public SoundEffect j_() {
        return SoundEffects.zQ;
    }

    @Override
    protected void b(BlockPosition pos, IBlockData block) {
        this.a(SoundEffects.zS, 0.15f, 1.0f);
    }

    @Override
    public boolean k_() {
        return this.u();
    }

    @Override
    public void a(IBlockData state, Vec3D motionMultiplier) {
        if (!state.a(Blocks.bz)) {
            super.a(state, motionMultiplier);
        }
    }

    @Override
    public boolean b(MobEffect potioneffect) {
        return (!potioneffect.a(MobEffects.s) || !this.dV().paperConfig().entities.mobEffects.spidersImmuneToPoisonEffect) && super.b(potioneffect);
    }

    public boolean u() {
        return (this.al.a(a) & 1) != 0;
    }

    public void w(boolean climbing) {
        byte b2 = this.al.a(a);
        b2 = climbing ? (byte)(b2 | 1) : (byte)(b2 & 0xFFFFFFFE);
        this.al.a(a, b2);
    }

    @Override
    @Nullable
    public GroupDataEntity a(WorldAccess level, DifficultyDamageScaler difficulty, EntitySpawnReason spawnReason, @Nullable GroupDataEntity spawnGroupData) {
        EntitySkeleton skeleton;
        spawnGroupData = super.a(level, difficulty, spawnReason, spawnGroupData);
        RandomSource random = level.G_();
        if (random.a(100) == 0 && (skeleton = EntityTypes.bg.a(this.dV(), EntitySpawnReason.g)) != null) {
            skeleton.b(this.dA(), this.dC(), this.dG(), this.dL(), 0.0f);
            skeleton.a(level, difficulty, spawnReason, null);
            skeleton.n(this);
        }
        if (spawnGroupData == null) {
            spawnGroupData = new GroupDataSpider();
            if (level.an() == EnumDifficulty.d && random.i() < 0.1f * difficulty.d()) {
                ((GroupDataSpider)spawnGroupData).a(random);
            }
        }
        if (spawnGroupData instanceof GroupDataSpider) {
            GroupDataSpider spiderEffectsGroupData = (GroupDataSpider)spawnGroupData;
            Holder<MobEffectList> holder = spiderEffectsGroupData.a;
            if (holder != null) {
                this.addEffect(new MobEffect(holder, -1), null, EntityPotionEffectEvent.Cause.SPIDER_SPAWN, level instanceof WorldServer);
            }
        }
        return spawnGroupData;
    }

    @Override
    public Vec3D l(Entity entity) {
        return entity.dq() <= this.dq() ? new Vec3D(0.0, 0.3125 * (double)this.el(), 0.0) : super.l(entity);
    }

    static class PathfinderGoalSpiderMeleeAttack
    extends PathfinderGoalMeleeAttack {
        public PathfinderGoalSpiderMeleeAttack(EntitySpider spider) {
            super(spider, 1.0, true);
        }

        @Override
        public boolean b() {
            return super.b() && !this.a.bZ();
        }

        @Override
        public boolean c() {
            float lightLevelDependentMagicValue = this.a.bw();
            if (lightLevelDependentMagicValue >= 0.5f && this.a.dY().a(100) == 0) {
                this.a.g((EntityLiving)null);
                return false;
            }
            return super.c();
        }
    }

    static class PathfinderGoalSpiderNearestAttackableTarget<T extends EntityLiving>
    extends PathfinderGoalNearestAttackableTarget<T> {
        public PathfinderGoalSpiderNearestAttackableTarget(EntitySpider spider, Class<T> entityTypeToTarget) {
            super((EntityInsentient)spider, entityTypeToTarget, true);
        }

        @Override
        public boolean b() {
            float lightLevelDependentMagicValue = this.e.bw();
            return !(lightLevelDependentMagicValue >= 0.5f) && super.b();
        }
    }

    public static class GroupDataSpider
    implements GroupDataEntity {
        @Nullable
        public Holder<MobEffectList> a;

        public void a(RandomSource random) {
            int randomInt = random.a(5);
            if (randomInt <= 1) {
                this.a = MobEffects.a;
            } else if (randomInt <= 2) {
                this.a = MobEffects.e;
            } else if (randomInt <= 3) {
                this.a = MobEffects.j;
            } else if (randomInt <= 4) {
                this.a = MobEffects.n;
            }
        }
    }
}

