/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster;

import com.google.common.collect.Sets;
import java.util.LinkedHashSet;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.Holder;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsFluid;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.ISteerable;
import net.minecraft.world.entity.SaddleStorage;
import net.minecraft.world.entity.ai.attributes.AttributeModifiable;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.PathfinderGoalBreed;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFollowParent;
import net.minecraft.world.entity.ai.goal.PathfinderGoalGotoTarget;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalPanic;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomLookaround;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStroll;
import net.minecraft.world.entity.ai.goal.PathfinderGoalTempt;
import net.minecraft.world.entity.ai.navigation.Navigation;
import net.minecraft.world.entity.ai.navigation.NavigationAbstract;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.monster.EntityZombie;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.vehicle.DismountUtil;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.equipment.Equippable;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.BlockFluids;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.pathfinder.PathMode;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.pathfinder.Pathfinder;
import net.minecraft.world.level.pathfinder.PathfinderNormal;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import org.bukkit.craftbukkit.v1_21_R4.event.CraftEventFactory;

public class EntityStrider
extends EntityAnimal
implements ISteerable {
    private static final MinecraftKey bI = MinecraftKey.b("suffocating");
    private static final AttributeModifier bJ = new AttributeModifier(bI, -0.34f, AttributeModifier.Operation.b);
    private static final float bK = 0.35f;
    private static final float bM = 0.55f;
    private static final DataWatcherObject<Integer> bN = DataWatcher.a(EntityStrider.class, DataWatcherRegistry.b);
    private static final DataWatcherObject<Boolean> bO = DataWatcher.a(EntityStrider.class, DataWatcherRegistry.k);
    public final SaddleStorage bP;
    @Nullable
    private PathfinderGoalTempt bQ;

    public EntityStrider(EntityTypes<? extends EntityStrider> entityType, World level) {
        super((EntityTypes<? extends EntityAnimal>)entityType, level);
        this.bP = new SaddleStorage(this.al, bN);
        this.I = true;
        this.a(PathType.j, -1.0f);
        this.a(PathType.i, 0.0f);
        this.a(PathType.n, 0.0f);
        this.a(PathType.o, 0.0f);
    }

    public static boolean c(EntityTypes<EntityStrider> entityType, GeneratorAccess level, EntitySpawnReason spawnReason, BlockPosition pos, RandomSource random) {
        BlockPosition.MutableBlockPosition mutableBlockPos = pos.k();
        do {
            mutableBlockPos.c(EnumDirection.b);
        } while (level.b_(mutableBlockPos).a(TagsFluid.b));
        return level.a_(mutableBlockPos).l();
    }

    @Override
    public void a(DataWatcherObject<?> key) {
        if (bN.equals(key) && this.dV().C) {
            this.bP.a();
        }
        super.a(key);
    }

    @Override
    protected void a(DataWatcher.a builder) {
        super.a(builder);
        builder.a(bN, 0);
        builder.a(bO, false);
    }

    @Override
    public boolean e(EnumItemSlot slot) {
        return slot != EnumItemSlot.h ? super.e(slot) : this.bJ() && !this.e_();
    }

    @Override
    protected boolean f(EnumItemSlot slot) {
        return slot == EnumItemSlot.h || super.f(slot);
    }

    @Override
    protected Holder<SoundEffect> a(EnumItemSlot slot, ItemStack stack, Equippable equippable) {
        return slot == EnumItemSlot.h ? SoundEffects.zi : super.a(slot, stack, equippable);
    }

    @Override
    protected void C() {
        this.bF.a(1, new PathfinderGoalPanic(this, 1.65));
        this.bF.a(2, new PathfinderGoalBreed(this, 1.0));
        this.bQ = new PathfinderGoalTempt(this, 1.4, itemStack -> itemStack.a(TagsItem.aA), false);
        this.bF.a(3, this.bQ);
        this.bF.a(4, new a(this, 1.0));
        this.bF.a(5, new PathfinderGoalFollowParent(this, 1.0));
        this.bF.a(7, new PathfinderGoalRandomStroll(this, 1.0, 60));
        this.bF.a(8, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 8.0f));
        this.bF.a(8, new PathfinderGoalRandomLookaround(this));
        this.bF.a(9, new PathfinderGoalLookAtPlayer(this, EntityStrider.class, 8.0f));
    }

    public void w(boolean suffocating) {
        this.al.a(bO, suffocating);
        AttributeModifiable attribute = this.g(GenericAttributes.v);
        if (attribute != null) {
            if (suffocating) {
                attribute.a(bJ);
            } else {
                attribute.c(bI);
            }
        }
    }

    public boolean m() {
        return this.al.a(bO);
    }

    @Override
    public boolean a(Fluid fluidState) {
        return fluidState.a(TagsFluid.b);
    }

    @Override
    protected Vec3D a(Entity entity, EntitySize dimensions, float partialTick) {
        if (!this.dV().A_()) {
            return super.a(entity, dimensions, partialTick);
        }
        float min = Math.min(0.25f, this.aT.b());
        float f2 = this.aT.c();
        float f1 = 0.12f * MathHelper.b(f2 * 1.5f) * 2.0f * min;
        return super.a(entity, dimensions, partialTick).b(0.0, f1 * partialTick, 0.0);
    }

    @Override
    public boolean a(IWorldReader level) {
        return level.f(this);
    }

    @Override
    @Nullable
    public EntityLiving cW() {
        EntityHuman player;
        Entity entity;
        return this.fZ() && (entity = this.cZ()) instanceof EntityHuman && (player = (EntityHuman)entity).b(Items.oB) ? player : super.cW();
    }

    @Override
    public Vec3D b(EntityLiving livingEntity) {
        Vec3D[] vec3s = new Vec3D[]{EntityStrider.a(this.dq(), (double)livingEntity.dq(), livingEntity.dL()), EntityStrider.a(this.dq(), (double)livingEntity.dq(), livingEntity.dL() - 22.5f), EntityStrider.a(this.dq(), (double)livingEntity.dq(), livingEntity.dL() + 22.5f), EntityStrider.a(this.dq(), (double)livingEntity.dq(), livingEntity.dL() - 45.0f), EntityStrider.a(this.dq(), (double)livingEntity.dq(), livingEntity.dL() + 45.0f)};
        LinkedHashSet set = Sets.newLinkedHashSet();
        double d2 = this.cR().e;
        double d1 = this.cR().b - 0.5;
        BlockPosition.MutableBlockPosition mutableBlockPos = new BlockPosition.MutableBlockPosition();
        for (Vec3D vec3 : vec3s) {
            mutableBlockPos.b(this.dA() + vec3.d, d2, this.dG() + vec3.f);
            for (double d22 = d2; d22 > d1; d22 -= 1.0) {
                set.add(mutableBlockPos.j());
                mutableBlockPos.c(EnumDirection.a);
            }
        }
        for (BlockPosition blockPos : set) {
            double blockFloorHeight;
            if (this.dV().b_(blockPos).a(TagsFluid.b) || !DismountUtil.a(blockFloorHeight = this.dV().j(blockPos))) continue;
            Vec3D vec31 = Vec3D.a(blockPos, blockFloorHeight);
            for (EntityPose pose : livingEntity.fO()) {
                AxisAlignedBB localBoundsForPose = livingEntity.f(pose);
                if (!DismountUtil.a(this.dV(), livingEntity, localBoundsForPose.c(vec31))) continue;
                livingEntity.b(pose);
                return vec31;
            }
        }
        return new Vec3D(this.dA(), this.cR().e, this.dG());
    }

    @Override
    protected void a(EntityHuman player, Vec3D travelVector) {
        this.b(player.dL(), player.dN() * 0.5f);
        this.aV = this.aX = this.dL();
        this.N = this.aX;
        this.bP.b();
        super.a(player, travelVector);
    }

    @Override
    protected Vec3D b(EntityHuman player, Vec3D travelVector) {
        return new Vec3D(0.0, 0.0, 1.0);
    }

    @Override
    protected float c(EntityHuman player) {
        return (float)(this.h(GenericAttributes.v) * (double)(this.m() ? 0.35f : 0.55f) * (double)this.bP.c());
    }

    @Override
    protected float aT() {
        return this.X + 0.6f;
    }

    @Override
    protected void b(BlockPosition pos, IBlockData block) {
        this.a(this.bv() ? SoundEffects.zg : SoundEffects.zf, 1.0f, 1.0f);
    }

    @Override
    public boolean a() {
        return this.bP.a(this.dY());
    }

    @Override
    protected void a(double y2, boolean onGround, IBlockData state, BlockPosition pos) {
        if (this.bv()) {
            this.j();
        } else {
            super.a(y2, onGround, state, pos);
        }
    }

    @Override
    public void g() {
        if (this.u() && this.ae.a(140) == 0) {
            this.b(SoundEffects.zb);
        } else if (this.gr() && this.ae.a(60) == 0) {
            this.b(SoundEffects.zc);
        }
        if (!this.gj()) {
            boolean suffocating;
            EntityStrider strider;
            IBlockData blockState = this.dV().a_(this.dv());
            IBlockData blockStateOnLegacy = this.br();
            boolean flag = blockState.a(TagsBlock.aW) || blockStateOnLegacy.a(TagsBlock.aW) || this.b(TagsFluid.b) > 0.0;
            Entity entity = this.dk();
            boolean flag1 = entity instanceof EntityStrider && (strider = (EntityStrider)entity).m();
            boolean bl = suffocating = !flag || flag1;
            if (suffocating ^ this.m() && CraftEventFactory.callStriderTemperatureChangeEvent(this, suffocating)) {
                this.w(suffocating);
            }
        }
        super.g();
        this.gu();
    }

    private boolean u() {
        return this.bQ != null && this.bQ.i();
    }

    @Override
    protected boolean E() {
        return true;
    }

    private void gu() {
        if (this.bv()) {
            VoxelShapeCollision collisionContext = VoxelShapeCollision.a(this);
            if (collisionContext.a(BlockFluids.d, this.dv(), true) && !this.dV().b_(this.dv().d()).a(TagsFluid.b)) {
                this.d(true);
            } else {
                this.i(this.dy().c(0.5).b(0.0, 0.05, 0.0));
            }
        }
    }

    public static AttributeProvider.Builder p() {
        return EntityAnimal.gz().a(GenericAttributes.v, 0.175f);
    }

    @Override
    public SoundEffect s() {
        return !this.gr() && !this.u() ? SoundEffects.za : null;
    }

    @Override
    public SoundEffect e(DamageSource damageSource) {
        return SoundEffects.ze;
    }

    @Override
    public SoundEffect j_() {
        return SoundEffects.zd;
    }

    @Override
    protected boolean r(Entity passenger) {
        return !this.bZ() && !((Entity)this).a(TagsFluid.b);
    }

    @Override
    public boolean fr() {
        return true;
    }

    @Override
    public boolean bX() {
        return false;
    }

    @Override
    protected NavigationAbstract b(World level) {
        return new b(this, level);
    }

    @Override
    public float a(BlockPosition pos, IWorldReader level) {
        if (level.a_(pos).y().a(TagsFluid.b)) {
            return 10.0f;
        }
        return this.bv() ? Float.NEGATIVE_INFINITY : 0.0f;
    }

    @Nullable
    public EntityStrider b(WorldServer level, EntityAgeable otherParent) {
        return EntityTypes.bu.a(level, EntitySpawnReason.e);
    }

    @Override
    public boolean i(ItemStack stack) {
        return stack.a(TagsItem.az);
    }

    @Override
    public EnumInteractionResult b(EntityHuman player, EnumHand hand) {
        boolean isFood = this.i(player.b(hand));
        if (!isFood && this.fZ() && !this.bZ() && !player.fY()) {
            if (!this.dV().C) {
                player.n(this);
            }
            return EnumInteractionResult.a;
        }
        EnumInteractionResult interactionResult = super.b(player, hand);
        if (!interactionResult.a()) {
            ItemStack itemInHand = player.b(hand);
            return this.a(itemInHand, EnumItemSlot.h) ? itemInHand.a(player, (EntityLiving)this, hand) : EnumInteractionResult.e;
        }
        if (isFood && !this.ba()) {
            this.dV().a(null, this.dA(), this.dC(), this.dG(), SoundEffects.zh, this.dm(), 1.0f, 1.0f + (this.ae.i() - this.ae.i()) * 0.2f);
        }
        return interactionResult;
    }

    @Override
    public Vec3D cT() {
        return new Vec3D(0.0, 0.6f * this.cS(), this.dq() * 0.4f);
    }

    @Override
    @Nullable
    public GroupDataEntity a(WorldAccess level, DifficultyDamageScaler difficulty, EntitySpawnReason spawnReason, @Nullable GroupDataEntity spawnGroupData) {
        if (this.e_()) {
            return super.a(level, difficulty, spawnReason, spawnGroupData);
        }
        RandomSource random = level.G_();
        if (random.a(30) == 0) {
            EntityInsentient mob = EntityTypes.bS.a(level.a(), EntitySpawnReason.g);
            if (mob != null) {
                spawnGroupData = this.a(level, difficulty, mob, (GroupDataEntity)new EntityZombie.GroupDataZombie(EntityZombie.a(random), false));
                mob.a(EnumItemSlot.a, new ItemStack(Items.oB));
                this.a(EnumItemSlot.h, new ItemStack(Items.ou));
                this.g(EnumItemSlot.h);
            }
        } else if (random.a(10) == 0) {
            EntityAgeable ageableMob = EntityTypes.bu.a(level.a(), EntitySpawnReason.g);
            if (ageableMob != null) {
                ageableMob.c_(-24000);
                spawnGroupData = this.a(level, difficulty, ageableMob, null);
            }
        } else {
            spawnGroupData = new EntityAgeable.a(0.5f);
        }
        return super.a(level, difficulty, spawnReason, spawnGroupData);
    }

    private GroupDataEntity a(WorldAccess serverLevel, DifficultyDamageScaler difficulty, EntityInsentient jockey, @Nullable GroupDataEntity spawnData) {
        jockey.b(this.dA(), this.dC(), this.dG(), this.dL(), 0.0f);
        jockey.a(serverLevel, difficulty, EntitySpawnReason.g, spawnData);
        jockey.a((Entity)this, true);
        return new EntityAgeable.a(0.0f);
    }

    static class a
    extends PathfinderGoalGotoTarget {
        private final EntityStrider g;

        a(EntityStrider strider, double speedModifier) {
            super(strider, speedModifier, 8, 2);
            this.g = strider;
        }

        @Override
        public BlockPosition k() {
            return this.e;
        }

        @Override
        public boolean c() {
            return !this.g.bv() && this.a(this.g.dV(), this.e);
        }

        @Override
        public boolean b() {
            return !this.g.bv() && super.b();
        }

        @Override
        public boolean l() {
            return this.d % 20 == 0;
        }

        @Override
        protected boolean a(IWorldReader level, BlockPosition pos) {
            return level.a_(pos).a(Blocks.K) && level.a_(pos.d()).a(PathMode.a);
        }
    }

    static class b
    extends Navigation {
        b(EntityStrider strider, World level) {
            super(strider, level);
        }

        @Override
        protected Pathfinder a(int maxVisitedNodes) {
            this.o = new PathfinderNormal();
            return new Pathfinder(this.o, maxVisitedNodes);
        }

        @Override
        protected boolean a(PathType pathType) {
            return pathType == PathType.i || pathType == PathType.o || pathType == PathType.n || super.a(pathType);
        }

        @Override
        public boolean a(BlockPosition pos) {
            return this.b.a_(pos).a(Blocks.K) || super.a(pos);
        }
    }
}

