/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster;

import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.TraceableEntity;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.control.ControllerMove;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalHurtByTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalTarget;
import net.minecraft.world.entity.ai.targeting.PathfinderTargetCondition;
import net.minecraft.world.entity.monster.EntityMonster;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.raid.EntityRaider;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.event.entity.EntityTargetEvent;

public class EntityVex
extends EntityMonster
implements TraceableEntity {
    public static final float a = 45.836624f;
    public static final int b = MathHelper.f(3.9269907f);
    protected static final DataWatcherObject<Byte> c = DataWatcher.a(EntityVex.class, DataWatcherRegistry.a);
    private static final int d = 1;
    @Nullable
    EntityInsentient e;
    @Nullable
    private BlockPosition f;
    public boolean bI;
    public int bJ;

    public EntityVex(EntityTypes<? extends EntityVex> entityType, World level) {
        super((EntityTypes<? extends EntityMonster>)entityType, level);
        this.bC = new c(this);
        this.bA = 3;
    }

    @Override
    public boolean aZ() {
        return this.af % b == 0;
    }

    @Override
    public boolean aK() {
        return !this.dQ();
    }

    @Override
    public void g() {
        this.ad = true;
        super.g();
        this.ad = false;
        this.f(true);
        if (this.bI && --this.bJ <= 0) {
            this.bJ = 20;
            this.a(this.dW().j(), 1.0f);
        }
    }

    @Override
    protected void C() {
        super.C();
        this.bF.a(0, new PathfinderGoalFloat(this));
        this.bF.a(4, new a());
        this.bF.a(8, new d());
        this.bF.a(9, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 3.0f, 1.0f));
        this.bF.a(10, new PathfinderGoalLookAtPlayer(this, EntityInsentient.class, 8.0f));
        this.bG.a(1, new PathfinderGoalHurtByTarget(this, EntityRaider.class).a(new Class[0]));
        this.bG.a(2, new b(this));
        this.bG.a(3, new PathfinderGoalNearestAttackableTarget<EntityHuman>((EntityInsentient)this, EntityHuman.class, true));
    }

    public static AttributeProvider.Builder m() {
        return EntityMonster.gA().a(GenericAttributes.s, 14.0).a(GenericAttributes.c, 4.0);
    }

    @Override
    protected void a(DataWatcher.a builder) {
        super.a(builder);
        builder.a(c, (byte)0);
    }

    @Override
    public void a(NBTTagCompound compound) {
        super.a(compound);
        this.f = compound.a("bound_pos", BlockPosition.a).orElse(null);
        compound.e("life_ticks").ifPresentOrElse(this::b, () -> {
            this.bI = false;
        });
    }

    @Override
    public void x(Entity entity) {
        super.x(entity);
        if (entity instanceof EntityVex) {
            EntityVex vex = (EntityVex)entity;
            this.e = vex.u();
        }
    }

    @Override
    public void b(NBTTagCompound compound) {
        super.b(compound);
        compound.b("bound_pos", BlockPosition.a, this.f);
        if (this.bI) {
            compound.a("life_ticks", this.bJ);
        }
    }

    @Nullable
    public EntityInsentient u() {
        return this.e;
    }

    @Nullable
    public BlockPosition gu() {
        return this.f;
    }

    public void h(@Nullable BlockPosition boundOrigin) {
        this.f = boundOrigin;
    }

    private boolean c(int mask) {
        byte i2 = this.al.a(c);
        return (i2 & mask) != 0;
    }

    private void a(int mask, boolean value) {
        int i2 = this.al.a(c).byteValue();
        i2 = value ? (i2 |= mask) : (i2 &= ~mask);
        this.al.a(c, (byte)(i2 & 0xFF));
    }

    public boolean gv() {
        return this.c(1);
    }

    public void w(boolean charging) {
        this.a(1, charging);
    }

    public void a(EntityInsentient owner) {
        this.e = owner;
    }

    public void b(int limitedLifeTicks) {
        this.bI = true;
        this.bJ = limitedLifeTicks;
    }

    @Override
    public SoundEffect s() {
        return SoundEffects.BS;
    }

    @Override
    public SoundEffect j_() {
        return SoundEffects.BU;
    }

    @Override
    public SoundEffect e(DamageSource damageSource) {
        return SoundEffects.BV;
    }

    @Override
    public float bw() {
        return 1.0f;
    }

    @Override
    @Nullable
    public GroupDataEntity a(WorldAccess level, DifficultyDamageScaler difficulty, EntitySpawnReason spawnReason, @Nullable GroupDataEntity spawnGroupData) {
        RandomSource random = level.G_();
        this.a(random, difficulty);
        this.a(level, random, difficulty);
        return super.a(level, difficulty, spawnReason, spawnGroupData);
    }

    @Override
    protected void a(RandomSource random, DifficultyDamageScaler difficulty) {
        this.a(EnumItemSlot.a, new ItemStack(Items.pP));
        this.a(EnumItemSlot.a, 0.0f);
    }

    class c
    extends ControllerMove {
        public c(EntityVex mob) {
            super(mob);
        }

        @Override
        public void a() {
            if (this.k == ControllerMove.Operation.b) {
                Vec3D vec3 = new Vec3D(this.e - EntityVex.this.dA(), this.f - EntityVex.this.dC(), this.g - EntityVex.this.dG());
                double len = vec3.g();
                if (len < EntityVex.this.cR().a()) {
                    this.k = ControllerMove.Operation.a;
                    EntityVex.this.i(EntityVex.this.dy().c(0.5));
                } else {
                    EntityVex.this.i(EntityVex.this.dy().e(vec3.c(this.h * 0.05 / len)));
                    if (EntityVex.this.e() == null) {
                        Vec3D deltaMovement = EntityVex.this.dy();
                        EntityVex.this.w(-((float)MathHelper.d(deltaMovement.d, deltaMovement.f)) * 57.295776f);
                        EntityVex.this.aV = EntityVex.this.dL();
                    } else {
                        double d2 = EntityVex.this.e().dA() - EntityVex.this.dA();
                        double d1 = EntityVex.this.e().dG() - EntityVex.this.dG();
                        EntityVex.this.w(-((float)MathHelper.d(d2, d1)) * 57.295776f);
                        EntityVex.this.aV = EntityVex.this.dL();
                    }
                }
            }
        }
    }

    class a
    extends PathfinderGoal {
        public a() {
            this.a(EnumSet.of(PathfinderGoal.Type.a));
        }

        @Override
        public boolean b() {
            EntityLiving target = EntityVex.this.e();
            return target != null && target.bJ() && !EntityVex.this.K().b() && EntityVex.this.ae.a(net.minecraft.world.entity.monster.EntityVex$a.b(7)) == 0 && EntityVex.this.g((Entity)target) > 4.0;
        }

        @Override
        public boolean c() {
            return EntityVex.this.K().b() && EntityVex.this.gv() && EntityVex.this.e() != null && EntityVex.this.e().bJ();
        }

        @Override
        public void d() {
            EntityLiving target = EntityVex.this.e();
            if (target != null) {
                Vec3D eyePosition = target.bD();
                EntityVex.this.bC.a(eyePosition.d, eyePosition.e, eyePosition.f, 1.0);
            }
            EntityVex.this.w(true);
            EntityVex.this.a(SoundEffects.BT, 1.0f, 1.0f);
        }

        @Override
        public void e() {
            EntityVex.this.w(false);
        }

        @Override
        public boolean W_() {
            return true;
        }

        @Override
        public void a() {
            EntityLiving target = EntityVex.this.e();
            if (target != null) {
                if (EntityVex.this.cR().c(target.cR())) {
                    EntityVex.this.c(net.minecraft.world.entity.monster.EntityVex$a.a(EntityVex.this.dV()), (Entity)target);
                    EntityVex.this.w(false);
                } else {
                    double d2 = EntityVex.this.g((Entity)target);
                    if (d2 < 9.0) {
                        Vec3D eyePosition = target.bD();
                        EntityVex.this.bC.a(eyePosition.d, eyePosition.e, eyePosition.f, 1.0);
                    }
                }
            }
        }
    }

    class d
    extends PathfinderGoal {
        public d() {
            this.a(EnumSet.of(PathfinderGoal.Type.a));
        }

        @Override
        public boolean b() {
            return !EntityVex.this.K().b() && EntityVex.this.ae.a(net.minecraft.world.entity.monster.EntityVex$d.b(7)) == 0;
        }

        @Override
        public boolean c() {
            return false;
        }

        @Override
        public void a() {
            BlockPosition boundOrigin = EntityVex.this.gu();
            if (boundOrigin == null) {
                boundOrigin = EntityVex.this.dv();
            }
            for (int i2 = 0; i2 < 3; ++i2) {
                BlockPosition blockPos = boundOrigin.b(EntityVex.this.ae.a(15) - 7, EntityVex.this.ae.a(11) - 5, EntityVex.this.ae.a(15) - 7);
                IBlockData blockState = EntityVex.this.dV().getBlockStateIfLoaded(blockPos);
                if (blockState == null || !blockState.l()) continue;
                EntityVex.this.bC.a((double)blockPos.u() + 0.5, (double)blockPos.v() + 0.5, (double)blockPos.w() + 0.5, 0.25);
                if (EntityVex.this.e() != null) break;
                EntityVex.this.I().a((double)blockPos.u() + 0.5, (double)blockPos.v() + 0.5, (double)blockPos.w() + 0.5, 180.0f, 20.0f);
                break;
            }
        }
    }

    class b
    extends PathfinderGoalTarget {
        private final PathfinderTargetCondition b;

        public b(EntityCreature mob) {
            super(mob, false);
            this.b = PathfinderTargetCondition.b().d().e();
        }

        @Override
        public boolean b() {
            return EntityVex.this.e != null && EntityVex.this.e.e() != null && this.a(EntityVex.this.e.e(), this.b);
        }

        @Override
        public void d() {
            EntityVex.this.setTarget(EntityVex.this.e.e(), EntityTargetEvent.TargetReason.OWNER_ATTACKED_TARGET);
            super.d();
        }
    }
}

