/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Predicates;
import java.time.LocalDate;
import java.time.temporal.ChronoField;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsFluid;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.ConversionParams;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntityPositionTypes;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.entity.ai.attributes.AttributeModifiable;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.PathfinderGoalBreakDoor;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalMoveThroughVillage;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomLookaround;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStrollLand;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRemoveBlock;
import net.minecraft.world.entity.ai.goal.PathfinderGoalZombieAttack;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalHurtByTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.ai.navigation.Navigation;
import net.minecraft.world.entity.ai.util.PathfinderGoalUtil;
import net.minecraft.world.entity.animal.EntityChicken;
import net.minecraft.world.entity.animal.EntityIronGolem;
import net.minecraft.world.entity.animal.EntityTurtle;
import net.minecraft.world.entity.monster.EntityCreeper;
import net.minecraft.world.entity.monster.EntityMonster;
import net.minecraft.world.entity.monster.EntityPigZombie;
import net.minecraft.world.entity.monster.EntityZombieVillager;
import net.minecraft.world.entity.npc.EntityVillager;
import net.minecraft.world.entity.npc.EntityVillagerAbstract;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import org.bukkit.entity.Zombie;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityCombustByEntityEvent;
import org.bukkit.event.entity.EntityTargetEvent;
import org.bukkit.event.entity.EntityTransformEvent;

public class EntityZombie
extends EntityMonster {
    private static final MinecraftKey a = MinecraftKey.b("baby");
    private final AttributeModifier babyModifier;
    private static final MinecraftKey c = MinecraftKey.b("reinforcement_caller_charge");
    private static final AttributeModifier bJ = new AttributeModifier(MinecraftKey.b("reinforcement_callee_charge"), -0.05f, AttributeModifier.Operation.a);
    private static final MinecraftKey bK = MinecraftKey.b("leader_zombie_bonus");
    private static final MinecraftKey bL = MinecraftKey.b("zombie_random_spawn_bonus");
    private static final DataWatcherObject<Boolean> bM = DataWatcher.a(EntityZombie.class, DataWatcherRegistry.k);
    private static final DataWatcherObject<Integer> bN = DataWatcher.a(EntityZombie.class, DataWatcherRegistry.b);
    public static final DataWatcherObject<Boolean> bO = DataWatcher.a(EntityZombie.class, DataWatcherRegistry.k);
    public static final float d = 0.05f;
    public static final int e = 50;
    public static final int f = 40;
    public static final int bI = 7;
    private static final int bP = -1;
    private static final EntitySize bQ = EntityTypes.bP.n().a(0.5f).b(0.93f);
    private static final float bR = 0.1f;
    public static final Predicate<EnumDifficulty> bS = difficulty -> difficulty == EnumDifficulty.d;
    private static final boolean bT = false;
    private static final boolean bU = false;
    private static final int bV = 0;
    private final PathfinderGoalBreakDoor bW;
    private boolean bX;
    private int bY;
    public int bZ;
    private boolean shouldBurnInDay;

    public EntityZombie(EntityTypes<? extends EntityZombie> entityType, World level) {
        super((EntityTypes<? extends EntityMonster>)entityType, level);
        this.babyModifier = new AttributeModifier(a, this.dV().paperConfig().entities.behavior.babyZombieMovementModifier, AttributeModifier.Operation.b);
        this.bX = false;
        this.bY = 0;
        this.shouldBurnInDay = true;
        this.bW = new PathfinderGoalBreakDoor(this, (Predicate<EnumDifficulty>)Predicates.in((Collection)level.paperConfig().entities.behavior.doorBreakingDifficulty.getOrDefault(entityType, level.paperConfig().entities.behavior.doorBreakingDifficulty.get(EntityTypes.bP))));
    }

    public EntityZombie(World level) {
        this((EntityTypes<? extends EntityZombie>)EntityTypes.bP, level);
    }

    @Override
    protected void C() {
        if (this.dV().paperConfig().entities.behavior.zombiesTargetTurtleEggs) {
            this.bF.a(4, new a((EntityCreature)this, 1.0, 3));
        }
        this.bF.a(8, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 8.0f));
        this.bF.a(8, new PathfinderGoalRandomLookaround(this));
        this.p();
    }

    protected void p() {
        this.bF.a(2, new PathfinderGoalZombieAttack(this, 1.0, false));
        this.bF.a(6, new PathfinderGoalMoveThroughVillage(this, 1.0, true, 4, this::gC));
        this.bF.a(7, new PathfinderGoalRandomStrollLand(this, 1.0));
        this.bG.a(1, new PathfinderGoalHurtByTarget(this, new Class[0]).a(EntityPigZombie.class));
        this.bG.a(2, new PathfinderGoalNearestAttackableTarget<EntityHuman>((EntityInsentient)this, EntityHuman.class, true));
        if (this.dV().spigotConfig.zombieAggressiveTowardsVillager) {
            this.bG.a(3, new PathfinderGoalNearestAttackableTarget<EntityVillagerAbstract>((EntityInsentient)this, EntityVillagerAbstract.class, false));
        }
        this.bG.a(3, new PathfinderGoalNearestAttackableTarget<EntityIronGolem>((EntityInsentient)this, EntityIronGolem.class, true));
        this.bG.a(5, new PathfinderGoalNearestAttackableTarget<EntityTurtle>(this, EntityTurtle.class, 10, true, false, EntityTurtle.bI));
    }

    public static AttributeProvider.Builder gy() {
        return EntityMonster.gA().a(GenericAttributes.m, 35.0).a(GenericAttributes.v, 0.23f).a(GenericAttributes.c, 3.0).a(GenericAttributes.a, 2.0).a(GenericAttributes.A);
    }

    @Override
    protected void a(DataWatcher.a builder) {
        super.a(builder);
        builder.a(bM, false);
        builder.a(bN, 0);
        builder.a(bO, false);
    }

    public boolean gB() {
        return this.ar().a(bO);
    }

    public boolean gC() {
        return this.bX;
    }

    public void x(boolean canBreakDoors) {
        if (PathfinderGoalUtil.a(this)) {
            if (this.bX != canBreakDoors) {
                this.bX = canBreakDoors;
                ((Navigation)this.N()).b(canBreakDoors);
                if (canBreakDoors) {
                    this.bF.a(1, this.bW);
                } else {
                    this.bF.a(this.bW);
                }
            }
        } else if (this.bX) {
            this.bF.a(this.bW);
            this.bX = false;
        }
    }

    @Override
    public boolean e_() {
        return this.ar().a(bM);
    }

    @Override
    protected int e(WorldServer level) {
        int previousReward = this.bA;
        if (this.e_()) {
            this.bA = (int)((double)this.bA * 2.5);
        }
        int reward = super.e(level);
        this.bA = previousReward;
        return reward;
    }

    @Override
    public void a(boolean childZombie) {
        this.ar().a(bM, childZombie);
        if (this.dV() != null && !this.dV().C) {
            AttributeModifiable attribute = this.g(GenericAttributes.v);
            attribute.c(this.babyModifier.a());
            if (childZombie) {
                attribute.b(this.babyModifier);
            }
        }
    }

    @Override
    public void a(DataWatcherObject<?> key) {
        if (bM.equals(key)) {
            this.h_();
        }
        super.a(key);
    }

    protected boolean gw() {
        return true;
    }

    @Override
    public void g() {
        if (!this.dV().C && this.bJ() && !this.gj()) {
            if (this.gB()) {
                --this.bZ;
                if (this.bZ < 0) {
                    this.ad_();
                }
            } else if (this.gw()) {
                if (((Entity)this).a(TagsFluid.a)) {
                    ++this.bY;
                    if (this.bY >= 600) {
                        this.r(300);
                    }
                } else {
                    this.bY = -1;
                }
            }
        }
        super.g();
    }

    @Override
    public void d_() {
        if (this.bJ()) {
            boolean flag;
            boolean bl = flag = this.ae_() && this.go();
            if (flag) {
                ItemStack itemBySlot = this.a(EnumItemSlot.f);
                if (!itemBySlot.f()) {
                    if (itemBySlot.m()) {
                        Item item = itemBySlot.h();
                        itemBySlot.b(itemBySlot.o() + this.ae.a(2));
                        if (itemBySlot.o() >= itemBySlot.p()) {
                            this.a(item, EnumItemSlot.f);
                            this.a(EnumItemSlot.f, ItemStack.l);
                        }
                    }
                    flag = false;
                }
                if (flag) {
                    this.e(8.0f);
                }
            }
        }
        super.d_();
    }

    public void stopDrowning() {
        this.bZ = -1;
        this.ar().a(bO, false);
    }

    public void r(int conversionTime) {
        this.bZ = conversionTime;
        this.ar().a(bO, true);
    }

    protected void ad_() {
        this.b(EntityTypes.L);
        if (!this.ba()) {
            this.dV().a(null, 1040, this.dv(), 0);
        }
    }

    protected void b(EntityTypes<? extends EntityZombie> entityType) {
        EntityZombie converted = this.convertTo(entityType, ConversionParams.a(this, true, true), (T zombie) -> zombie.J(zombie.dV().d_(zombie.dv()).d()), EntityTransformEvent.TransformReason.DROWNED, CreatureSpawnEvent.SpawnReason.DROWNED);
        if (converted == null) {
            ((Zombie)this.getBukkitEntity()).setConversionTime(-1);
        }
    }

    @VisibleForTesting
    public boolean a(WorldServer level, EntityVillager villager) {
        return EntityZombie.convertVillagerToZombieVillager(level, villager, this.dv(), this.ba(), EntityTransformEvent.TransformReason.INFECTION, CreatureSpawnEvent.SpawnReason.INFECTION) != null;
    }

    @Nullable
    public static EntityZombieVillager convertVillagerToZombieVillager(WorldServer level, EntityVillager villager, BlockPosition blockPosition, boolean silent, EntityTransformEvent.TransformReason transformReason, CreatureSpawnEvent.SpawnReason creatureSpawnReason) {
        EntityZombieVillager zombieVillager = villager.convertTo(EntityTypes.bR, ConversionParams.a(villager, true, true), (T mob) -> {
            mob.a((WorldAccess)level, level.d_(mob.dv()), EntitySpawnReason.i, new GroupDataZombie(false, true));
            mob.a(villager.gF());
            mob.a(villager.gP().d());
            mob.a(villager.gw().a());
            mob.s(villager.p());
            if (!silent) {
                level.a(null, 1026, blockPosition, 0);
            }
        }, transformReason, creatureSpawnReason);
        return zombieVillager;
    }

    public boolean ae_() {
        return this.shouldBurnInDay;
    }

    public void setShouldBurnInDay(boolean shouldBurnInDay) {
        this.shouldBurnInDay = shouldBurnInDay;
    }

    @Override
    public boolean a(WorldServer level, DamageSource damageSource, float amount) {
        if (!super.a(level, damageSource, amount)) {
            return false;
        }
        EntityLiving target = this.e();
        if (target == null && damageSource.d() instanceof EntityLiving) {
            target = (EntityLiving)damageSource.d();
        }
        if (target != null && level.an() == EnumDifficulty.d && (double)this.ae.i() < this.h(GenericAttributes.A) && level.O().c(GameRules.f)) {
            int floor = MathHelper.a(this.dA());
            int floor1 = MathHelper.a(this.dC());
            int floor2 = MathHelper.a(this.dG());
            EntityTypes<? extends EntityZombie> type = this.an();
            EntityZombie zombie = type.a(level, EntitySpawnReason.j);
            if (zombie == null) {
                return true;
            }
            for (int i2 = 0; i2 < 50; ++i2) {
                int i3;
                int i22;
                int i1 = floor + MathHelper.a(this.ae, 7, 40) * MathHelper.a(this.ae, -1, 1);
                BlockPosition blockPos = new BlockPosition(i1, i22 = floor1 + MathHelper.a(this.ae, 7, 40) * MathHelper.a(this.ae, -1, 1), i3 = floor2 + MathHelper.a(this.ae, 7, 40) * MathHelper.a(this.ae, -1, 1));
                if (!EntityPositionTypes.a(type, level, blockPos) || !EntityPositionTypes.a(type, level, EntitySpawnReason.j, blockPos, level.A)) continue;
                zombie.a_(i1, i22, i3);
                if (level.hasNearbyAlivePlayerThatAffectsSpawning(i1, i22, i3, 7.0) || !level.f(zombie) || !level.g(zombie) || !zombie.gu() && level.d(zombie.cR())) continue;
                zombie.setTarget(target, EntityTargetEvent.TargetReason.REINFORCEMENT_TARGET);
                zombie.a((WorldAccess)level, level.d_(zombie.dv()), EntitySpawnReason.j, null);
                level.addFreshEntityWithPassengers(zombie, CreatureSpawnEvent.SpawnReason.REINFORCEMENTS);
                AttributeModifiable attribute = this.g(GenericAttributes.A);
                AttributeModifier modifier = attribute.a(c);
                double d2 = modifier != null ? modifier.b() : 0.0;
                attribute.c(c);
                attribute.d(new AttributeModifier(c, d2 - 0.05, AttributeModifier.Operation.a));
                zombie.g(GenericAttributes.A).d(bJ);
                break;
            }
        }
        return true;
    }

    @Override
    public boolean c(WorldServer level, Entity source) {
        boolean flag = super.c(level, source);
        if (flag) {
            EntityCombustByEntityEvent event;
            float effectiveDifficulty = this.dV().d_(this.dv()).b();
            if (this.fb().f() && this.bX() && this.ae.i() < effectiveDifficulty * 0.3f && (event = new EntityCombustByEntityEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), (org.bukkit.entity.Entity)source.getBukkitEntity(), (float)(2 * (int)effectiveDifficulty))).callEvent()) {
                source.igniteForSeconds(event.getDuration(), false);
            }
        }
        return flag;
    }

    @Override
    public SoundEffect s() {
        return SoundEffects.Er;
    }

    @Override
    public SoundEffect e(DamageSource damageSource) {
        return SoundEffects.EB;
    }

    @Override
    public SoundEffect j_() {
        return SoundEffects.Ew;
    }

    protected SoundEffect u() {
        return SoundEffects.EH;
    }

    @Override
    protected void b(BlockPosition pos, IBlockData block) {
        this.a(this.u(), 0.15f, 1.0f);
    }

    public EntityTypes<? extends EntityZombie> an() {
        return super.an();
    }

    protected boolean gu() {
        return false;
    }

    @Override
    protected void a(RandomSource random, DifficultyDamageScaler difficulty) {
        super.a(random, difficulty);
        float f2 = random.i();
        float f3 = this.dV().an() == EnumDifficulty.d ? 0.05f : 0.01f;
        if (f2 < f3) {
            int randomInt = random.a(3);
            if (randomInt == 0) {
                this.a(EnumItemSlot.a, new ItemStack(Items.pP));
            } else {
                this.a(EnumItemSlot.a, new ItemStack(Items.pQ));
            }
        }
    }

    @Override
    public void b(NBTTagCompound compound) {
        super.b(compound);
        compound.a("IsBaby", this.e_());
        compound.a("CanBreakDoors", this.gC());
        compound.a("InWaterTime", this.bi() ? this.bY : -1);
        compound.a("DrownedConversionTime", this.gB() ? this.bZ : -1);
        compound.a("Paper.ShouldBurnInDay", this.shouldBurnInDay);
    }

    @Override
    public void a(NBTTagCompound compound) {
        super.a(compound);
        this.a(compound.b("IsBaby", false));
        this.x(compound.b("CanBreakDoors", false));
        this.bY = compound.b("InWaterTime", 0);
        int intOr = compound.b("DrownedConversionTime", -1);
        if (intOr != -1) {
            this.r(intOr);
        } else {
            this.ar().a(bO, false);
        }
        this.shouldBurnInDay = compound.b("Paper.ShouldBurnInDay", true);
    }

    @Override
    public boolean a(WorldServer level, EntityLiving entity) {
        EntityVillager villager;
        double fallbackChance;
        boolean flag = super.a(level, entity);
        double d2 = level.an() == EnumDifficulty.d ? 100.0 : (fallbackChance = level.an() == EnumDifficulty.c ? 50.0 : 0.0);
        if (this.ae.j() * 100.0 < level.paperConfig().entities.behavior.zombieVillagerInfectionChance.or(fallbackChance) && entity instanceof EntityVillager && this.a(level, villager = (EntityVillager)entity)) {
            flag = false;
        }
        return flag;
    }

    @Override
    public EntitySize e(EntityPose pose) {
        return this.e_() ? bQ : super.e(pose);
    }

    @Override
    public boolean g(ItemStack stack) {
        return (!stack.a(TagsItem.aa) || !this.e_() || !this.bY()) && super.g(stack);
    }

    @Override
    public boolean c(WorldServer level, ItemStack stack) {
        return !stack.a(Items.so) && super.c(level, stack);
    }

    @Override
    @Nullable
    public GroupDataEntity a(WorldAccess level, DifficultyDamageScaler difficulty, EntitySpawnReason spawnReason, @Nullable GroupDataEntity spawnGroupData) {
        RandomSource random = level.G_();
        spawnGroupData = super.a(level, difficulty, spawnReason, spawnGroupData);
        float specialMultiplier = difficulty.d();
        if (spawnReason != EntitySpawnReason.i) {
            this.a_(this.dV().paperConfig().entities.behavior.mobsCanAlwaysPickUpLoot.zombies || random.i() < 0.55f * specialMultiplier);
        }
        if (spawnGroupData == null) {
            spawnGroupData = new GroupDataZombie(EntityZombie.a(random), true);
        }
        if (spawnGroupData instanceof GroupDataZombie) {
            GroupDataZombie zombieGroupData = (GroupDataZombie)spawnGroupData;
            if (zombieGroupData.a) {
                this.a(true);
                if (zombieGroupData.b) {
                    EntityChicken chicken1;
                    if ((double)random.i() < 0.05) {
                        List<Entity> entitiesOfClass = level.a(EntityChicken.class, this.cR().c(5.0, 3.0, 5.0), IEntitySelector.c);
                        if (!entitiesOfClass.isEmpty()) {
                            EntityChicken chicken = (EntityChicken)entitiesOfClass.get(0);
                            chicken.w(true);
                            this.n(chicken);
                        }
                    } else if ((double)random.i() < 0.05 && (chicken1 = EntityTypes.A.a(this.dV(), EntitySpawnReason.g)) != null) {
                        chicken1.b(this.dA(), this.dC(), this.dG(), this.dL(), 0.0f);
                        chicken1.a(level, difficulty, EntitySpawnReason.g, null);
                        chicken1.w(true);
                        this.n(chicken1);
                        level.addFreshEntity(chicken1, CreatureSpawnEvent.SpawnReason.MOUNT);
                    }
                }
            }
            this.x(random.i() < specialMultiplier * 0.1f);
            if (spawnReason != EntitySpawnReason.i) {
                this.a(random, difficulty);
                this.a(level, random, difficulty);
            }
        }
        if (this.a(EnumItemSlot.f).f()) {
            LocalDate localDate = LocalDate.now();
            int i2 = localDate.get(ChronoField.DAY_OF_MONTH);
            int i1 = localDate.get(ChronoField.MONTH_OF_YEAR);
            if (i1 == 10 && i2 == 31 && random.i() < 0.25f) {
                this.a(EnumItemSlot.f, new ItemStack(random.i() < 0.1f ? Blocks.ew : Blocks.ev));
                this.a(EnumItemSlot.f, 0.0f);
            }
        }
        this.J(specialMultiplier);
        return spawnGroupData;
    }

    @VisibleForTesting
    public void b(int inWaterTime) {
        this.bY = inWaterTime;
    }

    @VisibleForTesting
    public void c(int conversionTime) {
        this.bZ = conversionTime;
    }

    public static boolean a(RandomSource random) {
        return random.i() < 0.05f;
    }

    protected void J(float difficulty) {
        this.gD();
        this.g(GenericAttributes.p).c(new AttributeModifier(EntityInsentient.by, this.ae.j() * (double)0.05f, AttributeModifier.Operation.a));
        double d2 = this.ae.j() * 1.5 * (double)difficulty;
        if (d2 > 1.0) {
            this.g(GenericAttributes.m).c(new AttributeModifier(bL, d2, AttributeModifier.Operation.c));
        }
        if (this.ae.i() < difficulty * 0.05f) {
            this.g(GenericAttributes.A).c(new AttributeModifier(bK, this.ae.j() * 0.25 + 0.5, AttributeModifier.Operation.a));
            this.g(GenericAttributes.s).c(new AttributeModifier(bK, this.ae.j() * 3.0 + 1.0, AttributeModifier.Operation.c));
            this.x(true);
        }
    }

    protected void gD() {
        this.g(GenericAttributes.A).a(this.ae.j() * (double)0.1f);
    }

    @Override
    protected void a(WorldServer level, DamageSource damageSource, boolean recentlyHit) {
        ItemStack skull;
        EntityCreeper creeper;
        super.a(level, damageSource, recentlyHit);
        Entity entity = damageSource.d();
        if (entity instanceof EntityCreeper && (creeper = (EntityCreeper)entity).gw() && !(skull = this.gv()).f()) {
            creeper.gx();
            this.a(level, skull);
        }
    }

    protected ItemStack gv() {
        return new ItemStack(Items.vy);
    }

    class a
    extends PathfinderGoalRemoveBlock {
        a(EntityCreature mob, double speedModifier, int verticalSearchRange) {
            super(Blocks.mL, mob, speedModifier, verticalSearchRange);
        }

        @Override
        public void a(GeneratorAccess level, BlockPosition pos) {
            level.a(null, pos, SoundEffects.Ex, SoundCategory.f, 0.5f, 0.9f + EntityZombie.this.ae.i() * 0.2f);
        }

        @Override
        public void a(World level, BlockPosition pos) {
            level.a(null, pos, SoundEffects.Bm, SoundCategory.e, 0.7f, 0.9f + level.A.i() * 0.2f);
        }

        @Override
        public double i() {
            return 1.14;
        }
    }

    public static class GroupDataZombie
    implements GroupDataEntity {
        public final boolean a;
        public final boolean b;

        public GroupDataZombie(boolean isBaby, boolean canSpawnJockey) {
            this.a = isBaby;
            this.b = canSpawnJockey;
        }
    }
}

