/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster;

import com.google.common.annotations.VisibleForTesting;
import com.mojang.serialization.DynamicOps;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.UUIDUtil;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.ConversionParams;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.ReputationHandler;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.ai.gossip.Reputation;
import net.minecraft.world.entity.ai.village.ReputationEvent;
import net.minecraft.world.entity.monster.EntityZombie;
import net.minecraft.world.entity.npc.EntityVillager;
import net.minecraft.world.entity.npc.VillagerData;
import net.minecraft.world.entity.npc.VillagerDataHolder;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerType;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.item.trading.MerchantRecipeList;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.BlockBed;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import org.bukkit.entity.ZombieVillager;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityPotionEffectEvent;
import org.bukkit.event.entity.EntityTransformEvent;

public class EntityZombieVillager
extends EntityZombie
implements VillagerDataHolder {
    public static final DataWatcherObject<Boolean> a = DataWatcher.a(EntityZombieVillager.class, DataWatcherRegistry.k);
    private static final DataWatcherObject<VillagerData> b = DataWatcher.a(EntityZombieVillager.class, DataWatcherRegistry.u);
    private static final int c = 3600;
    private static final int bJ = 6000;
    private static final int bK = 14;
    private static final int bL = 4;
    private static final int bM = -1;
    private static final int bN = 0;
    public int bO;
    @Nullable
    public UUID bP;
    @Nullable
    private Reputation bQ;
    @Nullable
    private MerchantRecipeList bR;
    private int bS = 0;

    public EntityZombieVillager(EntityTypes<? extends EntityZombieVillager> entityType, World level) {
        super((EntityTypes<? extends EntityZombie>)entityType, level);
        BuiltInRegistries.x.a(this.ae).ifPresent(profession -> this.a(this.gF().b((Holder<VillagerProfession>)profession)));
    }

    @Override
    protected void a(DataWatcher.a builder) {
        super.a(builder);
        builder.a(a, false);
        builder.a(b, EntityVillager.gJ());
    }

    @Override
    public void b(NBTTagCompound compound) {
        super.b(compound);
        compound.a("VillagerData", VillagerData.c, this.gF());
        compound.b("Offers", MerchantRecipeList.a, this.dX().a(DynamicOpsNBT.a), this.bR);
        compound.b("Gossips", Reputation.a, this.bQ);
        compound.a("ConversionTime", this.gE() ? this.bO : -1);
        compound.b("ConversionPlayer", UUIDUtil.a, this.bP);
        compound.a("Xp", this.bS);
    }

    @Override
    public void a(NBTTagCompound compound) {
        super.a(compound);
        this.al.a(b, compound.a("VillagerData", VillagerData.c).orElseGet(EntityVillager::gJ));
        this.bR = compound.a("Offers", MerchantRecipeList.a, (DynamicOps<NBTBase>)this.dX().a(DynamicOpsNBT.a)).orElse(null);
        this.bQ = compound.a("Gossips", Reputation.a).orElse(null);
        int intOr = compound.b("ConversionTime", -1);
        if (intOr != -1) {
            UUID uuid = compound.a("ConversionPlayer", UUIDUtil.a).orElse(null);
            this.b(uuid, intOr);
        } else {
            this.ar().a(a, false);
            this.bO = -1;
        }
        this.bS = compound.b("Xp", 0);
    }

    @Override
    public void g() {
        if (!this.dV().C && this.bJ() && this.gE()) {
            int conversionProgress = this.gH();
            this.bO -= conversionProgress;
            if (this.bO <= 0) {
                this.g((WorldServer)this.dV());
            }
        }
        super.g();
    }

    @Override
    public EnumInteractionResult b(EntityHuman player, EnumHand hand) {
        ItemStack itemInHand = player.b(hand);
        if (itemInHand.a(Items.qO)) {
            if (this.b(MobEffects.r)) {
                itemInHand.a(1, (EntityLiving)player);
                if (!this.dV().C) {
                    this.b(player.cG(), this.ae.a(2401) + 3600);
                }
                return EnumInteractionResult.b;
            }
            return EnumInteractionResult.c;
        }
        return super.b(player, hand);
    }

    @Override
    protected boolean gw() {
        return false;
    }

    @Override
    public boolean h(double distanceToClosestPlayer) {
        return !this.gE() && this.bS == 0;
    }

    public boolean gE() {
        return this.ar().a(a);
    }

    public void b(@Nullable UUID conversionStarter, int villagerConversionTime) {
        this.startConverting(conversionStarter, villagerConversionTime, true);
    }

    public void startConverting(@Nullable UUID conversionStarter, int villagerConversionTime, boolean broadcastEntityEvent) {
        this.bP = conversionStarter;
        this.bO = villagerConversionTime;
        this.ar().a(a, true);
        this.removeEffect(MobEffects.r, EntityPotionEffectEvent.Cause.CONVERSION);
        this.addEffect(new MobEffect(MobEffects.e, villagerConversionTime, Math.min(this.dV().an().a() - 1, 0)), EntityPotionEffectEvent.Cause.CONVERSION);
        if (broadcastEntityEvent) {
            this.dV().a((Entity)this, (byte)16);
        }
    }

    @Override
    public void b(byte id) {
        if (id == 16) {
            if (!this.ba()) {
                this.dV().a(this.dA(), this.dE(), this.dG(), SoundEffects.EK, this.dm(), 1.0f + this.ae.i(), this.ae.i() * 0.7f + 0.3f, false);
            }
        } else {
            super.b(id);
        }
    }

    private void g(WorldServer level) {
        EntityVillager converted = this.convertTo(EntityTypes.bE, ConversionParams.a(this, false, false), (T villager) -> {
            EntityHuman playerByUuid;
            for (EnumItemSlot equipmentSlot : this.a(level, (ItemStack stack) -> !EnchantmentManager.a(stack, EnchantmentEffectComponents.E))) {
                SlotAccess slot = villager.a_(equipmentSlot.b() + 300);
                slot.a(this.a(equipmentSlot));
            }
            villager.a(this.gF());
            if (this.bQ != null) {
                villager.a(this.bQ);
            }
            if (this.bR != null) {
                villager.b(this.bR.a());
            }
            villager.t(this.bS);
            villager.a((WorldAccess)level, level.d_(villager.dv()), EntitySpawnReason.i, null);
            villager.g(level);
            if (this.bP != null && (playerByUuid = level.getGlobalPlayerByUUID(this.bP)) instanceof EntityPlayer) {
                CriterionTriggers.s.a((EntityPlayer)playerByUuid, this, (EntityVillager)villager);
                level.a(ReputationEvent.a, (Entity)playerByUuid, (ReputationHandler)((Object)villager));
            }
            villager.addEffect(new MobEffect(MobEffects.i, 200, 0), EntityPotionEffectEvent.Cause.CONVERSION);
            if (!this.ba()) {
                level.a(null, 1027, this.dv(), 0);
            }
        }, EntityTransformEvent.TransformReason.CURED, CreatureSpawnEvent.SpawnReason.CURED);
        if (converted == null) {
            ((ZombieVillager)this.getBukkitEntity()).setConversionTime(-1);
        }
    }

    @Override
    @VisibleForTesting
    public void r(int villagerConversionTime) {
        this.bO = villagerConversionTime;
    }

    private int gH() {
        int i2 = 1;
        if (this.ae.i() < 0.01f) {
            int i1 = 0;
            BlockPosition.MutableBlockPosition mutableBlockPos = new BlockPosition.MutableBlockPosition();
            for (int i22 = (int)this.dA() - 4; i22 < (int)this.dA() + 4 && i1 < 14; ++i22) {
                for (int i3 = (int)this.dC() - 4; i3 < (int)this.dC() + 4 && i1 < 14; ++i3) {
                    for (int i4 = (int)this.dG() - 4; i4 < (int)this.dG() + 4 && i1 < 14; ++i4) {
                        IBlockData blockState = this.dV().a_(mutableBlockPos.d(i22, i3, i4));
                        if (!blockState.a(Blocks.fo) && !(blockState.b() instanceof BlockBed)) continue;
                        if (this.ae.i() < 0.3f) {
                            ++i2;
                        }
                        ++i1;
                    }
                }
            }
        }
        return i2;
    }

    @Override
    public float ff() {
        return this.e_() ? (this.ae.i() - this.ae.i()) * 0.2f + 2.0f : (this.ae.i() - this.ae.i()) * 0.2f + 1.0f;
    }

    @Override
    public SoundEffect s() {
        return SoundEffects.EI;
    }

    @Override
    public SoundEffect e(DamageSource damageSource) {
        return SoundEffects.EM;
    }

    @Override
    public SoundEffect j_() {
        return SoundEffects.EL;
    }

    @Override
    public SoundEffect u() {
        return SoundEffects.EN;
    }

    @Override
    protected ItemStack gv() {
        return ItemStack.l;
    }

    public void a(MerchantRecipeList tradeOffers) {
        this.bR = tradeOffers;
    }

    public void a(Reputation gossips) {
        this.bQ = gossips;
    }

    @Override
    @Nullable
    public GroupDataEntity a(WorldAccess level, DifficultyDamageScaler difficulty, EntitySpawnReason spawnReason, @Nullable GroupDataEntity spawnGroupData) {
        this.a(this.gF().a(level.J_(), VillagerType.a(level.u(this.dv()))));
        return super.a(level, difficulty, spawnReason, spawnGroupData);
    }

    @Override
    public void a(VillagerData data) {
        VillagerData villagerData = this.gF();
        if (!villagerData.b().equals(data.b())) {
            this.bR = null;
        }
        this.al.a(b, data);
    }

    @Override
    public VillagerData gF() {
        return this.al.a(b);
    }

    public int gG() {
        return this.bS;
    }

    public void s(int villagerXp) {
        this.bS = villagerXp;
    }

    @Override
    @Nullable
    public <T> T a(DataComponentType<? extends T> component) {
        return component == DataComponents.av ? EntityZombieVillager.c(component, this.gF().a()) : super.a(component);
    }

    @Override
    protected void a(DataComponentGetter componentGetter) {
        this.a(componentGetter, DataComponents.av);
        super.a(componentGetter);
    }

    @Override
    protected <T> boolean b(DataComponentType<T> component, T value) {
        if (component == DataComponents.av) {
            Holder<VillagerType> holder = EntityZombieVillager.c(DataComponents.av, value);
            this.a(this.gF().a(holder));
            return true;
        }
        return super.b(component, value);
    }
}

