/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster.creaking;

import com.mojang.serialization.Dynamic;
import io.papermc.paper.event.entity.EntityKnockbackEvent;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.particles.ParticleParamBlock;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.game.PacketDebug;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.ai.BehaviorController;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.control.ControllerJump;
import net.minecraft.world.entity.ai.control.ControllerLook;
import net.minecraft.world.entity.ai.control.ControllerMove;
import net.minecraft.world.entity.ai.control.EntityAIBodyControl;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.navigation.Navigation;
import net.minecraft.world.entity.ai.navigation.NavigationAbstract;
import net.minecraft.world.entity.monster.EntityMonster;
import net.minecraft.world.entity.monster.creaking.CreakingAi;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CreakingHeartBlock;
import net.minecraft.world.level.block.entity.CreakingHeartBlockEntity;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.CreakingHeartState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.pathfinder.Pathfinder;
import net.minecraft.world.level.pathfinder.PathfinderNormal;
import net.minecraft.world.level.pathfinder.PathfindingContext;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;

public class Creaking
extends EntityMonster {
    private static final DataWatcherObject<Boolean> bL = DataWatcher.a(Creaking.class, DataWatcherRegistry.k);
    private static final DataWatcherObject<Boolean> bM = DataWatcher.a(Creaking.class, DataWatcherRegistry.k);
    private static final DataWatcherObject<Boolean> bN = DataWatcher.a(Creaking.class, DataWatcherRegistry.k);
    private static final DataWatcherObject<Optional<BlockPosition>> bO = DataWatcher.a(Creaking.class, DataWatcherRegistry.p);
    private static final int bP = 15;
    private static final int bQ = 1;
    private static final float bR = 3.0f;
    private static final float bS = 32.0f;
    private static final float bT = 144.0f;
    public static final int a = 40;
    private static final float bU = 0.4f;
    public static final float b = 0.3f;
    public static final int c = 16545810;
    public static final int d = 0x5F5F5F;
    public static final int e = 8;
    public static final int f = 45;
    private static final int bV = 4;
    private int bW;
    public final AnimationState bI = new AnimationState();
    public final AnimationState bJ = new AnimationState();
    public final AnimationState bK = new AnimationState();
    private int bX;
    private boolean bY;
    private int bZ;
    private int ca;

    public Creaking(EntityTypes<? extends Creaking> entityType, World level) {
        super((EntityTypes<? extends EntityMonster>)entityType, level);
        this.bB = new c(this);
        this.bC = new d(this);
        this.bD = new b(this);
        Navigation groundPathNavigation = (Navigation)this.N();
        groundPathNavigation.a(true);
        this.bA = 0;
    }

    public void h(BlockPosition homePos) {
        this.i(homePos);
        this.a(PathType.q, 8.0f);
        this.a(PathType.f, 8.0f);
        this.a(PathType.i, 8.0f);
        this.a(PathType.o, 0.0f);
        this.a(PathType.n, 0.0f);
    }

    public boolean m() {
        return this.gw() != null;
    }

    @Override
    protected EntityAIBodyControl H() {
        return new a(this);
    }

    protected BehaviorController.b<Creaking> ed() {
        return CreakingAi.a();
    }

    @Override
    protected BehaviorController<?> a(Dynamic<?> dynamic) {
        return CreakingAi.b(this, this.ed().a(dynamic));
    }

    @Override
    protected void a(DataWatcher.a builder) {
        super.a(builder);
        builder.a(bL, true);
        builder.a(bM, false);
        builder.a(bN, false);
        builder.a(bO, Optional.empty());
    }

    public static AttributeProvider.Builder p() {
        return EntityMonster.gA().a(GenericAttributes.s, 1.0).a(GenericAttributes.v, 0.4f).a(GenericAttributes.c, 3.0).a(GenericAttributes.m, 32.0).a(GenericAttributes.B, 1.0625);
    }

    public boolean u() {
        return this.al.a(bL);
    }

    @Override
    public boolean c(WorldServer level, Entity source) {
        if (!(source instanceof EntityLiving)) {
            return false;
        }
        this.bW = 15;
        this.dV().a((Entity)this, (byte)4);
        return super.c(level, source);
    }

    @Override
    public boolean a(WorldServer level, DamageSource damageSource, float amount) {
        BlockPosition homePos = this.gw();
        if (homePos == null || damageSource.a(DamageTypeTags.d)) {
            return super.a(level, damageSource, amount);
        }
        if (!this.a(level, damageSource) && this.bX <= 0 && !this.eH()) {
            CreakingHeartBlockEntity creakingHeartBlockEntity;
            EntityHuman player = this.i(damageSource);
            Entity directEntity = damageSource.c();
            if (!(directEntity instanceof EntityLiving) && !(directEntity instanceof IProjectile) && player == null) {
                return false;
            }
            this.bX = 8;
            this.dV().a((Entity)this, (byte)66);
            ((Entity)this).a(GameEvent.u);
            TileEntity tileEntity = this.dV().c_(homePos);
            if (tileEntity instanceof CreakingHeartBlockEntity && (creakingHeartBlockEntity = (CreakingHeartBlockEntity)tileEntity).b(this)) {
                if (player != null) {
                    creakingHeartBlockEntity.c();
                }
                this.h(damageSource);
            }
            return true;
        }
        return false;
    }

    public EntityHuman i(DamageSource damageSource) {
        this.f(damageSource);
        return this.g(damageSource);
    }

    @Override
    public boolean bG() {
        return super.bG() && this.u();
    }

    @Override
    public void push(double x2, double y2, double z2, @Nullable Entity pushingEntity) {
        if (this.u()) {
            super.push(x2, y2, z2, pushingEntity);
        }
    }

    public BehaviorController<Creaking> ec() {
        return super.ec();
    }

    @Override
    protected void a(WorldServer level) {
        GameProfilerFiller profilerFiller = Profiler.a();
        profilerFiller.a("creakingBrain");
        this.ec().a((WorldServer)this.dV(), this);
        profilerFiller.c();
        CreakingAi.a(this);
    }

    @Override
    public void d_() {
        if (this.bX > 0) {
            --this.bX;
        }
        if (this.bW > 0) {
            --this.bW;
        }
        if (!this.dV().C) {
            boolean flag = this.al.a(bL);
            boolean flag1 = this.gD();
            if (flag1 != flag) {
                ((Entity)this).a(GameEvent.u);
                if (flag1) {
                    this.b(SoundEffects.gt);
                } else {
                    this.V();
                    this.b(SoundEffects.gs);
                }
            }
            this.al.a(bL, flag1);
        }
        super.d_();
    }

    @Override
    public void g() {
        BlockPosition homePos;
        if (!this.dV().C && (homePos = this.gw()) != null) {
            CreakingHeartBlockEntity creakingHeartBlockEntity;
            boolean flag;
            TileEntity tileEntity = this.dV().c_(homePos);
            boolean bl = flag = tileEntity instanceof CreakingHeartBlockEntity && (creakingHeartBlockEntity = (CreakingHeartBlockEntity)tileEntity).b(this);
            if (!flag) {
                this.d(0.0f);
            }
        }
        super.g();
        if (this.dV().C) {
            this.gG();
            this.gC();
        }
    }

    @Override
    protected void en() {
        if (this.m() && this.gy()) {
            ++this.aP;
            if (!this.dV().A_() && this.aP > 45 && !this.dQ()) {
                this.gu();
            }
        } else {
            super.en();
        }
    }

    @Override
    protected void A(float partialTick) {
        float min = Math.min(partialTick * 25.0f, 3.0f);
        this.aT.a(min, 0.4f, 1.0f);
    }

    private void gG() {
        this.bI.a(this.bW > 0, this.af);
        this.bJ.a(this.bX > 0, this.af);
        this.bK.a(this.gy(), this.af);
    }

    public void gu() {
        World world = this.dV();
        if (world instanceof WorldServer) {
            WorldServer serverLevel = (WorldServer)world;
            AxisAlignedBB boundingBox = this.cR();
            Vec3D center = boundingBox.f();
            double d2 = boundingBox.b() * 0.3;
            double d1 = boundingBox.c() * 0.3;
            double d22 = boundingBox.d() * 0.3;
            serverLevel.a(new ParticleParamBlock(Particles.bi, Blocks.u.m()), center.d, center.e, center.f, 100, d2, d1, d22, 0.0);
            serverLevel.a(new ParticleParamBlock(Particles.bi, (IBlockData)Blocks.cE.m().b(CreakingHeartBlock.c, CreakingHeartState.c)), center.d, center.e, center.f, 10, d2, d1, d22, 0.0);
        }
        this.b(this.j_());
        this.remove(Entity.RemovalReason.b, null);
    }

    public void j(DamageSource damageSource) {
        this.i(damageSource);
        this.a(damageSource);
        this.b(SoundEffects.gw);
    }

    @Override
    public void b(byte id) {
        if (id == 66) {
            this.bX = 8;
            this.h(this.dW().p());
        } else if (id == 4) {
            this.bW = 15;
            this.gn();
        } else {
            super.b(id);
        }
    }

    @Override
    public boolean bh() {
        return this.m() || super.bh();
    }

    @Override
    protected boolean r(Entity passenger) {
        return !this.m() && super.r(passenger);
    }

    @Override
    protected boolean bP() {
        return !this.m() && super.bP();
    }

    @Override
    protected void p(Entity passenger) {
        if (this.m()) {
            throw new IllegalStateException("Should never addPassenger without checking couldAcceptPassenger()");
        }
    }

    @Override
    public boolean n(boolean allowPassengers) {
        return !this.m() && super.n(allowPassengers);
    }

    @Override
    protected NavigationAbstract b(World level) {
        return new e(this, level);
    }

    public boolean gv() {
        List list = this.bs.c(MemoryModuleType.j).orElse(List.of());
        if (list.isEmpty()) {
            this.ca = 0;
            return false;
        }
        AxisAlignedBB boundingBox = this.cR();
        for (EntityHuman player : list) {
            if (!boundingBox.d(player.bD())) continue;
            ++this.ca;
            return this.ca > 4;
        }
        this.ca = 0;
        return false;
    }

    @Override
    public void a(NBTTagCompound compound) {
        super.a(compound);
        compound.a("home_pos", BlockPosition.a).ifPresent(this::h);
    }

    @Override
    public void b(NBTTagCompound compound) {
        super.b(compound);
        compound.b("home_pos", BlockPosition.a, this.gw());
    }

    public void i(BlockPosition homePos) {
        this.al.a(bO, Optional.of(homePos));
    }

    @Nullable
    public BlockPosition gw() {
        return this.al.a(bO).orElse(null);
    }

    public void gx() {
        this.al.a(bN, true);
    }

    public boolean gy() {
        return this.al.a(bN);
    }

    public boolean gB() {
        return this.bY;
    }

    public void gC() {
        if (this.aP > this.bZ) {
            this.bZ = this.aP + this.dY().a(this.bY ? 2 : this.aP / 4, this.bY ? 8 : this.aP / 2);
            this.bY = !this.bY;
        }
    }

    @Override
    public void gn() {
        this.b(SoundEffects.gp);
    }

    @Override
    public SoundEffect s() {
        return this.gF() ? null : SoundEffects.gm;
    }

    @Override
    public SoundEffect e(DamageSource damageSource) {
        return this.m() ? SoundEffects.gv : super.e(damageSource);
    }

    @Override
    public SoundEffect j_() {
        return SoundEffects.gq;
    }

    @Override
    protected void b(BlockPosition pos, IBlockData state) {
        this.a(SoundEffects.gr, 0.15f, 1.0f);
    }

    @Override
    @Nullable
    public EntityLiving e() {
        return this.P();
    }

    @Override
    protected void ab() {
        super.ab();
        PacketDebug.a(this);
    }

    @Override
    public void knockback(double strength, double x2, double z2, @Nullable Entity attacker, EntityKnockbackEvent.Cause cause) {
        if (this.u()) {
            super.knockback(strength, x2, z2, attacker, cause);
        }
    }

    public boolean gD() {
        List list = this.bs.c(MemoryModuleType.j).orElse(List.of());
        boolean isActive = this.gF();
        if (list.isEmpty()) {
            if (isActive) {
                this.gE();
            }
            return true;
        }
        boolean flag = false;
        for (EntityHuman player : list) {
            if (!this.c((EntityLiving)player) || this.s(player)) continue;
            flag = true;
            if (isActive && !EntityLiving.aH.test(player) || !this.a(player, 0.5, false, true, this.dE(), this.dC() + 0.5 * (double)this.el(), (this.dE() + this.dC()) / 2.0)) continue;
            if (isActive) {
                return false;
            }
            if (!(player.g(this) < 144.0)) continue;
            this.a(player);
            return false;
        }
        if (!flag && isActive) {
            this.gE();
        }
        return true;
    }

    public void a(EntityHuman player) {
        this.ec().a(MemoryModuleType.p, player);
        ((Entity)this).a(GameEvent.u);
        this.b(SoundEffects.gn);
        this.w(true);
    }

    public void gE() {
        this.ec().b(MemoryModuleType.p);
        ((Entity)this).a(GameEvent.u);
        this.b(SoundEffects.go);
        this.w(false);
    }

    public void w(boolean isActive) {
        this.al.a(bM, isActive);
    }

    public boolean gF() {
        return this.al.a(bM);
    }

    @Override
    public float a(BlockPosition pos, IWorldReader level) {
        return 0.0f;
    }

    class c
    extends ControllerLook {
        public c(Creaking mob) {
            super(mob);
        }

        @Override
        public void a() {
            if (Creaking.this.u()) {
                super.a();
            }
        }
    }

    class d
    extends ControllerMove {
        public d(Creaking mob) {
            super(mob);
        }

        @Override
        public void a() {
            if (Creaking.this.u()) {
                super.a();
            }
        }
    }

    class b
    extends ControllerJump {
        public b(Creaking mob) {
            super(mob);
        }

        @Override
        public void b() {
            if (Creaking.this.u()) {
                super.b();
            } else {
                Creaking.this.s(false);
            }
        }
    }

    class a
    extends EntityAIBodyControl {
        public a(Creaking mob) {
            super(mob);
        }

        @Override
        public void a() {
            if (Creaking.this.u()) {
                super.a();
            }
        }
    }

    class e
    extends Navigation {
        e(Creaking mob, World level) {
            super(mob, level);
        }

        @Override
        public void c() {
            if (Creaking.this.u()) {
                super.c();
            }
        }

        @Override
        protected Pathfinder a(int maxVisitedNodes) {
            this.o = new f();
            this.o.a(true);
            return new Pathfinder(this.o, maxVisitedNodes);
        }
    }

    class f
    extends PathfinderNormal {
        private static final int m = 1024;

        f() {
        }

        @Override
        public PathType a(PathfindingContext context, int x2, int y2, int z2) {
            BlockPosition homePos = Creaking.this.gw();
            if (homePos == null) {
                return super.a(context, x2, y2, z2);
            }
            double d2 = homePos.j(new BaseBlockPosition(x2, y2, z2));
            return d2 > 1024.0 && d2 >= homePos.j(context.b()) ? PathType.a : super.a(context, x2, y2, z2);
        }
    }
}

