/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster.hoglin;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Dynamic;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.game.PacketDebug;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.RandomSource;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.ConversionParams;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.ai.BehaviorController;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.monster.EntityMonster;
import net.minecraft.world.entity.monster.EntityZoglin;
import net.minecraft.world.entity.monster.IMonster;
import net.minecraft.world.entity.monster.hoglin.HoglinAI;
import net.minecraft.world.entity.monster.hoglin.IOglin;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityTransformEvent;

public class EntityHoglin
extends EntityAnimal
implements IMonster,
IOglin {
    private static final DataWatcherObject<Boolean> bM = DataWatcher.a(EntityHoglin.class, DataWatcherRegistry.k);
    private static final int bN = 40;
    private static final float bO = 0.3f;
    private static final int bP = 1;
    private static final float bQ = 0.6f;
    private static final int bR = 6;
    private static final float bS = 0.5f;
    private static final boolean bT = false;
    private static final int bU = 0;
    private static final boolean bV = false;
    public static final int bI = 300;
    private int bW;
    public int bX = 0;
    public boolean bY = false;
    protected static final ImmutableList<? extends SensorType<? extends Sensor<? super EntityHoglin>>> bJ = ImmutableList.of(SensorType.c, SensorType.d, SensorType.o, SensorType.n);
    protected static final ImmutableList<? extends MemoryModuleType<?>> bK = ImmutableList.of(MemoryModuleType.s, MemoryModuleType.g, MemoryModuleType.h, MemoryModuleType.k, MemoryModuleType.l, MemoryModuleType.o, MemoryModuleType.n, MemoryModuleType.F, MemoryModuleType.u, MemoryModuleType.p, MemoryModuleType.q, MemoryModuleType.ar, (Object[])new MemoryModuleType[]{MemoryModuleType.A, MemoryModuleType.at, MemoryModuleType.au, MemoryModuleType.aq, MemoryModuleType.L, MemoryModuleType.ax, MemoryModuleType.ay, MemoryModuleType.aa});

    public EntityHoglin(EntityTypes<? extends EntityHoglin> entityType, World level) {
        super((EntityTypes<? extends EntityAnimal>)entityType, level);
        this.bA = 5;
    }

    @VisibleForTesting
    public void s(int timeInOverworld) {
        this.bX = timeInOverworld;
    }

    @Override
    public boolean w() {
        return true;
    }

    public static AttributeProvider.Builder m() {
        return EntityMonster.gA().a(GenericAttributes.s, 40.0).a(GenericAttributes.v, 0.3f).a(GenericAttributes.p, 0.6f).a(GenericAttributes.d, 1.0).a(GenericAttributes.c, 6.0);
    }

    @Override
    public boolean c(WorldServer level, Entity source) {
        if (source instanceof EntityLiving) {
            EntityLiving livingEntity = (EntityLiving)source;
            this.bW = 10;
            this.dV().a((Entity)this, (byte)4);
            this.b(SoundEffects.mS);
            HoglinAI.a(this, livingEntity);
            return IOglin.a(level, this, livingEntity);
        }
        return false;
    }

    @Override
    protected void d(EntityLiving entity) {
        if (this.p()) {
            IOglin.a(this, entity);
        }
    }

    @Override
    public boolean a(WorldServer level, DamageSource damageSource, float amount) {
        Entity entity;
        boolean flag = super.a(level, damageSource, amount);
        if (flag && (entity = damageSource.d()) instanceof EntityLiving) {
            EntityLiving livingEntity = (EntityLiving)entity;
            HoglinAI.a(level, this, livingEntity);
        }
        return flag;
    }

    protected BehaviorController.b<EntityHoglin> ed() {
        return BehaviorController.a(bK, bJ);
    }

    @Override
    protected BehaviorController<?> a(Dynamic<?> dynamic) {
        return HoglinAI.a(this.ed().a(dynamic));
    }

    public BehaviorController<EntityHoglin> ec() {
        return super.ec();
    }

    @Override
    protected void a(WorldServer level) {
        GameProfilerFiller profilerFiller = Profiler.a();
        profilerFiller.a("hoglinBrain");
        this.ec().a(level, this);
        profilerFiller.c();
        HoglinAI.a(this);
        if (this.u()) {
            ++this.bX;
            if (this.bX > 300) {
                this.b(SoundEffects.mT);
                this.gw();
            }
        } else {
            this.bX = 0;
        }
    }

    @Override
    public void d_() {
        if (this.bW > 0) {
            --this.bW;
        }
        super.d_();
    }

    @Override
    protected void h() {
        if (this.e_()) {
            this.bA = 3;
            this.g(GenericAttributes.c).a(0.5);
        } else {
            this.bA = 5;
            this.g(GenericAttributes.c).a(6.0);
        }
    }

    public static boolean c(EntityTypes<EntityHoglin> entityType, GeneratorAccess level, EntitySpawnReason spawnReason, BlockPosition pos, RandomSource random) {
        return !level.a_(pos.e()).a(Blocks.lq);
    }

    @Override
    @Nullable
    public GroupDataEntity a(WorldAccess level, DifficultyDamageScaler difficulty, EntitySpawnReason spawnReason, @Nullable GroupDataEntity spawnGroupData) {
        if (level.G_().i() < 0.2f) {
            this.a(true);
        }
        return super.a(level, difficulty, spawnReason, spawnGroupData);
    }

    @Override
    public boolean h(double distanceToClosestPlayer) {
        return !this.gd();
    }

    @Override
    public float a(BlockPosition pos, IWorldReader level) {
        if (HoglinAI.a(this, pos)) {
            return -1.0f;
        }
        return level.a_(pos.e()).a(Blocks.pc) ? 10.0f : 0.0f;
    }

    @Override
    public EnumInteractionResult b(EntityHuman player, EnumHand hand) {
        EnumInteractionResult interactionResult = super.b(player, hand);
        if (interactionResult.a()) {
            this.gc();
        }
        return interactionResult;
    }

    @Override
    public void b(byte id) {
        if (id == 4) {
            this.bW = 10;
            this.b(SoundEffects.mS);
        } else {
            super.b(id);
        }
    }

    @Override
    public int gu() {
        return this.bW;
    }

    @Override
    public boolean eo() {
        return true;
    }

    @Override
    protected int e(WorldServer level) {
        return this.bA;
    }

    private void gw() {
        EntityZoglin converted = this.convertTo(EntityTypes.bO, ConversionParams.a(this, true, false), (T mob) -> mob.a(new MobEffect(MobEffects.i, 200, 0)), EntityTransformEvent.TransformReason.PIGLIN_ZOMBIFIED, CreatureSpawnEvent.SpawnReason.PIGLIN_ZOMBIFIED);
        if (converted == null) {
            this.bX = 0;
        }
    }

    @Override
    public boolean i(ItemStack stack) {
        return stack.a(TagsItem.ar);
    }

    public boolean p() {
        return !this.e_();
    }

    @Override
    protected void a(DataWatcher.a builder) {
        super.a(builder);
        builder.a(bM, false);
    }

    @Override
    public void b(NBTTagCompound compound) {
        super.b(compound);
        compound.a("IsImmuneToZombification", this.gx());
        compound.a("TimeInOverworld", this.bX);
        compound.a("CannotBeHunted", this.bY);
    }

    @Override
    public void a(NBTTagCompound compound) {
        super.a(compound);
        this.w(compound.b("IsImmuneToZombification", false));
        this.bX = compound.b("TimeInOverworld", 0);
        this.x(compound.b("CannotBeHunted", false));
    }

    public void w(boolean immuneToZombification) {
        this.ar().a(bM, immuneToZombification);
    }

    public boolean gx() {
        return this.ar().a(bM);
    }

    public boolean u() {
        return !this.dV().F_().b() && !this.gx() && !this.gj();
    }

    private void x(boolean cannotBeHunted) {
        this.bY = cannotBeHunted;
    }

    public boolean gv() {
        return this.p() && !this.bY;
    }

    @Override
    @Nullable
    public EntityAgeable a(WorldServer level, EntityAgeable otherParent) {
        EntityHoglin hoglin = EntityTypes.ak.a(level, EntitySpawnReason.e);
        if (hoglin != null) {
            hoglin.gc();
        }
        return hoglin;
    }

    @Override
    public boolean gB() {
        return !HoglinAI.c(this) && super.gB();
    }

    @Override
    public SoundCategory dm() {
        return SoundCategory.f;
    }

    @Override
    public SoundEffect s() {
        return this.dV().C ? null : (SoundEffect)HoglinAI.b(this).orElse(null);
    }

    @Override
    public SoundEffect e(DamageSource damageSource) {
        return SoundEffects.mV;
    }

    @Override
    public SoundEffect j_() {
        return SoundEffects.mU;
    }

    @Override
    public SoundEffect aU() {
        return SoundEffects.nA;
    }

    @Override
    public SoundEffect aV() {
        return SoundEffects.nz;
    }

    @Override
    protected void b(BlockPosition pos, IBlockData block) {
        this.a(SoundEffects.mX, 0.15f, 1.0f);
    }

    @Override
    protected void ab() {
        super.ab();
        PacketDebug.a(this);
    }

    @Override
    @Nullable
    public EntityLiving e() {
        return this.P();
    }
}

