/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster.piglin;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Dynamic;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagKey;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.RandomSource;
import net.minecraft.util.VisibleForDebug;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.InventorySubcontainer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.ai.BehaviorController;
import net.minecraft.world.entity.ai.attributes.AttributeModifiable;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.monster.EntityCreeper;
import net.minecraft.world.entity.monster.EntityMonster;
import net.minecraft.world.entity.monster.ICrossbow;
import net.minecraft.world.entity.monster.piglin.EntityPiglinAbstract;
import net.minecraft.world.entity.monster.piglin.EntityPiglinArmPose;
import net.minecraft.world.entity.monster.piglin.PiglinAI;
import net.minecraft.world.entity.npc.InventoryCarrier;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemCrossbow;
import net.minecraft.world.item.ItemProjectileWeapon;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;

public class EntityPiglin
extends EntityPiglinAbstract
implements ICrossbow,
InventoryCarrier {
    private static final DataWatcherObject<Boolean> bI = DataWatcher.a(EntityPiglin.class, DataWatcherRegistry.k);
    private static final DataWatcherObject<Boolean> bJ = DataWatcher.a(EntityPiglin.class, DataWatcherRegistry.k);
    private static final DataWatcherObject<Boolean> bK = DataWatcher.a(EntityPiglin.class, DataWatcherRegistry.k);
    private static final MinecraftKey bL = MinecraftKey.b("baby");
    private static final AttributeModifier bM = new AttributeModifier(bL, 0.2f, AttributeModifier.Operation.b);
    private static final int bN = 16;
    private static final float bO = 0.35f;
    private static final int bP = 5;
    private static final float bQ = 0.1f;
    private static final int bR = 3;
    private static final float bS = 0.2f;
    private static final EntitySize bT = EntityTypes.aS.n().a(0.5f).b(0.97f);
    private static final double bU = 0.5;
    private static final boolean bV = false;
    private static final boolean bW = false;
    public final InventorySubcontainer bX = new InventorySubcontainer(8);
    public boolean bY = false;
    protected static final ImmutableList<SensorType<? extends Sensor<? super EntityPiglin>>> d = ImmutableList.of(SensorType.c, SensorType.d, SensorType.b, SensorType.f, SensorType.l);
    protected static final ImmutableList<MemoryModuleType<?>> e = ImmutableList.of(MemoryModuleType.o, MemoryModuleType.w, MemoryModuleType.g, MemoryModuleType.h, MemoryModuleType.k, MemoryModuleType.l, MemoryModuleType.ap, MemoryModuleType.ao, MemoryModuleType.M, MemoryModuleType.aQ, MemoryModuleType.y, MemoryModuleType.z, (Object[])new MemoryModuleType[]{MemoryModuleType.n, MemoryModuleType.F, MemoryModuleType.p, MemoryModuleType.q, MemoryModuleType.r, MemoryModuleType.u, MemoryModuleType.ac, MemoryModuleType.ad, MemoryModuleType.A, MemoryModuleType.ae, MemoryModuleType.af, MemoryModuleType.ah, MemoryModuleType.ag, MemoryModuleType.aj, MemoryModuleType.ak, MemoryModuleType.ai, MemoryModuleType.am, MemoryModuleType.N, MemoryModuleType.as, MemoryModuleType.t, MemoryModuleType.at, MemoryModuleType.au, MemoryModuleType.al, MemoryModuleType.an, MemoryModuleType.av, MemoryModuleType.aw, MemoryModuleType.ax});
    public Set<Item> allowedBarterItems = new HashSet<Item>();
    public Set<Item> interestItems = new HashSet<Item>();
    private static final Codec<Set<Item>> ITEM_SET_CODEC = BuiltInRegistries.g.q().listOf().xmap(HashSet::new, List::copyOf);

    public EntityPiglin(EntityTypes<? extends EntityPiglinAbstract> entityType, World level) {
        super(entityType, level);
        this.bA = 5;
    }

    @Override
    public void b(NBTTagCompound compound) {
        super.b(compound);
        compound.a("IsBaby", this.e_());
        compound.a("CannotHunt", this.bY);
        this.b(compound, this.dX());
        compound.a("Bukkit.BarterList", ITEM_SET_CODEC, this.allowedBarterItems);
        compound.a("Bukkit.InterestList", ITEM_SET_CODEC, this.interestItems);
    }

    @Override
    public void a(NBTTagCompound compound) {
        super.a(compound);
        this.a(compound.b("IsBaby", false));
        this.y(compound.b("CannotHunt", false));
        this.a(compound, this.dX());
        this.allowedBarterItems = compound.a("Bukkit.BarterList", ITEM_SET_CODEC).orElseGet(HashSet::new);
        this.interestItems = compound.a("Bukkit.InterestList", ITEM_SET_CODEC).orElseGet(HashSet::new);
    }

    @Override
    @VisibleForDebug
    public InventorySubcontainer u() {
        return this.bX;
    }

    @Override
    protected void a(WorldServer level, DamageSource damageSource, boolean recentlyHit) {
        EntityCreeper creeper;
        super.a(level, damageSource, recentlyHit);
        Entity entity = damageSource.d();
        if (entity instanceof EntityCreeper && (creeper = (EntityCreeper)entity).gw()) {
            ItemStack itemStack = new ItemStack(Items.vB);
            creeper.gx();
            this.a(level, itemStack);
        }
        this.bX.f().forEach(itemStack1 -> this.a(level, (ItemStack)itemStack1));
    }

    protected ItemStack i(ItemStack stack) {
        return this.bX.b(stack);
    }

    protected boolean j(ItemStack stack) {
        return this.bX.c(stack);
    }

    @Override
    protected void a(DataWatcher.a builder) {
        super.a(builder);
        builder.a(bI, false);
        builder.a(bJ, false);
        builder.a(bK, false);
    }

    @Override
    public void a(DataWatcherObject<?> key) {
        super.a(key);
        if (bI.equals(key)) {
            this.h_();
        }
    }

    public static AttributeProvider.Builder gB() {
        return EntityMonster.gA().a(GenericAttributes.s, 16.0).a(GenericAttributes.v, 0.35f).a(GenericAttributes.c, 5.0);
    }

    public static boolean b(EntityTypes<EntityPiglin> entityType, GeneratorAccess level, EntitySpawnReason spawnReason, BlockPosition pos, RandomSource random) {
        return !level.a_(pos.e()).a(Blocks.lq);
    }

    @Override
    @Nullable
    public GroupDataEntity a(WorldAccess level, DifficultyDamageScaler difficulty, EntitySpawnReason spawnReason, @Nullable GroupDataEntity spawnGroupData) {
        RandomSource random = level.G_();
        if (spawnReason != EntitySpawnReason.d) {
            if (random.i() < 0.2f) {
                this.a(true);
            } else if (this.gv()) {
                this.a(EnumItemSlot.a, this.gD());
            }
        }
        PiglinAI.a(this, level.G_());
        this.a(random, difficulty);
        this.a(level, random, difficulty);
        return super.a(level, difficulty, spawnReason, spawnGroupData);
    }

    @Override
    protected boolean Z() {
        return false;
    }

    @Override
    public boolean h(double distanceToClosestPlayer) {
        return !this.gd();
    }

    @Override
    protected void a(RandomSource random, DifficultyDamageScaler difficulty) {
        if (this.gv()) {
            this.a(EnumItemSlot.f, new ItemStack(Items.qC), random);
            this.a(EnumItemSlot.e, new ItemStack(Items.qD), random);
            this.a(EnumItemSlot.d, new ItemStack(Items.qE), random);
            this.a(EnumItemSlot.c, new ItemStack(Items.qF), random);
        }
    }

    private void a(EnumItemSlot slot, ItemStack stack, RandomSource random) {
        if (random.i() < 0.1f) {
            this.a(slot, stack);
        }
    }

    protected BehaviorController.b<EntityPiglin> ed() {
        return BehaviorController.a(e, d);
    }

    @Override
    protected BehaviorController<?> a(Dynamic<?> dynamic) {
        return PiglinAI.a(this, this.ed().a(dynamic));
    }

    public BehaviorController<EntityPiglin> ec() {
        return super.ec();
    }

    @Override
    public EnumInteractionResult b(EntityHuman player, EnumHand hand) {
        EnumInteractionResult interactionResult = super.b(player, hand);
        if (interactionResult.a()) {
            return interactionResult;
        }
        World world = this.dV();
        if (world instanceof WorldServer) {
            WorldServer serverLevel = (WorldServer)world;
            return PiglinAI.a(serverLevel, this, player, hand);
        }
        boolean flag = PiglinAI.b(this, player.b(hand)) && this.gw() != EntityPiglinArmPose.d;
        return (EnumInteractionResult)((Object)(flag ? EnumInteractionResult.a : EnumInteractionResult.e));
    }

    @Override
    public EntitySize e(EntityPose pose) {
        return this.e_() ? bT : super.e(pose);
    }

    @Override
    public void a(boolean childZombie) {
        this.ar().a(bI, childZombie);
        if (!this.dV().C) {
            AttributeModifiable attribute = this.g(GenericAttributes.v);
            attribute.c(bM.a());
            if (childZombie) {
                attribute.b(bM);
            }
        }
    }

    @Override
    public boolean e_() {
        return this.ar().a(bI);
    }

    private void y(boolean cannotHunt) {
        this.bY = cannotHunt;
    }

    @Override
    protected boolean m() {
        return !this.bY;
    }

    @Override
    protected void a(WorldServer level) {
        GameProfilerFiller profilerFiller = Profiler.a();
        profilerFiller.a("piglinBrain");
        this.ec().a(level, this);
        profilerFiller.c();
        PiglinAI.a(this);
        super.a(level);
    }

    @Override
    protected int e(WorldServer level) {
        return this.bA;
    }

    @Override
    protected void g(WorldServer serverLevel) {
        PiglinAI.a(serverLevel, this);
        this.forceDrops = true;
        this.bX.f().forEach(itemStack -> this.a(serverLevel, (ItemStack)itemStack));
        this.forceDrops = false;
        super.g(serverLevel);
    }

    private ItemStack gD() {
        return (double)this.ae.i() < 0.5 ? new ItemStack(Items.xg) : new ItemStack(Items.pK);
    }

    @Override
    @Nullable
    public TagKey<Item> X() {
        return this.e_() ? null : TagsItem.bW;
    }

    public boolean gE() {
        return this.al.a(bJ);
    }

    @Override
    public void b(boolean isCharging) {
        this.al.a(bJ, isCharging);
    }

    @Override
    public void a() {
        this.bd = 0;
    }

    @Override
    public EntityPiglinArmPose gw() {
        if (this.gC()) {
            return EntityPiglinArmPose.e;
        }
        if (PiglinAI.a(this.fc())) {
            return EntityPiglinArmPose.d;
        }
        if (this.gl() && this.gx()) {
            return EntityPiglinArmPose.a;
        }
        if (this.gE()) {
            return EntityPiglinArmPose.c;
        }
        return this.b(Items.xg) && ItemCrossbow.g(this.dZ()) ? EntityPiglinArmPose.b : EntityPiglinArmPose.f;
    }

    public boolean gC() {
        return this.al.a(bK);
    }

    public void x(boolean dancing) {
        this.al.a(bK, dancing);
    }

    @Override
    public boolean a(WorldServer level, DamageSource damageSource, float amount) {
        Entity entity;
        boolean flag = super.a(level, damageSource, amount);
        if (flag && (entity = damageSource.d()) instanceof EntityLiving) {
            EntityLiving livingEntity = (EntityLiving)entity;
            PiglinAI.a(level, this, livingEntity);
        }
        return flag;
    }

    @Override
    public void a(EntityLiving target, float distanceFactor) {
        this.b(this, 1.6f);
    }

    @Override
    public boolean a(ItemProjectileWeapon projectileWeapon) {
        return projectileWeapon == Items.xg;
    }

    protected void k(ItemStack stack) {
        this.b(EnumItemSlot.a, stack);
    }

    protected void l(ItemStack stack) {
        if (stack.a(PiglinAI.c) || this.allowedBarterItems.contains(stack.h())) {
            this.a(EnumItemSlot.b, stack);
            this.g(EnumItemSlot.b);
        } else {
            this.b(EnumItemSlot.b, stack);
        }
    }

    @Override
    public boolean c(WorldServer level, ItemStack stack) {
        return level.O().c(GameRules.d) && this.fN() && PiglinAI.a(this, stack);
    }

    protected boolean m(ItemStack candidate) {
        EnumItemSlot equipmentSlotForItem = this.f(candidate);
        ItemStack itemBySlot = this.a(equipmentSlotForItem);
        return this.a(candidate, itemBySlot, equipmentSlotForItem);
    }

    @Override
    protected boolean a(ItemStack newItem, ItemStack currentItem, EnumItemSlot slot) {
        if (EnchantmentManager.a(currentItem, EnchantmentEffectComponents.E)) {
            return false;
        }
        TagKey<Item> preferredWeaponType = this.X();
        boolean flag = PiglinAI.isLovedItem(newItem, this) || preferredWeaponType != null && newItem.a(preferredWeaponType);
        boolean flag1 = PiglinAI.isLovedItem(currentItem, this) || preferredWeaponType != null && currentItem.a(preferredWeaponType);
        return flag && !flag1 || (flag || !flag1) && super.a(newItem, currentItem, slot);
    }

    @Override
    protected void a(WorldServer level, EntityItem entity) {
        PiglinAI.a(level, this, entity);
    }

    @Override
    public boolean a(Entity entity, boolean force) {
        if (this.e_() && entity.an() == EntityTypes.ak) {
            entity = this.b(entity, 3);
        }
        return super.a(entity, force);
    }

    private Entity b(Entity vehicle, int maxPosition) {
        List<Entity> passengers = vehicle.cY();
        return maxPosition != 1 && !passengers.isEmpty() ? this.b(passengers.getFirst(), maxPosition - 1) : vehicle;
    }

    @Override
    @Nullable
    public SoundEffect s() {
        return this.dV().C ? null : (SoundEffect)PiglinAI.b(this).orElse(null);
    }

    @Override
    public SoundEffect e(DamageSource damageSource) {
        return SoundEffects.uz;
    }

    @Override
    public SoundEffect j_() {
        return SoundEffects.ux;
    }

    @Override
    protected void b(BlockPosition pos, IBlockData block) {
        this.a(SoundEffects.uB, 0.15f, 1.0f);
    }

    @Override
    protected void gy() {
        this.b(SoundEffects.uC);
    }
}

