/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster.warden;

import com.google.common.annotations.VisibleForTesting;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import io.papermc.paper.event.entity.WardenAngerChangeEvent;
import java.util.Collections;
import java.util.Optional;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleParamBlock;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketDebug;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.resources.RegistryOps;
import net.minecraft.server.level.EntityTrackerEntry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.GameEventTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.util.Unit;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.entity.ai.BehaviorController;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.behavior.warden.SonicBoom;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.navigation.Navigation;
import net.minecraft.world.entity.ai.navigation.NavigationAbstract;
import net.minecraft.world.entity.monster.EntityMonster;
import net.minecraft.world.entity.monster.warden.AngerLevel;
import net.minecraft.world.entity.monster.warden.AngerManagement;
import net.minecraft.world.entity.monster.warden.WardenAi;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.EnumRenderType;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.DynamicGameEventListener;
import net.minecraft.world.level.gameevent.EntityPositionSource;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gameevent.PositionSource;
import net.minecraft.world.level.gameevent.vibrations.VibrationSystem;
import net.minecraft.world.level.pathfinder.PathPoint;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.pathfinder.Pathfinder;
import net.minecraft.world.level.pathfinder.PathfinderNormal;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityPotionEffectEvent;
import org.jetbrains.annotations.Contract;

public class Warden
extends EntityMonster
implements VibrationSystem {
    private static final int bI = 40;
    private static final int bJ = 200;
    private static final int bK = 500;
    private static final float bL = 0.3f;
    private static final float bM = 1.0f;
    private static final float bN = 1.5f;
    private static final int bO = 30;
    private static final int bP = 24;
    private static final DataWatcherObject<Integer> bQ = DataWatcher.a(Warden.class, DataWatcherRegistry.b);
    private static final int bR = 200;
    private static final int bS = 260;
    private static final int bT = 20;
    private static final int bU = 120;
    private static final int bV = 20;
    private static final int bW = 35;
    private static final int bX = 10;
    private static final int bY = 20;
    private static final int bZ = 100;
    private static final int ca = 20;
    private static final int cb = 30;
    private static final float cc = 4.5f;
    private static final float cd = 0.7f;
    private static final int ce = 30;
    private int cf;
    private int cg;
    private int ch;
    private int ci;
    public AnimationState a = new AnimationState();
    public AnimationState b = new AnimationState();
    public AnimationState c = new AnimationState();
    public AnimationState d = new AnimationState();
    public AnimationState e = new AnimationState();
    public AnimationState f = new AnimationState();
    private final DynamicGameEventListener<VibrationSystem.b> cj;
    private final VibrationSystem.d ck;
    private VibrationSystem.a cl;
    AngerManagement cm = new AngerManagement(this::b, Collections.emptyList());

    public Warden(EntityTypes<? extends EntityMonster> entityType, World level) {
        super(entityType, level);
        this.ck = new a();
        this.cl = new VibrationSystem.a();
        this.cj = new DynamicGameEventListener<VibrationSystem.b>(new VibrationSystem.b(this));
        this.bA = 5;
        this.N().a(true);
        this.a(PathType.m, 0.0f);
        this.a(PathType.q, 8.0f);
        this.a(PathType.f, 8.0f);
        this.a(PathType.i, 8.0f);
        this.a(PathType.o, 0.0f);
        this.a(PathType.n, 0.0f);
    }

    @Override
    public Packet<PacketListenerPlayOut> a(EntityTrackerEntry entity) {
        return new PacketPlayOutSpawnEntity((Entity)this, entity, this.c(EntityPose.n) ? 1 : 0);
    }

    @Override
    public void a(PacketPlayOutSpawnEntity packet) {
        super.a(packet);
        if (packet.p() == 1) {
            this.b(EntityPose.n);
        }
    }

    @Override
    public boolean a(IWorldReader level) {
        return super.a(level) && level.a((Entity)this, this.an().n().a(this.dt()));
    }

    @Override
    public float a(BlockPosition pos, IWorldReader level) {
        return 0.0f;
    }

    @Override
    public boolean a(WorldServer level, DamageSource damageSource) {
        return this.gy() && !damageSource.a(DamageTypeTags.d) || super.a(level, damageSource);
    }

    boolean gy() {
        return this.c(EntityPose.o) || this.c(EntityPose.n);
    }

    @Override
    protected boolean o(Entity vehicle) {
        return false;
    }

    @Override
    public float fU() {
        return 5.0f;
    }

    @Override
    protected float aT() {
        return this.X + 0.55f;
    }

    public static AttributeProvider.Builder m() {
        return EntityMonster.gA().a(GenericAttributes.s, 500.0).a(GenericAttributes.v, 0.3f).a(GenericAttributes.p, 1.0).a(GenericAttributes.d, 1.5).a(GenericAttributes.c, 30.0).a(GenericAttributes.m, 24.0);
    }

    @Override
    public boolean bg() {
        return true;
    }

    @Override
    public float fe() {
        return 4.0f;
    }

    @Override
    @Nullable
    public SoundEffect s() {
        return !this.c(EntityPose.l) && !this.gy() ? this.u().b() : null;
    }

    @Override
    public SoundEffect e(DamageSource damageSource) {
        return SoundEffects.CS;
    }

    @Override
    public SoundEffect j_() {
        return SoundEffects.CO;
    }

    @Override
    protected void b(BlockPosition pos, IBlockData state) {
        this.a(SoundEffects.Dc, 10.0f, 1.0f);
    }

    @Override
    public boolean c(WorldServer level, Entity source) {
        level.a((Entity)this, (byte)4);
        this.a(SoundEffects.CN, 10.0f, this.ff());
        SonicBoom.a((EntityLiving)this, 40);
        return super.c(level, source);
    }

    @Override
    protected void a(DataWatcher.a builder) {
        super.a(builder);
        builder.a(bQ, 0);
    }

    public int p() {
        return this.al.a(bQ);
    }

    private void gB() {
        this.al.a(bQ, this.gE());
    }

    @Override
    public void g() {
        World world = this.dV();
        if (world instanceof WorldServer) {
            WorldServer serverLevel = (WorldServer)world;
            VibrationSystem.c.a((World)serverLevel, this.cl, this.ck);
            if (this.gd() || this.Y()) {
                WardenAi.a((EntityLiving)this);
            }
        }
        super.g();
        if (this.dV().A_()) {
            if (this.af % this.gC() == 0) {
                this.ch = 10;
                if (!this.ba()) {
                    this.dV().a(this.dA(), this.dC(), this.dG(), SoundEffects.CR, this.dm(), 5.0f, this.ff(), false);
                }
            }
            this.cg = this.cf;
            if (this.cf > 0) {
                --this.cf;
            }
            this.ci = this.ch;
            if (this.ch > 0) {
                --this.ch;
            }
            switch (this.at()) {
                case n: {
                    this.a(this.c);
                    break;
                }
                case o: {
                    this.a(this.d);
                }
            }
        }
    }

    @Override
    protected void a(WorldServer level) {
        GameProfilerFiller profilerFiller = Profiler.a();
        profilerFiller.a("wardenBrain");
        this.ec().a(level, this);
        profilerFiller.c();
        super.a(level);
        if ((this.af + this.ao()) % 120 == 0) {
            Warden.a(level, this.dt(), this, 20);
        }
        if (this.af % 20 == 0) {
            this.cm.a(level, this::b);
            this.gB();
        }
        WardenAi.a(this);
    }

    @Override
    public void b(byte id) {
        if (id == 4) {
            this.a.a();
            this.e.a(this.af);
        } else if (id == 61) {
            this.cf = 10;
        } else if (id == 62) {
            this.f.a(this.af);
        } else {
            super.b(id);
        }
    }

    private int gC() {
        float f2 = (float)this.p() / (float)AngerLevel.c.a();
        return 40 - MathHelper.d(MathHelper.a(f2, 0.0f, 1.0f) * 30.0f);
    }

    public float J(float partialTick) {
        return MathHelper.h(partialTick, this.cg, this.cf) / 10.0f;
    }

    public float K(float partialTick) {
        return MathHelper.h(partialTick, this.ci, this.ch) / 10.0f;
    }

    private void a(AnimationState animationState) {
        if ((float)animationState.a((float)this.af) < 4500.0f) {
            RandomSource random = this.dY();
            IBlockData blockStateOn = this.bs();
            if (blockStateOn.o() != EnumRenderType.a) {
                for (int i2 = 0; i2 < 30; ++i2) {
                    double d2 = this.dA() + (double)MathHelper.b(random, -0.7f, 0.7f);
                    double y2 = this.dC();
                    double d1 = this.dG() + (double)MathHelper.b(random, -0.7f, 0.7f);
                    this.dV().a(new ParticleParamBlock(Particles.b, blockStateOn), d2, y2, d1, 0.0, 0.0, 0.0);
                }
            }
        }
    }

    @Override
    public void a(DataWatcherObject<?> key) {
        if (Entity.aq.equals(key)) {
            switch (this.at()) {
                case n: {
                    this.c.a(this.af);
                    break;
                }
                case o: {
                    this.d.a(this.af);
                    break;
                }
                case l: {
                    this.a.a(this.af);
                    break;
                }
                case m: {
                    this.b.a(this.af);
                }
            }
        }
        super.a(key);
    }

    @Override
    public boolean a(Explosion explosion) {
        return this.gy();
    }

    @Override
    protected BehaviorController<?> a(Dynamic<?> dynamic) {
        return WardenAi.a(this, dynamic);
    }

    public BehaviorController<Warden> ec() {
        return super.ec();
    }

    @Override
    protected void ab() {
        super.ab();
        PacketDebug.a(this);
    }

    @Override
    public void a(BiConsumer<DynamicGameEventListener<?>, WorldServer> listenerConsumer) {
        World world = this.dV();
        if (world instanceof WorldServer) {
            WorldServer serverLevel = (WorldServer)world;
            listenerConsumer.accept(this.cj, serverLevel);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Contract(value="null->false")
    public boolean b(@Nullable Entity entity) {
        if (!(entity instanceof EntityLiving)) return false;
        EntityLiving livingEntity = (EntityLiving)entity;
        if (this.dV() != entity.dV()) return false;
        if (!IEntitySelector.e.test(entity)) return false;
        if (this.s(entity)) return false;
        if (livingEntity.an() == EntityTypes.g) return false;
        if (livingEntity.an() == EntityTypes.bH) return false;
        if (livingEntity.cC()) return false;
        if (livingEntity.eH()) return false;
        if (!this.dV().E_().a(livingEntity.cR())) return false;
        return true;
    }

    public static void a(WorldServer level, Vec3D pos, @Nullable Entity source, int radius) {
        MobEffect mobEffectInstance = new MobEffect(MobEffects.G, 260, 0, false, false);
        MobEffectUtil.addEffectToPlayersAround(level, source, pos, radius, mobEffectInstance, 200, EntityPotionEffectEvent.Cause.WARDEN);
    }

    @Override
    public void b(NBTTagCompound compound) {
        super.b(compound);
        RegistryOps<NBTBase> registryOps = this.dX().a(DynamicOpsNBT.a);
        compound.a("anger", AngerManagement.a(this::b), registryOps, this.cm);
        compound.a("listener", VibrationSystem.a.a, registryOps, this.cl);
    }

    @Override
    public void a(NBTTagCompound compound) {
        super.a(compound);
        RegistryOps<NBTBase> registryOps = this.dX().a(DynamicOpsNBT.a);
        this.cm = compound.a("anger", AngerManagement.a(this::b), (DynamicOps<NBTBase>)registryOps).orElseGet(() -> new AngerManagement(this::b, Collections.emptyList()));
        this.gB();
        this.cl = compound.a("listener", VibrationSystem.a.a, (DynamicOps<NBTBase>)registryOps).orElseGet(VibrationSystem.a::new);
    }

    private void gD() {
        if (!this.c(EntityPose.l)) {
            this.a(this.u().c(), 10.0f, this.ff());
        }
    }

    public AngerLevel u() {
        return AngerLevel.a(this.gE());
    }

    private int gE() {
        return this.cm.b(this.e());
    }

    public void c(Entity entity) {
        this.cm.a(entity);
    }

    public void d(@Nullable Entity entity) {
        this.a(entity, 35, true);
    }

    @VisibleForTesting
    public void a(@Nullable Entity entity, int offset, boolean playListeningSound) {
        if (!this.gj() && this.b(entity)) {
            int activeAnger = this.cm.b(entity);
            WardenAngerChangeEvent event = new WardenAngerChangeEvent((org.bukkit.entity.Warden)this.getBukkitEntity(), (org.bukkit.entity.Entity)entity.getBukkitEntity(), activeAnger, Math.min(150, activeAnger + offset));
            this.dV().getCraftServer().getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                return;
            }
            offset = event.getNewAnger() - activeAnger;
            WardenAi.a((EntityLiving)this);
            boolean flag = !(this.e() instanceof EntityHuman);
            int i2 = this.cm.a(entity, offset);
            if (entity instanceof EntityHuman && flag && AngerLevel.a(i2).d()) {
                this.ec().b(MemoryModuleType.p);
            }
            if (playListeningSound) {
                this.gD();
            }
        }
    }

    public Optional<EntityLiving> gu() {
        return this.u().d() ? this.cm.a() : Optional.empty();
    }

    @Override
    @Nullable
    public EntityLiving e() {
        return this.P();
    }

    @Override
    public boolean h(double distanceToClosestPlayer) {
        return false;
    }

    @Override
    @Nullable
    public GroupDataEntity a(WorldAccess level, DifficultyDamageScaler difficulty, EntitySpawnReason spawnReason, @Nullable GroupDataEntity spawnGroupData) {
        this.ec().a(MemoryModuleType.aF, Unit.a, 1200L);
        if (spawnReason == EntitySpawnReason.k) {
            this.b(EntityPose.n);
            this.ec().a(MemoryModuleType.aD, Unit.a, WardenAi.a);
            this.a(SoundEffects.CK, 5.0f, 1.0f);
        }
        return super.a(level, difficulty, spawnReason, spawnGroupData);
    }

    @Override
    public boolean a(WorldServer level, DamageSource damageSource, float amount) {
        boolean flag = super.a(level, damageSource, amount);
        if (!this.gj() && !this.gy()) {
            Entity entity = damageSource.d();
            this.a(entity, AngerLevel.c.a() + 20, false);
            if (this.bs.c(MemoryModuleType.p).isEmpty() && entity instanceof EntityLiving) {
                EntityLiving livingEntity = (EntityLiving)entity;
                if (damageSource.b() || this.a((Entity)livingEntity, 5.0)) {
                    this.i(livingEntity);
                }
            }
        }
        return flag;
    }

    public void i(EntityLiving attackTarget) {
        this.ec().b(MemoryModuleType.az);
        this.ec().a(MemoryModuleType.p, attackTarget);
        this.ec().b(MemoryModuleType.F);
        SonicBoom.a((EntityLiving)this, 200);
    }

    @Override
    public EntitySize e(EntityPose pose) {
        EntitySize entityDimensions = super.e(pose);
        return this.gy() ? EntitySize.c(entityDimensions.a(), 1.0f) : entityDimensions;
    }

    @Override
    public boolean bG() {
        return !this.gy() && super.bG();
    }

    @Override
    protected void D(Entity entity) {
        if (!this.gj() && !this.ec().a(MemoryModuleType.aI)) {
            this.ec().a(MemoryModuleType.aI, Unit.a, 20L);
            this.d(entity);
            WardenAi.a(this, entity.dv());
        }
        super.D(entity);
    }

    @VisibleForTesting
    public AngerManagement gv() {
        return this.cm;
    }

    @Override
    protected NavigationAbstract b(World level) {
        return new Navigation(this, this, level){

            @Override
            protected Pathfinder a(int maxVisitedNodes) {
                this.o = new PathfinderNormal();
                return new Pathfinder(this, this.o, maxVisitedNodes){

                    @Override
                    protected float a(PathPoint first, PathPoint second) {
                        return first.b(second);
                    }
                };
            }
        };
    }

    @Override
    public VibrationSystem.a gw() {
        return this.cl;
    }

    @Override
    public VibrationSystem.d gx() {
        return this.ck;
    }

    class a
    implements VibrationSystem.d {
        private static final int b = 16;
        private final PositionSource c;

        a() {
            this.c = new EntityPositionSource(Warden.this, Warden.this.cS());
        }

        @Override
        public int a() {
            return 16;
        }

        @Override
        public PositionSource b() {
            return this.c;
        }

        @Override
        public TagKey<GameEvent> c() {
            return GameEventTags.b;
        }

        @Override
        public boolean d() {
            return true;
        }

        @Override
        public boolean a(WorldServer level, BlockPosition pos, Holder<GameEvent> gameEvent, GameEvent.a context) {
            EntityLiving livingEntity;
            Entity entity;
            return !Warden.this.gj() && !Warden.this.eH() && !Warden.this.ec().a(MemoryModuleType.aJ) && !Warden.this.gy() && level.E_().a(pos) && (!((entity = context.a()) instanceof EntityLiving) || Warden.this.b((Entity)(livingEntity = (EntityLiving)entity)));
        }

        @Override
        public void a(WorldServer level, BlockPosition pos, Holder<GameEvent> gameEvent, @Nullable Entity entity, @Nullable Entity playerEntity, float distance) {
            if (!Warden.this.eH()) {
                Warden.this.bs.a(MemoryModuleType.aJ, Unit.a, 40L);
                level.a((Entity)Warden.this, (byte)61);
                Warden.this.a(SoundEffects.Dd, 5.0f, Warden.this.ff());
                BlockPosition blockPos = pos;
                if (playerEntity != null) {
                    if (Warden.this.a(playerEntity, 30.0)) {
                        if (Warden.this.ec().a(MemoryModuleType.aB)) {
                            if (Warden.this.b(playerEntity)) {
                                blockPos = playerEntity.dv();
                            }
                            Warden.this.d(playerEntity);
                        } else {
                            Warden.this.a(playerEntity, 10, true);
                        }
                    }
                    Warden.this.ec().a(MemoryModuleType.aB, Unit.a, 100L);
                } else {
                    Warden.this.d(entity);
                }
                if (!Warden.this.u().d()) {
                    Optional<EntityLiving> activeEntity = Warden.this.cm.a();
                    if (playerEntity != null || activeEntity.isEmpty() || activeEntity.get() == entity) {
                        WardenAi.a(Warden.this, blockPos);
                    }
                }
            }
        }
    }
}

