/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.npc;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Dynamic;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiPredicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.Particles;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.game.PacketDebug;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.stats.StatisticList;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.MathHelper;
import net.minecraft.util.SpawnUtil;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.InventorySubcontainer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.ConversionParams;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityExperienceOrb;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLightning;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.ReputationHandler;
import net.minecraft.world.entity.ai.BehaviorController;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.behavior.BehaviorControl;
import net.minecraft.world.entity.ai.behavior.Behaviors;
import net.minecraft.world.entity.ai.gossip.Reputation;
import net.minecraft.world.entity.ai.gossip.ReputationType;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.NearestVisibleLivingEntities;
import net.minecraft.world.entity.ai.navigation.Navigation;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorGolemLastSeen;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.ai.village.ReputationEvent;
import net.minecraft.world.entity.ai.village.poi.PoiTypes;
import net.minecraft.world.entity.ai.village.poi.VillagePlace;
import net.minecraft.world.entity.ai.village.poi.VillagePlaceType;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.monster.EntityWitch;
import net.minecraft.world.entity.npc.EntityVillagerAbstract;
import net.minecraft.world.entity.npc.InventoryCarrier;
import net.minecraft.world.entity.npc.VillagerData;
import net.minecraft.world.entity.npc.VillagerDataHolder;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.entity.npc.VillagerType;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.raid.Raid;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.entity.schedule.Schedule;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.trading.MerchantRecipeList;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.phys.AxisAlignedBB;
import org.bukkit.craftbukkit.v1_21_R4.event.CraftEventFactory;
import org.bukkit.entity.AbstractVillager;
import org.bukkit.entity.ExperienceOrb;
import org.bukkit.entity.Villager;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityPotionEffectEvent;
import org.bukkit.event.entity.EntityTransformEvent;
import org.bukkit.event.entity.VillagerReplenishTradeEvent;
import org.bukkit.inventory.MerchantRecipe;
import org.slf4j.Logger;
import org.spigotmc.SpigotConfig;

public class EntityVillager
extends EntityVillagerAbstract
implements ReputationHandler,
VillagerDataHolder {
    private static final Logger bO = LogUtils.getLogger();
    private static final DataWatcherObject<VillagerData> bP = DataWatcher.a(EntityVillager.class, DataWatcherRegistry.u);
    public static final int bK = 12;
    public static final Map<Item, Integer> bL = ImmutableMap.of((Object)Items.ql, (Object)4, (Object)Items.vq, (Object)1, (Object)Items.vp, (Object)1, (Object)Items.wv, (Object)1);
    private static final int bQ = 2;
    private static final int bR = 10;
    private static final int bS = 1200;
    private static final int bT = 24000;
    private static final int bU = 10;
    private static final int bV = 5;
    private static final long bW = 24000L;
    @VisibleForTesting
    public static final float bM = 0.5f;
    private static final int bX = 0;
    private static final byte bY = 0;
    private static final int bZ = 0;
    private static final int ca = 0;
    private static final int cb = 0;
    private static final boolean cc = false;
    private int cd;
    private boolean ce;
    @Nullable
    private EntityHuman cf;
    private boolean cg;
    private int ch = 0;
    private final Reputation ci = new Reputation();
    private long cj;
    private long ck = 0L;
    private int cl = 0;
    private long cm = 0L;
    public int cn = 0;
    private long cq;
    private boolean cr = false;
    private static final ImmutableList<MemoryModuleType<?>> cs = ImmutableList.of(MemoryModuleType.b, MemoryModuleType.c, MemoryModuleType.d, MemoryModuleType.e, MemoryModuleType.g, MemoryModuleType.h, MemoryModuleType.i, MemoryModuleType.j, MemoryModuleType.k, MemoryModuleType.l, MemoryModuleType.M, MemoryModuleType.aQ, (Object[])new MemoryModuleType[]{MemoryModuleType.n, MemoryModuleType.o, MemoryModuleType.r, MemoryModuleType.s, MemoryModuleType.u, MemoryModuleType.w, MemoryModuleType.x, MemoryModuleType.y, MemoryModuleType.z, MemoryModuleType.B, MemoryModuleType.f, MemoryModuleType.D, MemoryModuleType.E, MemoryModuleType.F, MemoryModuleType.I, MemoryModuleType.J, MemoryModuleType.K, MemoryModuleType.G});
    private static final ImmutableList<SensorType<? extends Sensor<? super EntityVillager>>> ct = ImmutableList.of(SensorType.c, SensorType.d, SensorType.b, SensorType.e, SensorType.f, SensorType.g, SensorType.h, SensorType.i, SensorType.j);
    public static final Map<MemoryModuleType<GlobalPos>, BiPredicate<EntityVillager, Holder<VillagePlaceType>>> bN = ImmutableMap.of(MemoryModuleType.b, (villager, poiType) -> poiType.a(PoiTypes.n), MemoryModuleType.c, (villager, poiType) -> villager.gF().b().a().b().test((Holder<VillagePlaceType>)poiType), MemoryModuleType.d, (villager, poiType) -> VillagerProfession.a.test((Holder<VillagePlaceType>)poiType), MemoryModuleType.e, (villager, poiType) -> poiType.a(PoiTypes.o));

    public EntityVillager(EntityTypes<? extends EntityVillager> entityType, World level) {
        this(entityType, level, VillagerType.c);
    }

    public EntityVillager(EntityTypes<? extends EntityVillager> entityType, World level, ResourceKey<VillagerType> villagerType) {
        this(entityType, level, level.J_().d(villagerType));
    }

    public EntityVillager(EntityTypes<? extends EntityVillager> entityType, World level, Holder<VillagerType> villagerType) {
        super((EntityTypes<? extends EntityVillagerAbstract>)entityType, level);
        ((Navigation)this.N()).b(true);
        this.N().a(true);
        this.N().a(48.0f);
        this.a_(true);
        this.a(this.gF().a(villagerType).b(level.J_(), VillagerProfession.b));
    }

    public BehaviorController<EntityVillager> ec() {
        return super.ec();
    }

    protected BehaviorController.b<EntityVillager> ed() {
        return BehaviorController.a(cs, ct);
    }

    @Override
    protected BehaviorController<?> a(Dynamic<?> dynamic) {
        BehaviorController<EntityVillager> brain = this.ed().a(dynamic);
        this.a(brain);
        return brain;
    }

    public void g(WorldServer serverLevel) {
        BehaviorController<EntityVillager> brain = this.ec();
        brain.b(serverLevel, this);
        this.bs = brain.i();
        this.a(this.ec());
    }

    private void a(BehaviorController<EntityVillager> villagerBrain) {
        Holder<VillagerProfession> holder = this.gF().b();
        if (this.e_()) {
            villagerBrain.a(Schedule.e);
            villagerBrain.a(Activity.d, Behaviors.a(0.5f));
        } else {
            villagerBrain.a(Schedule.f);
            villagerBrain.a(Activity.c, (ImmutableList<Pair<Integer, BehaviorControl<EntityVillager>>>)Behaviors.b(holder, 0.5f), (Set<Pair<MemoryModuleType<?>, MemoryStatus>>)ImmutableSet.of((Object)Pair.of(MemoryModuleType.c, (Object)((Object)MemoryStatus.a))));
        }
        villagerBrain.a(Activity.a, Behaviors.a(holder, 0.5f));
        villagerBrain.a(Activity.f, (ImmutableList<Pair<Integer, BehaviorControl<EntityVillager>>>)Behaviors.d(holder, 0.5f), (Set<Pair<MemoryModuleType<?>, MemoryStatus>>)ImmutableSet.of((Object)Pair.of(MemoryModuleType.e, (Object)((Object)MemoryStatus.a))));
        villagerBrain.a(Activity.e, Behaviors.c(holder, 0.5f));
        villagerBrain.a(Activity.b, Behaviors.e(holder, 0.5f));
        villagerBrain.a(Activity.g, Behaviors.f(holder, 0.5f));
        villagerBrain.a(Activity.i, Behaviors.g(holder, 0.5f));
        villagerBrain.a(Activity.h, Behaviors.h(holder, 0.5f));
        villagerBrain.a(Activity.j, Behaviors.i(holder, 0.5f));
        villagerBrain.a((Set<Activity>)ImmutableSet.of((Object)Activity.a));
        villagerBrain.b(Activity.b);
        villagerBrain.a(Activity.b);
        villagerBrain.a(this.dV().af(), this.dV().ae());
    }

    @Override
    protected void h() {
        super.h();
        if (this.dV() instanceof WorldServer) {
            this.g((WorldServer)this.dV());
        }
    }

    public static AttributeProvider.Builder gD() {
        return EntityInsentient.D().a(GenericAttributes.v, 0.5);
    }

    public boolean gE() {
        return this.cr;
    }

    @Override
    public void inactiveTick() {
        if (this.m() > 0) {
            this.r(this.m() - 1);
        }
        if (this.dj()) {
            if (this.dV().spigotConfig.tickInactiveVillagers) {
                this.a(this.dV().getMinecraftWorld());
            } else {
                this.customServerAiStep(this.dV().getMinecraftWorld(), true);
            }
        }
        this.hd();
        super.inactiveTick();
    }

    @Override
    protected void a(WorldServer level) {
        this.customServerAiStep(level, false);
    }

    protected void customServerAiStep(WorldServer level, boolean inactive) {
        Raid raidAt;
        GameProfilerFiller profilerFiller = Profiler.a();
        profilerFiller.a("villagerBrain");
        if (!inactive) {
            this.ec().a(level, this);
        }
        profilerFiller.c();
        if (this.cr) {
            this.cr = false;
        }
        if (!this.gv() && this.cd > 0) {
            --this.cd;
            if (this.cd <= 0) {
                if (this.ce) {
                    this.hb();
                    this.ce = false;
                }
                this.addEffect(new MobEffect(MobEffects.j, 200, 0), EntityPotionEffectEvent.Cause.VILLAGER_TRADE);
            }
        }
        if (this.cf != null) {
            level.a(ReputationEvent.e, (Entity)this.cf, this);
            level.a((Entity)this, (byte)14);
            this.cf = null;
        }
        if (!inactive && !this.gj() && this.ae.a(100) == 0 && (raidAt = level.d(this.dv())) != null && raidAt.r() && !raidAt.a()) {
            level.a((Entity)this, (byte)42);
        }
        if (this.gF().b().a(VillagerProfession.b) && this.gv()) {
            this.gA();
        }
        if (inactive) {
            return;
        }
        super.a(level);
    }

    @Override
    public void g() {
        super.g();
        if (this.m() > 0) {
            this.r(this.m() - 1);
        }
        this.hd();
    }

    @Override
    public EnumInteractionResult b(EntityHuman player, EnumHand hand) {
        ItemStack itemInHand = player.b(hand);
        if (itemInHand.a(Items.uR) || !this.bJ() || this.gv() || this.fR()) {
            return super.b(player, hand);
        }
        if (this.e_()) {
            this.gQ();
            return EnumInteractionResult.a;
        }
        if (!this.dV().C) {
            boolean isEmpty = this.gw().isEmpty();
            if (hand == EnumHand.a) {
                if (isEmpty) {
                    this.gQ();
                }
                player.a(StatisticList.S);
            }
            if (isEmpty) {
                return EnumInteractionResult.c;
            }
            this.g(player);
        }
        return EnumInteractionResult.a;
    }

    public void gQ() {
        this.r(40);
        if (!this.dV().A_()) {
            this.b(SoundEffects.Ca);
        }
    }

    private void g(EntityHuman player) {
        this.h(player);
        this.a(player);
        this.a(player, this.P_(), this.gF().c());
    }

    @Override
    public void a(@Nullable EntityHuman player) {
        boolean flag = this.gu() != null && player == null;
        super.a(player);
        if (flag) {
            this.gA();
        }
    }

    @Override
    protected void gA() {
        super.gA();
        this.gR();
    }

    private void gR() {
        if (!this.dV().A_()) {
            for (net.minecraft.world.item.trading.MerchantRecipe merchantOffer : this.gw()) {
                merchantOffer.n();
            }
        }
    }

    @Override
    public boolean gG() {
        return true;
    }

    public void gH() {
        this.gW();
        for (net.minecraft.world.item.trading.MerchantRecipe merchantOffer : this.gw()) {
            VillagerReplenishTradeEvent event = new VillagerReplenishTradeEvent((AbstractVillager)((Villager)this.getBukkitEntity()), (MerchantRecipe)merchantOffer.asBukkit());
            if (!event.callEvent()) continue;
            merchantOffer.j();
        }
        this.gS();
        this.cm = this.dV().ae();
        ++this.cn;
    }

    private void gS() {
        MerchantRecipeList offers = this.gw();
        EntityHuman tradingPlayer = this.gu();
        if (tradingPlayer != null && !offers.isEmpty()) {
            tradingPlayer.a(tradingPlayer.bR.l, offers, this.gF().c(), this.p(), this.gx(), this.gG());
        }
    }

    private boolean gT() {
        for (net.minecraft.world.item.trading.MerchantRecipe merchantOffer : this.gw()) {
            if (!merchantOffer.t()) continue;
            return true;
        }
        return false;
    }

    private boolean gU() {
        return this.cn == 0 || this.cn < 2 && this.dV().ae() > this.cm + 2400L;
    }

    public boolean gI() {
        long l2 = this.cm + 12000L;
        long gameTime = this.dV().ae();
        boolean flag = gameTime > l2;
        long dayTime = this.dV().af();
        if (this.cq > 0L) {
            long l22 = dayTime / 24000L;
            long l1 = this.cq / 24000L;
            flag |= l22 > l1;
        }
        this.cq = dayTime;
        if (flag) {
            this.cm = gameTime;
            this.he();
        }
        return this.gU() && this.gT();
    }

    private void gV() {
        int i2 = 2 - this.cn;
        if (i2 > 0) {
            for (net.minecraft.world.item.trading.MerchantRecipe merchantOffer : this.gw()) {
                VillagerReplenishTradeEvent event = new VillagerReplenishTradeEvent((AbstractVillager)((Villager)this.getBukkitEntity()), (MerchantRecipe)merchantOffer.asBukkit());
                if (!event.callEvent()) continue;
                merchantOffer.j();
            }
        }
        for (int i1 = 0; i1 < i2; ++i1) {
            this.gW();
        }
        this.gS();
    }

    private void gW() {
        for (net.minecraft.world.item.trading.MerchantRecipe merchantOffer : this.gw()) {
            merchantOffer.g();
        }
    }

    private void h(EntityHuman player) {
        int playerReputation = this.f(player);
        if (playerReputation != 0) {
            for (net.minecraft.world.item.trading.MerchantRecipe merchantOffer : this.gw()) {
                if (merchantOffer.ignoreDiscounts) continue;
                merchantOffer.a(-MathHelper.d((float)playerReputation * merchantOffer.p()));
            }
        }
        if (player.b(MobEffects.F)) {
            MobEffect effect = player.c(MobEffects.F);
            int amplifier = effect.e();
            for (net.minecraft.world.item.trading.MerchantRecipe merchantOffer1 : this.gw()) {
                if (merchantOffer1.ignoreDiscounts) continue;
                double d2 = 0.3 + 0.0625 * (double)amplifier;
                int i2 = (int)Math.floor(d2 * (double)merchantOffer1.a().M());
                merchantOffer1.a(-Math.max(i2, 1));
            }
        }
    }

    @Override
    protected void a(DataWatcher.a builder) {
        super.a(builder);
        builder.a(bP, EntityVillager.gJ());
    }

    public static VillagerData gJ() {
        return new VillagerData(BuiltInRegistries.w.b(VillagerType.c), BuiltInRegistries.x.b(VillagerProfession.b), 1);
    }

    @Override
    public void b(NBTTagCompound compound) {
        super.b(compound);
        compound.a("VillagerData", VillagerData.c, this.gF());
        compound.a("FoodLevel", (byte)this.ch);
        compound.a("Gossips", Reputation.a, this.ci);
        compound.a("Xp", this.cl);
        compound.a("LastRestock", this.cm);
        compound.a("LastGossipDecay", this.ck);
        compound.a("RestocksToday", this.cn);
        if (this.cr) {
            compound.a("AssignProfessionWhenSpawned", true);
        }
    }

    @Override
    public void a(NBTTagCompound compound) {
        super.a(compound);
        this.al.a(bP, compound.a("VillagerData", VillagerData.c).orElseGet(EntityVillager::gJ));
        this.ch = compound.b("FoodLevel", (byte)0);
        this.ci.c();
        compound.a("Gossips", Reputation.a).ifPresent(this.ci::a);
        this.cl = compound.b("Xp", 0);
        this.cm = compound.b("LastRestock", 0L);
        this.ck = compound.b("LastGossipDecay", 0L);
        if (this.dV() instanceof WorldServer) {
            this.g((WorldServer)this.dV());
        }
        this.cn = compound.b("RestocksToday", 0);
        this.cr = compound.b("AssignProfessionWhenSpawned", false);
    }

    @Override
    public boolean h(double distanceToClosestPlayer) {
        return false;
    }

    @Override
    @Nullable
    public SoundEffect s() {
        if (this.fR()) {
            return null;
        }
        return this.gv() ? SoundEffects.Cb : SoundEffects.BW;
    }

    @Override
    public SoundEffect e(DamageSource damageSource) {
        return SoundEffects.BZ;
    }

    @Override
    public SoundEffect j_() {
        return SoundEffects.BY;
    }

    public void gK() {
        this.b(this.gF().b().a().f());
    }

    @Override
    public void a(VillagerData data) {
        VillagerData villagerData = this.gF();
        if (!villagerData.b().equals(data.b())) {
            this.bJ = null;
        }
        this.al.a(bP, data);
    }

    @Override
    public VillagerData gF() {
        return this.al.a(bP);
    }

    @Override
    protected void b(net.minecraft.world.item.trading.MerchantRecipe offer) {
        int i2 = 3 + this.ae.a(4);
        this.cl += offer.q();
        this.cf = this.gu();
        if (this.ha()) {
            this.cd = 40;
            this.ce = true;
            i2 += 5;
        }
        if (offer.u()) {
            this.dV().b(new EntityExperienceOrb(this.dV(), this.dA(), this.dC() + 0.5, this.dG(), i2, ExperienceOrb.SpawnReason.VILLAGER_TRADE, this.gu(), this));
        }
    }

    @Override
    public void a(@Nullable EntityLiving livingBase) {
        if (livingBase != null && this.dV() instanceof WorldServer) {
            ((WorldServer)this.dV()).a(ReputationEvent.c, (Entity)livingBase, this);
            if (this.bJ() && livingBase instanceof EntityHuman) {
                this.dV().a((Entity)this, (byte)13);
            }
        }
        super.a(livingBase);
    }

    @Override
    public void a(DamageSource cause) {
        Entity entity;
        if (SpigotConfig.logVillagerDeaths) {
            bO.info("Villager {} died, message: '{}'", (Object)this, (Object)cause.a(this).getString());
        }
        if ((entity = cause.d()) != null) {
            this.b(entity);
        }
        this.gX();
        super.a(cause);
    }

    public void gX() {
        this.a(MemoryModuleType.b);
        this.a(MemoryModuleType.c);
        this.a(MemoryModuleType.d);
        this.a(MemoryModuleType.e);
    }

    private void b(Entity murderer) {
        World world = this.dV();
        if (world instanceof WorldServer) {
            WorldServer serverLevel = (WorldServer)world;
            Optional<NearestVisibleLivingEntities> memory = this.bs.c(MemoryModuleType.h);
            if (!memory.isEmpty()) {
                memory.get().b(ReputationHandler.class::isInstance).forEach(entity -> serverLevel.a(ReputationEvent.d, murderer, (ReputationHandler)((Object)entity)));
            }
        }
    }

    public void a(MemoryModuleType<GlobalPos> moduleType) {
        if (this.dV() instanceof WorldServer) {
            MinecraftServer server = ((WorldServer)this.dV()).p();
            this.bs.c(moduleType).ifPresent(pos -> {
                WorldServer level = server.a(pos.a());
                if (level != null) {
                    VillagePlace poiManager = level.A();
                    Optional<Holder<VillagePlaceType>> type = poiManager.c(pos.b());
                    BiPredicate<EntityVillager, Holder<VillagePlaceType>> biPredicate = bN.get(moduleType);
                    if (type.isPresent() && biPredicate.test(this, type.get())) {
                        poiManager.b(pos.b());
                        PacketDebug.c(level, pos.b());
                    }
                }
            });
        }
    }

    @Override
    public boolean X_() {
        return this.ch + this.hc() >= 12 && !this.fR() && this.Y_() == 0;
    }

    private boolean gY() {
        return this.ch < 12;
    }

    private void gZ() {
        if (this.gY() && this.hc() != 0) {
            for (int i2 = 0; i2 < this.u().b(); ++i2) {
                int count;
                Integer integer;
                ItemStack item = this.u().a(i2);
                if (item.f() || (integer = bL.get(item.h())) == null) continue;
                for (int i1 = count = item.M(); i1 > 0; --i1) {
                    this.ch += integer.intValue();
                    this.u().a(i2, 1);
                    if (this.gY()) continue;
                    return;
                }
            }
        }
    }

    public int f(EntityHuman player) {
        return this.ci.a(player.cG(), (ReputationType type) -> true);
    }

    private void u(int qty) {
        this.ch -= qty;
    }

    public void gL() {
        this.gZ();
        this.u(12);
    }

    public void b(MerchantRecipeList offers) {
        this.bJ = offers;
    }

    private boolean ha() {
        int level = this.gF().c();
        return VillagerData.d(level) && this.cl >= VillagerData.c(level);
    }

    public void hb() {
        this.a(this.gF().a(this.gF().c() + 1));
        this.gB();
    }

    @Override
    protected IChatBaseComponent cz() {
        return this.gF().b().a().a();
    }

    @Override
    public void b(byte id) {
        if (id == 12) {
            this.a(Particles.S);
        } else if (id == 13) {
            this.a(Particles.a);
        } else if (id == 14) {
            this.a(Particles.Q);
        } else if (id == 42) {
            this.a(Particles.ap);
        } else {
            super.b(id);
        }
    }

    @Override
    @Nullable
    public GroupDataEntity a(WorldAccess level, DifficultyDamageScaler difficulty, EntitySpawnReason spawnReason, @Nullable GroupDataEntity spawnGroupData) {
        if (spawnReason == EntitySpawnReason.e) {
            this.a(this.gF().b(level.J_(), VillagerProfession.b));
        }
        if (spawnReason == EntitySpawnReason.n || spawnReason == EntitySpawnReason.m || EntitySpawnReason.a(spawnReason) || spawnReason == EntitySpawnReason.o) {
            this.a(this.gF().a(level.J_(), VillagerType.a(level.u(this.dv()))));
        }
        if (spawnReason == EntitySpawnReason.d) {
            this.cr = true;
        }
        return super.a(level, difficulty, spawnReason, spawnGroupData);
    }

    @Nullable
    public EntityVillager b(WorldServer level, EntityAgeable otherParent) {
        double randomDouble = this.ae.j();
        Holder<VillagerType> orThrow = randomDouble < 0.5 ? level.J_().d(VillagerType.a(level.u(this.dv()))) : (randomDouble < 0.75 ? this.gF().a() : ((EntityVillager)otherParent).gF().a());
        EntityVillager villager = new EntityVillager(EntityTypes.bE, (World)level, orThrow);
        villager.a((WorldAccess)level, level.d_(villager.dv()), EntitySpawnReason.e, null);
        return villager;
    }

    @Override
    public void a(WorldServer level, EntityLightning lightning) {
        if (level.an() != EnumDifficulty.a) {
            EntityWitch witch = this.convertTo(EntityTypes.bJ, ConversionParams.a(this, false, false), (T witch1) -> {
                if (CraftEventFactory.callEntityZapEvent(this, lightning, witch1).isCancelled()) {
                    return false;
                }
                if (SpigotConfig.logVillagerDeaths) {
                    bO.info("Villager {} was struck by lightning {}.", (Object)this, (Object)lightning);
                }
                witch1.a((WorldAccess)level, level.d_(witch1.dv()), EntitySpawnReason.i, null);
                witch1.gc();
                this.gX();
                return true;
            }, EntityTransformEvent.TransformReason.LIGHTNING, CreatureSpawnEvent.SpawnReason.LIGHTNING);
            if (witch == null) {
                super.a(level, lightning);
            }
        } else {
            super.a(level, lightning);
        }
    }

    @Override
    protected void a(WorldServer level, EntityItem entity) {
        InventoryCarrier.a(level, this, this, entity);
    }

    @Override
    public boolean c(WorldServer level, ItemStack stack) {
        Item item = stack.h();
        return (stack.a(TagsItem.bP) || this.gF().b().a().d().contains((Object)item)) && this.u().c(stack);
    }

    public boolean gM() {
        return this.hc() >= 24;
    }

    public boolean gN() {
        return this.hc() < 12;
    }

    private int hc() {
        InventorySubcontainer inventory = this.u();
        return bL.entrySet().stream().mapToInt(entry -> inventory.a_((Item)entry.getKey()) * (Integer)entry.getValue()).sum();
    }

    public boolean gO() {
        return this.u().a_((ItemStack stack) -> stack.a(TagsItem.bO));
    }

    @Override
    protected void gB() {
        this.updateTrades(2);
    }

    public boolean updateTrades(int amount) {
        VillagerTrades.IMerchantRecipeOption[] itemListings;
        Int2ObjectMap<VillagerTrades.IMerchantRecipeOption[]> map;
        Int2ObjectMap<VillagerTrades.IMerchantRecipeOption[]> map1;
        VillagerData villagerData = this.gF();
        ResourceKey resourceKey = villagerData.b().e().orElse(null);
        if (resourceKey != null && (map1 = this.dV().K().b(FeatureFlags.b) ? ((map = VillagerTrades.c.get(resourceKey)) != null ? map : VillagerTrades.a.get(resourceKey)) : VillagerTrades.a.get(resourceKey)) != null && !map1.isEmpty() && (itemListings = (VillagerTrades.IMerchantRecipeOption[])map1.get(villagerData.c())) != null) {
            MerchantRecipeList offers = this.gw();
            this.a(offers, itemListings, amount);
            return true;
        }
        return false;
    }

    public void a(WorldServer serverLevel, EntityVillager target, long gameTime) {
        if (!(gameTime >= this.cj && gameTime < this.cj + 1200L || gameTime >= target.cj && gameTime < target.cj + 1200L)) {
            this.ci.a(target.ci, this.ae, 10);
            this.cj = gameTime;
            target.cj = gameTime;
            this.a(serverLevel, gameTime, 5);
        }
    }

    private void hd() {
        long gameTime = this.dV().ae();
        if (this.ck == 0L) {
            this.ck = gameTime;
        } else if (gameTime >= this.ck + 24000L) {
            this.ci.b();
            this.ck = gameTime;
        }
    }

    public void a(WorldServer serverLevel, long gameTime, int minVillagerAmount) {
        AxisAlignedBB aabb;
        List<EntityVillager> entitiesOfClass;
        List<EntityVillager> list;
        if (this.a(gameTime) && (list = (entitiesOfClass = serverLevel.a(EntityVillager.class, aabb = this.cR().c(10.0, 10.0, 10.0))).stream().filter(villager -> villager.a(gameTime)).limit(5L).toList()).size() >= minVillagerAmount && SpawnUtil.trySpawnMob(EntityTypes.aq, EntitySpawnReason.f, serverLevel, this.dv(), 10, 8, 6, SpawnUtil.a.a, false, CreatureSpawnEvent.SpawnReason.VILLAGE_DEFENSE, () -> SensorGolemLastSeen.b(this)).isPresent()) {
            entitiesOfClass.forEach(SensorGolemLastSeen::b);
        }
    }

    public boolean a(long gameTime) {
        return this.b(this.dV().ae()) && !this.bs.a(MemoryModuleType.G);
    }

    @Override
    public void a(ReputationEvent type, Entity target) {
        if (type == ReputationEvent.a) {
            this.ci.a(target.cG(), ReputationType.d, 20);
            this.ci.a(target.cG(), ReputationType.c, 25);
        } else if (type == ReputationEvent.e) {
            this.ci.a(target.cG(), ReputationType.e, 2);
        } else if (type == ReputationEvent.c) {
            this.ci.a(target.cG(), ReputationType.b, 25);
        } else if (type == ReputationEvent.d) {
            this.ci.a(target.cG(), ReputationType.a, 25);
        }
    }

    @Override
    public int p() {
        return this.cl;
    }

    public void t(int villagerXp) {
        this.cl = villagerXp;
    }

    private void he() {
        this.gV();
        this.cn = 0;
    }

    public Reputation gP() {
        return this.ci;
    }

    public void a(Reputation gossips) {
        this.ci.a(gossips);
    }

    @Override
    protected void ab() {
        super.ab();
        PacketDebug.a(this);
    }

    @Override
    public void b(BlockPosition pos) {
        super.b(pos);
        this.bs.a(MemoryModuleType.I, Long.valueOf(this.dV().ae()));
        this.bs.b(MemoryModuleType.n);
        this.bs.b(MemoryModuleType.F);
    }

    @Override
    public void fS() {
        super.fS();
        this.bs.a(MemoryModuleType.J, Long.valueOf(this.dV().ae()));
    }

    private boolean b(long gameTime) {
        Optional<Long> memory = this.bs.c(MemoryModuleType.I);
        return memory.filter(lastSlept -> gameTime - lastSlept < 24000L).isPresent();
    }

    @Override
    @Nullable
    public <T> T a(DataComponentType<? extends T> component) {
        return component == DataComponents.av ? EntityVillager.c(component, this.gF().a()) : super.a(component);
    }

    @Override
    protected void a(DataComponentGetter componentGetter) {
        this.a(componentGetter, DataComponents.av);
        super.a(componentGetter);
    }

    @Override
    protected <T> boolean b(DataComponentType<T> component, T value) {
        if (component == DataComponents.av) {
            Holder<VillagerType> holder = EntityVillager.c(DataComponents.av, value);
            this.a(this.gF().a(holder));
            return true;
        }
        return super.b(component, value);
    }
}

