/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.npc;

import com.google.common.collect.Lists;
import com.mojang.serialization.DynamicOps;
import io.papermc.paper.event.player.PlayerPurchaseEvent;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.core.particles.ParticleParam;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.MathHelper;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.InventorySubcontainer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.npc.InventoryCarrier;
import net.minecraft.world.entity.npc.NPC;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.trading.IMerchant;
import net.minecraft.world.item.trading.MerchantRecipe;
import net.minecraft.world.item.trading.MerchantRecipeList;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.portal.TeleportTransition;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_21_R4.entity.CraftAbstractVillager;
import org.bukkit.craftbukkit.v1_21_R4.inventory.CraftMerchant;
import org.bukkit.craftbukkit.v1_21_R4.inventory.CraftMerchantRecipe;
import org.bukkit.entity.AbstractVillager;
import org.bukkit.event.entity.VillagerAcquireTradeEvent;

public abstract class EntityVillagerAbstract
extends EntityAgeable
implements InventoryCarrier,
NPC,
IMerchant {
    private static final DataWatcherObject<Integer> bK = DataWatcher.a(EntityVillagerAbstract.class, DataWatcherRegistry.b);
    public static final int bI = 300;
    private static final int bL = 8;
    @Nullable
    private EntityHuman bM;
    @Nullable
    protected MerchantRecipeList bJ;
    private final InventorySubcontainer bN = new InventorySubcontainer(8, (CraftAbstractVillager)this.getBukkitEntity());

    public EntityVillagerAbstract(EntityTypes<? extends EntityVillagerAbstract> entityType, World level) {
        super((EntityTypes<? extends EntityAgeable>)entityType, level);
        this.a(PathType.n, 16.0f);
        this.a(PathType.o, -1.0f);
    }

    @Override
    public GroupDataEntity a(WorldAccess level, DifficultyDamageScaler difficulty, EntitySpawnReason spawnReason, @Nullable GroupDataEntity spawnGroupData) {
        if (spawnGroupData == null) {
            spawnGroupData = new EntityAgeable.a(false);
        }
        return super.a(level, difficulty, spawnReason, spawnGroupData);
    }

    public int m() {
        return this.al.a(bK);
    }

    public void r(int unhappyCounter) {
        this.al.a(bK, unhappyCounter);
    }

    @Override
    public int p() {
        return 0;
    }

    @Override
    protected void a(DataWatcher.a builder) {
        super.a(builder);
        builder.a(bK, 0);
    }

    @Override
    public void a(@Nullable EntityHuman player) {
        this.bM = player;
    }

    @Override
    @Nullable
    public EntityHuman gu() {
        return this.bM;
    }

    public boolean gv() {
        return this.bM != null;
    }

    @Override
    public CraftMerchant getCraftMerchant() {
        return (CraftAbstractVillager)this.getBukkitEntity();
    }

    public void resetOffers() {
        this.bJ = new MerchantRecipeList();
        this.gB();
    }

    @Override
    public MerchantRecipeList gw() {
        if (this.dV().C) {
            throw new IllegalStateException("Cannot load Villager offers on the client");
        }
        if (this.bJ == null) {
            this.bJ = new MerchantRecipeList();
            this.gB();
        }
        return this.bJ;
    }

    @Override
    public void a(@Nullable MerchantRecipeList offers) {
    }

    @Override
    public void s(int xp) {
    }

    @Override
    public void processTrade(MerchantRecipe offer, @Nullable PlayerPurchaseEvent event) {
        if (event == null || event.willIncreaseTradeUses()) {
            offer.l();
        }
        if (event == null || event.isRewardingExp()) {
            this.b(offer);
        }
        this.a(offer);
    }

    @Override
    public void a(MerchantRecipe offer) {
        this.bz = -this.R();
        if (this.bM instanceof EntityPlayer) {
            CriterionTriggers.t.a((EntityPlayer)this.bM, this, offer.f());
        }
    }

    protected abstract void b(MerchantRecipe var1);

    @Override
    public boolean gx() {
        return true;
    }

    @Override
    public void i(ItemStack stack) {
        if (!this.dV().C && this.bz > -this.R() + 20) {
            this.bz = -this.R();
            this.b(this.w(!stack.f()));
        }
    }

    @Override
    public SoundEffect gy() {
        return SoundEffects.Cc;
    }

    protected SoundEffect w(boolean isYesSound) {
        return isYesSound ? SoundEffects.Cc : SoundEffects.Ca;
    }

    public void gz() {
        this.b(SoundEffects.BX);
    }

    @Override
    public void b(NBTTagCompound compound) {
        MerchantRecipeList offers;
        super.b(compound);
        if (!this.dV().C && !(offers = this.gw()).isEmpty()) {
            compound.a("Offers", MerchantRecipeList.a, this.dX().a(DynamicOpsNBT.a), offers);
        }
        this.b(compound, this.dX());
    }

    @Override
    public void a(NBTTagCompound compound) {
        super.a(compound);
        this.bJ = compound.a("Offers", MerchantRecipeList.a, (DynamicOps<NBTBase>)this.dX().a(DynamicOpsNBT.a)).orElse(null);
        this.a(compound, this.dX());
    }

    @Override
    @Nullable
    public Entity b(TeleportTransition teleportTransition) {
        this.gA();
        return super.b(teleportTransition);
    }

    protected void gA() {
        this.a((EntityHuman)null);
    }

    @Override
    public void a(DamageSource cause) {
        super.a(cause);
        this.gA();
    }

    protected void a(ParticleParam particleOption) {
        for (int i2 = 0; i2 < 5; ++i2) {
            double d2 = this.ae.k() * 0.02;
            double d1 = this.ae.k() * 0.02;
            double d22 = this.ae.k() * 0.02;
            this.dV().a(particleOption, this.d(1.0), this.dD() + 1.0, this.g(1.0), d2, d1, d22);
        }
    }

    @Override
    public boolean w() {
        return false;
    }

    @Override
    public InventorySubcontainer u() {
        return this.bN;
    }

    @Override
    public SlotAccess a_(int slot) {
        int i2 = slot - 300;
        return i2 >= 0 && i2 < this.bN.b() ? SlotAccess.a(this.bN, i2) : super.a_(slot);
    }

    protected abstract void gB();

    protected void a(MerchantRecipeList givenMerchantOffers, VillagerTrades.IMerchantRecipeOption[] newTrades, int maxNumbers) {
        ArrayList list = Lists.newArrayList((Object[])newTrades);
        int i2 = 0;
        while (i2 < maxNumbers && !list.isEmpty()) {
            MerchantRecipe offer = ((VillagerTrades.IMerchantRecipeOption)list.remove(this.ae.a(list.size()))).a(this, this.ae);
            if (offer == null) continue;
            VillagerAcquireTradeEvent event = new VillagerAcquireTradeEvent((AbstractVillager)this.getBukkitEntity(), (org.bukkit.inventory.MerchantRecipe)offer.asBukkit());
            if (this.valid) {
                event.callEvent();
            }
            if (!event.isCancelled()) {
                CraftMerchantRecipe craftMerchantRecipe = CraftMerchantRecipe.fromBukkit(event.getRecipe());
                if (craftMerchantRecipe.getIngredients().isEmpty()) {
                    return;
                }
                givenMerchantOffers.add(craftMerchantRecipe.toMinecraft());
            }
            ++i2;
        }
    }

    @Override
    public Vec3D v(float partialTicks) {
        float f2 = MathHelper.h(partialTicks, this.aW, this.aV) * ((float)Math.PI / 180);
        Vec3D vec3 = new Vec3D(0.0, this.cR().c() - 1.0, 0.2);
        return this.p(partialTicks).e(vec3.b(-f2));
    }

    @Override
    public boolean gC() {
        return this.dV().C;
    }

    @Override
    public boolean e(EntityHuman player) {
        return this.gu() == player && this.bJ() && player.b((Entity)this, 4.0);
    }
}

