/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.npc;

import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.stats.StatisticList;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityExperienceOrb;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.goal.PathfinderGoalAvoidTarget;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalInteract;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtTradingPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalMoveTowardsRestriction;
import net.minecraft.world.entity.ai.goal.PathfinderGoalPanic;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStrollLand;
import net.minecraft.world.entity.ai.goal.PathfinderGoalTradeWithPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalUseItem;
import net.minecraft.world.entity.monster.EntityEvoker;
import net.minecraft.world.entity.monster.EntityIllagerIllusioner;
import net.minecraft.world.entity.monster.EntityPillager;
import net.minecraft.world.entity.monster.EntityVex;
import net.minecraft.world.entity.monster.EntityVindicator;
import net.minecraft.world.entity.monster.EntityZoglin;
import net.minecraft.world.entity.monster.EntityZombie;
import net.minecraft.world.entity.npc.EntityVillagerAbstract;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.component.Consumable;
import net.minecraft.world.item.trading.MerchantRecipe;
import net.minecraft.world.item.trading.MerchantRecipeList;
import net.minecraft.world.level.World;
import net.minecraft.world.phys.Vec3D;
import org.apache.commons.lang3.tuple.Pair;
import org.bukkit.entity.ExperienceOrb;
import org.bukkit.event.entity.EntityRemoveEvent;

public class EntityVillagerTrader
extends EntityVillagerAbstract
implements Consumable.b {
    private static final int bK = 0;
    @Nullable
    private BlockPosition bL;
    private int bM = 0;
    public boolean canDrinkPotion = true;
    public boolean canDrinkMilk = true;

    public EntityVillagerTrader(EntityTypes<? extends EntityVillagerTrader> entityType, World level) {
        super((EntityTypes<? extends EntityVillagerAbstract>)entityType, level);
    }

    @Override
    protected void C() {
        this.bF.a(0, new PathfinderGoalFloat(this));
        this.bF.a(0, new PathfinderGoalUseItem<EntityVillagerTrader>(this, PotionContents.a(Items.tt, Potions.g), SoundEffects.CC, wanderingTrader -> this.canDrinkPotion && this.dV().W() && !wanderingTrader.co()));
        this.bF.a(0, new PathfinderGoalUseItem<EntityVillagerTrader>(this, new ItemStack(Items.ru), SoundEffects.CH, wanderingTrader -> this.canDrinkMilk && this.dV().V() && wanderingTrader.co()));
        this.bF.a(1, new PathfinderGoalTradeWithPlayer(this));
        this.bF.a(1, new PathfinderGoalAvoidTarget<EntityZombie>(this, EntityZombie.class, 8.0f, 0.5, 0.5));
        this.bF.a(1, new PathfinderGoalAvoidTarget<EntityEvoker>(this, EntityEvoker.class, 12.0f, 0.5, 0.5));
        this.bF.a(1, new PathfinderGoalAvoidTarget<EntityVindicator>(this, EntityVindicator.class, 8.0f, 0.5, 0.5));
        this.bF.a(1, new PathfinderGoalAvoidTarget<EntityVex>(this, EntityVex.class, 8.0f, 0.5, 0.5));
        this.bF.a(1, new PathfinderGoalAvoidTarget<EntityPillager>(this, EntityPillager.class, 15.0f, 0.5, 0.5));
        this.bF.a(1, new PathfinderGoalAvoidTarget<EntityIllagerIllusioner>(this, EntityIllagerIllusioner.class, 12.0f, 0.5, 0.5));
        this.bF.a(1, new PathfinderGoalAvoidTarget<EntityZoglin>(this, EntityZoglin.class, 10.0f, 0.5, 0.5));
        this.bF.a(1, new PathfinderGoalPanic(this, 0.5));
        this.bF.a(1, new PathfinderGoalLookAtTradingPlayer(this));
        this.bF.a(2, new a(this, 2.0, 0.35));
        this.bF.a(4, new PathfinderGoalMoveTowardsRestriction(this, 0.35));
        this.bF.a(8, new PathfinderGoalRandomStrollLand(this, 0.35));
        this.bF.a(9, new PathfinderGoalInteract(this, EntityHuman.class, 3.0f, 1.0f));
        this.bF.a(10, new PathfinderGoalLookAtPlayer(this, EntityInsentient.class, 8.0f));
    }

    @Override
    @Nullable
    public EntityAgeable a(WorldServer level, EntityAgeable otherParent) {
        return null;
    }

    @Override
    public boolean gx() {
        return false;
    }

    @Override
    public EnumInteractionResult b(EntityHuman player, EnumHand hand) {
        ItemStack itemInHand = player.b(hand);
        if (!itemInHand.a(Items.uR) && this.bJ() && !this.gv() && !this.e_()) {
            if (hand == EnumHand.a) {
                player.a(StatisticList.S);
            }
            if (!this.dV().C) {
                if (this.gw().isEmpty()) {
                    return EnumInteractionResult.c;
                }
                this.a(player);
                this.a(player, this.P_(), 1);
            }
            return EnumInteractionResult.a;
        }
        return super.b(player, hand);
    }

    @Override
    protected void gB() {
        MerchantRecipeList offers = this.gw();
        for (Pair<VillagerTrades.IMerchantRecipeOption[], Integer> pair : VillagerTrades.b) {
            VillagerTrades.IMerchantRecipeOption[] itemListings = (VillagerTrades.IMerchantRecipeOption[])pair.getLeft();
            this.a(offers, itemListings, (int)((Integer)pair.getRight()));
        }
    }

    @Override
    public void b(NBTTagCompound compound) {
        super.b(compound);
        compound.a("DespawnDelay", this.bM);
        compound.b("wander_target", BlockPosition.a, this.bL);
    }

    @Override
    public void a(NBTTagCompound compound) {
        super.a(compound);
        this.bM = compound.b("DespawnDelay", 0);
        this.bL = compound.a("wander_target", BlockPosition.a).orElse(null);
        this.c_(Math.max(0, this.Y_()));
    }

    @Override
    public boolean h(double distanceToClosestPlayer) {
        return false;
    }

    @Override
    protected void b(MerchantRecipe offer) {
        if (offer.u()) {
            int i2 = 3 + this.ae.a(4);
            this.dV().b(new EntityExperienceOrb(this.dV(), this.dA(), this.dC() + 0.5, this.dG(), i2, ExperienceOrb.SpawnReason.VILLAGER_TRADE, this.gu(), this));
        }
    }

    @Override
    public SoundEffect s() {
        return this.gv() ? SoundEffects.CI : SoundEffects.CA;
    }

    @Override
    public SoundEffect e(DamageSource damageSource) {
        return SoundEffects.CF;
    }

    @Override
    public SoundEffect j_() {
        return SoundEffects.CB;
    }

    @Override
    public SoundEffect j(ItemStack stack) {
        return stack.a(Items.ru) ? SoundEffects.CD : SoundEffects.CE;
    }

    @Override
    protected SoundEffect w(boolean getYesSound) {
        return getYesSound ? SoundEffects.CJ : SoundEffects.CG;
    }

    @Override
    public SoundEffect gy() {
        return SoundEffects.CJ;
    }

    public void t(int despawnDelay) {
        this.bM = despawnDelay;
    }

    public int gD() {
        return this.bM;
    }

    @Override
    public void d_() {
        super.d_();
        if (!this.dV().C) {
            this.gE();
        }
    }

    private void gE() {
        if (this.bM > 0 && !this.gv() && --this.bM == 0) {
            this.discard(EntityRemoveEvent.Cause.DESPAWN);
        }
    }

    public void h(@Nullable BlockPosition wanderTarget) {
        this.bL = wanderTarget;
    }

    @Nullable
    public BlockPosition gF() {
        return this.bL;
    }

    class a
    extends PathfinderGoal {
        final EntityVillagerTrader a;
        final double b;
        final double c;

        a(EntityVillagerTrader trader, double stopDistance, double speedModifier) {
            this.a = trader;
            this.b = stopDistance;
            this.c = speedModifier;
            this.a(EnumSet.of(PathfinderGoal.Type.a));
        }

        @Override
        public void e() {
            this.a.h((BlockPosition)null);
            EntityVillagerTrader.this.bE.m();
        }

        @Override
        public boolean b() {
            BlockPosition wanderTarget = this.a.gF();
            return wanderTarget != null && this.a(wanderTarget, this.b);
        }

        @Override
        public void a() {
            BlockPosition wanderTarget = this.a.gF();
            if (wanderTarget != null && EntityVillagerTrader.this.bE.k()) {
                if (this.a(wanderTarget, 10.0)) {
                    Vec3D vec3 = new Vec3D((double)wanderTarget.u() - this.a.dA(), (double)wanderTarget.v() - this.a.dC(), (double)wanderTarget.w() - this.a.dG()).d();
                    Vec3D vec31 = vec3.c(10.0).b(this.a.dA(), this.a.dC(), this.a.dG());
                    EntityVillagerTrader.this.bE.a(vec31.d, vec31.e, vec31.f, this.c);
                } else {
                    EntityVillagerTrader.this.bE.a((double)wanderTarget.u(), (double)wanderTarget.v(), (double)wanderTarget.w(), this.c);
                }
            }
        }

        private boolean a(BlockPosition pos, double distance) {
            return !pos.a(this.a.dt(), distance);
        }
    }
}

