/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.player;

import com.destroystokyo.paper.event.player.PlayerReadyArrowEvent;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.math.IntMath;
import com.mojang.authlib.GameProfile;
import com.mojang.datafixers.util.Either;
import io.papermc.paper.event.entity.EntityKnockbackEvent;
import io.papermc.paper.event.player.PlayerClientLoadedWorldEvent;
import io.papermc.paper.event.player.PlayerDeepSleepEvent;
import io.papermc.paper.event.player.PrePlayerAttackEntityEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.kyori.adventure.util.TriState;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.Particles;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.chat.ChatClickable;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.network.protocol.game.PacketPlayOutEntityVelocity;
import net.minecraft.network.protocol.game.PacketPlayOutNamedSoundEffect;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.stats.Statistic;
import net.minecraft.stats.StatisticList;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsEntity;
import net.minecraft.tags.TagsFluid;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Unit;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.IInventory;
import net.minecraft.world.ITileInventory;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAttachment;
import net.minecraft.world.entity.EntityAttachments;
import net.minecraft.world.entity.EntityEquipment;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTameableAnimal;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.EnumMainHand;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.animal.EntityParrot;
import net.minecraft.world.entity.animal.horse.EntityHorseAbstract;
import net.minecraft.world.entity.boss.EntityComplexPart;
import net.minecraft.world.entity.decoration.EntityArmorStand;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.monster.warden.WardenSpawnTracker;
import net.minecraft.world.entity.player.PlayerAbilities;
import net.minecraft.world.entity.player.PlayerEquipment;
import net.minecraft.world.entity.player.PlayerInventory;
import net.minecraft.world.entity.player.PlayerModelPart;
import net.minecraft.world.entity.projectile.EntityFishingHook;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.entity.projectile.ProjectileDeflection;
import net.minecraft.world.food.FoodMetaData;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Container;
import net.minecraft.world.inventory.ContainerPlayer;
import net.minecraft.world.inventory.InventoryEnderChest;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemCooldown;
import net.minecraft.world.item.ItemProjectileWeapon;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.BlocksAttacks;
import net.minecraft.world.item.crafting.IRecipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.item.equipment.Equippable;
import net.minecraft.world.item.trading.MerchantRecipeList;
import net.minecraft.world.level.CommandBlockListenerAbstract;
import net.minecraft.world.level.EnumGamemode;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.entity.TestBlockEntity;
import net.minecraft.world.level.block.entity.TestInstanceBlockEntity;
import net.minecraft.world.level.block.entity.TileEntityCommand;
import net.minecraft.world.level.block.entity.TileEntityJigsaw;
import net.minecraft.world.level.block.entity.TileEntitySign;
import net.minecraft.world.level.block.entity.TileEntityStructure;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.pattern.ShapeDetectorBlock;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.scores.Scoreboard;
import net.minecraft.world.scores.ScoreboardTeam;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.bukkit.OfflinePlayer;
import org.bukkit.craftbukkit.v1_21_R4.entity.CraftHumanEntity;
import org.bukkit.craftbukkit.v1_21_R4.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_21_R4.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_21_R4.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_21_R4.util.CraftVector;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityExhaustionEvent;
import org.bukkit.event.entity.EntityPotionEffectEvent;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.player.PlayerVelocityEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.scoreboard.Team;
import org.bukkit.util.Vector;

public abstract class EntityHuman
extends EntityLiving {
    public static final EnumMainHand bu = EnumMainHand.b;
    public static final int bv = 0;
    public static final int bw = 20;
    public static final int bx = 100;
    public static final int by = 10;
    public static final int bz = 200;
    public static final int bA = 499;
    public static final int bB = 500;
    public static final float bC = 4.5f;
    public static final float bD = 3.0f;
    public static final float bE = 1.5f;
    public static final float bF = 0.6f;
    public static final float bG = 0.6f;
    public static final float bH = 1.62f;
    private static final int a = 40;
    public static final Vec3D bI = new Vec3D(0.0, 0.6, 0.0);
    public static final EntitySize bJ = EntitySize.b(0.6f, 1.8f).b(1.62f).a(EntityAttachments.a().a(EntityAttachment.b, bI));
    private static final Map<EntityPose, EntitySize> b = ImmutableMap.builder().put((Object)EntityPose.a, (Object)bJ).put((Object)EntityPose.c, (Object)EntityLiving.aD).put((Object)EntityPose.b, (Object)EntitySize.b(0.6f, 0.6f).b(0.4f)).put((Object)EntityPose.d, (Object)EntitySize.b(0.6f, 0.6f).b(0.4f)).put((Object)EntityPose.e, (Object)EntitySize.b(0.6f, 0.6f).b(0.4f)).put((Object)EntityPose.f, (Object)EntitySize.b(0.6f, 1.5f).b(1.27f).a(EntityAttachments.a().a(EntityAttachment.b, bI))).put((Object)EntityPose.h, (Object)EntitySize.c(0.2f, 0.2f).b(1.62f)).build();
    private static final DataWatcherObject<Float> c = DataWatcher.a(EntityHuman.class, DataWatcherRegistry.d);
    private static final DataWatcherObject<Integer> d = DataWatcher.a(EntityHuman.class, DataWatcherRegistry.b);
    public static final DataWatcherObject<Byte> bK = DataWatcher.a(EntityHuman.class, DataWatcherRegistry.a);
    protected static final DataWatcherObject<Byte> bL = DataWatcher.a(EntityHuman.class, DataWatcherRegistry.a);
    protected static final DataWatcherObject<NBTTagCompound> bM = DataWatcher.a(EntityHuman.class, DataWatcherRegistry.t);
    protected static final DataWatcherObject<NBTTagCompound> bN = DataWatcher.a(EntityHuman.class, DataWatcherRegistry.t);
    public static final int bO = 60;
    private static final short e = 0;
    private static final float f = 0.0f;
    private static final int g = 0;
    private static final int h = 0;
    private static final int i = 0;
    private static final int j = 0;
    private static final int k = 0;
    private static final boolean cq = false;
    private static final int cr = 0;
    private long cs;
    final PlayerInventory ct;
    protected InventoryEnderChest bP = new InventoryEnderChest(this);
    public final ContainerPlayer bQ;
    public Container bR;
    protected FoodMetaData bS = new FoodMetaData();
    protected int bT;
    private boolean cu = false;
    protected int bU = 60;
    public float bV;
    public float bW;
    public int bX;
    public double bY;
    public double bZ;
    public double ca;
    public double cb;
    public double cc;
    public double cd;
    public int cv = 0;
    protected boolean ce;
    private final PlayerAbilities cw = new PlayerAbilities();
    public int cf = 0;
    public int cg = 0;
    public float ch = 0.0f;
    public int ci = 0;
    protected final float cj = 0.02f;
    private int cx;
    public GameProfile cy;
    private boolean cz;
    private net.minecraft.world.item.ItemStack cA = net.minecraft.world.item.ItemStack.l;
    private final ItemCooldown cB = this.f();
    private Optional<GlobalPos> cC = Optional.empty();
    @Nullable
    public EntityFishingHook ck;
    public float cl;
    @Nullable
    public Vec3D cm;
    @Nullable
    public Entity cn;
    private boolean cD = false;
    private int cE = 0;
    public boolean affectsSpawning = true;
    public TriState flyingFallDamage = TriState.NOT_SET;
    public boolean fauxSleeping;
    public int oldLevel = -1;

    @Override
    public CraftHumanEntity getBukkitEntity() {
        return (CraftHumanEntity)super.getBukkitEntity();
    }

    public EntityHuman(World level, BlockPosition pos, float yRot, GameProfile gameProfile) {
        super((EntityTypes<? extends EntityLiving>)EntityTypes.bT, level);
        this.a_(gameProfile.getId());
        this.cy = gameProfile;
        this.ct = new PlayerInventory(this, this.bt);
        this.bQ = new ContainerPlayer(this.ct, !level.C, this);
        this.bR = this.bQ;
        this.b((double)pos.u() + 0.5, pos.v() + 1, (double)pos.w() + 0.5, yRot, 0.0f);
    }

    @Override
    protected EntityEquipment eb() {
        return new PlayerEquipment(this);
    }

    public boolean a(World level, BlockPosition pos, EnumGamemode gameMode) {
        if (!gameMode.f()) {
            return false;
        }
        if (gameMode == EnumGamemode.d) {
            return true;
        }
        if (this.gw()) {
            return false;
        }
        net.minecraft.world.item.ItemStack mainHandItem = this.fb();
        return mainHandItem.f() || !mainHandItem.b(new ShapeDetectorBlock(level, pos, false));
    }

    public static AttributeProvider.Builder fX() {
        return EntityLiving.ee().a(GenericAttributes.c, 1.0).a(GenericAttributes.v, 0.1f).a(GenericAttributes.e).a(GenericAttributes.q).a(GenericAttributes.g, 4.5).a(GenericAttributes.j, 3.0).a(GenericAttributes.f).a(GenericAttributes.C).a(GenericAttributes.z).a(GenericAttributes.t).a(GenericAttributes.D);
    }

    @Override
    protected void a(DataWatcher.a builder) {
        super.a(builder);
        builder.a(c, Float.valueOf(0.0f));
        builder.a(d, 0);
        builder.a(bK, (byte)0);
        builder.a(bL, (byte)bu.b());
        builder.a(bM, new NBTTagCompound());
        builder.a(bN, new NBTTagCompound());
    }

    @Override
    public void g() {
        this.ad = this.ak();
        if (this.ak() || this.bY()) {
            this.d(false);
        }
        if (this.bX > 0) {
            --this.bX;
        }
        if (this.fR()) {
            ++this.cv;
            if (this.cv == 100 && !new PlayerDeepSleepEvent((Player)this.getBukkitEntity()).callEvent()) {
                this.cv = Integer.MIN_VALUE;
            }
            if (this.cv > 100) {
                this.cv = 100;
            }
            if (!this.dV().C && this.dV().V()) {
                this.a(false, true);
            }
        } else if (this.cv > 0) {
            ++this.cv;
            if (this.cv >= 110) {
                this.cv = 0;
            }
        }
        this.gb();
        super.g();
        if (!this.dV().C && this.bR != null && !this.bR.b(this)) {
            this.closeContainer(InventoryCloseEvent.Reason.CANT_USE);
            this.bR = this.bQ;
        }
        this.s();
        EntityHuman entityHuman = this;
        if (entityHuman instanceof EntityPlayer) {
            EntityPlayer serverPlayer = (EntityPlayer)entityHuman;
            this.bS.a(serverPlayer);
            this.a(StatisticList.k);
            this.a(StatisticList.l);
            if (this.bJ()) {
                this.a(StatisticList.m);
            }
            if (this.cf()) {
                this.a(StatisticList.o);
            }
            if (!this.fR()) {
                this.a(StatisticList.n);
            }
        }
        int i2 = 29999999;
        double d2 = MathHelper.a(this.dA(), -2.9999999E7, 2.9999999E7);
        double d1 = MathHelper.a(this.dG(), -2.9999999E7, 2.9999999E7);
        if (d2 != this.dA() || d1 != this.dG()) {
            this.a_(d2, this.dC(), d1);
        }
        ++this.aS;
        net.minecraft.world.item.ItemStack mainHandItem = this.fb();
        if (!net.minecraft.world.item.ItemStack.a(this.cA, mainHandItem)) {
            if (!net.minecraft.world.item.ItemStack.b(this.cA, mainHandItem)) {
                this.gF();
            }
            this.cA = mainHandItem.v();
        }
        if (!((Entity)this).a(TagsFluid.a) && this.c(Items.pc)) {
            this.m();
        }
        this.cB.a();
        this.gc();
        if (this.cE > 0) {
            --this.cE;
        }
    }

    @Override
    protected float fp() {
        return this.fG() ? 15.0f : super.fp();
    }

    public boolean fY() {
        return this.cc();
    }

    protected boolean fZ() {
        return this.cc();
    }

    protected boolean ga() {
        return this.cc();
    }

    protected boolean gb() {
        this.ce = ((Entity)this).a(TagsFluid.a);
        return this.ce;
    }

    @Override
    public void a(boolean downwards, BlockPosition pos) {
        if (!this.gk().b) {
            super.a(downwards, pos);
        }
    }

    @Override
    public void l(boolean downwards) {
        if (!this.gk().b) {
            super.l(downwards);
        }
    }

    private void m() {
        this.addEffect(new MobEffect(MobEffects.m, 200, 0, false, false, true), EntityPotionEffectEvent.Cause.TURTLE_HELMET);
    }

    private boolean c(Item item) {
        for (EnumItemSlot equipmentSlot : EnumItemSlot.j) {
            net.minecraft.world.item.ItemStack itemBySlot = this.a(equipmentSlot);
            Equippable equippable = itemBySlot.a(DataComponents.D);
            if (!itemBySlot.a(item) || equippable == null || equippable.b() != equipmentSlot) continue;
            return true;
        }
        return false;
    }

    protected ItemCooldown f() {
        return new ItemCooldown();
    }

    private void s() {
        this.bY = this.cb;
        this.bZ = this.cc;
        this.ca = this.cd;
        double d2 = this.dA() - this.cb;
        double d1 = this.dC() - this.cc;
        double d22 = this.dG() - this.cd;
        double d3 = 10.0;
        if (d2 > 10.0) {
            this.bY = this.cb = this.dA();
        }
        if (d22 > 10.0) {
            this.ca = this.cd = this.dG();
        }
        if (d1 > 10.0) {
            this.bZ = this.cc = this.dC();
        }
        if (d2 < -10.0) {
            this.bY = this.cb = this.dA();
        }
        if (d22 < -10.0) {
            this.ca = this.cd = this.dG();
        }
        if (d1 < -10.0) {
            this.bZ = this.cc = this.dC();
        }
        this.cb += d2 * 0.25;
        this.cd += d22 * 0.25;
        this.cc += d1 * 0.25;
    }

    protected void gc() {
        if (this.h(EntityPose.d)) {
            EntityPose desiredPose = this.u();
            EntityPose pose = this.ak() || this.bY() || this.h(desiredPose) ? desiredPose : (this.h(EntityPose.f) ? EntityPose.f : EntityPose.d);
            this.b(pose);
        }
    }

    private EntityPose u() {
        if (this.fR()) {
            return EntityPose.c;
        }
        if (this.cj()) {
            return EntityPose.d;
        }
        if (this.fJ()) {
            return EntityPose.b;
        }
        if (this.fv()) {
            return EntityPose.e;
        }
        return this.cc() && !this.cw.b ? EntityPose.f : EntityPose.a;
    }

    protected boolean h(EntityPose pose) {
        return this.dV().a((Entity)this, this.a(pose).a(this.dt()).h(1.0E-7));
    }

    @Override
    public SoundEffect aU() {
        return SoundEffects.vi;
    }

    @Override
    public SoundEffect aV() {
        return SoundEffects.vg;
    }

    @Override
    public SoundEffect aW() {
        return SoundEffects.vh;
    }

    @Override
    public int bW() {
        return 10;
    }

    @Override
    public void a(SoundEffect sound, float volume, float pitch) {
        this.dV().a((Entity)this, this.dA(), this.dC(), this.dG(), sound, this.dm(), volume, pitch);
    }

    public void a(SoundEffect sound, SoundCategory source, float volume, float pitch) {
    }

    @Override
    public SoundCategory dm() {
        return SoundCategory.h;
    }

    @Override
    public int dn() {
        return 20;
    }

    @Override
    public void b(byte id) {
        if (id == 9) {
            this.v();
        } else if (id == 23) {
            this.cz = false;
        } else if (id == 22) {
            this.cz = true;
        } else {
            super.b(id);
        }
    }

    public void closeContainer(InventoryCloseEvent.Reason reason) {
        this.o();
        this.bR = this.bQ;
    }

    public void closeUnloadedInventory(InventoryCloseEvent.Reason reason) {
        this.bR = this.bQ;
    }

    public void o() {
        this.bR = this.bQ;
    }

    protected void p() {
    }

    @Override
    public void q() {
        if (!this.dV().C && this.fZ() && this.bY()) {
            this.bO();
            if (!this.bY()) {
                this.g(false);
                return;
            }
        }
        super.q();
        this.bV = this.bW;
        this.bW = 0.0f;
    }

    @Override
    public void d_() {
        if (this.bT > 0) {
            --this.bT;
        }
        this.i();
        this.ct.l();
        this.bV = this.bW;
        if (this.cw.b && !this.bY()) {
            this.j();
        }
        super.d_();
        this.eZ();
        this.aX = this.dL();
        this.B((float)this.h(GenericAttributes.v));
        float f2 = this.aH() && !this.eH() && !this.cj() ? Math.min(0.1f, (float)this.dy().i()) : 0.0f;
        this.bW += (f2 - this.bW) * 0.4f;
        if (this.eG() > 0.0f && !this.ak()) {
            AxisAlignedBB aabb = this.bY() && !this.dk().dQ() ? this.cR().b(this.dk().cR()).c(1.0, 0.0, 1.0) : this.cR().c(1.0, 0.5, 1.0);
            List<Entity> entities = this.dV().a_(this, aabb);
            ArrayList list = Lists.newArrayList();
            for (Entity entity : entities) {
                if (entity.an() == EntityTypes.W) {
                    list.add(entity);
                    continue;
                }
                if (entity.dQ()) continue;
                this.d(entity);
            }
            if (!list.isEmpty()) {
                this.d((Entity)SystemUtils.a(list, this.ae));
            }
        }
        this.c(this.gC());
        this.c(this.gD());
        if ((!this.dV().C && (this.Z > 0.5 || this.bi()) || this.cw.b || this.fR() || this.av) && !this.dV().paperConfig().entities.behavior.parrotsAreUnaffectedByPlayerMovement) {
            this.gy();
        }
    }

    protected void i() {
    }

    private void c(NBTTagCompound entityCompound) {
        EntityTypes entityType;
        if (!(entityCompound.j() || entityCompound.b("Silent", false) || this.dV().A.a(200) != 0 || (entityType = (EntityTypes)entityCompound.a("id", EntityTypes.a).orElse(null)) != EntityTypes.aP || EntityParrot.a(this.dV(), this))) {
            this.dV().a(null, this.dA(), this.dC(), this.dG(), EntityParrot.a(this.dV(), this.dV().A), this.dm(), 1.0f, EntityParrot.a(this.dV().A));
        }
    }

    private void d(Entity entity) {
        entity.a_(this);
    }

    public int gd() {
        return this.al.a(d);
    }

    public void q(int score) {
        this.al.a(d, score);
    }

    public void r(int score) {
        int score1 = this.gd();
        this.al.a(d, score1 + score);
    }

    public void a(int ticks, float damage, net.minecraft.world.item.ItemStack itemStack) {
        this.bp = ticks;
        this.bq = damage;
        this.br = itemStack;
        if (!this.dV().C) {
            this.gy();
            this.c(4, true);
        }
    }

    @Override
    @Nonnull
    public net.minecraft.world.item.ItemStack dZ() {
        return this.fv() && this.br != null ? this.br : super.dZ();
    }

    @Override
    public void a(DamageSource cause) {
        World world;
        super.a(cause);
        this.av();
        if (!this.ak() && (world = this.dV()) instanceof WorldServer) {
            WorldServer serverLevel = (WorldServer)world;
            this.dropAllDeathLoot(serverLevel, cause);
        }
        if (cause != null) {
            this.n(-MathHelper.b((this.eM() + this.dL()) * ((float)Math.PI / 180)) * 0.1f, 0.1f, -MathHelper.a((this.eM() + this.dL()) * ((float)Math.PI / 180)) * 0.1f);
        } else {
            this.n(0.0, 0.1, 0.0);
        }
        this.a(StatisticList.N);
        this.a(StatisticList.i.b(StatisticList.m));
        this.a(StatisticList.i.b(StatisticList.n));
        this.aF();
        this.c(false);
        this.a(Optional.of(GlobalPos.a(this.dV().aj(), this.dv())));
    }

    @Override
    protected void f(WorldServer level) {
        super.f(level);
        if (!level.O().c(GameRules.e)) {
            this.ge();
            this.ct.m();
        }
    }

    protected void ge() {
        for (int i2 = 0; i2 < this.ct.b(); ++i2) {
            net.minecraft.world.item.ItemStack item = this.ct.a(i2);
            if (item.f() || !EnchantmentManager.a(item, EnchantmentEffectComponents.D)) continue;
            this.ct.b(i2);
        }
    }

    @Override
    public SoundEffect e(DamageSource damageSource) {
        return damageSource.k().d().a();
    }

    @Override
    public SoundEffect j_() {
        return SoundEffects.uY;
    }

    public void g(net.minecraft.world.item.ItemStack stack) {
    }

    @Nullable
    public EntityItem a(net.minecraft.world.item.ItemStack itemStack, boolean includeThrowerName) {
        return this.a(itemStack, false, includeThrowerName);
    }

    public float c(IBlockData state) {
        float destroySpeed = this.ct.g().a(state);
        if (destroySpeed > 1.0f) {
            destroySpeed += (float)this.h(GenericAttributes.t);
        }
        if (MobEffectUtil.a(this)) {
            destroySpeed *= 1.0f + (float)(MobEffectUtil.b(this) + 1) * 0.2f;
        }
        if (this.b(MobEffects.d)) {
            float f2 = switch (this.c(MobEffects.d).e()) {
                case 0 -> 0.3f;
                case 1 -> 0.09f;
                case 2 -> 0.0027f;
                default -> 8.1E-4f;
            };
            destroySpeed *= f2;
        }
        destroySpeed *= (float)this.h(GenericAttributes.f);
        if (((Entity)this).a(TagsFluid.a)) {
            destroySpeed *= (float)this.g(GenericAttributes.C).g();
        }
        if (!this.aH()) {
            destroySpeed /= 5.0f;
        }
        return destroySpeed;
    }

    public boolean d(IBlockData state) {
        return !state.C() || this.ct.g().b(state);
    }

    @Override
    public void a(NBTTagCompound compound) {
        super.a(compound);
        this.a_(this.cy.getId());
        NBTTagList listOrEmpty = compound.p("Inventory");
        this.ct.b(listOrEmpty);
        this.ct.c(compound.b("SelectedItemSlot", 0));
        this.cv = compound.b("SleepTimer", (short)0);
        this.ch = compound.b("XpP", 0.0f);
        this.cf = compound.b("XpLevel", 0);
        this.cg = compound.b("XpTotal", 0);
        this.ci = compound.b("XpSeed", 0);
        if (this.ci == 0) {
            this.ci = this.ae.f();
        }
        this.q(compound.b("Score", 0));
        this.bS.a(compound);
        this.cw.b(compound);
        this.g(GenericAttributes.v).a(this.cw.b());
        compound.o("EnderItems").ifPresent(listTag -> this.bP.a((NBTTagList)listTag, this.dX()));
        this.k(compound.n("ShoulderEntityLeft"));
        this.l(compound.n("ShoulderEntityRight"));
        this.a(compound.a("LastDeathLocation", GlobalPos.b));
        this.cm = compound.a("current_explosion_impact_pos", Vec3D.a).orElse(null);
        this.cD = compound.b("ignore_fall_damage_from_current_explosion", false);
        this.cE = compound.b("current_impulse_context_reset_grace_time", 0);
    }

    @Override
    public void b(NBTTagCompound compound) {
        super.b(compound);
        GameProfileSerializer.e(compound);
        compound.a("Inventory", this.ct.a(new NBTTagList()));
        compound.a("SelectedItemSlot", this.ct.f());
        compound.a("SleepTimer", (short)this.cv);
        compound.a("XpP", this.ch);
        compound.a("XpLevel", this.cf);
        compound.a("XpTotal", this.cg);
        compound.a("XpSeed", this.ci);
        compound.a("Score", this.gd());
        this.bS.b(compound);
        this.cw.a(compound);
        compound.a("EnderItems", this.bP.a(this.dX()));
        if (!this.gC().j()) {
            compound.a("ShoulderEntityLeft", this.gC());
        }
        if (!this.gD().j()) {
            compound.a("ShoulderEntityRight", this.gD());
        }
        this.cC.ifPresent(globalPos -> compound.a("LastDeathLocation", GlobalPos.b, globalPos));
        compound.b("current_explosion_impact_pos", Vec3D.a, this.cm);
        compound.a("ignore_fall_damage_from_current_explosion", this.cD);
        compound.a("current_impulse_context_reset_grace_time", this.cE);
    }

    @Override
    public boolean a(WorldServer level, DamageSource damageSource) {
        if (super.a(level, damageSource)) {
            return true;
        }
        if (damageSource.a(DamageTypeTags.n)) {
            return !level.O().c(GameRules.I);
        }
        if (damageSource.a(DamageTypeTags.m)) {
            return !level.O().c(GameRules.J);
        }
        return damageSource.a(DamageTypeTags.i) ? !level.O().c(GameRules.K) : damageSource.a(DamageTypeTags.o) && !level.O().c(GameRules.L);
    }

    @Override
    public boolean a(WorldServer level, DamageSource damageSource, float amount) {
        boolean damaged;
        if (this.a(level, damageSource)) {
            return false;
        }
        if (this.cw.a && !damageSource.a(DamageTypeTags.d)) {
            return false;
        }
        this.bd = 0;
        if (this.eH()) {
            return false;
        }
        if (damageSource.g()) {
            if (level.an() == EnumDifficulty.a) {
                return false;
            }
            if (level.an() == EnumDifficulty.b) {
                amount = Math.min(amount / 2.0f + 1.0f, amount);
            }
            if (level.an() == EnumDifficulty.d) {
                amount = amount * 3.0f / 2.0f;
            }
        }
        if (damaged = super.a(level, damageSource, amount)) {
            this.gy();
        }
        return damaged;
    }

    @Override
    protected void b(WorldServer level, EntityLiving entity) {
        super.b(level, entity);
        net.minecraft.world.item.ItemStack itemBlockingWith = this.fH();
        BlocksAttacks blocksAttacks = itemBlockingWith != null ? itemBlockingWith.a(DataComponents.I) : null;
        float secondsToDisableBlocking = entity.fU();
        if (secondsToDisableBlocking > 0.0f && blocksAttacks != null) {
            blocksAttacks.disable(level, this, secondsToDisableBlocking, itemBlockingWith, entity);
        }
    }

    @Override
    public boolean ez() {
        return !this.gk().a && super.ez();
    }

    public boolean a(EntityHuman other) {
        Team team;
        if (other instanceof EntityPlayer) {
            EntityPlayer thatPlayer = (EntityPlayer)other;
            team = thatPlayer.getBukkitEntity().getScoreboard().getPlayerTeam((OfflinePlayer)thatPlayer.getBukkitEntity());
            if (team == null || team.allowFriendlyFire()) {
                return true;
            }
        } else {
            OfflinePlayer thisPlayer = other.dV().getCraftServer().getOfflinePlayer(other.cI());
            team = other.dV().getCraftServer().getScoreboardManager().getMainScoreboard().getPlayerTeam(thisPlayer);
            if (team == null || team.allowFriendlyFire()) {
                return true;
            }
        }
        if (this instanceof EntityPlayer) {
            return !team.hasPlayer((OfflinePlayer)((EntityPlayer)this).getBukkitEntity());
        }
        return !team.hasPlayer(this.dV().getCraftServer().getOfflinePlayer(this.cI()));
    }

    @Override
    protected void c(DamageSource damageSource, float damage) {
        this.a(damageSource, damage, EnumItemSlot.c, EnumItemSlot.d, EnumItemSlot.e, EnumItemSlot.f);
    }

    @Override
    protected void d(DamageSource damageSource, float damageAmount) {
        this.a(damageSource, damageAmount, EnumItemSlot.f);
    }

    @Override
    protected boolean actuallyHurt(WorldServer level, DamageSource damageSource, float amount, EntityDamageEvent event) {
        return super.actuallyHurt(level, damageSource, amount, event);
    }

    public boolean W() {
        return false;
    }

    public void a(TileEntitySign signEntity, boolean isFrontText) {
    }

    public void a(CommandBlockListenerAbstract commandEntity) {
    }

    public void a(TileEntityCommand commandBlockEntity) {
    }

    public void a(TileEntityStructure structureEntity) {
    }

    public void a(TestBlockEntity testBlockEntity) {
    }

    public void a(TestInstanceBlockEntity testInstanceBlockEntity) {
    }

    public void a(TileEntityJigsaw jigsawBlockEntity) {
    }

    public void a(EntityHorseAbstract horse, IInventory inventory) {
    }

    public OptionalInt a(@Nullable ITileInventory menu) {
        return OptionalInt.empty();
    }

    public void a(int containerId, MerchantRecipeList offers, int villagerLevel, int villagerXp, boolean showProgress, boolean canRestock) {
    }

    public void a(net.minecraft.world.item.ItemStack stack, EnumHand hand) {
    }

    public EnumInteractionResult a(Entity entityToInteractOn, EnumHand hand) {
        if (this.ak()) {
            if (entityToInteractOn instanceof ITileInventory) {
                this.a((ITileInventory)((Object)entityToInteractOn));
            }
            return EnumInteractionResult.e;
        }
        net.minecraft.world.item.ItemStack itemInHand = this.b(hand);
        net.minecraft.world.item.ItemStack itemStack = itemInHand.v();
        EnumInteractionResult interactionResult = entityToInteractOn.a(this, hand);
        if (interactionResult.a()) {
            if (this.fV() && itemInHand == this.b(hand) && itemInHand.M() < itemStack.M()) {
                itemInHand.e(itemStack.M());
            }
            return interactionResult;
        }
        if (!itemInHand.f() && entityToInteractOn instanceof EntityLiving) {
            EnumInteractionResult interactionResult1;
            if (this.fV()) {
                itemInHand = itemStack;
            }
            if ((interactionResult1 = itemInHand.a(this, (EntityLiving)entityToInteractOn, hand)).a()) {
                this.dV().a(GameEvent.r, entityToInteractOn.dt(), GameEvent.a.a(this));
                if (itemInHand.f() && !this.fV()) {
                    this.a(hand, net.minecraft.world.item.ItemStack.l);
                }
                return interactionResult1;
            }
        }
        return EnumInteractionResult.e;
    }

    @Override
    public void aa() {
        this.removeVehicle(false);
    }

    @Override
    public void removeVehicle(boolean suppressCancellation) {
        super.removeVehicle(suppressCancellation);
        this.J = 0;
    }

    @Override
    protected boolean fg() {
        return super.fg() || this.fR() || this.dQ() || !this.valid;
    }

    @Override
    public boolean em() {
        return !this.cw.b;
    }

    @Override
    protected Vec3D a(Vec3D vec, EnumMoveType mover) {
        float f2 = this.dP();
        if (!this.cw.b && !(vec.e > 0.0) && (mover == EnumMoveType.a || mover == EnumMoveType.b) && this.ga() && this.I(f2)) {
            double d2;
            double d1 = vec.f;
            double d22 = 0.05;
            double d3 = Math.signum(d2) * 0.05;
            double d4 = Math.signum(d1) * 0.05;
            for (d2 = vec.d; d2 != 0.0 && this.q(d2, 0.0, f2); d2 -= d3) {
                if (!(Math.abs(d2) <= 0.05)) continue;
                d2 = 0.0;
                break;
            }
            while (d1 != 0.0 && this.q(0.0, d1, f2)) {
                if (Math.abs(d1) <= 0.05) {
                    d1 = 0.0;
                    break;
                }
                d1 -= d4;
            }
            while (d2 != 0.0 && d1 != 0.0 && this.q(d2, d1, f2)) {
                d2 = Math.abs(d2) <= 0.05 ? 0.0 : (d2 -= d3);
                if (Math.abs(d1) <= 0.05) {
                    d1 = 0.0;
                    continue;
                }
                d1 -= d4;
            }
            return new Vec3D(d2, vec.e, d1);
        }
        return vec;
    }

    private boolean I(float maxUpStep) {
        return this.aH() || this.Z < (double)maxUpStep && !this.q(0.0, 0.0, (double)maxUpStep - this.Z);
    }

    private boolean q(double x2, double z2, double distance) {
        AxisAlignedBB boundingBox = this.cR();
        return this.dV().a((Entity)this, new AxisAlignedBB(boundingBox.a + 1.0E-7 + x2, boundingBox.b - distance - 1.0E-7, boundingBox.c + 1.0E-7 + z2, boundingBox.d - 1.0E-7 + x2, boundingBox.b, boundingBox.f - 1.0E-7 + z2));
    }

    public void e(Entity target) {
        boolean willAttack = target.cB() && !target.v(this);
        PrePlayerAttackEntityEvent playerAttackEntityEvent = new PrePlayerAttackEntityEvent((Player)this.getBukkitEntity(), (org.bukkit.entity.Entity)target.getBukkitEntity(), willAttack);
        if (playerAttackEntityEvent.callEvent() && willAttack) {
            float f2 = this.fv() ? this.bq : (float)this.h(GenericAttributes.c);
            net.minecraft.world.item.ItemStack weaponItem = this.dZ();
            DamageSource damageSource = Optional.ofNullable(weaponItem.h().a(this)).orElse(this.dW().a(this));
            float f1 = this.a(target, f2, damageSource) - f2;
            float attackStrengthScale = this.H(0.5f);
            f2 *= 0.2f + attackStrengthScale * attackStrengthScale * 0.8f;
            f1 *= attackStrengthScale;
            if (target.an().a(TagsEntity.H) && target instanceof IProjectile) {
                IProjectile projectile = (IProjectile)target;
                if (CraftEventFactory.handleNonLivingEntityDamageEvent(target, damageSource, f1, false)) {
                    return;
                }
                if (projectile.a(ProjectileDeflection.c, this, this, true)) {
                    this.dV().a(null, this.dA(), this.dC(), this.dG(), SoundEffects.uR, this.dm());
                    return;
                }
            }
            if (f2 > 0.0f || f1 > 0.0f) {
                double d1;
                double d2;
                boolean flag1;
                boolean flag;
                boolean bl = flag = attackStrengthScale > 0.9f;
                if (this.ci() && flag) {
                    EntityHuman.sendSoundEffect(this, this.dA(), this.dC(), this.dG(), SoundEffects.uQ, this.dm(), 1.0f, 1.0f);
                    flag1 = true;
                } else {
                    flag1 = false;
                }
                f2 += weaponItem.h().a(target, f2, damageSource);
                boolean flag2 = flag && this.Z > 0.0 && !this.aH() && !this.k_() && !this.bi() && !this.b(MobEffects.o) && !this.bY() && target instanceof EntityLiving && !this.ci();
                boolean bl2 = flag2 = flag2 && !this.dV().paperConfig().entities.behavior.disablePlayerCrits;
                if (flag2) {
                    damageSource = damageSource.critical();
                    f2 *= 1.5f;
                }
                float f22 = f2 + f1;
                boolean flag3 = false;
                if (flag && !flag2 && !flag1 && this.aH() && (d2 = this.ad().j()) < MathHelper.k(d1 = (double)this.fo() * 2.5) && this.b(EnumHand.a).a(TagsItem.bI)) {
                    flag3 = true;
                }
                float f3 = 0.0f;
                if (target instanceof EntityLiving) {
                    EntityLiving livingEntity = (EntityLiving)target;
                    f3 = livingEntity.eG();
                }
                Vec3D deltaMovement = target.dy();
                boolean flag4 = target.b(damageSource, f22);
                if (flag4) {
                    Object event;
                    float f4 = this.b(target, damageSource) + (flag1 ? 1.0f : 0.0f);
                    if (f4 > 0.0f) {
                        if (target instanceof EntityLiving) {
                            EntityLiving livingEntity1 = (EntityLiving)target;
                            livingEntity1.knockback(f4 * 0.5f, MathHelper.a(this.dL() * ((float)Math.PI / 180)), -MathHelper.b(this.dL() * ((float)Math.PI / 180)), this, EntityKnockbackEvent.Cause.ENTITY_ATTACK);
                        } else {
                            target.push(-MathHelper.a(this.dL() * ((float)Math.PI / 180)) * f4 * 0.5f, 0.1, MathHelper.b(this.dL() * ((float)Math.PI / 180)) * f4 * 0.5f, this);
                        }
                        this.i(this.dy().d(0.6, 1.0, 0.6));
                        if (!this.dV().paperConfig().misc.disableSprintInterruptionOnAttack) {
                            this.h(false);
                        }
                    }
                    if (flag3) {
                        float f5 = 1.0f + (float)this.h(GenericAttributes.D) * f2;
                        for (EntityLiving livingEntity2 : this.dV().a(EntityLiving.class, target.cR().c(1.0, 0.25, 1.0))) {
                            WorldServer serverLevel;
                            EntityArmorStand armorStand;
                            if (livingEntity2 == this || livingEntity2 == target || this.s(livingEntity2) || livingEntity2 instanceof EntityArmorStand && (armorStand = (EntityArmorStand)livingEntity2).w() || !(this.g(livingEntity2) < 9.0)) continue;
                            float f6 = this.a((Entity)livingEntity2, f5, damageSource) * attackStrengthScale;
                            livingEntity2.lastDamageCancelled = false;
                            World world = this.dV();
                            if (!(world instanceof WorldServer) || !livingEntity2.a(serverLevel = (WorldServer)world, damageSource.knownCause(EntityDamageEvent.DamageCause.ENTITY_SWEEP_ATTACK), f6) || livingEntity2.lastDamageCancelled) continue;
                            livingEntity2.knockback(0.4f, MathHelper.a(this.dL() * ((float)Math.PI / 180)), -MathHelper.b(this.dL() * ((float)Math.PI / 180)), this, EntityKnockbackEvent.Cause.SWEEP_ATTACK);
                            EnchantmentManager.a(serverLevel, (Entity)livingEntity2, damageSource);
                        }
                        EntityHuman.sendSoundEffect(this, this.dA(), this.dC(), this.dG(), SoundEffects.uT, this.dm(), 1.0f, 1.0f);
                        this.gf();
                    }
                    if (target instanceof EntityPlayer && target.T) {
                        boolean cancelled = false;
                        Player player = (Player)target.getBukkitEntity();
                        Vector velocity = CraftVector.toBukkit(deltaMovement);
                        event = new PlayerVelocityEvent(player, velocity.clone());
                        this.dV().getCraftServer().getPluginManager().callEvent((Event)event);
                        if (event.isCancelled()) {
                            cancelled = true;
                        } else if (!velocity.equals((Object)event.getVelocity())) {
                            player.setVelocity(event.getVelocity());
                        }
                        if (!cancelled) {
                            ((EntityPlayer)target).f.b(new PacketPlayOutEntityVelocity(target));
                            target.T = false;
                            target.i(deltaMovement);
                        }
                    }
                    if (flag2) {
                        EntityHuman.sendSoundEffect(this, this.dA(), this.dC(), this.dG(), SoundEffects.uP, this.dm(), 1.0f, 1.0f);
                        this.b(target);
                    }
                    if (!flag2 && !flag3) {
                        if (flag) {
                            EntityHuman.sendSoundEffect(this, this.dA(), this.dC(), this.dG(), SoundEffects.uS, this.dm(), 1.0f, 1.0f);
                        } else {
                            EntityHuman.sendSoundEffect(this, this.dA(), this.dC(), this.dG(), SoundEffects.uU, this.dm(), 1.0f, 1.0f);
                        }
                    }
                    if (f1 > 0.0f) {
                        this.c(target);
                    }
                    this.B(target);
                    Entity entity = target;
                    if (target instanceof EntityComplexPart) {
                        entity = ((EntityComplexPart)target).a;
                    }
                    boolean flag5 = false;
                    event = this.dV();
                    if (event instanceof WorldServer) {
                        WorldServer serverLevel1 = (WorldServer)event;
                        if (entity instanceof EntityLiving) {
                            EntityLiving livingEntity2x = (EntityLiving)entity;
                            flag5 = weaponItem.a(livingEntity2x, (EntityLiving)this);
                        }
                        EnchantmentManager.a(serverLevel1, target, damageSource);
                    }
                    if (!this.dV().C && !weaponItem.f() && entity instanceof EntityLiving) {
                        if (flag5) {
                            weaponItem.b((EntityLiving)entity, (EntityLiving)this);
                        }
                        if (weaponItem.f()) {
                            if (weaponItem == this.fb()) {
                                this.a(EnumHand.a, net.minecraft.world.item.ItemStack.l);
                            } else {
                                this.a(EnumHand.b, net.minecraft.world.item.ItemStack.l);
                            }
                        }
                    }
                    if (target instanceof EntityLiving) {
                        float f7 = f3 - ((EntityLiving)target).eG();
                        this.a(StatisticList.G, Math.round(f7 * 10.0f));
                        if (this.dV() instanceof WorldServer && f7 > 2.0f) {
                            int i2 = (int)((double)f7 * 0.5);
                            ((WorldServer)this.dV()).a(Particles.g, target.dA(), target.e(0.5), target.dG(), i2, 0.1, 0.0, 0.1, 0.2);
                        }
                    }
                    this.causeFoodExhaustion(this.dV().spigotConfig.combatExhaustion, EntityExhaustionEvent.ExhaustionReason.ATTACK);
                } else {
                    EntityHuman.sendSoundEffect(this, this.dA(), this.dC(), this.dG(), SoundEffects.uR, this.dm(), 1.0f, 1.0f);
                    this.bR.b();
                }
            }
        }
    }

    protected float a(Entity entity, float damage, DamageSource damageSource) {
        return damage;
    }

    @Override
    protected void f(EntityLiving target) {
        this.e((Entity)target);
    }

    public void b(Entity entityHit) {
    }

    public void c(Entity entityHit) {
    }

    public void gf() {
        double d2 = -MathHelper.a(this.dL() * ((float)Math.PI / 180));
        double d1 = MathHelper.b(this.dL() * ((float)Math.PI / 180));
        if (this.dV() instanceof WorldServer) {
            ((WorldServer)this.dV()).a(Particles.am, this.dA() + d2, this.e(0.5), this.dG() + d1, 0, d2, 0.0, d1, 0.0);
        }
    }

    public void gg() {
    }

    @Override
    public void remove(Entity.RemovalReason reason, @Nullable EntityRemoveEvent.Cause eventCause) {
        super.remove(reason, eventCause);
        this.bQ.a(this);
        if (this.bR != null && this.gm()) {
            this.p();
        }
    }

    @Override
    public boolean Z_() {
        return true;
    }

    @Override
    protected boolean dh() {
        return this.gh();
    }

    public boolean gh() {
        return false;
    }

    @Override
    public boolean di() {
        return !this.dV().C || this.gh();
    }

    @Override
    public boolean dj() {
        return !this.dV().C || this.gh();
    }

    public GameProfile gi() {
        return this.cy;
    }

    public PlayerInventory gj() {
        return this.ct;
    }

    public PlayerAbilities gk() {
        return this.cw;
    }

    @Override
    public boolean fV() {
        return this.cw.d;
    }

    public boolean gl() {
        return this.cw.d;
    }

    public void a(net.minecraft.world.item.ItemStack carried, net.minecraft.world.item.ItemStack clicked, ClickAction action) {
    }

    public boolean gm() {
        return this.bR != this.bQ;
    }

    public boolean gn() {
        return true;
    }

    public Either<EnumBedResult, Unit> a(BlockPosition bedPos) {
        return this.startSleepInBed(bedPos, false);
    }

    public Either<EnumBedResult, Unit> startSleepInBed(BlockPosition bedPos, boolean force) {
        this.b(bedPos);
        this.cv = 0;
        return Either.right(Unit.a);
    }

    public void a(boolean wakeImmediately, boolean updateLevelForSleepingPlayers) {
        super.fS();
        if (this.dV() instanceof WorldServer && updateLevelForSleepingPlayers) {
            ((WorldServer)this.dV()).f();
        }
        this.cv = wakeImmediately ? 0 : 100;
    }

    @Override
    public void fS() {
        this.a(true, true);
    }

    public boolean go() {
        return this.fR() && this.cv >= 100;
    }

    public int gp() {
        return this.cv;
    }

    public void a(IChatBaseComponent chatComponent, boolean actionBar) {
    }

    public void a(MinecraftKey statKey) {
        this.b(StatisticList.i.b(statKey));
    }

    public void a(MinecraftKey stat, int increment) {
        this.a(StatisticList.i.b(stat), increment);
    }

    public void b(Statistic<?> stat) {
        this.a(stat, 1);
    }

    public void a(Statistic<?> stat, int increment) {
    }

    public void a(Statistic<?> stat) {
    }

    public int a(Collection<RecipeHolder<?>> recipes) {
        return 0;
    }

    public void a(RecipeHolder<?> recipe, List<net.minecraft.world.item.ItemStack> items) {
    }

    public void b(List<ResourceKey<IRecipe<?>>> recipes) {
    }

    public int b(Collection<RecipeHolder<?>> recipes) {
        return 0;
    }

    @Override
    public void a_(Vec3D travelVector) {
        if (this.bY()) {
            super.a_(travelVector);
        } else {
            double d2;
            if (this.cj()) {
                double d1;
                d2 = this.bS().e;
                double d3 = d1 = d2 < -0.2 ? 0.085 : 0.06;
                if (d2 <= 0.0 || this.bf || !this.dV().b_(BlockPosition.a(this.dA(), this.dC() + 1.0 - 0.1, this.dG())).c()) {
                    Vec3D deltaMovement = this.dy();
                    this.i(deltaMovement.b(0.0, (d2 - deltaMovement.e) * d1, 0.0));
                }
            }
            if (this.gk().b) {
                d2 = this.dy().e;
                super.a_(travelVector);
                this.i(this.dy().a(EnumDirection.EnumAxis.b, d2 * 0.6));
            } else {
                super.a_(travelVector);
            }
        }
    }

    @Override
    protected boolean ft() {
        return !this.cw.b && super.ft();
    }

    @Override
    public void bn() {
        if (this.cw.b) {
            this.i(false);
        } else {
            super.bn();
        }
    }

    protected boolean h(BlockPosition pos) {
        return !this.dV().a_(pos).j(this.dV(), pos);
    }

    @Override
    public float fo() {
        return (float)this.h(GenericAttributes.v);
    }

    @Override
    public boolean a(double fallDistance, float damageMultiplier, DamageSource damageSource) {
        double min;
        boolean flag;
        if (this.cw.c && !this.flyingFallDamage.toBooleanOrElse(false)) {
            return false;
        }
        if (fallDistance >= 2.0) {
            this.a(StatisticList.t, (int)Math.round(fallDistance * 100.0));
        }
        boolean bl = flag = this.cm != null && this.cD;
        if (flag) {
            boolean flag1;
            min = Math.min(fallDistance, this.cm.e - this.dC());
            boolean bl2 = flag1 = min <= 0.0;
            if (flag1) {
                this.gQ();
            } else {
                this.gP();
            }
        } else {
            min = fallDistance;
        }
        if (min > 0.0 && super.a(min, damageMultiplier, damageSource)) {
            this.gQ();
            return true;
        }
        this.b(fallDistance, damageMultiplier, damageSource);
        return false;
    }

    public boolean gq() {
        if (!this.fJ() && this.ft() && !this.bi()) {
            this.gr();
            return true;
        }
        return false;
    }

    public void gr() {
        if (!CraftEventFactory.callToggleGlideEvent(this, true).isCancelled()) {
            this.b(7, true);
        } else {
            this.b(7, true);
            this.b(7, false);
        }
    }

    @Override
    protected void bq() {
        if (!this.ak()) {
            super.bq();
        }
    }

    @Override
    protected void b(BlockPosition pos, IBlockData state) {
        if (this.bi()) {
            this.aX();
            this.b(state);
        } else {
            BlockPosition primaryStepSoundBlockPos = this.e(pos);
            if (!pos.equals(primaryStepSoundBlockPos)) {
                IBlockData blockState = this.dV().a_(primaryStepSoundBlockPos);
                if (blockState.a(TagsBlock.br)) {
                    this.a(blockState, state);
                } else {
                    super.b(primaryStepSoundBlockPos, blockState);
                }
            } else {
                super.b(pos, state);
            }
        }
    }

    @Override
    public EntityLiving.a eO() {
        return new EntityLiving.a(SoundEffects.vf, SoundEffects.uV);
    }

    @Override
    public boolean a(WorldServer level, EntityLiving entity) {
        this.b(StatisticList.g.b(entity.an()));
        return true;
    }

    @Override
    public void a(IBlockData state, Vec3D motionMultiplier) {
        if (!this.cw.b) {
            super.a(state, motionMultiplier);
        }
        this.gP();
    }

    public void d(int xpPoints) {
        this.r(xpPoints);
        this.ch += (float)xpPoints / (float)this.gt();
        this.cg = MathHelper.a(this.cg + xpPoints, 0, Integer.MAX_VALUE);
        while (this.ch < 0.0f) {
            float f2 = this.ch * (float)this.gt();
            if (this.cf > 0) {
                this.c(-1);
                this.ch = 1.0f + f2 / (float)this.gt();
                continue;
            }
            this.c(-1);
            this.ch = 0.0f;
        }
        while (this.ch >= 1.0f) {
            this.ch = (this.ch - 1.0f) * (float)this.gt();
            this.c(1);
            this.ch /= (float)this.gt();
        }
    }

    public int gs() {
        return this.ci;
    }

    public void a(net.minecraft.world.item.ItemStack enchantedItem, int levelCost) {
        this.cf -= levelCost;
        if (this.cf < 0) {
            this.cf = 0;
            this.ch = 0.0f;
            this.cg = 0;
        }
        this.ci = this.ae.f();
    }

    public void c(int levels) {
        this.cf = IntMath.saturatedAdd((int)this.cf, (int)levels);
        if (this.cf < 0) {
            this.cf = 0;
            this.ch = 0.0f;
            this.cg = 0;
        }
        if (levels > 0 && this.cf % 5 == 0 && (float)this.cx < (float)this.af - 100.0f) {
            float f2 = this.cf > 30 ? 1.0f : (float)this.cf / 30.0f;
            this.dV().a(null, this.dA(), this.dC(), this.dG(), SoundEffects.ve, this.dm(), f2 * 0.75f, 1.0f);
            this.cx = this.af;
        }
    }

    public int gt() {
        if (this.cf >= 30) {
            return 112 + (this.cf - 30) * 9;
        }
        return this.cf >= 15 ? 37 + (this.cf - 15) * 5 : 7 + this.cf * 2;
    }

    private static void sendSoundEffect(EntityHuman fromEntity, double x2, double y2, double z2, SoundEffect soundEffect, SoundCategory soundCategory, float volume, float pitch) {
        fromEntity.dV().a((Entity)fromEntity, x2, y2, z2, soundEffect, soundCategory, volume, pitch);
        if (fromEntity instanceof EntityPlayer) {
            EntityPlayer serverPlayer = (EntityPlayer)fromEntity;
            serverPlayer.f.b(new PacketPlayOutNamedSoundEffect(BuiltInRegistries.b.e(soundEffect), soundCategory, x2, y2, z2, volume, pitch, fromEntity.ae.g()));
        }
    }

    public void G(float exhaustion) {
        this.causeFoodExhaustion(exhaustion, EntityExhaustionEvent.ExhaustionReason.UNKNOWN);
    }

    public void causeFoodExhaustion(float exhaustion, EntityExhaustionEvent.ExhaustionReason reason) {
        EntityExhaustionEvent event;
        if (!(this.cw.a || this.dV().C || (event = CraftEventFactory.callPlayerExhaustionEvent(this, reason, exhaustion)).isCancelled())) {
            this.bS.a(event.getExhaustion());
        }
    }

    public Optional<WardenSpawnTracker> Y() {
        return Optional.empty();
    }

    public FoodMetaData gu() {
        return this.bS;
    }

    public boolean t(boolean canAlwaysEat) {
        return this.cw.a || canAlwaysEat || this.bS.b();
    }

    public boolean gv() {
        return this.eG() > 0.0f && this.eG() < this.eU();
    }

    public boolean gw() {
        return this.cw.e;
    }

    public boolean a(BlockPosition pos, EnumDirection facing, net.minecraft.world.item.ItemStack stack) {
        if (this.cw.e) {
            return true;
        }
        BlockPosition blockPos = pos.a(facing.g());
        ShapeDetectorBlock blockInWorld = new ShapeDetectorBlock(this.dV(), blockPos, false);
        return stack.a(blockInWorld);
    }

    @Override
    protected int e(WorldServer level) {
        return !level.O().c(GameRules.e) && !this.ak() ? Math.min(this.cf * 7, 100) : 0;
    }

    @Override
    protected boolean eq() {
        return true;
    }

    @Override
    public boolean cM() {
        return true;
    }

    @Override
    protected Entity.MovementEmission bf() {
        return this.cw.b || this.aH() && this.cf() ? Entity.MovementEmission.a : Entity.MovementEmission.d;
    }

    public void w() {
    }

    @Override
    public IChatBaseComponent ah() {
        return IChatBaseComponent.b(this.cy.getName());
    }

    public InventoryEnderChest gx() {
        return this.bP;
    }

    @Override
    protected boolean b(EnumItemSlot slot) {
        return slot.a() == EnumItemSlot.Function.b;
    }

    public boolean h(net.minecraft.world.item.ItemStack stack) {
        return this.ct.g(stack);
    }

    public boolean j(NBTTagCompound entityCompound) {
        if (this.bY() || !this.aH() || this.bi() || this.av) {
            return false;
        }
        if (this.gC().j()) {
            this.k(entityCompound);
            this.cs = this.dV().ae();
            return true;
        }
        if (this.gD().j()) {
            this.l(entityCompound);
            this.cs = this.dV().ae();
            return true;
        }
        return false;
    }

    public void gy() {
        if (this.cs + 20L < this.dV().ae()) {
            if (this.respawnEntityOnShoulder(this.gC())) {
                this.k(new NBTTagCompound());
            }
            if (this.respawnEntityOnShoulder(this.gD())) {
                this.l(new NBTTagCompound());
            }
        }
    }

    public Entity releaseLeftShoulderEntity() {
        Entity entity = this.respawnEntityOnShoulder0(this.gC());
        if (entity != null) {
            this.k(new NBTTagCompound());
        }
        return entity;
    }

    public Entity releaseRightShoulderEntity() {
        Entity entity = this.respawnEntityOnShoulder0(this.gD());
        if (entity != null) {
            this.l(new NBTTagCompound());
        }
        return entity;
    }

    private boolean respawnEntityOnShoulder(NBTTagCompound entityCompound) {
        return this.respawnEntityOnShoulder0(entityCompound) != null;
    }

    @Nullable
    private Entity respawnEntityOnShoulder0(NBTTagCompound entityCompound) {
        if (!this.dV().C && !entityCompound.j()) {
            return EntityTypes.a(entityCompound, this.dV(), EntitySpawnReason.r).map(entity -> {
                if (entity instanceof EntityTameableAnimal) {
                    EntityTameableAnimal tamableAnimal = (EntityTameableAnimal)entity;
                    tamableAnimal.i(this);
                }
                entity.a_(this.dA(), this.dC() + (double)0.7f, this.dG());
                return ((WorldServer)this.dV()).addWithUUID((Entity)entity, CreatureSpawnEvent.SpawnReason.SHOULDER_ENTITY) ? entity : null;
            }).orElse(null);
        }
        return null;
    }

    @Nullable
    public abstract EnumGamemode a();

    @Override
    public boolean ak() {
        return this.a() == EnumGamemode.d;
    }

    @Override
    public boolean bE() {
        return !this.ak() && super.bE();
    }

    @Override
    public boolean cj() {
        return !this.cw.b && !this.ak() && super.cj();
    }

    public boolean gz() {
        return this.a() == EnumGamemode.b;
    }

    @Override
    public boolean cJ() {
        return !this.cw.b;
    }

    public Scoreboard gA() {
        return this.dV().R();
    }

    @Override
    public IChatBaseComponent P_() {
        IChatMutableComponent mutableComponent = ScoreboardTeam.a(this.cq(), this.ah());
        return this.a(mutableComponent);
    }

    private IChatMutableComponent a(IChatMutableComponent displayName) {
        String name = this.gi().getName();
        return displayName.a(style -> style.a(new ChatClickable.SuggestCommand("/tell " + name + " ")).a(this.cQ()).a(name));
    }

    @Override
    public String cI() {
        return this.gi().getName();
    }

    @Override
    protected void F(float absorptionAmount) {
        this.ar().a(c, Float.valueOf(absorptionAmount));
    }

    @Override
    public float fw() {
        return this.ar().a(c).floatValue();
    }

    public boolean a(PlayerModelPart part) {
        return (this.ar().a(bK) & part.a()) == part.a();
    }

    @Override
    public SlotAccess a_(int slot) {
        if (slot == 499) {
            return new SlotAccess(){

                @Override
                public net.minecraft.world.item.ItemStack a() {
                    return EntityHuman.this.bR.g();
                }

                @Override
                public boolean a(net.minecraft.world.item.ItemStack carried) {
                    EntityHuman.this.bR.a(carried);
                    return true;
                }
            };
        }
        final int i2 = slot - 500;
        if (i2 >= 0 && i2 < 4) {
            return new SlotAccess(){

                @Override
                public net.minecraft.world.item.ItemStack a() {
                    return EntityHuman.this.bQ.r().a(i2);
                }

                @Override
                public boolean a(net.minecraft.world.item.ItemStack carried) {
                    EntityHuman.this.bQ.r().a(i2, carried);
                    EntityHuman.this.bQ.a(EntityHuman.this.ct);
                    return true;
                }
            };
        }
        if (slot >= 0 && slot < this.ct.i().size()) {
            return SlotAccess.a(this.ct, slot);
        }
        int i1 = slot - 200;
        return i1 >= 0 && i1 < this.bP.b() ? SlotAccess.a(this.bP, i1) : super.a_(slot);
    }

    public boolean gB() {
        return this.cz;
    }

    public void u(boolean reducedDebugInfo) {
        this.cz = reducedDebugInfo;
    }

    @Override
    public void h(int ticks) {
        super.h(this.cw.a ? Math.min(ticks, 1) : ticks);
    }

    @Override
    public EnumMainHand fy() {
        return this.al.a(bL) == 0 ? EnumMainHand.a : EnumMainHand.b;
    }

    public void b(EnumMainHand hand) {
        this.al.a(bL, (byte)(hand != EnumMainHand.a ? 1 : 0));
    }

    public NBTTagCompound gC() {
        return this.al.a(bM);
    }

    public void k(NBTTagCompound entityCompound) {
        this.al.a(bM, entityCompound);
    }

    public NBTTagCompound gD() {
        return this.al.a(bN);
    }

    public void l(NBTTagCompound entityCompound) {
        this.al.a(bN, entityCompound);
    }

    public float gE() {
        return (float)(1.0 / this.h(GenericAttributes.e) * 20.0);
    }

    public float H(float adjustTicks) {
        return MathHelper.a(((float)this.aS + adjustTicks) / this.gE(), 0.0f, 1.0f);
    }

    public void gF() {
        this.aS = 0;
    }

    public ItemCooldown gG() {
        return this.cB;
    }

    @Override
    protected float aS() {
        return !this.cw.b && !this.fJ() ? super.aS() : 1.0f;
    }

    @Override
    public float eh() {
        return (float)this.h(GenericAttributes.q);
    }

    public boolean gH() {
        return this.cw.d && this.F() >= 2;
    }

    public int F() {
        return 0;
    }

    public boolean s(int permissionLevel) {
        return this.F() >= permissionLevel;
    }

    @Override
    public EntitySize e(EntityPose pose) {
        return b.getOrDefault((Object)pose, bJ);
    }

    @Override
    public ImmutableList<EntityPose> fO() {
        return ImmutableList.of((Object)((Object)EntityPose.a), (Object)((Object)EntityPose.f), (Object)((Object)EntityPose.d));
    }

    protected boolean tryReadyArrow(net.minecraft.world.item.ItemStack bow, net.minecraft.world.item.ItemStack itemstack, MutableBoolean cancelled) {
        EntityHuman entityHuman = this;
        if (!(entityHuman instanceof EntityPlayer)) {
            return true;
        }
        EntityPlayer serverPlayer = (EntityPlayer)entityHuman;
        boolean notCancelled = new PlayerReadyArrowEvent((Player)serverPlayer.getBukkitEntity(), (ItemStack)CraftItemStack.asCraftMirror(bow), (ItemStack)CraftItemStack.asCraftMirror(itemstack)).callEvent();
        if (!notCancelled) {
            cancelled.setValue(true);
        }
        return notCancelled;
    }

    @Override
    public net.minecraft.world.item.ItemStack d(net.minecraft.world.item.ItemStack shootable) {
        EntityHuman entityHuman;
        if (!(shootable.h() instanceof ItemProjectileWeapon)) {
            return net.minecraft.world.item.ItemStack.l;
        }
        MutableBoolean anyEventCancelled = new MutableBoolean();
        Predicate<net.minecraft.world.item.ItemStack> supportedHeldProjectiles = ((ItemProjectileWeapon)shootable.h()).c().and(item -> this.tryReadyArrow(shootable, (net.minecraft.world.item.ItemStack)item, anyEventCancelled));
        net.minecraft.world.item.ItemStack heldProjectile = ItemProjectileWeapon.a(this, supportedHeldProjectiles);
        if (!heldProjectile.f()) {
            return heldProjectile;
        }
        supportedHeldProjectiles = ((ItemProjectileWeapon)shootable.h()).a().and(item -> this.tryReadyArrow(shootable, (net.minecraft.world.item.ItemStack)item, anyEventCancelled));
        for (int i2 = 0; i2 < this.ct.b(); ++i2) {
            net.minecraft.world.item.ItemStack item2 = this.ct.a(i2);
            if (!supportedHeldProjectiles.test(item2)) continue;
            return item2;
        }
        if (anyEventCancelled.booleanValue() && !this.cw.d && (entityHuman = this) instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entityHuman;
            this.resyncUsingItem(player);
        }
        return this.fV() ? new net.minecraft.world.item.ItemStack(Items.pk) : net.minecraft.world.item.ItemStack.l;
    }

    @Override
    public Vec3D v(float partialTicks) {
        double d2 = 0.22 * (this.fy() == EnumMainHand.b ? -1.0 : 1.0);
        float f2 = MathHelper.h(partialTicks * 0.5f, this.dN(), this.O) * ((float)Math.PI / 180);
        float f1 = MathHelper.h(partialTicks, this.aW, this.aV) * ((float)Math.PI / 180);
        if (this.fJ() || this.fv()) {
            float f22;
            Vec3D viewVector = this.h(partialTicks);
            Vec3D deltaMovement = this.dy();
            double d1 = deltaMovement.j();
            double d22 = viewVector.j();
            if (d1 > 0.0 && d22 > 0.0) {
                double d3 = (deltaMovement.d * viewVector.d + deltaMovement.f * viewVector.f) / Math.sqrt(d1 * d22);
                double d4 = deltaMovement.d * viewVector.f - deltaMovement.f * viewVector.d;
                f22 = (float)(Math.signum(d4) * Math.acos(d3));
            } else {
                f22 = 0.0f;
            }
            return this.p(partialTicks).e(new Vec3D(d2, -0.11, 0.85).c(-f22).a(-f2).b(-f1));
        }
        if (this.ck()) {
            return this.p(partialTicks).e(new Vec3D(d2, 0.2, -0.15).a(-f2).b(-f1));
        }
        double d5 = this.cR().c() - 1.0;
        double d1 = this.ch() ? -0.2 : 0.07;
        return this.p(partialTicks).e(new Vec3D(d2, d5, d1).b(-f1));
    }

    @Override
    public boolean dU() {
        return true;
    }

    public boolean gI() {
        return this.fz() && this.fB().a(Items.sf);
    }

    @Override
    public boolean dT() {
        return false;
    }

    public Optional<GlobalPos> gJ() {
        return this.cC;
    }

    public void a(Optional<GlobalPos> lastDeathLocation) {
        this.cC = lastDeathLocation;
    }

    @Override
    public float eM() {
        return this.cl;
    }

    @Override
    public void q(float yaw) {
        super.q(yaw);
        this.cl = yaw;
    }

    @Override
    public boolean dO() {
        return true;
    }

    @Override
    protected float fn() {
        if (this.cw.b && !this.bY()) {
            return this.ci() ? this.cw.a() * 2.0f : this.cw.a();
        }
        return this.ci() ? 0.025999999f : 0.02f;
    }

    public boolean gK() {
        return this.cu;
    }

    public void gL() {
        if (!this.cu) {
            --this.bU;
            if (this.bU <= 0) {
                this.cu = true;
                PlayerClientLoadedWorldEvent event = new PlayerClientLoadedWorldEvent((Player)((CraftPlayer)this.getBukkitEntity()), true);
                event.callEvent();
            }
        }
    }

    public void v(boolean clientLoaded) {
        this.cu = clientLoaded;
        if (!this.cu) {
            this.bU = 60;
        }
    }

    public double gM() {
        return this.h(GenericAttributes.g);
    }

    public double gN() {
        return this.h(GenericAttributes.j);
    }

    public boolean b(Entity entity, double distance) {
        return !entity.dQ() && this.a(entity.cR(), distance);
    }

    public boolean a(AxisAlignedBB boundingBox, double distance) {
        double d2 = this.gN() + distance;
        return boundingBox.e(this.bD()) < d2 * d2;
    }

    public boolean a(BlockPosition pos, double distance) {
        double d2 = this.gM() + distance;
        return new AxisAlignedBB(pos).e(this.bD()) < d2 * d2;
    }

    public void w(boolean ignoreFallDamageFromCurrentImpulse) {
        this.cD = ignoreFallDamageFromCurrentImpulse;
        this.cE = ignoreFallDamageFromCurrentImpulse ? 40 : 0;
    }

    public boolean gO() {
        return this.cD;
    }

    public void gP() {
        if (this.cE == 0) {
            this.gQ();
        }
    }

    public void gQ() {
        this.cE = 0;
        this.cn = null;
        this.cm = null;
        this.cD = false;
    }

    public boolean gR() {
        return false;
    }

    @Override
    public boolean k_() {
        return !this.cw.b && super.k_();
    }

    public String gS() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.ah().getString()).add("id", this.ao()).add("pos", (Object)this.dt()).add("mode", (Object)this.a()).add("permission", this.F()).toString();
    }

    public static final class EnumBedResult
    extends Enum<EnumBedResult> {
        public static final /* enum */ EnumBedResult a = new EnumBedResult();
        public static final /* enum */ EnumBedResult b = new EnumBedResult(IChatBaseComponent.c("block.minecraft.bed.no_sleep"));
        public static final /* enum */ EnumBedResult c = new EnumBedResult(IChatBaseComponent.c("block.minecraft.bed.too_far_away"));
        public static final /* enum */ EnumBedResult d = new EnumBedResult(IChatBaseComponent.c("block.minecraft.bed.obstructed"));
        public static final /* enum */ EnumBedResult e = new EnumBedResult();
        public static final /* enum */ EnumBedResult f = new EnumBedResult(IChatBaseComponent.c("block.minecraft.bed.not_safe"));
        @Nullable
        private final IChatBaseComponent g;
        private static final /* synthetic */ EnumBedResult[] h;

        public static EnumBedResult[] values() {
            return (EnumBedResult[])h.clone();
        }

        public static EnumBedResult valueOf(String name) {
            return Enum.valueOf(EnumBedResult.class, name);
        }

        private EnumBedResult() {
            this.g = null;
        }

        private EnumBedResult(IChatBaseComponent message) {
            this.g = message;
        }

        @Nullable
        public IChatBaseComponent a() {
            return this.g;
        }

        private static /* synthetic */ EnumBedResult[] b() {
            return new EnumBedResult[]{a, b, c, d, e, f};
        }

        static {
            h = EnumBedResult.b();
        }
    }
}

